/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.enterprise.BinaryProtocol;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.GuestHostLanguage;
import com.oracle.truffle.polyglot.enterprise.HSContext;
import com.oracle.truffle.polyglot.enterprise.HSObjectReferences;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativeEngine;
import com.oracle.truffle.polyglot.enterprise.NativeOptionConverter;
import com.oracle.truffle.polyglot.enterprise.NativeOptionConverterGen;
import com.oracle.truffle.polyglot.enterprise.NativeOptionValidator;
import com.oracle.truffle.polyglot.enterprise.NativeOptionValidatorGen;
import com.oracle.truffle.polyglot.enterprise.NativeOutputStream;
import com.oracle.truffle.polyglot.enterprise.NativeOutputStreamGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.MarshalledException;
import org.graalvm.nativebridge.MarshallerAnnotation;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativebridge.TypeLiteral;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.ProcessHandler;

final class PolyglotJNIConfig {
    private static final JNIConfig INSTANCE = PolyglotJNIConfig.createConfig();

    PolyglotJNIConfig() {
    }

    static JNIConfig getInstance() {
        return INSTANCE;
    }

    private static JNIConfig createConfig() {
        BinaryMarshaller<Set<AccessMode>> binaryMarshaller = SetMarshaller.covariant(new SetMarshaller<AccessMode>(new EnumMarshaller<AccessMode>(AccessMode.class)){

            @Override
            int inferElementsSize(Set<AccessMode> set) {
                return set.size();
            }
        });
        BinaryMarshaller<Set<OpenOption>> binaryMarshaller2 = SetMarshaller.covariant(new SetMarshaller<OpenOption>(new ExtensibleEnumMarshaller<OpenOption>(OpenOption.class, List.of(LinkOption.class, StandardOpenOption.class))){

            @Override
            int inferElementsSize(Set<OpenOption> set) {
                return 2 * set.size();
            }
        });
        SetMarshaller<PosixFilePermission> setMarshaller = new SetMarshaller<PosixFilePermission>(new EnumMarshaller<PosixFilePermission>(PosixFilePermission.class)){

            @Override
            int inferElementsSize(Set<PosixFilePermission> set) {
                return set.size();
            }
        };
        FileAttributeValueMarshaller fileAttributeValueMarshaller = new FileAttributeValueMarshaller((BinaryMarshaller<Set<PosixFilePermission>>)setMarshaller);
        JNIConfig.Builder builder = JNIConfig.newBuilder();
        builder.registerMarshaller(ByteBuffer.class, BinaryMarshaller.nullable((BinaryMarshaller)new ByteBufferMarshaller()));
        builder.registerMarshaller(ByteSequence.class, BinaryMarshaller.nullable((BinaryMarshaller)new ByteSequenceMarshaller()));
        builder.registerMarshaller(CharSequence.class, BinaryMarshaller.nullable((BinaryMarshaller)new CharSequenceMarshaller()));
        builder.registerMarshaller(Charset.class, BinaryMarshaller.nullable((BinaryMarshaller)new CharsetMarshaller()));
        builder.registerMarshaller(CopyOption.class, BinaryMarshaller.nullable(new ExtensibleEnumMarshaller<CopyOption>(CopyOption.class, List.of(LinkOption.class, StandardCopyOption.class))));
        builder.registerMarshaller(Duration.class, BinaryMarshaller.nullable((BinaryMarshaller)new DurationMarshaller()));
        builder.registerMarshaller(Error.class, BinaryMarshaller.nullable(new ExceptionMarshaller<Error>(Error.class)));
        builder.registerMarshaller(LinkOption.class, new EnumMarshaller<LinkOption>(LinkOption.class));
        builder.registerMarshaller(LogRecord.class, BinaryMarshaller.nullable((BinaryMarshaller)new LogRecordMarshaller()));
        builder.registerMarshaller(OptionDescriptor.class, BinaryMarshaller.nullable((BinaryMarshaller)new OptionDescriptorMarshaller()));
        builder.registerMarshaller(ProcessHandler.ProcessCommand.class, BinaryMarshaller.nullable((BinaryMarshaller)new ProcessCommandMarshaller()));
        builder.registerMarshaller(ProcessHandle.class, BinaryMarshaller.nullable((BinaryMarshaller)new ProcessHandleMarshaller()));
        builder.registerMarshaller(SandboxPolicy.class, BinaryMarshaller.nullable(new EnumMarshaller<SandboxPolicy>(SandboxPolicy.class)));
        builder.registerMarshaller(Throwable.class, BinaryMarshaller.nullable((BinaryMarshaller)ThrowableMarshaller.INSTANCE));
        builder.registerMarshaller(TimeUnit.class, BinaryMarshaller.nullable(new EnumMarshaller<TimeUnit>(TimeUnit.class)));
        builder.registerMarshaller(URI.class, BinaryMarshaller.nullable((BinaryMarshaller)new URIMarshaller()));
        builder.registerMarshaller(URL.class, BinaryMarshaller.nullable((BinaryMarshaller)new URLMarshaller()));
        builder.registerMarshaller(ZoneId.class, BinaryMarshaller.nullable((BinaryMarshaller)new ZoneIdMarshaller()));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, BinaryMarshaller.nullable((BinaryMarshaller)new StringMapMarshaller()));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Map<String, String[]>>(){}, BinaryMarshaller.nullable((BinaryMarshaller)new StringArrayMapMarshaller()));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Set<String>>(){}, BinaryMarshaller.nullable((BinaryMarshaller)new StringSetMarshaller()));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Set<? extends AccessMode>>(){}, BinaryMarshaller.nullable(binaryMarshaller));
        builder.registerMarshaller(new TypeLiteral<FileAttribute<?>>(){}, (BinaryMarshaller)new FileAttributeMarshaller((BinaryMarshaller<Set<PosixFilePermission>>)setMarshaller));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Set<? extends OpenOption>>(){}, BinaryMarshaller.nullable(binaryMarshaller2));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Map<String, Object>>(){}, FileAttributeMap.class, BinaryMarshaller.nullable((BinaryMarshaller)new FileAttributeMapMarshaller(fileAttributeValueMarshaller)));
        builder.registerMarshaller(ByteBuffer.class, ReadOnly.class, BinaryMarshaller.nullable((BinaryMarshaller)new ReadOnlyByteBufferMarshaller()));
        builder.registerMarshaller(ByteBuffer.class, WriteOnly.class, BinaryMarshaller.nullable((BinaryMarshaller)new WriteOnlyByteBufferMarshaller()));
        builder.registerMarshaller(Object.class, ContextReceiver.class, BinaryMarshaller.nullable((BinaryMarshaller)new ContextReceiverMarshaller()));
        builder.registerMarshaller(Object.class, EngineReceiver.class, BinaryMarshaller.nullable((BinaryMarshaller)new EngineReceiverMarshaller()));
        builder.registerMarshaller(Object.class, EnvironmentAccessByValue.class, BinaryMarshaller.nullable((BinaryMarshaller)new EnvironmentAccessMarshaller()));
        builder.registerMarshaller(Object.class, FileAttributeValue.class, BinaryMarshaller.nullable((BinaryMarshaller)fileAttributeValueMarshaller));
        builder.registerMarshaller(Object.class, HostContext.class, BinaryMarshaller.nullable((BinaryMarshaller)new HostContextMarshaller()));
        builder.registerMarshaller(Object.class, InteropObject.class, BinaryMarshaller.nullable((BinaryMarshaller)new InteropObjectMarshaller()));
        builder.registerMarshaller(Object.class, IOAccessByValue.class, BinaryMarshaller.nullable((BinaryMarshaller)new IOAccessMarshaller()));
        builder.registerMarshaller(Object.class, Null.class, (BinaryMarshaller)new NullMarshaller());
        builder.registerMarshaller(Object.class, OptionValue.class, BinaryMarshaller.nullable((BinaryMarshaller)new OptionValueMarshaller()));
        builder.registerMarshaller(Object.class, PolyglotAccessByValue.class, BinaryMarshaller.nullable((BinaryMarshaller)new PolyglotAccessMarshaller()));
        builder.registerMarshaller(Object.class, SourceByValue.class, BinaryMarshaller.nullable((BinaryMarshaller)new SourceCopyMarshaller()));
        builder.registerMarshaller(Object.class, SourceReceiver.class, BinaryMarshaller.nullable((BinaryMarshaller)new SourceMarshaller()));
        builder.registerMarshaller(Object.class, SourceSectionReceiver.class, BinaryMarshaller.nullable((BinaryMarshaller)new SourceSectionMarshaller()));
        builder.registerMarshaller(Object.class, TruffleFile.class, BinaryMarshaller.nullable((BinaryMarshaller)new TruffleFileMarshaller()));
        builder.registerMarshaller(Object.class, ValueReceiver.class, BinaryMarshaller.nullable((BinaryMarshaller)new ValueMarshaller()));
        builder.registerMarshaller(RuntimeException.class, PolyglotExceptionReceiver.class, BinaryMarshaller.nullable(new ExceptionMarshaller<RuntimeException>(RuntimeException.class, runtimeException -> EnterprisePolyglotImpl.instance.getAPIAccess().isPolyglotException(runtimeException))));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Map<String, Object>>(){}, InstrumentsMap.class, BinaryMarshaller.nullable((BinaryMarshaller)new InstrumentMapMarshaller()));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<Map<String, Object>>(){}, LanguagesMap.class, BinaryMarshaller.nullable((BinaryMarshaller)new LanguageMapMarshaller()));
        builder.registerMarshaller((TypeLiteral)new TypeLiteral<List<Object>>(){}, ValuesList.class, BinaryMarshaller.nullable((BinaryMarshaller)new ValueListMarshaller()));
        builder.setAttachThreadAction(EnterprisePolyglotImpl::attachIsolate);
        builder.setDetachThreadAction(EnterprisePolyglotImpl::detachIsolate);
        builder.setShutDownIsolateAction(EnterprisePolyglotImpl::tearDownIsolate);
        builder.setReleaseNativeObjectAction(EnterprisePolyglotImpl::releaseHandle);
        builder.setNativeThreadLocalFactory(supplier -> EnterpriseEngineAccessor.RUNTIME.createTerminatingThreadLocal(supplier, nativeIsolateThread -> nativeIsolateThread.getIsolate().detachCurrentThread()));
        return builder.build();
    }

    private static boolean isHost() {
        return PolyglotIsolate.lazy == null;
    }

    static int strsize(String string) {
        return 4 + string.length();
    }

    static int optstrsize(String string) {
        return 1 + (string == null ? 0 : PolyglotJNIConfig.strsize(string));
    }

    private static final class EnumMarshaller<E extends Enum<E>>
    implements BinaryMarshaller<E> {
        private final E[] values;

        EnumMarshaller(Class<E> clazz) {
            this.values = (Enum[])clazz.getEnumConstants();
            if (this.values.length > 127) {
                throw new IllegalArgumentException("Only 127 enum constants are supported.");
            }
        }

        public E read(BinaryInput binaryInput) {
            return this.values[binaryInput.readByte()];
        }

        public void write(BinaryOutput binaryOutput, E e2) {
            binaryOutput.writeByte(((Enum)e2).ordinal());
        }

        public int inferSize(E e2) {
            return 1;
        }
    }

    private static class SetMarshaller<T>
    implements BinaryMarshaller<Set<T>> {
        private final BinaryMarshaller<T> elementMarshaller;

        SetMarshaller(BinaryMarshaller<T> binaryMarshaller) {
            this.elementMarshaller = Objects.requireNonNull(binaryMarshaller);
        }

        public final Set<T> read(BinaryInput binaryInput) {
            boolean bl = binaryInput.readBoolean();
            int n2 = binaryInput.readInt();
            HashSet hashSet = bl ? new LinkedHashSet(n2) : new HashSet(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                hashSet.add(this.elementMarshaller.read(binaryInput));
            }
            return hashSet;
        }

        public final void write(BinaryOutput binaryOutput, Set<T> set) {
            boolean bl = set instanceof SortedSet || set instanceof LinkedHashSet;
            binaryOutput.writeBoolean(bl);
            binaryOutput.writeInt(set.size());
            for (T t2 : set) {
                this.elementMarshaller.write(binaryOutput, t2);
            }
        }

        public final int inferSize(Set<T> set) {
            int n2 = this.inferElementsSize(set);
            return 5 + n2;
        }

        int inferElementsSize(Set<T> set) {
            int n2 = set.size();
            if (n2 == 0) {
                return 0;
            }
            return n2 * this.elementMarshaller.inferSize(set.iterator().next());
        }

        static <T> BinaryMarshaller<Set<? extends T>> covariant(BinaryMarshaller<Set<T>> binaryMarshaller) {
            return binaryMarshaller;
        }
    }

    private static final class ExtensibleEnumMarshaller<T>
    implements BinaryMarshaller<T> {
        private final Class<?>[] implementors;
        private final EnumMarshaller<?>[] marshallers;

        ExtensibleEnumMarshaller(Class<T> clazz, List<Class<? extends Enum<?>>> list) {
            if (list.size() > 127) {
                throw new IllegalArgumentException("Only 127 implementors are supported.");
            }
            this.implementors = list.toArray(new Class[list.size()]);
            EnumMarshaller[] enumMarshallerArray = new EnumMarshaller[list.size()];
            for (int i2 = 0; i2 < enumMarshallerArray.length; ++i2) {
                Class<? extends Enum<?>> clazz2 = list.get(i2);
                if (!clazz.isAssignableFrom(clazz2)) {
                    throw new IllegalArgumentException(String.valueOf(clazz2) + " does not implement " + String.valueOf(clazz));
                }
                enumMarshallerArray[i2] = ExtensibleEnumMarshaller.enumMarshaller(clazz2);
            }
            this.marshallers = enumMarshallerArray;
        }

        private static <E extends Enum<E>> EnumMarshaller<?> enumMarshaller(Class<? extends Enum<?>> clazz) {
            return new EnumMarshaller(clazz);
        }

        public T read(BinaryInput binaryInput) {
            byte by = binaryInput.readByte();
            return (T)this.asExtensibleEnumInterfaceMarshaller(this.marshallers[by]).read(binaryInput);
        }

        public void write(BinaryOutput binaryOutput, T t2) {
            for (int i2 = 0; i2 < this.implementors.length; ++i2) {
                if (!this.implementors[i2].isInstance(t2)) continue;
                binaryOutput.writeByte(i2);
                this.asExtensibleEnumInterfaceMarshaller(this.marshallers[i2]).write(binaryOutput, t2);
                return;
            }
            throw new IllegalArgumentException(String.valueOf(t2));
        }

        public int inferSize(T t2) {
            return 2;
        }

        private BinaryMarshaller<T> asExtensibleEnumInterfaceMarshaller(EnumMarshaller<?> enumMarshaller) {
            return enumMarshaller;
        }
    }

    private static final class FileAttributeValueMarshaller
    implements BinaryMarshaller<Object> {
        static final int ATTRIBUTE_SIZE_ESTIMATE = 20;
        private static final byte NULL = 0;
        private static final byte BOOLEAN = 1;
        private static final byte INT = 2;
        private static final byte LONG = 3;
        private static final byte FILE_TIME = 4;
        private static final byte GROUP_PRINCIPAL = 5;
        private static final byte USER_PRINCIPAL = 6;
        private static final byte POSIX_PERMISSIONS = 7;
        private final BinaryMarshaller<Set<PosixFilePermission>> posixFilePermissionsMarshaller;

        FileAttributeValueMarshaller(BinaryMarshaller<Set<PosixFilePermission>> binaryMarshaller) {
            this.posixFilePermissionsMarshaller = Objects.requireNonNull(binaryMarshaller);
        }

        public Object read(BinaryInput binaryInput) {
            byte by = binaryInput.readByte();
            switch (by) {
                case 0: {
                    return null;
                }
                case 1: {
                    return binaryInput.readBoolean();
                }
                case 2: {
                    return binaryInput.readInt();
                }
                case 3: {
                    return binaryInput.readLong();
                }
                case 4: {
                    long l2 = binaryInput.readLong();
                    long l3 = binaryInput.readLong();
                    return FileTime.from(Instant.ofEpochSecond(l2, l3));
                }
                case 5: {
                    int n2 = binaryInput.readInt();
                    String string = binaryInput.readUTF();
                    return new Group(n2, string);
                }
                case 6: {
                    int n3 = binaryInput.readInt();
                    String string = binaryInput.readUTF();
                    return new User(n3, string);
                }
                case 7: {
                    return this.posixFilePermissionsMarshaller.read(binaryInput);
                }
            }
            throw new IllegalArgumentException(String.valueOf(by));
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (object == null) {
                binaryOutput.writeByte(0);
            } else if (object instanceof Boolean) {
                binaryOutput.writeByte(1);
                binaryOutput.writeBoolean(((Boolean)object).booleanValue());
            } else if (object instanceof Integer) {
                binaryOutput.writeByte(2);
                binaryOutput.writeInt(((Integer)object).intValue());
            } else if (object instanceof Long) {
                binaryOutput.writeByte(3);
                binaryOutput.writeLong(((Long)object).longValue());
            } else if (object instanceof FileTime) {
                binaryOutput.writeByte(4);
                Instant instant = ((FileTime)object).toInstant();
                binaryOutput.writeLong(instant.getEpochSecond());
                binaryOutput.writeLong((long)instant.getNano());
            } else if (object instanceof GroupPrincipal) {
                binaryOutput.writeByte(5);
                binaryOutput.writeInt(object.hashCode());
                binaryOutput.writeUTF(((GroupPrincipal)object).getName());
            } else if (object instanceof UserPrincipal) {
                binaryOutput.writeByte(6);
                binaryOutput.writeInt(object.hashCode());
                binaryOutput.writeUTF(((UserPrincipal)object).getName());
            } else if (FileAttributeValueMarshaller.isPosixFilePermissionsSet(object)) {
                binaryOutput.writeByte(7);
                this.posixFilePermissionsMarshaller.write(binaryOutput, FileAttributeValueMarshaller.asPosixFilePermissionsSet(object));
            } else {
                throw new IllegalArgumentException(String.valueOf(object) + ": " + String.valueOf(object.getClass()));
            }
        }

        private static boolean isPosixFilePermissionsSet(Object object) {
            if (object instanceof Set) {
                Set set = (Set)object;
                return set.isEmpty() || set.iterator().next() instanceof PosixFilePermission;
            }
            return false;
        }

        private static Set<PosixFilePermission> asPosixFilePermissionsSet(Object object) {
            return (Set)object;
        }

        public int inferSize(Object object) {
            return 20;
        }

        private static final class Group
        extends User
        implements GroupPrincipal {
            Group(int n2, String string) {
                super(n2, string);
            }
        }

        private static class User
        implements UserPrincipal {
            private final int id;
            private final String name;

            User(int n2, String string) {
                this.id = n2;
                this.name = string;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public int hashCode() {
                return this.id;
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof UserPrincipal) {
                    return this.hashCode() == object.hashCode() && Objects.equals(this.name, ((UserPrincipal)object).getName());
                }
                return false;
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    private static final class ByteBufferMarshaller
    implements BinaryMarshaller<ByteBuffer> {
        private ByteBufferMarshaller() {
        }

        public ByteBuffer read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            int n3 = binaryInput.readInt();
            int n4 = binaryInput.readInt();
            byte[] byArray = new byte[n2];
            binaryInput.read(byArray, 0, n2);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.limit(n3);
            byteBuffer.position(n4);
            return byteBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(BinaryOutput binaryOutput, ByteBuffer byteBuffer) {
            int n2 = byteBuffer.capacity();
            int n3 = byteBuffer.limit();
            int n4 = byteBuffer.position();
            binaryOutput.writeInt(n2);
            binaryOutput.writeInt(n3);
            binaryOutput.writeInt(n4);
            try {
                byteBuffer.limit(n2);
                for (int i2 = 0; i2 < byteBuffer.capacity(); ++i2) {
                    binaryOutput.writeByte((int)byteBuffer.get(i2));
                }
            }
            finally {
                byteBuffer.limit(n3);
            }
        }

        public void readUpdate(BinaryInput binaryInput, ByteBuffer byteBuffer) {
            int n2 = binaryInput.readInt();
            assert (n2 == byteBuffer.capacity()) : "Invalid buffer instance";
            int n3 = binaryInput.readInt();
            int n4 = binaryInput.readInt();
            if (!byteBuffer.isReadOnly()) {
                if (byteBuffer.hasArray()) {
                    byte[] byArray = byteBuffer.array();
                    binaryInput.read(byArray, 0, n2);
                } else {
                    byte[] byArray = new byte[n2];
                    binaryInput.read(byArray, 0, n2);
                    byteBuffer.limit(n2);
                    byteBuffer.position(0);
                    byteBuffer.put(byArray);
                }
            }
            byteBuffer.limit(n3);
            byteBuffer.position(n4);
        }

        public void writeUpdate(BinaryOutput binaryOutput, ByteBuffer byteBuffer) {
            this.write(binaryOutput, byteBuffer);
        }

        public int inferSize(ByteBuffer byteBuffer) {
            return 12 + byteBuffer.capacity();
        }

        public int inferUpdateSize(ByteBuffer byteBuffer) {
            return this.inferSize(byteBuffer);
        }
    }

    private static final class ByteSequenceMarshaller
    implements BinaryMarshaller<ByteSequence> {
        private ByteSequenceMarshaller() {
        }

        public ByteSequence read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            byte[] byArray = new byte[n2];
            binaryInput.read(byArray, 0, n2);
            return ByteSequence.create((byte[])byArray);
        }

        public void write(BinaryOutput binaryOutput, ByteSequence byteSequence) {
            int n2 = byteSequence.length();
            binaryOutput.writeInt(n2);
            binaryOutput.write(byteSequence.toByteArray(), 0, n2);
        }

        public int inferSize(ByteSequence byteSequence) {
            return 4 + byteSequence.length();
        }
    }

    private static final class CharSequenceMarshaller
    implements BinaryMarshaller<CharSequence> {
        private CharSequenceMarshaller() {
        }

        public CharSequence read(BinaryInput binaryInput) {
            return binaryInput.readUTF();
        }

        public void write(BinaryOutput binaryOutput, CharSequence charSequence) {
            binaryOutput.writeUTF(charSequence.toString());
        }

        public int inferSize(CharSequence charSequence) {
            return 4 + charSequence.length();
        }
    }

    private static final class CharsetMarshaller
    implements BinaryMarshaller<Charset> {
        private CharsetMarshaller() {
        }

        public Charset read(BinaryInput binaryInput) {
            String string = binaryInput.readUTF();
            return Charset.forName(string);
        }

        public void write(BinaryOutput binaryOutput, Charset charset) {
            binaryOutput.writeUTF(charset.name());
        }

        public int inferSize(Charset charset) {
            return PolyglotJNIConfig.strsize(charset.name());
        }
    }

    private static final class DurationMarshaller
    implements BinaryMarshaller<Duration> {
        private DurationMarshaller() {
        }

        public Duration read(BinaryInput binaryInput) {
            long l2 = binaryInput.readLong();
            int n2 = binaryInput.readInt();
            return Duration.ofSeconds(l2, n2);
        }

        public void write(BinaryOutput binaryOutput, Duration duration) {
            binaryOutput.writeLong(duration.getSeconds());
            binaryOutput.writeInt(duration.getNano());
        }

        public int inferSize(Duration duration) {
            return 12;
        }
    }

    private static final class ExceptionMarshaller<T extends Throwable>
    implements BinaryMarshaller<T> {
        private final ThrowableMarshaller delegate = ThrowableMarshaller.INSTANCE;
        private final Class<T> exceptionType;
        private final Predicate<T> filter;

        ExceptionMarshaller(Class<T> clazz) {
            this(clazz, clazz::isInstance);
        }

        ExceptionMarshaller(Class<T> clazz, Predicate<T> predicate) {
            this.exceptionType = Objects.requireNonNull(clazz, "ExceptionType must be non null.");
            this.filter = Objects.requireNonNull(predicate, "Filter must be non null.");
        }

        public void write(BinaryOutput binaryOutput, T t2) {
            if (!this.filter.test(t2)) {
                throw new IllegalArgumentException("Object not accepted by a filter.");
            }
            this.delegate.write(binaryOutput, (Throwable)t2);
        }

        public T read(BinaryInput binaryInput) {
            return (T)((Throwable)this.exceptionType.cast(this.delegate.read(binaryInput)));
        }

        public int inferSize(T t2) {
            return this.delegate.inferSize((Throwable)t2);
        }
    }

    private static final class LogRecordMarshaller
    implements BinaryMarshaller<LogRecord> {
        private static final int PARAMETER_SIZE_ESTIMATE = 48;

        private LogRecordMarshaller() {
        }

        public LogRecord read(BinaryInput binaryInput) {
            Level level = Level.parse(Integer.toString(binaryInput.readInt()));
            String string = (String)binaryInput.readTypedValue();
            String string2 = (String)binaryInput.readTypedValue();
            String string3 = (String)binaryInput.readTypedValue();
            String string4 = (String)binaryInput.readTypedValue();
            String string5 = binaryInput.readUTF();
            Object[] objectArray = (Object[])binaryInput.readTypedValue();
            return EnterpriseEngineAccessor.ENGINE.createLogRecord(level, string, string2, string3, string4, objectArray, null, string5);
        }

        public void write(BinaryOutput binaryOutput, LogRecord logRecord) {
            binaryOutput.writeInt(logRecord.getLevel().intValue());
            binaryOutput.writeTypedValue((Object)logRecord.getLoggerName());
            binaryOutput.writeTypedValue((Object)logRecord.getMessage());
            binaryOutput.writeTypedValue((Object)logRecord.getSourceClassName());
            binaryOutput.writeTypedValue((Object)logRecord.getSourceMethodName());
            binaryOutput.writeUTF(EnterpriseEngineAccessor.ENGINE.getFormatKind(logRecord));
            binaryOutput.writeTypedValue((Object)logRecord.getParameters());
        }

        public int inferSize(LogRecord logRecord) {
            Object[] objectArray = logRecord.getParameters();
            return 4 + PolyglotJNIConfig.optstrsize(logRecord.getLoggerName()) + PolyglotJNIConfig.optstrsize(logRecord.getMessage()) + PolyglotJNIConfig.optstrsize(logRecord.getSourceClassName()) + PolyglotJNIConfig.optstrsize(logRecord.getSourceMethodName()) + 10 + (objectArray == null ? 0 : objectArray.length) * 48;
        }
    }

    private static final class OptionDescriptorMarshaller
    implements BinaryMarshaller<OptionDescriptor> {
        private final OptionValueMarshaller optionValueMarshaller = new OptionValueMarshaller();

        private OptionDescriptorMarshaller() {
        }

        public OptionDescriptor read(BinaryInput binaryInput) {
            String string = binaryInput.readUTF();
            OptionCategory optionCategory = OptionCategory.values()[binaryInput.readInt()];
            OptionStability optionStability = OptionStability.values()[binaryInput.readInt()];
            String string2 = binaryInput.readUTF();
            boolean bl = binaryInput.readBoolean();
            String string3 = binaryInput.readUTF();
            String string4 = (String)binaryInput.readTypedValue();
            Object object = this.optionValueMarshaller.read(binaryInput);
            String string5 = binaryInput.readUTF();
            NativeIsolate nativeIsolate = NativeIsolate.get((long)binaryInput.readLong());
            long l2 = binaryInput.readLong();
            long l3 = binaryInput.readLong();
            NativeOptionConverter nativeOptionConverter = NativeOptionConverterGen.create(nativeIsolate, l2);
            NativeOptionValidator nativeOptionValidator = NativeOptionValidatorGen.create(nativeIsolate, l3);
            OptionKey optionKey = new OptionKey(object, new OptionType(string5, (Function)nativeOptionConverter, (Consumer)nativeOptionValidator));
            return OptionDescriptor.newBuilder((OptionKey)optionKey, (String)string).category(optionCategory).stability(optionStability).help(string2).deprecated(bl).deprecationMessage(string3).usageSyntax(string4).build();
        }

        public void write(BinaryOutput binaryOutput, OptionDescriptor optionDescriptor) {
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported for HotSpot to Native.");
            }
            binaryOutput.writeUTF(optionDescriptor.getName());
            binaryOutput.writeInt(optionDescriptor.getCategory().ordinal());
            binaryOutput.writeInt(optionDescriptor.getStability().ordinal());
            binaryOutput.writeUTF(optionDescriptor.getHelp());
            binaryOutput.writeBoolean(optionDescriptor.isDeprecated());
            binaryOutput.writeUTF(optionDescriptor.getDeprecationMessage());
            binaryOutput.writeTypedValue((Object)optionDescriptor.getUsageSyntax());
            OptionKey optionKey = optionDescriptor.getKey();
            this.optionValueMarshaller.write(binaryOutput, optionKey.getDefaultValue());
            binaryOutput.writeUTF(optionKey.getType().getName());
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            binaryOutput.writeLong(NativeObjectHandles.create((Object)new OptionConvertor(optionKey.getType())));
            binaryOutput.writeLong(NativeObjectHandles.create((Object)new OptionValidator(optionKey.getType())));
        }

        public int inferSize(OptionDescriptor optionDescriptor) {
            OptionKey optionKey = optionDescriptor.getKey();
            return PolyglotJNIConfig.strsize(optionDescriptor.getName()) + 8 + PolyglotJNIConfig.strsize(optionDescriptor.getHelp()) + 1 + PolyglotJNIConfig.strsize(optionDescriptor.getDeprecationMessage()) + PolyglotJNIConfig.optstrsize(optionDescriptor.getUsageSyntax()) + this.optionValueMarshaller.inferSize(optionKey.getDefaultValue()) + PolyglotJNIConfig.strsize(optionKey.getType().getName()) + 24;
        }

        private static final class OptionConvertor
        implements Function<String, Object> {
            private final OptionType<?> delegate;

            OptionConvertor(OptionType<?> optionType) {
                this.delegate = optionType;
            }

            @Override
            public Object apply(String string) {
                return this.delegate.convert(string);
            }
        }

        private static final class OptionValidator
        implements Consumer<Object> {
            private final OptionType<Object> delegate;

            OptionValidator(OptionType<?> optionType) {
                this.delegate = optionType;
            }

            @Override
            public void accept(Object object) {
                this.delegate.validate(object);
            }
        }
    }

    private static final class ProcessCommandMarshaller
    implements BinaryMarshaller<ProcessHandler.ProcessCommand> {
        private static final byte PIPE = 0;
        private static final byte INHERIT = 1;
        private static final byte REDIRECT = 2;

        private ProcessCommandMarshaller() {
        }

        public void write(BinaryOutput binaryOutput, ProcessHandler.ProcessCommand processCommand) {
            List list = processCommand.getCommand();
            binaryOutput.writeInt(list.size());
            for (Object object : list) {
                binaryOutput.writeUTF((String)object);
            }
            binaryOutput.writeTypedValue((Object)processCommand.getDirectory());
            Map map = processCommand.getEnvironment();
            binaryOutput.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                binaryOutput.writeUTF((String)entry.getKey());
                binaryOutput.writeUTF((String)entry.getValue());
            }
            binaryOutput.writeBoolean(processCommand.isRedirectErrorStream());
            ProcessCommandMarshaller.serializeRedirect(binaryOutput, processCommand.getInputRedirect());
            ProcessCommandMarshaller.serializeRedirect(binaryOutput, processCommand.getOutputRedirect());
            ProcessCommandMarshaller.serializeRedirect(binaryOutput, processCommand.getErrorRedirect());
        }

        public ProcessHandler.ProcessCommand read(BinaryInput binaryInput) {
            String string;
            String string2;
            int n2;
            int n3 = binaryInput.readInt();
            ArrayList<String> arrayList = new ArrayList<String>(n3);
            for (int i2 = 0; i2 < n3; i2 += 1) {
                arrayList.add(binaryInput.readUTF());
            }
            String string3 = (String)binaryInput.readTypedValue();
            n3 = binaryInput.readInt();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (n2 = 0; n2 < n3; n2 += 1) {
                string2 = binaryInput.readUTF();
                string = binaryInput.readUTF();
                hashMap.put(string2, string);
            }
            n2 = binaryInput.readBoolean() ? 1 : 0;
            string2 = ProcessCommandMarshaller.deserializeRedirect(binaryInput);
            string = ProcessCommandMarshaller.deserializeRedirect(binaryInput);
            ProcessHandler.Redirect redirect = ProcessCommandMarshaller.deserializeRedirect(binaryInput);
            return ProcessHandler.ProcessCommand.create(arrayList, (String)string3, hashMap, n2 != 0, (ProcessHandler.Redirect)string2, (ProcessHandler.Redirect)string, (ProcessHandler.Redirect)redirect);
        }

        private static void serializeRedirect(BinaryOutput binaryOutput, ProcessHandler.Redirect redirect) {
            if (redirect == ProcessHandler.Redirect.PIPE) {
                binaryOutput.writeByte(0);
            } else if (redirect == ProcessHandler.Redirect.INHERIT) {
                binaryOutput.writeByte(1);
            } else {
                binaryOutput.writeByte(2);
                OutputStream outputStream = redirect.getOutputStream();
                binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
                binaryOutput.writeLong(NativeObjectHandles.create((Object)outputStream));
            }
        }

        private static ProcessHandler.Redirect deserializeRedirect(BinaryInput binaryInput) {
            byte by = binaryInput.readByte();
            switch (by) {
                case 0: {
                    return ProcessHandler.Redirect.PIPE;
                }
                case 1: {
                    return ProcessHandler.Redirect.INHERIT;
                }
                case 2: {
                    long l2 = binaryInput.readLong();
                    long l3 = binaryInput.readLong();
                    NativeObject nativeObject = new NativeObject(NativeIsolate.get((long)l2), l3);
                    NativeOutputStream nativeOutputStream = NativeOutputStreamGen.create(nativeObject);
                    return ProcessHandler.Redirect.createRedirectToStream((OutputStream)nativeOutputStream);
                }
            }
            throw new IllegalArgumentException("Unknown redirect " + by);
        }

        public int inferSize(ProcessHandler.ProcessCommand processCommand) {
            int n2 = 4;
            for (String object : processCommand.getCommand()) {
                n2 += PolyglotJNIConfig.strsize(object);
            }
            n2 += PolyglotJNIConfig.optstrsize(processCommand.getDirectory());
            n2 += 4;
            for (Map.Entry entry : processCommand.getEnvironment().entrySet()) {
                n2 += PolyglotJNIConfig.strsize((String)entry.getKey());
                n2 += PolyglotJNIConfig.strsize((String)entry.getValue());
            }
            return n2 += 17;
        }
    }

    private static final class ProcessHandleMarshaller
    implements BinaryMarshaller<ProcessHandle> {
        private ProcessHandleMarshaller() {
        }

        public void write(BinaryOutput binaryOutput, ProcessHandle processHandle) {
            binaryOutput.writeLong(processHandle.pid());
        }

        public ProcessHandle read(BinaryInput binaryInput) {
            long l2 = binaryInput.readLong();
            return ProcessHandle.of(l2).orElse(null);
        }

        public int inferSize(ProcessHandle processHandle) {
            return 8;
        }
    }

    private static final class ThrowableMarshaller
    implements BinaryMarshaller<Throwable> {
        private static final int INTEROP_EXCEPTION_SIZE_ESTIMATE = 64;
        private static final int STACK_SIZE_ESTIMATE = 1024;
        static final ThrowableMarshaller INSTANCE = new ThrowableMarshaller();
        private final BinaryMarshaller<StackTraceElement[]> stackTraceMarshaller = JNIConfig.Builder.defaultStackTraceMarshaller();

        private ThrowableMarshaller() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(BinaryOutput binaryOutput, Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionType exceptionType = ExceptionType.match(throwable);
            Object var5_5 = null;
            long l2 = 0L;
            if (exceptionType == ExceptionType.PolyglotException) {
                long l3;
                binaryOutput.writeByte(ExceptionType.PolyglotException.id);
                EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
                AbstractPolyglotImpl.APIAccess aPIAccess = enterprisePolyglotImpl.getAPIAccess();
                RuntimeException runtimeException = (RuntimeException)throwable2;
                throwable2 = EnterpriseEngineAccessor.ENGINE.getPolyglotExceptionCause(aPIAccess.getPolyglotExceptionReceiver(runtimeException));
                exceptionType = ExceptionType.match(throwable2);
                if (!PolyglotJNIConfig.isHost()) {
                    binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
                }
                Engine engine = aPIAccess.getPolyglotExceptionAPIEngine(runtimeException);
                Context context = aPIAccess.getPolyglotExceptionAPIContext(runtimeException);
                long l4 = l3 = engine == null ? 0L : EnterprisePolyglotImpl.findEngineHandleByEngineReceiver(aPIAccess.getEngineReceiver((Object)engine));
                if (context != null) {
                    Object object = aPIAccess.getContextReceiver((Object)context);
                    l2 = EnterprisePolyglotImpl.findContextHandleByContextReceiver(object);
                }
                binaryOutput.writeLong(l3);
                binaryOutput.writeLong(l2);
            } else if (exceptionType == ExceptionType.PolyglotEngineException) {
                binaryOutput.writeByte(ExceptionType.PolyglotEngineException.id);
                throwable2 = EnterpriseEngineAccessor.ENGINE.getPolyglotEngineExceptionCause(throwable);
                exceptionType = ExceptionType.match(throwable2);
            }
            if (exceptionType == ExceptionType.AbstractTruffleExceptionReference) {
                if (PolyglotJNIConfig.isHost() && l2 == 0L) {
                    NativeContext nativeContext = ThrowableMarshaller.findNativeContext(0L, 0L);
                    long l5 = l2 = nativeContext != null ? nativeContext.getHandle() : 0L;
                }
                if (l2 == 0L) {
                    this.writeDefault(binaryOutput, ExceptionType.AbstractTruffleException, throwable2);
                    return;
                } else {
                    binaryOutput.writeByte(exceptionType.id);
                    if (PolyglotJNIConfig.isHost()) {
                        void var5_9;
                        binaryOutput.writeLong(l2);
                        BinaryProtocol.writeHostTypedValue(binaryOutput, throwable2, ((NativeContext)var5_9).getGuestToHostReceiver());
                        return;
                    } else {
                        if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
                        HSContext hSContext = PolyglotIsolate.getHSContextByHandle(l2);
                        BinaryProtocol.writeGuestTypedValue(binaryOutput, throwable2, hSContext.hostToGuestObjectReferences);
                    }
                }
                return;
            } else if (exceptionType == ExceptionType.BinaryProtocolException) {
                binaryOutput.writeByte(exceptionType.id);
                if (PolyglotJNIConfig.isHost()) {
                    BinaryProtocol.writeHostTypedValue(binaryOutput, throwable2, null);
                    return;
                } else {
                    if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
                    BinaryProtocol.writeGuestTypedValue(binaryOutput, throwable2, null);
                }
                return;
            } else {
                this.writeDefault(binaryOutput, exceptionType, throwable2);
            }
        }

        private void writeDefault(BinaryOutput binaryOutput, ExceptionType exceptionType, Throwable throwable) {
            String string = throwable.getMessage();
            String string2 = exceptionType == ExceptionType.UnknownException ? ThrowableMarshaller.getExceptionClassName(throwable) : null;
            binaryOutput.writeByte(exceptionType.id);
            if (string2 != null) {
                binaryOutput.writeUTF(string2);
            }
            binaryOutput.writeTypedValue((Object)string);
            this.stackTraceMarshaller.write(binaryOutput, (Object)throwable.getStackTrace());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Throwable read(BinaryInput binaryInput) {
            Throwable throwable;
            ExceptionType exceptionType = ExceptionType.forId(binaryInput.readByte());
            boolean bl = false;
            boolean bl2 = false;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            if (exceptionType == ExceptionType.PolyglotException) {
                bl = true;
                if (PolyglotJNIConfig.isHost()) {
                    l2 = binaryInput.readLong();
                }
                l4 = binaryInput.readLong();
                l3 = binaryInput.readLong();
                exceptionType = ExceptionType.forId(binaryInput.readByte());
            } else if (exceptionType == ExceptionType.PolyglotEngineException) {
                bl2 = true;
                exceptionType = ExceptionType.forId(binaryInput.readByte());
            }
            if (exceptionType == ExceptionType.AbstractTruffleExceptionReference) {
                if (PolyglotJNIConfig.isHost()) {
                    throwable = (Throwable)BinaryProtocol.readHostTypedValue(binaryInput, ThrowableMarshaller.findNativeContext(l2, l3));
                } else {
                    if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
                    throwable = (Throwable)BinaryProtocol.readGuestTypedValue(binaryInput, PolyglotIsolate.getHSContextByHandle(binaryInput.readLong()));
                }
            } else if (exceptionType == ExceptionType.BinaryProtocolException) {
                if (PolyglotJNIConfig.isHost()) {
                    throwable = (Throwable)BinaryProtocol.readHostTypedValue(binaryInput, null);
                } else {
                    if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
                    throwable = (Throwable)BinaryProtocol.readGuestTypedValue(binaryInput, null);
                }
            } else {
                String string = null;
                if (exceptionType == ExceptionType.UnknownException) {
                    string = binaryInput.readUTF();
                } else if (exceptionType == ExceptionType.AbstractTruffleException) {
                    l4 = 0L;
                }
                String string2 = (String)binaryInput.readTypedValue();
                StackTraceElement[] stackTraceElementArray = ForeignException.mergeStackTrace((StackTraceElement[])((StackTraceElement[])this.stackTraceMarshaller.read(binaryInput)));
                throwable = exceptionType.instantiate(string, string2, stackTraceElementArray);
            }
            if (bl) {
                return ThrowableMarshaller.createPolyglotException(EnterprisePolyglotImpl.instance, l2, l4, l3, throwable);
            }
            if (!bl2) return throwable;
            return EnterpriseEngineAccessor.ENGINE.createPolyglotEngineException((RuntimeException)throwable);
        }

        private static String getExceptionClassName(Throwable throwable) {
            return throwable instanceof MarshalledException ? ((MarshalledException)throwable).getForeignExceptionClassName() : throwable.getClass().getName();
        }

        private static Object findPolyglotEngineImplByHandle(EnterprisePolyglotImpl enterprisePolyglotImpl, long l2, long l3) {
            Object object = enterprisePolyglotImpl.findEngineReceiverByHandle(l2, l3);
            if (object instanceof NativeEngine) {
                object = enterprisePolyglotImpl.getAPIAccess().getEngineReceiver((Object)((NativeEngine)((Object)object)).getLocalEngine());
            }
            return object;
        }

        private static Object findPolyglotContextImplByHandle(EnterprisePolyglotImpl enterprisePolyglotImpl, long l2, long l3) {
            Object object = enterprisePolyglotImpl.findContextByHandle(l2, l3);
            if (object instanceof NativeContext) {
                object = enterprisePolyglotImpl.getAPIAccess().getContextReceiver((Object)((NativeContext)((Object)object)).getLocalContext());
            }
            return object;
        }

        private static NativeContext findNativeContext(long l2, long l3) {
            if (l3 == 0L) {
                if (EnterpriseEngineAccessor.ENGINE.hasCurrentContext()) {
                    EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
                    return (NativeContext)((Object)enterprisePolyglotImpl.getAPIAccess().getContextReceiver(enterprisePolyglotImpl.getCurrentContext()));
                }
                return null;
            }
            return (NativeContext)((Object)EnterprisePolyglotImpl.instance.findContextByHandle(l2, l3));
        }

        private static RuntimeException createPolyglotException(EnterprisePolyglotImpl enterprisePolyglotImpl, long l2, long l3, long l4, Throwable throwable) {
            Object object = ThrowableMarshaller.findPolyglotContextImplByHandle(enterprisePolyglotImpl, l2, l4);
            if (object != null) {
                return EnterpriseEngineAccessor.ENGINE.wrapGuestException(object, throwable);
            }
            Object object2 = ThrowableMarshaller.findPolyglotEngineImplByHandle(enterprisePolyglotImpl, l2, l3);
            if (object2 != null) {
                return EnterpriseEngineAccessor.ENGINE.wrapGuestException(object2, throwable);
            }
            return EnterpriseEngineAccessor.ENGINE.wrapGuestException((Object)enterprisePolyglotImpl.getNext(), throwable);
        }

        public int inferSize(Throwable throwable) {
            int n2 = 34;
            if (BinaryProtocol.isSupportedException(throwable)) {
                n2 += 64;
            } else {
                n2 += PolyglotJNIConfig.strsize(throwable.getClass().getName());
                n2 += PolyglotJNIConfig.optstrsize(throwable.getMessage());
                n2 += 1024;
            }
            return n2;
        }

        private static final class ExceptionType
        extends Enum<ExceptionType> {
            public static final /* enum */ ExceptionType IllegalArgumentException = new ExceptionType(1);
            public static final /* enum */ ExceptionType IllegalStateException = new ExceptionType(2);
            public static final /* enum */ ExceptionType BinaryProtocolException = new ExceptionType(3);
            public static final /* enum */ ExceptionType IOException = new ExceptionType(4);
            public static final /* enum */ ExceptionType NotLinkException = new ExceptionType(5);
            public static final /* enum */ ExceptionType OutOfMemoryError = new ExceptionType(6);
            public static final /* enum */ ExceptionType PolyglotEngineException = new ExceptionType(7);
            public static final /* enum */ ExceptionType PolyglotException = new ExceptionType(8);
            public static final /* enum */ ExceptionType SecurityException = new ExceptionType(9);
            public static final /* enum */ ExceptionType StackOverflowError = new ExceptionType(10);
            public static final /* enum */ ExceptionType VetoException = new ExceptionType(11);
            public static final /* enum */ ExceptionType AbstractTruffleExceptionReference = new ExceptionType(12);
            public static final /* enum */ ExceptionType AbstractTruffleException = new ExceptionType(13);
            public static final /* enum */ ExceptionType UnsupportedOperationException = new ExceptionType(14);
            public static final /* enum */ ExceptionType UnknownException = new ExceptionType(0);
            private static final ExceptionType[] valuesById;
            final int id;
            private static final /* synthetic */ ExceptionType[] $VALUES;

            public static ExceptionType[] values() {
                return (ExceptionType[])$VALUES.clone();
            }

            public static ExceptionType valueOf(String string) {
                return Enum.valueOf(ExceptionType.class, string);
            }

            private ExceptionType(int n3) {
                this.id = n3;
            }

            Throwable instantiate(String string, String string2, StackTraceElement[] stackTraceElementArray) {
                Object object;
                boolean bl = true;
                switch (this.ordinal()) {
                    case 0: {
                        object = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        object = new IllegalStateException(string2);
                        break;
                    }
                    case 13: {
                        object = new UnsupportedOperationException(string2);
                        break;
                    }
                    case 4: {
                        object = new NotLinkException(string2);
                        break;
                    }
                    case 3: {
                        object = new IOException(string2);
                        break;
                    }
                    case 5: {
                        object = new OutOfMemoryError(string2);
                        break;
                    }
                    case 8: {
                        object = new SecurityException(string2);
                        break;
                    }
                    case 9: {
                        object = new StackOverflowError(string2);
                        break;
                    }
                    case 10: {
                        object = EnterprisePolyglotImpl.instance.getIO().createVetoException(string2);
                        break;
                    }
                    case 12: {
                        object = new AbstractTruffleExceptionImpl(string2);
                        break;
                    }
                    case 14: {
                        object = new MarshalledException(string, string2, stackTraceElementArray);
                        bl = false;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.toString());
                    }
                }
                if (bl) {
                    ((Throwable)object).setStackTrace(stackTraceElementArray);
                }
                return object;
            }

            static ExceptionType forId(int n2) {
                return valuesById[n2];
            }

            static ExceptionType match(Throwable throwable) {
                if (EnterprisePolyglotImpl.instance.getAPIAccess().isPolyglotException((Object)throwable)) {
                    return PolyglotException;
                }
                if (EnterpriseEngineAccessor.ENGINE.isPolyglotEngineException(throwable)) {
                    return PolyglotEngineException;
                }
                if (throwable instanceof AbstractTruffleException) {
                    return AbstractTruffleExceptionReference;
                }
                if (BinaryProtocol.isSupportedException(throwable)) {
                    return BinaryProtocolException;
                }
                if (throwable instanceof IllegalArgumentException) {
                    return IllegalArgumentException;
                }
                if (throwable instanceof IllegalStateException) {
                    return IllegalStateException;
                }
                if (throwable instanceof UnsupportedOperationException) {
                    return UnsupportedOperationException;
                }
                if (throwable instanceof NotLinkException) {
                    return NotLinkException;
                }
                if (throwable instanceof IOException) {
                    return IOException;
                }
                if (EnterprisePolyglotImpl.instance.getIO().isVetoException(throwable)) {
                    return VetoException;
                }
                if (throwable instanceof SecurityException) {
                    return SecurityException;
                }
                if (throwable instanceof OutOfMemoryError) {
                    return OutOfMemoryError;
                }
                if (throwable instanceof StackOverflowError) {
                    return StackOverflowError;
                }
                return UnknownException;
            }

            private static ExceptionType[] createValuesById() {
                ExceptionType[] exceptionTypeArray = ExceptionType.values();
                ExceptionType[] exceptionTypeArray2 = new ExceptionType[exceptionTypeArray.length];
                for (ExceptionType exceptionType : exceptionTypeArray) {
                    assert (exceptionTypeArray2[exceptionType.id] == null) : String.format("Both %s and %s have the same id %d.", new Object[]{exceptionTypeArray2[exceptionType.id], exceptionType, exceptionType.id});
                    exceptionTypeArray2[exceptionType.id] = exceptionType;
                }
                return exceptionTypeArray2;
            }

            private static /* synthetic */ ExceptionType[] $values() {
                return new ExceptionType[]{IllegalArgumentException, IllegalStateException, BinaryProtocolException, IOException, NotLinkException, OutOfMemoryError, PolyglotEngineException, PolyglotException, SecurityException, StackOverflowError, VetoException, AbstractTruffleExceptionReference, AbstractTruffleException, UnsupportedOperationException, UnknownException};
            }

            static {
                $VALUES = ExceptionType.$values();
                valuesById = ExceptionType.createValuesById();
            }
        }

        private static final class AbstractTruffleExceptionImpl
        extends AbstractTruffleException {
            AbstractTruffleExceptionImpl(String string) {
                super(string);
            }
        }
    }

    private static final class URIMarshaller
    implements BinaryMarshaller<URI> {
        private URIMarshaller() {
        }

        public URI read(BinaryInput binaryInput) {
            try {
                return new URI(binaryInput.readUTF());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)uRISyntaxException);
            }
        }

        public void write(BinaryOutput binaryOutput, URI uRI) {
            binaryOutput.writeUTF(uRI.toString());
        }

        public int inferSize(URI uRI) {
            return PolyglotJNIConfig.strsize(uRI.toString());
        }
    }

    private static final class URLMarshaller
    implements BinaryMarshaller<URL> {
        private URLMarshaller() {
        }

        public URL read(BinaryInput binaryInput) {
            try {
                String string = binaryInput.readUTF();
                String string2 = (String)binaryInput.readTypedValue();
                int n2 = binaryInput.readInt();
                String string3 = binaryInput.readUTF();
                return new URL(string, string2, n2, string3);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        public void write(BinaryOutput binaryOutput, URL uRL) {
            binaryOutput.writeUTF(uRL.getProtocol());
            binaryOutput.writeTypedValue((Object)uRL.getHost());
            binaryOutput.writeInt(uRL.getPort());
            binaryOutput.writeUTF(uRL.getPath());
        }

        public int inferSize(URL uRL) {
            return PolyglotJNIConfig.strsize(uRL.getProtocol()) + PolyglotJNIConfig.optstrsize(uRL.getHost()) + 4 + PolyglotJNIConfig.strsize(uRL.getPath());
        }
    }

    private static final class ZoneIdMarshaller
    implements BinaryMarshaller<ZoneId> {
        private ZoneIdMarshaller() {
        }

        public ZoneId read(BinaryInput binaryInput) {
            String string = binaryInput.readUTF();
            return ZoneId.of(string);
        }

        public void write(BinaryOutput binaryOutput, ZoneId zoneId) {
            binaryOutput.writeUTF(zoneId.getId());
        }

        public int inferSize(ZoneId zoneId) {
            return PolyglotJNIConfig.strsize(zoneId.getId());
        }
    }

    private static final class StringMapMarshaller
    implements BinaryMarshaller<Map<String, String>> {
        private static final int STRING_SIZE_ESTIMATE = 32;

        private StringMapMarshaller() {
        }

        public Map<String, String> read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            HashMap<String, String> hashMap = new HashMap<String, String>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = binaryInput.readUTF();
                String string2 = binaryInput.readUTF();
                hashMap.put(string, string2);
            }
            return hashMap;
        }

        public void write(BinaryOutput binaryOutput, Map<String, String> map) {
            binaryOutput.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                binaryOutput.writeUTF(entry.getKey());
                binaryOutput.writeUTF(entry.getValue());
            }
        }

        public int inferSize(Map<String, String> map) {
            return 4 + map.size() * 32 * 2;
        }
    }

    private static final class StringArrayMapMarshaller
    implements BinaryMarshaller<Map<String, String[]>> {
        private static final int STRING_SIZE_ESTIMATE = 32;
        private static final int STRING_ARRAY_SIZE_ESTIMATE = 32;

        private StringArrayMapMarshaller() {
        }

        public Map<String, String[]> read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = binaryInput.readUTF();
                int n3 = binaryInput.readInt();
                String[] stringArray = new String[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    stringArray[i3] = binaryInput.readUTF();
                }
                hashMap.put(string, stringArray);
            }
            return hashMap;
        }

        public void write(BinaryOutput binaryOutput, Map<String, String[]> map) {
            binaryOutput.writeInt(map.size());
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                binaryOutput.writeUTF(entry.getKey());
                String[] stringArray = entry.getValue();
                binaryOutput.writeInt(stringArray.length);
                for (String string : stringArray) {
                    binaryOutput.writeUTF(string);
                }
            }
        }

        public int inferSize(Map<String, String[]> map) {
            return 4 + map.size() * 68;
        }
    }

    private static final class StringSetMarshaller
    implements BinaryMarshaller<Set<String>> {
        private static final int STRING_SIZE_ESTIMATE = 32;

        private StringSetMarshaller() {
        }

        public Set<String> read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            HashSet<String> hashSet = new HashSet<String>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                hashSet.add(binaryInput.readUTF());
            }
            return hashSet;
        }

        public void write(BinaryOutput binaryOutput, Set<String> set) {
            binaryOutput.writeInt(set.size());
            for (String string : set) {
                binaryOutput.writeUTF(string);
            }
        }

        public int inferSize(Set<String> set) {
            return 4 + set.size() * 32;
        }
    }

    private static final class FileAttributeMarshaller
    implements BinaryMarshaller<FileAttribute<?>> {
        private static final int ATTRIBUTE_SIZE_ESTIMATE = 14;
        private static final byte POSIX_PERMISSIONS = 1;
        private final BinaryMarshaller<Set<PosixFilePermission>> posixFilePermissionsMarshaller;

        FileAttributeMarshaller(BinaryMarshaller<Set<PosixFilePermission>> binaryMarshaller) {
            this.posixFilePermissionsMarshaller = Objects.requireNonNull(binaryMarshaller);
        }

        public FileAttribute<?> read(BinaryInput binaryInput) {
            byte by = binaryInput.readByte();
            if (by == 1) {
                return PosixFilePermissions.asFileAttribute((Set)this.posixFilePermissionsMarshaller.read(binaryInput));
            }
            throw new IllegalArgumentException(String.valueOf(by));
        }

        public void write(BinaryOutput binaryOutput, FileAttribute<?> fileAttribute) {
            if (!"posix:permissions".equals(fileAttribute.name())) {
                throw new IllegalArgumentException(String.valueOf(fileAttribute));
            }
            binaryOutput.writeByte(1);
            this.posixFilePermissionsMarshaller.write(binaryOutput, FileAttributeMarshaller.asPosixFilePermissionsSet(fileAttribute.value()));
        }

        static Set<PosixFilePermission> asPosixFilePermissionsSet(Object object) {
            return (Set)object;
        }

        public int inferSize(FileAttribute<?> fileAttribute) {
            return 14;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface FileAttributeMap {
    }

    private static final class FileAttributeMapMarshaller
    implements BinaryMarshaller<Map<String, Object>> {
        private static final int KEY_SIZE_ESTIMATE = 20;
        private final FileAttributeValueMarshaller fileAttributeValueMarshaller;

        FileAttributeMapMarshaller(FileAttributeValueMarshaller fileAttributeValueMarshaller) {
            this.fileAttributeValueMarshaller = Objects.requireNonNull(fileAttributeValueMarshaller);
        }

        public Map<String, Object> read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            HashMap<String, Object> hashMap = new HashMap<String, Object>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = binaryInput.readUTF();
                Object object = this.fileAttributeValueMarshaller.read(binaryInput);
                hashMap.put(string, object);
            }
            return hashMap;
        }

        public void write(BinaryOutput binaryOutput, Map<String, Object> map) {
            binaryOutput.writeInt(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                Object object = entry.getValue();
                if ("fileKey".equals(string)) {
                    object = null;
                }
                binaryOutput.writeUTF(string);
                this.fileAttributeValueMarshaller.write(binaryOutput, object);
            }
        }

        public int inferSize(Map<String, Object> map) {
            return 4 + map.size() * 40;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER})
    static @interface ReadOnly {
    }

    private static final class ReadOnlyByteBufferMarshaller
    implements BinaryMarshaller<ByteBuffer> {
        private ReadOnlyByteBufferMarshaller() {
        }

        public ByteBuffer read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            return ByteBuffer.allocate(n2);
        }

        public void write(BinaryOutput binaryOutput, ByteBuffer byteBuffer) {
            binaryOutput.writeInt(byteBuffer.limit() - byteBuffer.position());
        }

        public void writeUpdate(BinaryOutput binaryOutput, ByteBuffer byteBuffer) {
            int n2 = byteBuffer.position();
            binaryOutput.writeInt(n2);
            binaryOutput.write(byteBuffer.array(), 0, byteBuffer.position());
        }

        public void readUpdate(BinaryInput binaryInput, ByteBuffer byteBuffer) {
            int n2 = binaryInput.readInt();
            if (!byteBuffer.isReadOnly()) {
                if (byteBuffer.hasArray()) {
                    int n3 = byteBuffer.position();
                    byte[] byArray = byteBuffer.array();
                    binaryInput.read(byArray, n3, n2);
                    byteBuffer.position(n3 + n2);
                } else {
                    byte[] byArray = new byte[n2];
                    binaryInput.read(byArray, 0, n2);
                    byteBuffer.put(byArray);
                }
            }
        }

        public int inferSize(ByteBuffer byteBuffer) {
            return 4;
        }

        public int inferUpdateSize(ByteBuffer byteBuffer) {
            return 4 + byteBuffer.position();
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER})
    static @interface WriteOnly {
    }

    private static final class WriteOnlyByteBufferMarshaller
    implements BinaryMarshaller<ByteBuffer> {
        private WriteOnlyByteBufferMarshaller() {
        }

        public ByteBuffer read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            return binaryInput.asByteBuffer(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(BinaryOutput binaryOutput, ByteBuffer byteBuffer) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            int n4 = n3 - n2;
            binaryOutput.writeInt(n4);
            if (byteBuffer.hasArray()) {
                byte[] byArray = byteBuffer.array();
                binaryOutput.write(byArray, n2, n3);
            } else {
                byte[] byArray = new byte[n4];
                try {
                    byteBuffer.get(byArray);
                }
                finally {
                    byteBuffer.position(n2);
                }
                binaryOutput.write(byArray, 0, n4);
            }
        }

        public void writeUpdate(BinaryOutput binaryOutput, ByteBuffer byteBuffer) {
            int n2 = byteBuffer.position();
            binaryOutput.writeInt(n2);
        }

        public void readUpdate(BinaryInput binaryInput, ByteBuffer byteBuffer) {
            int n2 = binaryInput.readInt();
            byteBuffer.position(byteBuffer.position() + n2);
        }

        public int inferSize(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.limit() - byteBuffer.position();
            return 4 + n2;
        }

        public int inferUpdateSize(ByteBuffer byteBuffer) {
            return 4;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface ContextReceiver {
    }

    private static final class ContextReceiverMarshaller
    implements BinaryMarshaller<Object> {
        private ContextReceiverMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            if (PolyglotJNIConfig.isHost()) {
                long l2 = binaryInput.readLong();
                long l3 = binaryInput.readLong();
                EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
                return enterprisePolyglotImpl.findContextByHandle(l2, l3);
            }
            throw new UnsupportedOperationException("Not supported on the guest.");
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
            }
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported on the host.");
            }
            assert (object == EnterpriseEngineAccessor.ENGINE.getOuterContext(object));
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
            Long l2 = null;
            if (!lazy.disposed) {
                l2 = lazy.contextHandleByContextReceiver.get(object);
            }
            if (l2 != null) {
                binaryOutput.writeLong(l2.longValue());
            } else {
                binaryOutput.writeLong(0L);
            }
        }

        public int inferSize(Object object) {
            return 16;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface EngineReceiver {
    }

    private static final class EngineReceiverMarshaller
    implements BinaryMarshaller<Object> {
        private EngineReceiverMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            if (PolyglotJNIConfig.isHost()) {
                long l2 = binaryInput.readLong();
                long l3 = binaryInput.readLong();
                EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
                return enterprisePolyglotImpl.findEngineReceiverByHandle(l2, l3);
            }
            throw new UnsupportedOperationException("Not supported on the guest.");
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
            }
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported on the host.");
            }
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
            Long l2 = null;
            if (!lazy.disposed) {
                l2 = lazy.engineHandleByEngineReceiver.get(object);
            }
            if (l2 != null) {
                binaryOutput.writeLong(l2.longValue());
            } else {
                binaryOutput.writeLong(0L);
            }
        }

        public int inferSize(Object object) {
            return 16;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface EnvironmentAccessByValue {
    }

    private static final class EnvironmentAccessMarshaller
    implements BinaryMarshaller<Object> {
        private static final int NONE = 0;
        private static final int INHERIT = 1;

        private EnvironmentAccessMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
            switch (n2) {
                case 0: {
                    return aPIAccess.getEnvironmentAccessNone();
                }
                case 1: {
                    return aPIAccess.getEnvironmentAccessInherit();
                }
            }
            throw new IllegalArgumentException("Unsupported environment access " + n2);
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            int n2;
            AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
            if (object == aPIAccess.getEnvironmentAccessNone()) {
                n2 = 0;
            } else if (object == aPIAccess.getEnvironmentAccessInherit()) {
                n2 = 1;
            } else {
                throw new IllegalArgumentException("Unsupported environment access " + String.valueOf(object));
            }
            binaryOutput.writeInt(n2);
        }

        public int inferSize(Object object) {
            return 4;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface FileAttributeValue {
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface HostContext {
    }

    private static final class HostContextMarshaller
    implements BinaryMarshaller<Object> {
        private HostContextMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            long l2 = binaryInput.readLong();
            long l3 = binaryInput.readLong();
            EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
            NativeContext nativeContext = (NativeContext)((Object)enterprisePolyglotImpl.findContextByHandle(l2, l3));
            Object object = enterprisePolyglotImpl.getAPIAccess().getContextReceiver((Object)nativeContext.getLocalContext());
            return EnterpriseEngineAccessor.ENGINE.getHostContext(object);
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            GuestHostLanguage.GuestHostLanguageContext guestHostLanguageContext = (GuestHostLanguage.GuestHostLanguageContext)object;
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            binaryOutput.writeLong(PolyglotIsolate.lazy.contextHandleByContextReceiver.get(guestHostLanguageContext.internalOuterContext).longValue());
        }

        public int inferSize(Object object) {
            return 16;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface InteropObject {
    }

    private static final class InteropObjectMarshaller
    implements BinaryMarshaller<Object> {
        private InteropObjectMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            if (PolyglotJNIConfig.isHost()) {
                EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
                NativeContext nativeContext = (NativeContext)((Object)enterprisePolyglotImpl.getAPIAccess().getContextReceiver(enterprisePolyglotImpl.getCurrentContext()));
                return BinaryProtocol.readHostTypedValue(binaryInput, nativeContext);
            }
            if (ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                long l2 = binaryInput.readLong();
                return BinaryProtocol.readGuestTypedValue(binaryInput, PolyglotIsolate.getHSContextByHandle(l2));
            }
            throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (!(object instanceof TruffleObject)) {
                throw CompilerDirectives.shouldNotReachHere((String)"Must be a truffle object");
            }
            EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
            if (PolyglotJNIConfig.isHost()) {
                NativeContext nativeContext = (NativeContext)((Object)enterprisePolyglotImpl.getAPIAccess().getContextReceiver(enterprisePolyglotImpl.getCurrentContext()));
                long l2 = nativeContext.getHandle();
                binaryOutput.writeLong(l2);
                BinaryProtocol.writeHostTypedValue(binaryOutput, object, nativeContext.getGuestToHostReceiver());
            } else if (ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                Object object2 = enterprisePolyglotImpl.getAPIAccess().getContextReceiver(enterprisePolyglotImpl.getCurrentContext());
                HSContext hSContext = PolyglotIsolate.getHSContextByHandle(EnterprisePolyglotImpl.findContextHandleByContextReceiver(object2));
                BinaryProtocol.writeGuestTypedValue(binaryOutput, object, hSContext.hostToGuestObjectReferences);
            } else {
                throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
            }
        }

        public int inferSize(Object object) {
            return 17;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface IOAccessByValue {
    }

    private static final class IOAccessMarshaller
    implements BinaryMarshaller<Object> {
        private IOAccessMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            boolean bl = binaryInput.readBoolean();
            boolean bl2 = binaryInput.readBoolean();
            AbstractPolyglotImpl.IOAccessor iOAccessor = EnterprisePolyglotImpl.instance.getIO();
            return iOAccessor.createIOAccess(null, bl, bl2, null);
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            AbstractPolyglotImpl.IOAccessor iOAccessor = EnterprisePolyglotImpl.instance.getIO();
            binaryOutput.writeBoolean(iOAccessor.hasHostFileAccess(object));
            binaryOutput.writeBoolean(iOAccessor.hasHostSocketAccess(object));
        }

        public int inferSize(Object object) {
            return 2;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface Null {
    }

    private static final class NullMarshaller
    implements BinaryMarshaller<Object> {
        private NullMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            return null;
        }

        public void write(BinaryOutput binaryOutput, Object object) {
        }

        public int inferSize(Object object) {
            return 0;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface OptionValue {
    }

    private static final class OptionValueMarshaller
    implements BinaryMarshaller<Object> {
        private static final int OPTION_VALUE_SIZE_ESTIMATE = 16;
        static final int VALUE = 1;
        static final int MAP = 2;
        static final int UNSUPPORTED = 3;

        private OptionValueMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            byte by = binaryInput.readByte();
            switch (by) {
                case 3: {
                    return null;
                }
                case 1: {
                    return OptionValueMarshaller.readValue(binaryInput);
                }
                case 2: {
                    int n2 = binaryInput.readInt();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = binaryInput.readUTF();
                        Object object = OptionValueMarshaller.readValue(binaryInput);
                        if (object == null) {
                            return null;
                        }
                        hashMap.put(string, object);
                    }
                    return hashMap;
                }
            }
            throw new UnsupportedOperationException("Unknown kind: " + by);
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (object instanceof Map) {
                Map map = (Map)object;
                if (OptionValueMarshaller.isMapSupported(map)) {
                    binaryOutput.writeByte(2);
                    binaryOutput.writeInt(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        binaryOutput.writeUTF((String)entry.getKey());
                        OptionValueMarshaller.writeValue(binaryOutput, entry.getValue());
                    }
                } else {
                    binaryOutput.writeByte(3);
                }
            } else if (OptionValueMarshaller.isValueSupported(object)) {
                binaryOutput.writeByte(1);
                OptionValueMarshaller.writeValue(binaryOutput, object);
            } else {
                binaryOutput.writeByte(3);
            }
        }

        private static void writeValue(BinaryOutput binaryOutput, Object object) {
            if (OptionValueMarshaller.isValue(object)) {
                binaryOutput.writeBoolean(false);
                binaryOutput.writeTypedValue(object);
            } else {
                binaryOutput.writeBoolean(true);
                binaryOutput.writeUTF(object.getClass().getName());
                binaryOutput.writeInt(((Enum)object).ordinal());
            }
        }

        private static Object readValue(BinaryInput binaryInput) {
            boolean bl = binaryInput.readBoolean();
            if (!bl) {
                return binaryInput.readTypedValue();
            }
            String string = binaryInput.readUTF();
            int n2 = binaryInput.readInt();
            try {
                Class<?> clazz = Class.forName(string);
                return clazz.getEnumConstants()[n2];
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static boolean isValue(Object object) {
            if (object == null) {
                return false;
            }
            Class<?> clazz = object.getClass();
            return clazz == String.class || clazz == Boolean.class || clazz == Byte.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
        }

        private static boolean isEnum(Object object) {
            return object instanceof Enum;
        }

        private static boolean isValueSupported(Object object) {
            return OptionValueMarshaller.isValue(object) || OptionValueMarshaller.isEnum(object);
        }

        private static boolean isMapSupported(Map<String, Object> map) {
            for (Object object : map.values()) {
                if (OptionValueMarshaller.isValueSupported(object)) continue;
                return false;
            }
            return true;
        }

        public int inferSize(Object object) {
            return 16;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface PolyglotAccessByValue {
    }

    private static final class PolyglotAccessMarshaller
    implements BinaryMarshaller<Object> {
        private static final int BINDING_SIZE_ESTIMATE = 48;

        private PolyglotAccessMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            boolean bl = binaryInput.readBoolean();
            if (bl) {
                return EnterprisePolyglotImpl.instance.getAPIAccess().getPolyglotAccessAll();
            }
            int n2 = binaryInput.readInt();
            int n3 = binaryInput.readInt();
            if (n2 == 0 && n3 == 0) {
                return EnterprisePolyglotImpl.instance.getAPIAccess().getPolyglotAccessNone();
            }
            AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
            HashSet<String> hashSet = new HashSet<String>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = binaryInput.readUTF();
                hashSet.add(string);
            }
            HashMap hashMap = new HashMap(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                String string = binaryInput.readUTF();
                int n4 = binaryInput.readInt();
                HashSet<String> hashSet2 = new HashSet<String>(n4);
                for (int i4 = 0; i4 < n4; ++i4) {
                    String string2 = binaryInput.readUTF();
                    hashSet2.add(string2);
                }
                hashMap.put(string, hashSet2);
            }
            return aPIAccess.createPolyglotAccess(hashSet, hashMap);
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
            Set set = aPIAccess.getBindingsAccess(object);
            boolean bl = set == null;
            Map map = aPIAccess.getEvalAccess(object);
            assert (!bl || map == null);
            binaryOutput.writeBoolean(bl);
            if (!bl) {
                binaryOutput.writeInt(set.size());
                binaryOutput.writeInt(map.size());
                for (String object2 : set) {
                    binaryOutput.writeUTF(object2);
                }
                for (Map.Entry entry : map.entrySet()) {
                    binaryOutput.writeUTF((String)entry.getKey());
                    Set set2 = (Set)entry.getValue();
                    binaryOutput.writeInt(set2.size());
                    for (String string : set2) {
                        binaryOutput.writeUTF(string);
                    }
                }
            }
        }

        public int inferSize(Object object) {
            AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
            Set set = aPIAccess.getBindingsAccess(object);
            int n2 = 1;
            if (set != null) {
                n2 += set.size() * 48;
            }
            return n2;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface SourceByValue {
    }

    private static final class SourceCopyMarshaller
    implements BinaryMarshaller<Object> {
        private SourceCopyMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            try {
                CharSequence charSequence;
                String string = binaryInput.readUTF();
                String string2 = (String)binaryInput.readTypedValue();
                String string3 = binaryInput.readUTF();
                String string4 = (String)binaryInput.readTypedValue();
                URI uRI = string4 == null ? null : URI.create(string4);
                String string5 = (String)binaryInput.readTypedValue();
                URL uRL = string5 == null ? null : new URL(string5);
                String string6 = (String)binaryInput.readTypedValue();
                boolean bl = binaryInput.readBoolean();
                boolean bl2 = binaryInput.readBoolean();
                boolean bl3 = binaryInput.readBoolean();
                boolean bl4 = binaryInput.readBoolean();
                boolean bl5 = binaryInput.readBoolean();
                if (bl4) {
                    charSequence = binaryInput.readUTF();
                } else if (bl5) {
                    int n2 = binaryInput.readInt();
                    byte[] byArray = new byte[n2];
                    binaryInput.read(byArray, 0, n2);
                    charSequence = ByteSequence.create((byte[])byArray);
                } else {
                    charSequence = Source.CONTENT_NONE;
                }
                return EnterprisePolyglotImpl.instance.buildSource(string3, charSequence, uRI, string, string6, charSequence, bl, bl2, bl3, null, uRL, string2);
            }
            catch (IOException iOException) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)iOException);
            }
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
            AbstractPolyglotImpl.AbstractSourceDispatch abstractSourceDispatch = enterprisePolyglotImpl.getAPIAccess().getSourceDispatch(object);
            Object object2 = enterprisePolyglotImpl.getAPIAccess().getSourceReceiver(object);
            binaryOutput.writeUTF(abstractSourceDispatch.getName(object2));
            binaryOutput.writeTypedValue((Object)abstractSourceDispatch.getPath(object2));
            binaryOutput.writeUTF(abstractSourceDispatch.getLanguage(object2));
            URI uRI = abstractSourceDispatch.getURI(object2);
            String string = uRI == null ? null : uRI.toString();
            binaryOutput.writeTypedValue((Object)string);
            URL uRL = abstractSourceDispatch.getURL(object2);
            String string2 = uRL == null ? null : uRL.toString();
            binaryOutput.writeTypedValue((Object)string2);
            String string3 = abstractSourceDispatch.getMimeType(object2);
            binaryOutput.writeTypedValue((Object)string3);
            binaryOutput.writeBoolean(abstractSourceDispatch.isInteractive(object2));
            binaryOutput.writeBoolean(abstractSourceDispatch.isInternal(object2));
            binaryOutput.writeBoolean(abstractSourceDispatch.isCached(object2));
            boolean bl = abstractSourceDispatch.hasCharacters(object2);
            boolean bl2 = abstractSourceDispatch.hasBytes(object2);
            binaryOutput.writeBoolean(bl);
            binaryOutput.writeBoolean(bl2);
            if (bl) {
                binaryOutput.writeUTF(abstractSourceDispatch.getCharacters(object2).toString());
            } else if (bl2) {
                byte[] byArray = abstractSourceDispatch.getByteArray(object2);
                binaryOutput.writeInt(byArray.length);
                binaryOutput.write(byArray, 0, byArray.length);
            }
        }

        public int inferSize(Object object) {
            int n2 = 0;
            EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
            AbstractPolyglotImpl.AbstractSourceDispatch abstractSourceDispatch = enterprisePolyglotImpl.getAPIAccess().getSourceDispatch(object);
            Object object2 = enterprisePolyglotImpl.getAPIAccess().getSourceReceiver(object);
            n2 += PolyglotJNIConfig.strsize(abstractSourceDispatch.getName(object2));
            n2 += PolyglotJNIConfig.strsize(abstractSourceDispatch.getLanguage(object2));
            URI uRI = abstractSourceDispatch.getURI(object2);
            String string = uRI == null ? "" : uRI.toString();
            n2 += PolyglotJNIConfig.strsize(string);
            String string2 = abstractSourceDispatch.getMimeType(object2);
            string2 = string2 == null ? "" : string2;
            n2 += PolyglotJNIConfig.strsize(string2);
            n2 += 5;
            if (abstractSourceDispatch.hasCharacters(object2) || abstractSourceDispatch.hasBytes(object2)) {
                n2 += 4 + abstractSourceDispatch.getLength(object2);
            }
            return n2;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface SourceReceiver {
    }

    private static final class SourceMarshaller
    implements BinaryMarshaller<Object> {
        private SourceMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            long l2 = binaryInput.readLong();
            NativeIsolate nativeIsolate = NativeIsolate.get((long)l2);
            return SourceMarshaller.deserializeSource(binaryInput, nativeIsolate, EnterprisePolyglotImpl.instance.getAPIAccess());
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported for HotSpot to Native.");
            }
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            SourceMarshaller.serializeSource(binaryOutput, object);
        }

        static void serializeSource(BinaryOutput binaryOutput, Object object) {
            binaryOutput.writeLong(NativeObjectHandles.create((Object)object));
        }

        static Object deserializeSource(BinaryInput binaryInput, NativeIsolate nativeIsolate, AbstractPolyglotImpl.APIAccess aPIAccess) {
            long l2 = binaryInput.readLong();
            NativeObject nativeObject = new NativeObject(nativeIsolate, l2);
            return aPIAccess.newSource(EnterprisePolyglotImpl.instance.getSourceDispatch(), (Object)nativeObject);
        }

        public int inferSize(Object object) {
            return 16;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface SourceSectionReceiver {
    }

    private static final class SourceSectionMarshaller
    implements BinaryMarshaller<Object> {
        private SourceSectionMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            long l2 = binaryInput.readLong();
            NativeIsolate nativeIsolate = NativeIsolate.get((long)l2);
            AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
            Object object = SourceMarshaller.deserializeSource(binaryInput, nativeIsolate, aPIAccess);
            long l3 = binaryInput.readLong();
            NativeObject nativeObject = new NativeObject(nativeIsolate, l3);
            return aPIAccess.newSourceSection(object, EnterprisePolyglotImpl.instance.getSourceSectionDispatch(), (Object)nativeObject);
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported for HotSpot to Native.");
            }
            AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            SourceMarshaller.serializeSource(binaryOutput, aPIAccess.getSourceSectionSource(object));
            binaryOutput.writeLong(NativeObjectHandles.create((Object)object));
        }

        public int inferSize(Object object) {
            return 24;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface TruffleFile {
    }

    private static final class TruffleFileMarshaller
    implements BinaryMarshaller<Object> {
        private TruffleFileMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            boolean bl = binaryInput.readBoolean();
            String string = binaryInput.readUTF();
            Object object = EnterpriseEngineAccessor.ENGINE.getCurrentHostContext();
            Object object2 = bl ? EnterpriseEngineAccessor.ENGINE.getInternalFileSystemContext(object) : EnterpriseEngineAccessor.ENGINE.getPublicFileSystemContext(object);
            return EnterpriseEngineAccessor.LANGUAGE.getTruffleFile(string, object2);
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            com.oracle.truffle.api.TruffleFile truffleFile = (com.oracle.truffle.api.TruffleFile)object;
            binaryOutput.writeBoolean(EnterpriseEngineAccessor.ENGINE.isInternal(truffleFile));
            binaryOutput.writeUTF(truffleFile.getPath());
        }

        public int inferSize(Object object) {
            return 1 + PolyglotJNIConfig.strsize(((com.oracle.truffle.api.TruffleFile)object).getPath());
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface ValueReceiver {
    }

    private static final class ValueMarshaller
    implements BinaryMarshaller<Object> {
        private static final int VALUE_SIZE_ESTIMATE = 128;

        private ValueMarshaller() {
        }

        public Object read(BinaryInput binaryInput) {
            if (PolyglotJNIConfig.isHost()) {
                long l2 = binaryInput.readLong();
                long l3 = binaryInput.readLong();
                NativeContext nativeContext = (NativeContext)((Object)EnterprisePolyglotImpl.instance.findContextByHandle(l2, l3));
                Object object = EnterprisePolyglotImpl.instance.getAPIAccess().getContextReceiver((Object)nativeContext.getLocalContext());
                return EnterpriseEngineAccessor.ENGINE.asValue(object, BinaryProtocol.readHostTypedValue(binaryInput, nativeContext));
            }
            throw new UnsupportedOperationException("Not supported on the guest.");
        }

        public void write(BinaryOutput binaryOutput, Object object) {
            if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
            }
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported on the host.");
            }
            EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
            AbstractPolyglotImpl.APIAccess aPIAccess = enterprisePolyglotImpl.getAPIAccess();
            Object object2 = aPIAccess.getContextReceiver((Object)((Value)object).getContext());
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            long l2 = EnterprisePolyglotImpl.findContextHandleByContextReceiver(object2);
            binaryOutput.writeLong(l2);
            Object object3 = aPIAccess.getValueReceiver(object);
            HSContext hSContext = PolyglotIsolate.getHSContextByHandle(l2);
            BinaryProtocol.writeGuestTypedValue(binaryOutput, object3, hSContext.hostToGuestObjectReferences);
        }

        public int inferSize(Object object) {
            return 128;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface PolyglotExceptionReceiver {
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface InstrumentsMap {
    }

    private static final class InstrumentMapMarshaller
    implements BinaryMarshaller<Map<String, Object>> {
        private static final int INSTRUMENT_SIZE_ESTIMATE = 24;

        private InstrumentMapMarshaller() {
        }

        public Map<String, Object> read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            NativeIsolate nativeIsolate = NativeIsolate.get((long)binaryInput.readLong());
            HashMap<String, Object> hashMap = new HashMap<String, Object>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = binaryInput.readUTF();
                long l2 = binaryInput.readLong();
                NativeObject nativeObject = new NativeObject(nativeIsolate, l2);
                hashMap.put(string, nativeObject);
            }
            return hashMap;
        }

        public void write(BinaryOutput binaryOutput, Map<String, Object> map) {
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported for HotSpot to Native.");
            }
            binaryOutput.writeInt(map.size());
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                binaryOutput.writeUTF(entry.getKey());
                binaryOutput.writeLong(NativeObjectHandles.create((Object)entry.getValue()));
            }
        }

        public int inferSize(Map<String, Object> map) {
            return 12 + map.size() * 24;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface LanguagesMap {
    }

    private static final class LanguageMapMarshaller
    implements BinaryMarshaller<Map<String, Object>> {
        private static final int LANGUAGE_SIZE_ESTIMATE = 24;

        private LanguageMapMarshaller() {
        }

        public Map<String, Object> read(BinaryInput binaryInput) {
            int n2 = binaryInput.readInt();
            NativeIsolate nativeIsolate = NativeIsolate.get((long)binaryInput.readLong());
            HashMap<String, Object> hashMap = new HashMap<String, Object>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = binaryInput.readUTF();
                long l2 = binaryInput.readLong();
                NativeObject nativeObject = new NativeObject(nativeIsolate, l2);
                hashMap.put(string, nativeObject);
            }
            return hashMap;
        }

        public void write(BinaryOutput binaryOutput, Map<String, Object> map) {
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported for HotSpot to Native.");
            }
            binaryOutput.writeInt(map.size());
            binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                binaryOutput.writeUTF(entry.getKey());
                binaryOutput.writeLong(NativeObjectHandles.create((Object)entry.getValue()));
            }
        }

        public int inferSize(Map<String, Object> map) {
            return 12 + map.size() * 24;
        }
    }

    @MarshallerAnnotation
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    static @interface ValuesList {
    }

    private static final class ValueListMarshaller
    implements BinaryMarshaller<List<Object>> {
        private ValueListMarshaller() {
        }

        public List<Object> read(BinaryInput binaryInput) {
            if (PolyglotJNIConfig.isHost()) {
                int n2 = binaryInput.readInt();
                if (n2 == 0) {
                    return Collections.emptyList();
                }
                long l2 = binaryInput.readLong();
                long l3 = binaryInput.readLong();
                NativeContext nativeContext = (NativeContext)((Object)EnterprisePolyglotImpl.instance.findContextByHandle(l2, l3));
                Object object = EnterprisePolyglotImpl.instance.getAPIAccess().getContextReceiver((Object)nativeContext.getLocalContext());
                ArrayList<Object> arrayList = new ArrayList<Object>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object2 = EnterpriseEngineAccessor.ENGINE.asValue(object, BinaryProtocol.readHostTypedValue(binaryInput, nativeContext));
                    arrayList.add(object2);
                }
                return arrayList;
            }
            throw new UnsupportedOperationException("Not supported on the guest.");
        }

        public void write(BinaryOutput binaryOutput, List<Object> list) {
            if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                throw new UnsupportedOperationException("Not supported on the guest when the PolyglotIsolateGuestFeature is not enabled.");
            }
            if (PolyglotJNIConfig.isHost()) {
                throw new UnsupportedOperationException("Not supported on the host.");
            }
            int n2 = list.size();
            binaryOutput.writeInt(n2);
            if (n2 > 0) {
                EnterprisePolyglotImpl enterprisePolyglotImpl = EnterprisePolyglotImpl.instance;
                AbstractPolyglotImpl.APIAccess aPIAccess = enterprisePolyglotImpl.getAPIAccess();
                Object object = aPIAccess.getContextReceiver((Object)((Value)list.get(0)).getContext());
                binaryOutput.writeLong(CurrentIsolate.getIsolate().rawValue());
                long l2 = EnterprisePolyglotImpl.findContextHandleByContextReceiver(object);
                binaryOutput.writeLong(l2);
                HSContext hSContext = PolyglotIsolate.getHSContextByHandle(l2);
                HSObjectReferences hSObjectReferences = hSContext.hostToGuestObjectReferences;
                for (Object object2 : list) {
                    Object object3 = aPIAccess.getValueReceiver(object2);
                    BinaryProtocol.writeGuestTypedValue(binaryOutput, object3, hSObjectReferences);
                }
            }
        }

        public int inferSize(List<Object> list) {
            return 20 + list.size() * 9;
        }
    }
}

