/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSInputStream;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.io.InputStream;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;

final class HSInputStreamGen {
    HSInputStreamGen() {
    }

    static HSInputStream createNativeToHS(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
        return new StartPoint(hSPolyglotObject, jNIEnv);
    }

    private static final class StartPoint
    extends HSInputStream {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
            super(hSPolyglotObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public int available() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.availableMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.closeMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void mark(int n2) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                jValue.addressOf(1).setInt(n2);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.markMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean markSupported() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.markSupportedMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public int read() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readMethod2, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                jValue.addressOf(1).setJObject((JNI.JObject)jByteArray);
                jValue.addressOf(2).setInt(0);
                jValue.addressOf(3).setInt(n3);
                int n4 = ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readMethod3, jValue);
                if (n4 > 0) {
                    JNIUtil.arrayCopy((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (byte[])byArray, (int)n2, (int)n4);
                }
                return n4;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                return JNIUtil.createArray((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)((JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readAllBytesMethod, jValue)));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public byte[] readNBytes(int n2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                jValue.addressOf(1).setInt(n2);
                return JNIUtil.createArray((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)((JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readNBytesMethod2, jValue)));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public int readNBytes(byte[] byArray, int n2, int n3) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                jValue.addressOf(1).setJObject((JNI.JObject)JNIUtil.createHSArray((JNI.JNIEnv)jNIEnv, (byte[])byArray));
                jValue.addressOf(2).setInt(n2);
                jValue.addressOf(3).setInt(n3);
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readNBytesMethod3, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void reset() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.resetMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long skip(long l2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                jValue.addressOf(1).setLong(l2);
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.skipMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void skipNBytes(long l2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostInputStream.getHandle());
                jValue.addressOf(1).setLong(l2);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.skipNBytesMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod availableMethod;
            final JNICalls.JNIMethod closeMethod;
            final JNICalls.JNIMethod markMethod;
            final JNICalls.JNIMethod markSupportedMethod;
            final JNICalls.JNIMethod readMethod2;
            final JNICalls.JNIMethod readMethod3;
            final JNICalls.JNIMethod readAllBytesMethod;
            final JNICalls.JNIMethod readNBytesMethod2;
            final JNICalls.JNIMethod readNBytesMethod3;
            final JNICalls.JNIMethod resetMethod;
            final JNICalls.JNIMethod skipMethod;
            final JNICalls.JNIMethod skipNBytesMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.availableMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"available", (String)"(Ljava/io/InputStream;)I");
                this.closeMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"close", (String)"(Ljava/io/InputStream;)V");
                this.markMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"mark", (String)"(Ljava/io/InputStream;I)V");
                this.markSupportedMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"markSupported", (String)"(Ljava/io/InputStream;)Z");
                this.readMethod2 = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"read", (String)"(Ljava/io/InputStream;)I");
                this.readMethod3 = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"read", (String)"(Ljava/io/InputStream;[BII)I");
                this.readAllBytesMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"readAllBytes", (String)"(Ljava/io/InputStream;)[B");
                this.readNBytesMethod2 = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"readNBytes", (String)"(Ljava/io/InputStream;I)[B");
                this.readNBytesMethod3 = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"readNBytes", (String)"(Ljava/io/InputStream;[BII)I");
                this.resetMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"reset", (String)"(Ljava/io/InputStream;)V");
                this.skipMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"skip", (String)"(Ljava/io/InputStream;J)J");
                this.skipNBytesMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"skipNBytes", (String)"(Ljava/io/InputStream;J)V");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static int available(InputStream inputStream) {
            try {
                int n2 = inputStream.available();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void close(InputStream inputStream) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void mark(InputStream inputStream, int n2) {
            try {
                inputStream.mark(n2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean markSupported(InputStream inputStream) {
            try {
                boolean bl = inputStream.markSupported();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int read(InputStream inputStream) {
            try {
                int n2 = inputStream.read();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int read(InputStream inputStream, byte[] byArray, int n2, int n3) {
            try {
                int n4 = inputStream.read(byArray, n2, n3);
                return n4;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] readAllBytes(InputStream inputStream) {
            try {
                byte[] byArray = inputStream.readAllBytes();
                return byArray;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] readNBytes(InputStream inputStream, int n2) {
            try {
                byte[] byArray = inputStream.readNBytes(n2);
                return byArray;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int readNBytes(InputStream inputStream, byte[] byArray, int n2, int n3) {
            try {
                int n4 = inputStream.readNBytes(byArray, n2, n3);
                return n4;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void reset(InputStream inputStream) {
            try {
                inputStream.reset();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long skip(InputStream inputStream, long l2) {
            try {
                long l3 = inputStream.skip(l2);
                return l3;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void skipNBytes(InputStream inputStream, long l2) {
            try {
                inputStream.skipNBytes(l2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

