/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

abstract class CleanableWeakReference<T>
extends WeakReference<T>
implements Runnable {
    private static final Set<CleanableWeakReference<?>> cleaners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ReferenceQueue<Object> cleanersQueue = new ReferenceQueue();

    CleanableWeakReference(T t2) {
        super(t2, cleanersQueue);
        CleanableWeakReference.clean();
        cleaners.add(this);
    }

    void invalidate() {
        cleaners.remove(this);
    }

    static void clean() {
        CleanableWeakReference cleanableWeakReference;
        while ((cleanableWeakReference = (CleanableWeakReference)cleanersQueue.poll()) != null) {
            if (!cleaners.remove(cleanableWeakReference)) continue;
            cleanableWeakReference.run();
        }
    }
}

