/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSStringPredicate;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.function.Predicate;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;

final class HSStringPredicateGen {
    HSStringPredicateGen() {
    }

    static HSStringPredicate createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSStringPredicate {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public boolean test(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.testMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod testMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.testMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"test", (String)"(Ljava/util/function/Predicate;Ljava/lang/String;)Z");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static boolean test(Predicate<String> predicate, String string) {
            try {
                boolean bl = predicate.test(string);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

