/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.InternalResourceCache;
import com.oracle.truffle.polyglot.InternalResourceRoots;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;

final class FileSystems {
    static final org.graalvm.polyglot.io.FileSystem INVALID_FILESYSTEM = new InvalidFileSystem();

    private FileSystems() {
        throw new IllegalStateException("No instance allowed");
    }

    static org.graalvm.polyglot.io.FileSystem newDefaultFileSystem(String hostTmpDirPath) {
        return new NIOFileSystem(FileSystems.findDefaultFileSystem(), hostTmpDirPath, true);
    }

    static org.graalvm.polyglot.io.FileSystem newNIOFileSystem(FileSystem fileSystem) {
        return new NIOFileSystem(fileSystem, null, false);
    }

    static org.graalvm.polyglot.io.FileSystem allowInternalResourceAccess(AbstractPolyglotImpl polyglot, org.graalvm.polyglot.io.FileSystem fileSystem) {
        HashSet<Path> languageHomes = new HashSet<Path>();
        for (LanguageCache cache : LanguageCache.languages().values()) {
            String languageHome = cache.getLanguageHome();
            if (languageHome == null) continue;
            languageHomes.add(Paths.get(languageHome, new String[0]));
        }
        ForwardingFileSystem internalResourcesFileSystem = new ForwardingFileSystem(FileSystems.newDefaultFileSystem(null)){

            @Override
            public boolean isHost() {
                return false;
            }
        };
        InternalResourcesSelector selector = new InternalResourcesSelector(internalResourcesFileSystem, InternalResourceRoots.getInstance(), languageHomes);
        return new CompositeFileSystem(polyglot, fileSystem, selector);
    }

    static org.graalvm.polyglot.io.FileSystem newCompositeFileSystem(AbstractPolyglotImpl polyglot, org.graalvm.polyglot.io.FileSystem fallbackFileSystem, FileSystem.Selector ... delegates) {
        return new CompositeFileSystem(polyglot, fallbackFileSystem, delegates);
    }

    static org.graalvm.polyglot.io.FileSystem newReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return new ReadOnlyFileSystem(fileSystem);
    }

    static org.graalvm.polyglot.io.FileSystem newDenyIOFileSystem() {
        return new DeniedIOFileSystem();
    }

    static org.graalvm.polyglot.io.FileSystem newResourcesFileSystem(PolyglotEngineImpl engine) {
        org.graalvm.polyglot.io.FileSystem defaultFS = FileSystems.newDefaultFileSystem(null);
        ReadOnlyFileSystem internalResourcesFileSystem = new ReadOnlyFileSystem(defaultFS);
        InternalResourcesSelector selector = new InternalResourcesSelector(internalResourcesFileSystem, engine.internalResourceRoots, List.copyOf(engine.languageHomes().values()));
        return new CompositeFileSystem(engine.getImpl(), new PathOperationsOnlyFileSystem(defaultFS), selector);
    }

    static boolean hasNoAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).hasNoAccess();
    }

    static boolean isInternal(AbstractPolyglotImpl polyglot, org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isInternal(polyglot);
    }

    static boolean isHostFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isHost();
    }

    static Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> newFileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
        return new FileTypeDetectorsSupplier(languageCaches);
    }

    static String getRelativePathInResourceRoot(TruffleFile file) {
        Object engineObject = EngineAccessor.LANGUAGE.getFileSystemEngineObject(EngineAccessor.LANGUAGE.getFileSystemContext(file));
        if (engineObject instanceof PolyglotLanguageContext) {
            Path hostPath;
            InternalResourceCache cache;
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)engineObject;
            Path path = EngineAccessor.LANGUAGE.getPath(file);
            if (InternalResourceCache.usesInternalResources() && (cache = languageContext.context.engine.internalResourceRoots.findInternalResource(hostPath = FileSystems.toHostPath(path))) != null) {
                return cache.getPathOrNull().relativize(hostPath).toString();
            }
            org.graalvm.polyglot.io.FileSystem fs = EngineAccessor.LANGUAGE.getFileSystem(file);
            String result = FileSystems.relativizeToLanguageHome(fs, path, languageContext.language);
            if (result != null) {
                return result;
            }
            Map<String, LanguageInfo> accessibleLanguages = languageContext.getAccessibleLanguages(true);
            if (accessibleLanguages != null) {
                for (LanguageInfo language : accessibleLanguages.values()) {
                    PolyglotLanguage lang = languageContext.context.engine.idToLanguage.get(language.getId());
                    result = FileSystems.relativizeToLanguageHome(fs, path, lang);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
        if (engineObject instanceof PolyglotImpl.EmbedderFileSystemContext) {
            return null;
        }
        throw new AssertionError();
    }

    private static Path toHostPath(Path path) {
        if (path.getClass() != Path.of("", new String[0]).getClass()) {
            return Paths.get(path.toString(), new String[0]);
        }
        return path;
    }

    private static String relativizeToLanguageHome(org.graalvm.polyglot.io.FileSystem fs, Path path, PolyglotLanguage language) {
        String languageHome = language.cache.getLanguageHome();
        if (languageHome == null) {
            return null;
        }
        Path languageHomePath = fs.parsePath(language.cache.getLanguageHome());
        if (path.startsWith(languageHomePath)) {
            return languageHomePath.relativize(path).toString();
        }
        return null;
    }

    private static FileSystem findDefaultFileSystem() {
        FileSystem fs = java.nio.file.FileSystems.getDefault();
        assert ("file".equals(fs.provider().getScheme()));
        return fs;
    }

    private static FileSystemProvider findDefaultFileSystemProvider() {
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!"file".equals(provider.getScheme())) continue;
            return provider;
        }
        return null;
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (Objects.requireNonNull(lo) != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    private static void validateLinkOptions(LinkOption ... linkOptions) {
        for (LinkOption linkOption : linkOptions) {
            Objects.requireNonNull(linkOption);
        }
    }

    private static SecurityException forbidden(Path path) {
        throw new SecurityException((String)(path == null ? "Operation is not allowed." : "Operation is not allowed for: " + String.valueOf(path)));
    }

    private static final class NIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystem fileSystem;
        private final FileSystemProvider fileSystemProvider;
        private final boolean isDefault;
        private final String hostTmpDirPath;
        private volatile Path userDir;
        private volatile Path tmpDir;

        NIOFileSystem(FileSystem fileSystem, String hostTmpDirPath, boolean isDefault) {
            Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            this.fileSystem = fileSystem;
            this.fileSystemProvider = fileSystem.provider();
            this.hostTmpDirPath = hostTmpDirPath;
            this.isDefault = isDefault;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return this.isDefault;
        }

        @Override
        public boolean hasNoAccess() {
            return false;
        }

        @Override
        public boolean isHost() {
            return this.isDefault;
        }

        public Path parsePath(URI uri) {
            if (!this.fileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.fileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public Path parsePath(String path) {
            Objects.requireNonNull(path);
            return this.fileSystem.getPath(path, new String[0]);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path);
            Objects.requireNonNull(modes);
            if (FileSystems.isFollowLinks(linkOptions)) {
                this.fileSystemProvider.checkAccess(this.resolveRelative(path), modes.toArray(new AccessMode[0]));
            } else if (modes.isEmpty()) {
                this.fileSystemProvider.readAttributes(path, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
            } else {
                throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
            }
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(dir);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createDirectory(this.resolveRelative(dir), attrs);
        }

        public void delete(Path path) throws IOException {
            Objects.requireNonNull(path);
            this.fileSystemProvider.delete(this.resolveRelative(path));
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.copy(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.move(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(path);
            Objects.requireNonNull(options);
            Objects.requireNonNull(attrs);
            Path resolved = this.resolveRelative(path);
            try {
                return this.fileSystemProvider.newFileChannel(resolved, options, attrs);
            }
            catch (UnsupportedOperationException uoe) {
                return this.fileSystemProvider.newByteChannel(resolved, options, attrs);
            }
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            boolean relativize;
            Path resolvedPath;
            Objects.requireNonNull(dir);
            Path cwd = this.userDir;
            if (!dir.isAbsolute() && cwd != null) {
                resolvedPath = cwd.resolve(dir);
                relativize = true;
            } else {
                resolvedPath = dir;
                relativize = false;
            }
            RelativizeDirectoryStream result = this.fileSystemProvider.newDirectoryStream(resolvedPath, filter);
            if (relativize) {
                result = new RelativizeDirectoryStream(cwd, result);
            }
            return result;
        }

        public void createLink(Path link, Path existing) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(existing);
            this.fileSystemProvider.createLink(this.resolveRelative(link), this.resolveRelative(existing));
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(target);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createSymbolicLink(this.resolveRelative(link), target, attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            Objects.requireNonNull(link);
            return this.fileSystemProvider.readSymbolicLink(this.resolveRelative(link));
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(options);
            return this.fileSystemProvider.readAttributes(this.resolveRelative(path), attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(options);
            this.fileSystemProvider.setAttribute(this.resolveRelative(path), attribute, value, options);
        }

        public Path toAbsolutePath(Path path) {
            Objects.requireNonNull(path);
            if (path.isAbsolute()) {
                return path;
            }
            Path cwd = this.userDir;
            if (cwd == null) {
                return path.toAbsolutePath();
            }
            return cwd.resolve(path);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            boolean nonDirectory;
            Objects.requireNonNull(currentWorkingDirectory, "Current working directory must be non null.");
            if (!currentWorkingDirectory.isAbsolute()) {
                throw new IllegalArgumentException("Current working directory must be absolute.");
            }
            try {
                nonDirectory = Boolean.FALSE.equals(this.fileSystemProvider.readAttributes(currentWorkingDirectory, "isDirectory", new LinkOption[0]).get("isDirectory"));
            }
            catch (IOException ioe) {
                nonDirectory = false;
            }
            if (nonDirectory) {
                throw new IllegalArgumentException("Current working directory must be a directory.");
            }
            this.userDir = currentWorkingDirectory;
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(linkOptions);
            Path resolvedPath = this.resolveRelative(path);
            return resolvedPath.toRealPath(linkOptions);
        }

        public Path getTempDirectory() {
            Path result = this.tmpDir;
            if (result == null) {
                if (this.hostTmpDirPath != null) {
                    this.tmpDir = result = this.parsePath(this.hostTmpDirPath);
                } else {
                    throw new UnsupportedOperationException("Temporary directories not supported");
                }
            }
            return result;
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path1);
            Objects.requireNonNull(path2);
            if (FileSystems.isFollowLinks(options)) {
                Path absolutePath1 = this.resolveRelative(path1);
                Path absolutePath2 = this.resolveRelative(path2);
                return this.fileSystemProvider.isSameFile(absolutePath1, absolutePath2);
            }
            return PolyglotFileSystem.super.isSameFile(path1, path2, options);
        }

        private Path resolveRelative(Path path) {
            return !path.isAbsolute() && this.userDir != null ? this.toAbsolutePath(path) : path;
        }
    }

    private static final class InternalResourcesSelector
    extends FileSystem.Selector {
        private final InternalResourceRoots resourceRoots;
        private final Collection<Path> languageHomes;

        InternalResourcesSelector(org.graalvm.polyglot.io.FileSystem fileSystem, InternalResourceRoots resourceRoots, Collection<Path> languageHomes) {
            super(fileSystem);
            this.resourceRoots = resourceRoots;
            this.languageHomes = languageHomes;
        }

        public boolean test(Path path) {
            if (this.resourceRoots.findRoot(path) != null) {
                return true;
            }
            for (Path home : this.languageHomes) {
                if (!path.startsWith(home)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class CompositeFileSystem
    implements PolyglotFileSystem {
        private final org.graalvm.polyglot.io.FileSystem fallBackFileSystem;
        private final FileSystem.Selector[] delegates;
        private final ReadWriteLock changeDirLock = new ReentrantReadWriteLock();
        private final boolean internal;
        private final boolean noAccess;
        private final boolean host;
        private Path currentWorkingDirectory;

        CompositeFileSystem(AbstractPolyglotImpl polyglot, org.graalvm.polyglot.io.FileSystem fallBackFileSystem, FileSystem.Selector ... delegates) {
            this.fallBackFileSystem = Objects.requireNonNull(fallBackFileSystem, "FallBackFileSystem must be non-null");
            this.delegates = Objects.requireNonNull(delegates, "Delegates must be non-null");
            CompositeFileSystem.verifyFileSystemsCompatibility(fallBackFileSystem, (org.graalvm.polyglot.io.FileSystem[])Arrays.stream(delegates).map(FileSystem.Selector::getFileSystem).toArray(org.graalvm.polyglot.io.FileSystem[]::new));
            AbstractPolyglotImpl rootPolyglot = polyglot.getRootImpl();
            boolean isInternal = rootPolyglot.isInternalFileSystem(fallBackFileSystem);
            boolean isNoAccess = CompositeFileSystem.hasNoAccess(fallBackFileSystem);
            boolean isHost = CompositeFileSystem.isHost(fallBackFileSystem);
            for (FileSystem.Selector delegate : delegates) {
                isInternal &= rootPolyglot.isInternalFileSystem(delegate.getFileSystem());
                isNoAccess &= CompositeFileSystem.hasNoAccess(delegate.getFileSystem());
                isHost |= CompositeFileSystem.isHost(delegate.getFileSystem());
            }
            this.internal = isInternal;
            this.noAccess = isNoAccess;
            this.host = isHost;
        }

        private static void verifyFileSystemsCompatibility(org.graalvm.polyglot.io.FileSystem main, org.graalvm.polyglot.io.FileSystem ... others) {
            Class<?> mainPathType = main.parsePath("").getClass();
            String mainSeparator = main.getSeparator();
            String mainPathSeparator = main.getPathSeparator();
            for (org.graalvm.polyglot.io.FileSystem other : others) {
                Class<?> otherPathType = other.parsePath("").getClass();
                if (mainPathType != otherPathType) {
                    throw new IllegalArgumentException(String.format("Incompatible file systems: '%s' and '%s'. Path type mismatch detected. '%s' uses path type '%s', while '%s' uses path type '%s'. Ensure both file systems share the same path type.", main, other, main, mainPathType, other, otherPathType));
                }
                String otherSeparator = other.getSeparator();
                if (!mainSeparator.equals(otherSeparator)) {
                    throw new IllegalArgumentException(String.format("Incompatible file systems: '%s' and '%s'. Separator mismatch detected. '%s' uses separator '%s', while '%s' uses separator '%s'. Ensure both file systems share the same separator.", main, other, main, mainSeparator, other, otherSeparator));
                }
                String otherPathSeparator = other.getPathSeparator();
                if (mainPathSeparator.equals(otherPathSeparator)) continue;
                throw new IllegalArgumentException(String.format("Incompatible file systems: '%s' and '%s'. Path separator mismatch detected. '%s' uses path separator '%s', while '%s' uses path separator '%s'. Ensure both file systems share the same path separator.", main, other, main, mainSeparator, other, otherSeparator));
            }
        }

        private static boolean hasNoAccess(org.graalvm.polyglot.io.FileSystem fs) {
            PolyglotFileSystem pfs;
            return fs instanceof PolyglotFileSystem && (pfs = (PolyglotFileSystem)fs).hasNoAccess();
        }

        private static boolean isHost(org.graalvm.polyglot.io.FileSystem fs) {
            PolyglotFileSystem pfs;
            return fs instanceof PolyglotFileSystem && (pfs = (PolyglotFileSystem)fs).isHost();
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return this.internal;
        }

        @Override
        public boolean hasNoAccess() {
            return this.noAccess;
        }

        @Override
        public boolean isHost() {
            return this.host;
        }

        public Path parsePath(URI uri) {
            return this.fallBackFileSystem.parsePath(uri);
        }

        public Path parsePath(String path) {
            return this.fallBackFileSystem.parsePath(path);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            fileSystemInfo.fileSystem.checkAccess(fileSystemInfo.path, modes, linkOptions);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(dir);
            fileSystemInfo.fileSystem.createDirectory(fileSystemInfo.path, (FileAttribute[])attrs);
        }

        public void delete(Path path) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            fileSystemInfo.fileSystem.delete(fileSystemInfo.path);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            return fileSystemInfo.fileSystem.newByteChannel(fileSystemInfo.path, options, (FileAttribute[])attrs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            this.changeDirLock.readLock().lock();
            try {
                FileSystemInfo fileSystemInfo = this.selectFileSystem(dir);
                DirectoryStream result = fileSystemInfo.fileSystem.newDirectoryStream(fileSystemInfo.path, filter);
                if (!dir.isAbsolute() && this.currentWorkingDirectory != null) {
                    result = new RelativizeDirectoryStream(this.currentWorkingDirectory, result);
                }
                DirectoryStream directoryStream = result;
                return directoryStream;
            }
            finally {
                this.changeDirLock.readLock().unlock();
            }
        }

        public Path toAbsolutePath(Path path) {
            this.changeDirLock.readLock().lock();
            try {
                Path path2 = this.toAbsolutePathImpl(path);
                return path2;
            }
            finally {
                this.changeDirLock.readLock().unlock();
            }
        }

        private Path toAbsolutePathImpl(Path path) {
            if (this.currentWorkingDirectory != null) {
                return this.currentWorkingDirectory.resolve(path);
            }
            return this.fallBackFileSystem.toAbsolutePath(path);
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            return fileSystemInfo.fileSystem.toRealPath(fileSystemInfo.path, linkOptions);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            return fileSystemInfo.fileSystem.readAttributes(fileSystemInfo.path, attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            fileSystemInfo.fileSystem.setAttribute(fileSystemInfo.path, attribute, value, options);
        }

        public void createLink(Path link, Path existing) throws IOException {
            FileSystemInfo linkFileSystemInfo = this.selectFileSystem(link);
            FileSystemInfo existingFileSystemInfo = this.selectFileSystem(existing);
            if (linkFileSystemInfo.fileSystem != existingFileSystemInfo.fileSystem) {
                throw new IOException("Cross file system linking is not supported.");
            }
            linkFileSystemInfo.fileSystem.createLink(linkFileSystemInfo.path, existingFileSystemInfo.path);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            FileSystemInfo linkFileSystemInfo = this.selectFileSystem(link);
            FileSystemInfo targetFileSystemInfo = this.selectFileSystem(target);
            if (linkFileSystemInfo.fileSystem != targetFileSystemInfo.fileSystem) {
                throw new IOException("Cross file system linking is not supported.");
            }
            linkFileSystemInfo.fileSystem.createSymbolicLink(linkFileSystemInfo.path, target, new FileAttribute[0]);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(link);
            return fileSystemInfo.fileSystem.readSymbolicLink(fileSystemInfo.path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCurrentWorkingDirectory(Path newCurrentWorkingDirectory) {
            boolean nonDirectory;
            Objects.requireNonNull(newCurrentWorkingDirectory, "Current working directory must be non null.");
            if (!newCurrentWorkingDirectory.isAbsolute()) {
                throw new IllegalArgumentException("Current working directory must be absolute.");
            }
            FileSystemInfo fileSystemInfo = this.selectFileSystem(newCurrentWorkingDirectory);
            try {
                nonDirectory = Boolean.FALSE.equals(fileSystemInfo.fileSystem.readAttributes(fileSystemInfo.path, "isDirectory", new LinkOption[0]).get("isDirectory"));
            }
            catch (IOException ioe) {
                nonDirectory = false;
            }
            if (nonDirectory) {
                throw new IllegalArgumentException("Current working directory must be a directory.");
            }
            this.changeDirLock.writeLock().lock();
            try {
                this.currentWorkingDirectory = newCurrentWorkingDirectory;
            }
            finally {
                this.changeDirLock.writeLock().unlock();
            }
        }

        public String getSeparator() {
            return this.fallBackFileSystem.getSeparator();
        }

        public String getPathSeparator() {
            return this.fallBackFileSystem.getPathSeparator();
        }

        public String getMimeType(Path path) {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            return fileSystemInfo.fileSystem.getMimeType(fileSystemInfo.path);
        }

        public Charset getEncoding(Path path) {
            FileSystemInfo fileSystemInfo = this.selectFileSystem(path);
            return fileSystemInfo.fileSystem.getEncoding(fileSystemInfo.path);
        }

        public Path getTempDirectory() {
            return this.fallBackFileSystem.getTempDirectory();
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            FileSystemInfo fileSystemInfo1 = this.selectFileSystem(path1);
            FileSystemInfo fileSystemInfo2 = this.selectFileSystem(path2);
            if (fileSystemInfo1.fileSystem == fileSystemInfo2.fileSystem) {
                return fileSystemInfo1.fileSystem.isSameFile(fileSystemInfo1.path, fileSystemInfo2.path, options);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileSystemInfo selectFileSystem(Path path) {
            this.changeDirLock.readLock().lock();
            try {
                Path absolutePath = this.toNormalizedAbsolutePath(path);
                org.graalvm.polyglot.io.FileSystem fs = this.fallBackFileSystem;
                for (FileSystem.Selector delegate : this.delegates) {
                    if (!delegate.test(absolutePath)) continue;
                    fs = delegate.getFileSystem();
                    break;
                }
                FileSystemInfo fileSystemInfo = new FileSystemInfo(fs, this.currentWorkingDirectory != null ? absolutePath : path);
                return fileSystemInfo;
            }
            finally {
                this.changeDirLock.readLock().unlock();
            }
        }

        private Path toNormalizedAbsolutePath(Path path) {
            if (path.isAbsolute()) {
                return path;
            }
            Path absolutePath = this.toAbsolutePathImpl(path);
            if (CompositeFileSystem.isNormalized(path)) {
                return absolutePath;
            }
            return absolutePath.normalize();
        }

        private static boolean isNormalized(Path path) {
            for (Path name : path) {
                String strName = name.toString();
                if (!".".equals(strName) && !"..".equals(strName)) continue;
                return false;
            }
            return true;
        }

        private record FileSystemInfo(org.graalvm.polyglot.io.FileSystem fileSystem, Path path) {
        }
    }

    private static class ReadOnlyFileSystem
    extends DeniedIOFileSystem {
        private static final List<AccessMode> READ_MODES = Arrays.asList(AccessMode.READ, AccessMode.EXECUTE);
        private static final Set<? extends OpenOption> READ_OPTIONS = Set.of(StandardOpenOption.READ, StandardOpenOption.DSYNC, StandardOpenOption.SPARSE, StandardOpenOption.SYNC, StandardOpenOption.TRUNCATE_EXISTING, LinkOption.NOFOLLOW_LINKS);
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        ReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public Path parsePath(URI uri) {
            return this.delegateFileSystem.parsePath(uri);
        }

        @Override
        public Path parsePath(String path) {
            return this.delegateFileSystem.parsePath(path);
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).isHost();
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            HashSet<? extends AccessMode> writeModes = new HashSet<AccessMode>(modes);
            writeModes.removeAll(READ_MODES);
            if (!writeModes.isEmpty()) {
                throw new IOException("Read-only file");
            }
            this.delegateFileSystem.checkAccess(path, modes, linkOptions);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            boolean write;
            HashSet<? extends OpenOption> copy = new HashSet<OpenOption>(options);
            HashSet<? extends OpenOption> writeOptions = new HashSet<OpenOption>(copy);
            boolean read = writeOptions.contains(StandardOpenOption.READ);
            writeOptions.removeAll(READ_OPTIONS);
            if (read) {
                writeOptions.remove(StandardOpenOption.APPEND);
            }
            boolean bl = write = !writeOptions.isEmpty();
            if (write) {
                throw FileSystems.forbidden(inPath);
            }
            return this.delegateFileSystem.newByteChannel(inPath, copy, (FileAttribute[])attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            return this.delegateFileSystem.newDirectoryStream(dir, filter);
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.readAttributes(path, attributes, options);
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            return this.delegateFileSystem.readSymbolicLink(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }

        public String getMimeType(Path path) {
            return this.delegateFileSystem.getMimeType(path);
        }

        public Charset getEncoding(Path path) {
            return this.delegateFileSystem.getEncoding(path);
        }
    }

    private static class DeniedIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystemProvider defaultFileSystemProvider = FileSystems.findDefaultFileSystemProvider();

        DeniedIOFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        public Path parsePath(URI uri) {
            if (!this.defaultFileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.defaultFileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public Path parsePath(String path) {
            return Paths.get(path, new String[0]);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        public void delete(Path path) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(inPath);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public Path toAbsolutePath(Path path) {
            throw FileSystems.forbidden(path);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public Path getTempDirectory() {
            throw FileSystems.forbidden(null);
        }

        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            throw FileSystems.forbidden(link);
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path1);
        }
    }

    private static final class PathOperationsOnlyFileSystem
    extends DeniedIOFileSystem {
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        PathOperationsOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }
    }

    private static interface PolyglotFileSystem
    extends org.graalvm.polyglot.io.FileSystem {
        public boolean isInternal(AbstractPolyglotImpl var1);

        public boolean hasNoAccess();

        public boolean isHost();
    }

    private static final class FileTypeDetectorsSupplier
    implements Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> {
        private final Iterable<LanguageCache> languageCaches;

        FileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
            this.languageCaches = languageCaches;
        }

        @Override
        public Map<String, Collection<? extends TruffleFile.FileTypeDetector>> get() {
            HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>> detectors = new HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>>();
            for (LanguageCache cache : this.languageCaches) {
                for (String mimeType : cache.getMimeTypes()) {
                    List<? extends TruffleFile.FileTypeDetector> languageDetectors = cache.getFileTypeDetectors();
                    Collection mimeTypeDetectors = (Collection)detectors.get(mimeType);
                    if (mimeTypeDetectors != null) {
                        if (languageDetectors.isEmpty()) continue;
                        ArrayList<? extends TruffleFile.FileTypeDetector> mergedDetectors = new ArrayList<TruffleFile.FileTypeDetector>(mimeTypeDetectors);
                        mergedDetectors.addAll(languageDetectors);
                        detectors.put(mimeType, mergedDetectors);
                        continue;
                    }
                    detectors.put(mimeType, languageDetectors);
                }
            }
            return detectors;
        }
    }

    private static final class InvalidFileSystem
    implements PolyglotFileSystem {
        private InvalidFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        public Path parsePath(URI uri) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        public Path parsePath(String path) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(dir);
        }

        public void delete(Path path) {
            throw FileSystems.forbidden(path);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(path);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) {
            throw FileSystems.forbidden(dir);
        }

        public Path toAbsolutePath(Path path) {
            throw FileSystems.forbidden(path);
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
            throw FileSystems.forbidden(path);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
            throw FileSystems.forbidden(path);
        }

        public void copy(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        public void move(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        public Path readSymbolicLink(Path link) {
            throw FileSystems.forbidden(link);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            throw FileSystems.forbidden(currentWorkingDirectory);
        }
    }

    private static class ForwardingFileSystem
    implements PolyglotFileSystem {
        private final org.graalvm.polyglot.io.FileSystem delegate;

        protected ForwardingFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            this.delegate = fileSystem;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            PolyglotFileSystem pfs;
            org.graalvm.polyglot.io.FileSystem fileSystem = this.delegate;
            return fileSystem instanceof PolyglotFileSystem && (pfs = (PolyglotFileSystem)fileSystem).isInternal(polyglot);
        }

        @Override
        public boolean hasNoAccess() {
            PolyglotFileSystem pfs;
            org.graalvm.polyglot.io.FileSystem fileSystem = this.delegate;
            return fileSystem instanceof PolyglotFileSystem && (pfs = (PolyglotFileSystem)fileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            PolyglotFileSystem pfs;
            org.graalvm.polyglot.io.FileSystem fileSystem = this.delegate;
            return fileSystem instanceof PolyglotFileSystem && (pfs = (PolyglotFileSystem)fileSystem).isHost();
        }

        public Path parsePath(URI path) {
            return this.delegate.parsePath(path);
        }

        public Path parsePath(String path) {
            return this.delegate.parsePath(path);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            this.delegate.checkAccess(path, modes, linkOptions);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createDirectory(dir, (FileAttribute[])attrs);
        }

        public void delete(Path path) throws IOException {
            this.delegate.delete(path);
        }

        public void createLink(Path link, Path existing) throws IOException {
            this.delegate.createLink(link, existing);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createSymbolicLink(link, target, (FileAttribute[])attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            return this.delegate.readSymbolicLink(link);
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.copy(source, target, options);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.move(source, target, options);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            return this.delegate.newByteChannel(path, options, (FileAttribute[])attrs);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            return this.delegate.newDirectoryStream(dir, filter);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegate.readAttributes(path, attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            this.delegate.setAttribute(path, attribute, value, options);
        }

        public Path toAbsolutePath(Path path) {
            return this.delegate.toAbsolutePath(path);
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegate.toRealPath(path, linkOptions);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegate.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        public String getPathSeparator() {
            return this.delegate.getPathSeparator();
        }

        public String getMimeType(Path path) {
            return this.delegate.getMimeType(path);
        }

        public Charset getEncoding(Path path) {
            return this.delegate.getEncoding(path);
        }

        public Path getTempDirectory() {
            return this.delegate.getTempDirectory();
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegate.isSameFile(path1, path2, options);
        }
    }

    private static final class RelativizeDirectoryStream
    implements DirectoryStream<Path> {
        private final Path folder;
        private final DirectoryStream<? extends Path> delegateDirectoryStream;

        RelativizeDirectoryStream(Path folder, DirectoryStream<? extends Path> delegateDirectoryStream) {
            this.folder = folder;
            this.delegateDirectoryStream = delegateDirectoryStream;
        }

        @Override
        public Iterator<Path> iterator() {
            return new RelativizeIterator(this.folder, this.delegateDirectoryStream.iterator());
        }

        @Override
        public void close() throws IOException {
            this.delegateDirectoryStream.close();
        }

        private static final class RelativizeIterator
        implements Iterator<Path> {
            private final Path folder;
            private final Iterator<? extends Path> delegateIterator;

            RelativizeIterator(Path folder, Iterator<? extends Path> delegateIterator) {
                this.folder = folder;
                this.delegateIterator = delegateIterator;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return this.folder.relativize(this.delegateIterator.next());
            }
        }
    }

    static final class PreInitializeContextFileSystem
    implements PolyglotFileSystem {
        private org.graalvm.polyglot.io.FileSystem delegate;
        private Function<Path, PreInitializePath> factory;

        PreInitializeContextFileSystem(String tmpDir) {
            this.delegate = FileSystems.newDefaultFileSystem(tmpDir);
            this.factory = new ImageBuildTimeFactory();
        }

        void onPreInitializeContextEnd(InternalResourceRoots internalResourceRoots, Map<String, Path> languageHomes) {
            if (this.factory == null) {
                throw new IllegalStateException("Context pre-initialization already finished.");
            }
            ((ImageBuildTimeFactory)this.factory).onPreInitializeContextEnd(internalResourceRoots, languageHomes);
            this.factory = null;
            this.delegate = INVALID_FILESYSTEM;
        }

        void onLoadPreinitializedContext(org.graalvm.polyglot.io.FileSystem newDelegate) {
            Objects.requireNonNull(newDelegate, "NewDelegate must be non null.");
            if (this.factory != null) {
                throw new IllegalStateException("Pre-initialized context already loaded.");
            }
            this.delegate = newDelegate;
            this.factory = new ImageExecutionTimeFactory();
        }

        private static void verifyImageState() {
            if (ImageInfo.inImageBuildtimeCode()) {
                throw CompilerDirectives.shouldNotReachHere("Reintroducing absolute path into an image heap.");
            }
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegate);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).isHost();
        }

        public Path parsePath(URI path) {
            return this.factory.apply(this.delegate.parsePath(path));
        }

        public Path parsePath(String path) {
            return this.factory.apply(this.delegate.parsePath(path));
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            this.delegate.checkAccess(PreInitializePath.unwrap(path), modes, linkOptions);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createDirectory(PreInitializePath.unwrap(dir), (FileAttribute[])attrs);
        }

        public void delete(Path path) throws IOException {
            this.delegate.delete(PreInitializePath.unwrap(path));
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            return this.delegate.newByteChannel(PreInitializePath.unwrap(path), options, (FileAttribute[])attrs);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            final DirectoryStream delegateStream = this.delegate.newDirectoryStream(PreInitializePath.unwrap(dir), filter);
            return new DirectoryStream<Path>(this){
                final /* synthetic */ PreInitializeContextFileSystem this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Iterator<Path> iterator() {
                    return new ForwardingPath.ForwardingPathIterator<PreInitializePath>(delegateStream.iterator(), this.this$0.factory);
                }

                @Override
                public void close() throws IOException {
                    delegateStream.close();
                }
            };
        }

        public Path toAbsolutePath(Path path) {
            return this.factory.apply(this.delegate.toAbsolutePath(PreInitializePath.unwrap(path)));
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.factory.apply(this.delegate.toRealPath(PreInitializePath.unwrap(path), linkOptions));
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegate.readAttributes(PreInitializePath.unwrap(path), attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            this.delegate.setAttribute(PreInitializePath.unwrap(path), attribute, value, options);
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.copy(PreInitializePath.unwrap(source), PreInitializePath.unwrap(target), options);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.move(PreInitializePath.unwrap(source), PreInitializePath.unwrap(target), options);
        }

        public void createLink(Path link, Path existing) throws IOException {
            this.delegate.createLink(PreInitializePath.unwrap(link), PreInitializePath.unwrap(existing));
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createSymbolicLink(PreInitializePath.unwrap(link), PreInitializePath.unwrap(target), (FileAttribute[])attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            return this.factory.apply(this.delegate.readSymbolicLink(PreInitializePath.unwrap(link)));
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegate.setCurrentWorkingDirectory(PreInitializePath.unwrap(currentWorkingDirectory));
        }

        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        public Charset getEncoding(Path path) {
            return this.delegate.getEncoding(PreInitializePath.unwrap(path));
        }

        public String getMimeType(Path path) {
            return this.delegate.getMimeType(PreInitializePath.unwrap(path));
        }

        public Path getTempDirectory() {
            return this.factory.apply(this.delegate.getTempDirectory());
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegate.isSameFile(PreInitializePath.unwrap(path1), PreInitializePath.unwrap(path2), options);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PreInitializeContextFileSystem)) {
                return false;
            }
            return this.delegate.equals((Object)((PreInitializeContextFileSystem)other).delegate);
        }

        private final class ImageBuildTimeFactory
        extends ImageExecutionTimeFactory {
            private final Collection<Reference<PreInitializePath>> emittedPaths;

            private ImageBuildTimeFactory() {
                this.emittedPaths = new ArrayList<Reference<PreInitializePath>>();
            }

            @Override
            public PreInitializePath apply(Path path) {
                if (path == null) {
                    return null;
                }
                PreInitializePath preInitPath = super.apply(path);
                this.emittedPaths.add(new WeakReference<PreInitializePath>(preInitPath));
                return preInitPath;
            }

            void onPreInitializeContextEnd(InternalResourceRoots internalResourceRoots, Map<String, Path> languageHomes) {
                for (Reference<PreInitializePath> pathRef : this.emittedPaths) {
                    PreInitializePath path = pathRef.get();
                    if (path == null) continue;
                    path.onPreInitializeContextEnd(internalResourceRoots, languageHomes);
                }
            }
        }

        private class ImageExecutionTimeFactory
        implements Function<Path, PreInitializePath> {
            private ImageExecutionTimeFactory() {
            }

            @Override
            public PreInitializePath apply(Path path) {
                return path == null ? null : new PreInitializePath(path);
            }
        }

        private final class PreInitializePath
        extends ForwardingPath<PreInitializePath>
        implements ResetablePath {
            private volatile Object delegatePath;

            PreInitializePath(Path delegatePath) {
                this.delegatePath = delegatePath;
            }

            @Override
            PreInitializePath wrap(Path path) {
                return PreInitializeContextFileSystem.this.factory.apply(path);
            }

            @Override
            Path unwrap() {
                Path result = this.resolve(PreInitializeContextFileSystem.this.delegate);
                this.delegatePath = result;
                return result;
            }

            private Path resolve(org.graalvm.polyglot.io.FileSystem fs) {
                Object current = this.delegatePath;
                if (current instanceof Path) {
                    return (Path)current;
                }
                if (current instanceof ImageHeapPath) {
                    return ((ImageHeapPath)current).resolve(fs);
                }
                throw new IllegalStateException("Unknown delegate " + String.valueOf(current));
            }

            void onPreInitializeContextEnd(InternalResourceRoots resourceRoots, Map<String, Path> languageHomes) {
                Path internalPath = (Path)this.delegatePath;
                ImageHeapPath result = null;
                InternalResourceCache owner = resourceRoots.findInternalResource(internalPath);
                if (owner != null) {
                    String relativePath = owner.getPathOrNull().relativize(internalPath).toString();
                    result = new InternalResourceImageHeapPath(owner, relativePath);
                }
                if (result == null) {
                    for (Map.Entry<String, Path> e : languageHomes.entrySet()) {
                        if (!internalPath.startsWith(e.getValue())) continue;
                        String languageId = e.getKey();
                        String relativePath = e.getValue().relativize(internalPath).toString();
                        result = new LanguageHomeImageHeapPath(languageId, relativePath);
                    }
                }
                if (result == null) {
                    result = new PathImageHeapPath(internalPath.toString(), internalPath.isAbsolute());
                }
                this.delegatePath = result;
            }

            @Override
            public boolean isAbsolute() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    return ((ImageHeapPath)this.delegatePath).absolute;
                }
                return super.isAbsolute();
            }

            @Override
            public String toString() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    ImageHeapPath imageHeapPath = (ImageHeapPath)this.delegatePath;
                    assert (imageHeapPath instanceof PathImageHeapPath) : "ToString can be called only for non internal resource files located outside of language homes.";
                    return imageHeapPath.path;
                }
                return super.toString();
            }

            @Override
            public String getReinitializedPath() {
                if (PreInitializeContextFileSystem.this.delegate != INVALID_FILESYSTEM) {
                    return this.toString();
                }
                PreInitializeContextFileSystem.verifyImageState();
                return this.resolve(FileSystems.newDefaultFileSystem(null)).toString();
            }

            @Override
            public URI getReinitializedURI() {
                if (PreInitializeContextFileSystem.this.delegate != INVALID_FILESYSTEM) {
                    return this.toUri();
                }
                PreInitializeContextFileSystem.verifyImageState();
                Path resolved = this.resolve(FileSystems.newDefaultFileSystem(null));
                if (!resolved.isAbsolute()) {
                    throw new IllegalArgumentException("Path must be absolute.");
                }
                return resolved.toUri();
            }
        }

        private static final class PathImageHeapPath
        extends ImageHeapPath {
            PathImageHeapPath(String path, boolean absolute) {
                super(path, absolute);
            }

            @Override
            Path resolve(org.graalvm.polyglot.io.FileSystem fileSystem) {
                return fileSystem.parsePath(this.path);
            }
        }

        private static final class InternalResourceImageHeapPath
        extends ImageHeapPath {
            private final InternalResourceCache cache;

            InternalResourceImageHeapPath(InternalResourceCache cache, String path) {
                super(path, false);
                this.cache = cache;
            }

            @Override
            Path resolve(org.graalvm.polyglot.io.FileSystem fileSystem) {
                return fileSystem.parsePath(this.cache.getPathOrNull().toString()).resolve(this.path);
            }
        }

        private static final class LanguageHomeImageHeapPath
        extends ImageHeapPath {
            private final String languageId;

            LanguageHomeImageHeapPath(String languageId, String path) {
                super(path, false);
                this.languageId = Objects.requireNonNull(languageId, "LanguageId must be non-null");
            }

            @Override
            Path resolve(org.graalvm.polyglot.io.FileSystem fileSystem) {
                String newLanguageHome = LanguageCache.languages().get(this.languageId).getLanguageHome();
                assert (newLanguageHome != null) : "Pre-initialized language " + this.languageId + " must exist in the image execution time.";
                return fileSystem.parsePath(newLanguageHome).resolve(this.path);
            }
        }

        private static abstract class ImageHeapPath {
            final String path;
            final boolean absolute;

            ImageHeapPath(String path, boolean absolute) {
                this.path = Objects.requireNonNull(path, "Path must be non-null");
                this.absolute = absolute;
            }

            abstract Path resolve(org.graalvm.polyglot.io.FileSystem var1);
        }
    }

    static interface ResetablePath
    extends Path {
        public String getReinitializedPath();

        public URI getReinitializedURI();
    }

    private static abstract class ForwardingPath<T extends ForwardingPath<T>>
    implements Path {
        private ForwardingPath() {
        }

        abstract T wrap(Path var1);

        abstract Path unwrap();

        static Path unwrap(Path path) {
            if (path instanceof ForwardingPath) {
                ForwardingPath forwardingPath = (ForwardingPath)path;
                return forwardingPath.unwrap();
            }
            return path;
        }

        @Override
        public FileSystem getFileSystem() {
            return null;
        }

        @Override
        public boolean isAbsolute() {
            return this.unwrap().isAbsolute();
        }

        @Override
        public Path getRoot() {
            return this.wrap(this.unwrap().getRoot());
        }

        @Override
        public Path getFileName() {
            return this.wrap(this.unwrap().getFileName());
        }

        @Override
        public Path getParent() {
            return this.wrap(this.unwrap().getParent());
        }

        @Override
        public int getNameCount() {
            return this.unwrap().getNameCount();
        }

        @Override
        public Path getName(int index) {
            return this.wrap(this.unwrap().getName(index));
        }

        @Override
        public Path subpath(int beginIndex, int endIndex) {
            return this.wrap(this.unwrap().subpath(beginIndex, endIndex));
        }

        @Override
        public boolean startsWith(Path other) {
            return this.unwrap().startsWith(ForwardingPath.unwrap(other));
        }

        @Override
        public boolean startsWith(String other) {
            return this.unwrap().startsWith(other);
        }

        @Override
        public boolean endsWith(Path other) {
            return this.unwrap().endsWith(ForwardingPath.unwrap(other));
        }

        @Override
        public boolean endsWith(String other) {
            return this.unwrap().endsWith(other);
        }

        @Override
        public Path normalize() {
            return this.wrap(this.unwrap().normalize());
        }

        @Override
        public Path resolve(Path other) {
            return this.wrap(this.unwrap().resolve(ForwardingPath.unwrap(other)));
        }

        @Override
        public Path resolve(String other) {
            return this.wrap(this.unwrap().resolve(other));
        }

        @Override
        public Path resolveSibling(Path other) {
            return this.wrap(this.unwrap().resolveSibling(ForwardingPath.unwrap(other)));
        }

        @Override
        public Path resolveSibling(String other) {
            return this.wrap(this.unwrap().resolveSibling(other));
        }

        @Override
        public Path relativize(Path other) {
            return this.wrap(this.unwrap().relativize(ForwardingPath.unwrap(other)));
        }

        @Override
        public URI toUri() {
            return this.unwrap().toUri();
        }

        @Override
        public Path toAbsolutePath() {
            return this.wrap(this.unwrap().toAbsolutePath());
        }

        @Override
        public Path toRealPath(LinkOption ... options) throws IOException {
            return this.wrap(this.unwrap().toRealPath(options));
        }

        @Override
        public File toFile() {
            return this.unwrap().toFile();
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Path> iterator() {
            return new ForwardingPathIterator<ForwardingPath>(this.unwrap().iterator(), this::wrap);
        }

        @Override
        public int compareTo(Path other) {
            return this.unwrap().compareTo(ForwardingPath.unwrap(other));
        }

        @Override
        public int hashCode() {
            return this.unwrap().hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ForwardingPath)) {
                return false;
            }
            return this.unwrap().equals(ForwardingPath.unwrap((Path)other));
        }

        @Override
        public String toString() {
            return this.unwrap().toString();
        }

        private static final class ForwardingPathIterator<T extends ForwardingPath<T>>
        implements Iterator<Path> {
            private final Iterator<Path> delegateIterator;
            private final Function<Path, T> wrap;

            ForwardingPathIterator(Iterator<Path> delegateIterator, Function<Path, T> wrap) {
                Objects.requireNonNull(delegateIterator, "DelegateIterator must be non-null.");
                Objects.requireNonNull(delegateIterator, "Wrap function must be non-null.");
                this.delegateIterator = delegateIterator;
                this.wrap = wrap;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return (Path)this.wrap.apply(this.delegateIterator.next());
            }
        }
    }
}

