/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

final class WeakKey<K>
extends WeakReference<K> {
    private final int hashCode;

    WeakKey(K key) {
        super(key);
        this.hashCode = key.hashCode();
    }

    WeakKey(K key, ReferenceQueue<K> q) {
        super(key, q);
        this.hashCode = key.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object thisKey = this.get();
        if (thisKey == null) {
            return false;
        }
        Object otherKey = obj instanceof WeakKey ? ((WeakKey)obj).get() : obj;
        return thisKey.equals(otherKey);
    }
}

