/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.InlineSnippet;
import org.graalvm.polyglot.tck.ResultVerifier;
import org.graalvm.polyglot.tck.Snippet;
import org.graalvm.polyglot.tck.TypeDescriptor;

public interface LanguageProvider {
    public String getId();

    default public Map<String, String> additionalOptions() {
        return Collections.emptyMap();
    }

    public Value createIdentityFunction(Context var1);

    default public Snippet createIdentityFunctionSnippet(Context context) {
        Value value = this.createIdentityFunction(context);
        if (!value.canExecute()) {
            throw new AssertionError((Object)String.format("Result of createIdentityFunction for tck provider %s did not return an executable value. Returned value '%s'.", this.getId(), value));
        }
        return Snippet.newBuilder("identity", value, TypeDescriptor.ANY).parameterTypes(TypeDescriptor.ANY).resultVerifier(ResultVerifier.getIdentityFunctionDefaultResultVerifier()).build();
    }

    public Collection<? extends Snippet> createValueConstructors(Context var1);

    public Collection<? extends Snippet> createExpressions(Context var1);

    public Collection<? extends Snippet> createStatements(Context var1);

    public Collection<? extends Snippet> createScripts(Context var1);

    public Collection<? extends Source> createInvalidSyntaxScripts(Context var1);

    default public Collection<? extends InlineSnippet> createInlineScripts(Context context) {
        return Collections.emptyList();
    }
}

