/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.collections;

import java.util.Comparator;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;

public final class EconomicMapUtil {
    private EconomicMapUtil() {
    }

    public static <K, V> boolean equals(UnmodifiableEconomicMap<K, V> lhs, UnmodifiableEconomicMap<K, V> rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null || lhs.size() != rhs.size() || !Objects.equals(lhs.getEquivalenceStrategy(), rhs.getEquivalenceStrategy())) {
            return false;
        }
        UnmodifiableMapCursor<K, V> cursor = rhs.getEntries();
        while (cursor.advance()) {
            if (lhs.containsKey(cursor.getKey()) && Objects.equals(lhs.get(cursor.getKey()), cursor.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K, V> int hashCode(UnmodifiableEconomicMap<K, V> map) {
        if (map == null) {
            return -1;
        }
        int keyHash = 0;
        int valueHash = 0;
        UnmodifiableMapCursor<K, V> cursor = map.getEntries();
        while (cursor.advance()) {
            keyHash ^= cursor.getKey().hashCode();
            if (cursor.getValue() == null) continue;
            valueHash ^= cursor.getValue().hashCode();
        }
        return keyHash + 31 * valueHash;
    }

    public static <K, V> EconomicSet<K> keySet(EconomicMap<K, V> map) {
        EconomicSet set = EconomicSet.create(map.size());
        for (Object key : map.getKeys()) {
            set.add(key);
        }
        return set;
    }

    public static <K, V> Comparator<UnmodifiableEconomicMap<K, V>> lexicographicalComparator(final Comparator<K> keyComparator, final Comparator<V> valueComparator) {
        return new Comparator<UnmodifiableEconomicMap<K, V>>(){

            @Override
            public int compare(UnmodifiableEconomicMap<K, V> map1, UnmodifiableEconomicMap<K, V> map2) {
                if (map2.size() > map1.size()) {
                    return -this.compare(map2, map1);
                }
                assert (map1.size() >= map2.size());
                UnmodifiableMapCursor cursor1 = map1.getEntries();
                UnmodifiableMapCursor cursor2 = map2.getEntries();
                while (cursor1.advance()) {
                    int order;
                    Object key2 = null;
                    Object value2 = null;
                    if (cursor2.advance()) {
                        key2 = cursor2.getKey();
                        value2 = cursor2.getValue();
                    }
                    if ((order = keyComparator.compare(cursor1.getKey(), key2)) != 0) {
                        return order;
                    }
                    order = valueComparator.compare(cursor1.getValue(), value2);
                    if (order == 0) continue;
                    return order;
                }
                return 0;
            }
        };
    }
}

