/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.shell;

import com.oracle.graal.python.shell.ConsoleHandler;
import com.oracle.graal.python.shell.DefaultConsoleHandler;
import com.oracle.graal.python.shell.JLineConsoleHandler;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graalvm.launcher.AbstractLanguageLauncher;
import org.graalvm.launcher.Launcher;
import org.graalvm.maven.downloader.Main;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.options.OptionCategory;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.shadowed.org.jline.reader.UserInterruptException;

public final class GraalPythonMain
extends AbstractLanguageLauncher {
    private static final boolean IS_WINDOWS = System.getProperty("os.name") != null && System.getProperty("os.name").toLowerCase().contains("windows");
    private static final String SHORT_HELP = "usage: python [option] ... [-c cmd | -m mod | file | -] [arg] ...\nTry `python -h' for more information.";
    private static final String STRING_LIST_DELIMITER = "\ud83c\udfc6";
    private static final int INT_MAX_STR_DIGITS_THRESHOLD = 640;
    private static final String LANGUAGE_ID = "python";
    private static final String J_PYENVCFG = "pyvenv.cfg";
    private static long startupWallClockTime = -1L;
    private static long startupNanoTime = -1L;
    private boolean verboseLauncher = false;
    private ArrayList<String> programArgs = null;
    private ArrayList<String> origArgs = null;
    private String commandString = null;
    private String inputFile = null;
    private boolean isolateFlag = false;
    private boolean ignoreEnv = false;
    private boolean safePath = false;
    private boolean inspectFlag = false;
    private boolean verboseFlag = false;
    private boolean quietFlag = false;
    private boolean noUserSite = false;
    private boolean noSite = false;
    private boolean unbufferedIO = false;
    private boolean multiContext = false;
    private boolean snaptshotStartup = false;
    private boolean warnDefaultEncoding = false;
    private int intMaxStrDigits = -1;
    private Launcher.VersionAction versionAction = Launcher.VersionAction.None;
    private List<String> givenArguments;
    private List<String> relaunchArgs;
    private boolean wantsExperimental = false;
    private Map<String, String> enginePolyglotOptions;
    private boolean dontWriteBytecode = false;
    private String warnOptions = null;
    private String checkHashPycsMode = "default";
    private String execName;

    public static void main(String[] args) {
        new GraalPythonMain().launch(args);
    }

    public GraalPythonMain() {
        this.verboseLauncher = Boolean.parseBoolean(System.getenv("VERBOSE_GRAALVM_LAUNCHERS"));
    }

    protected static void setStartupTime() {
        if (startupNanoTime == -1L) {
            startupNanoTime = System.nanoTime();
        }
        if (startupWallClockTime == -1L) {
            startupWallClockTime = System.currentTimeMillis();
        }
    }

    private void polyglotGet(String exe, List<String> originalArgs) {
        Path binPath;
        ArrayList<String> args = new ArrayList<String>();
        if (originalArgs.size() == 1 && !originalArgs.get(0).startsWith("-")) {
            args.add("-a");
        }
        args.addAll(originalArgs);
        if (!originalArgs.contains("-o") && (binPath = Paths.get(exe, new String[0]).getParent()) != null) {
            args.add("-o");
            args.add(binPath.resolveSibling("modules").toString());
        }
        if (!originalArgs.contains("-v")) {
            try (Engine tmpEngine = Engine.newBuilder().useSystemProperties(false).out(OutputStream.nullOutputStream()).err(OutputStream.nullOutputStream()).option("engine.WarnInterpreterOnly", "false").build();){
                args.add("-v");
                args.add(tmpEngine.getVersion());
            }
        }
        try {
            Main.main((String[])args.toArray(new String[0]));
        }
        catch (Exception e) {
            throw this.abort(e);
        }
        System.exit(0);
    }

    protected List<String> preprocessArguments(List<String> givenArgs, Map<String, String> polyglotOptions) {
        String launcherName = this.getLauncherExecName();
        if (launcherName != null && (launcherName.endsWith("graalpy-polyglot-get") || launcherName.endsWith("graalpy-polyglot-get.exe"))) {
            this.polyglotGet(launcherName, givenArgs);
        }
        ArrayList<String> unrecognized = new ArrayList<String>();
        List<String> defaultEnvironmentArgs = GraalPythonMain.getDefaultEnvironmentArgs();
        ArrayList<String> inputArgs = new ArrayList<String>(defaultEnvironmentArgs);
        inputArgs.addAll(givenArgs);
        this.givenArguments = new ArrayList<String>(inputArgs);
        ArrayList<String> arguments = new ArrayList<String>(inputArgs);
        ArrayList<String> subprocessArgs = new ArrayList<String>();
        this.programArgs = new ArrayList();
        this.origArgs = new ArrayList();
        boolean posixBackendSpecified = false;
        boolean sha3BackendSpecified = false;
        boolean installSignalHandlersSpecified = false;
        boolean isolateNativeModulesSpecified = false;
        Iterator<String> argumentIterator = arguments.iterator();
        block53: while (argumentIterator.hasNext()) {
            block79: {
                String arg = (String)argumentIterator.next();
                this.origArgs.add(arg);
                if (arg.startsWith("-")) {
                    if (arg.length() == 1) continue;
                    if (this.wantsExperimental) {
                        switch (arg) {
                            case "-debug-java": {
                                if (GraalPythonMain.isAOT()) continue block53;
                                subprocessArgs.add("agentlib:jdwp=transport=dt_socket,server=y,address=8000,suspend=y");
                                inputArgs.remove("-debug-java");
                                continue block53;
                            }
                            case "-debug-subprocess-java-port": 
                            case "-debug-subprocess-java": {
                                int subprocessDebuggerPort = 8000;
                                if (arg.equals("-debug-subprocess-java-port")) {
                                    subprocessDebuggerPort = Integer.parseInt((String)argumentIterator.next());
                                }
                                this.addRelaunchArg("-debug-subprocess-java-port");
                                this.addRelaunchArg(Integer.toString(subprocessDebuggerPort + 1));
                                this.addRelaunchArg("--vm.agentlib:jdwp=transport=dt_socket,server=y,address=" + subprocessDebuggerPort + ",suspend=y");
                                continue block53;
                            }
                            case "-debug-perf": {
                                unrecognized.add("--engine.TraceCompilation");
                                unrecognized.add("--engine.TraceCompilationDetails");
                                unrecognized.add("--engine.TraceInlining");
                                unrecognized.add("--engine.TraceSplitting");
                                unrecognized.add("--engine.TraceCompilationPolymorphism");
                                unrecognized.add("--engine.TraceAssumptions");
                                unrecognized.add("--engine.TraceTransferToInterpreter");
                                unrecognized.add("--engine.TracePerformanceWarnings=all");
                                unrecognized.add("--engine.CompilationFailureAction=Print");
                                inputArgs.remove("-debug-perf");
                                continue block53;
                            }
                            case "-multi-context": {
                                this.multiContext = true;
                                continue block53;
                            }
                            case "-dump": {
                                subprocessArgs.add("Dgraal.Dump=");
                                inputArgs.add("--engine.BackgroundCompilation=false");
                                inputArgs.remove("-dump");
                                continue block53;
                            }
                            case "-snapshot-startup": {
                                this.snaptshotStartup = true;
                                continue block53;
                            }
                        }
                    }
                    if (arg.startsWith("--")) {
                        switch (arg) {
                            case "--version": {
                                this.versionAction = Launcher.VersionAction.PrintAndExit;
                                continue block53;
                            }
                            case "--show-version": {
                                this.versionAction = Launcher.VersionAction.PrintAndContinue;
                                continue block53;
                            }
                            case "--experimental-options": 
                            case "--experimental-options=true": {
                                this.wantsExperimental = true;
                                this.addRelaunchArg(arg);
                                unrecognized.add(arg);
                                continue block53;
                            }
                            case "--check-hash-based-pycs": {
                                if (!argumentIterator.hasNext()) {
                                    throw this.abort("Argument expected for the --check-hash-based-pycs option\nusage: python [option] ... [-c cmd | -m mod | file | -] [arg] ...\nTry `python -h' for more information.", 2);
                                }
                                this.checkHashPycsMode = (String)argumentIterator.next();
                                continue block53;
                            }
                        }
                        if (arg.startsWith("--llvm.") || GraalPythonMain.matchesPythonOption(arg, "CoreHome") || GraalPythonMain.matchesPythonOption(arg, "StdLibHome") || GraalPythonMain.matchesPythonOption(arg, "CAPI") || GraalPythonMain.matchesPythonOption(arg, "PosixModuleBackend") || GraalPythonMain.matchesPythonOption(arg, "Sha3ModuleBackend")) {
                            this.addRelaunchArg(arg);
                        }
                        if (GraalPythonMain.matchesPythonOption(arg, "PosixModuleBackend")) {
                            posixBackendSpecified = true;
                        }
                        if (GraalPythonMain.matchesPythonOption(arg, "Sha3ModuleBackend")) {
                            sha3BackendSpecified = true;
                        }
                        if (GraalPythonMain.matchesPythonOption(arg, "InstallSignalHandlers")) {
                            installSignalHandlersSpecified = true;
                        }
                        if (GraalPythonMain.matchesPythonOption(arg, "IsolateNativeModules")) {
                            isolateNativeModulesSpecified = true;
                        }
                        unrecognized.add(arg);
                        continue;
                    }
                    String remainder = arg.substring(1);
                    while (!remainder.isEmpty()) {
                        char option = remainder.charAt(0);
                        remainder = remainder.substring(1);
                        switch (option) {
                            case 'b': {
                                break;
                            }
                            case 'B': {
                                this.dontWriteBytecode = true;
                                break;
                            }
                            case 'c': {
                                this.programArgs.add("-c");
                                this.commandString = this.getShortOptionParameter(argumentIterator, remainder, 'c');
                                break block79;
                            }
                            case 'd': {
                                break;
                            }
                            case 'E': {
                                this.ignoreEnv = true;
                                break;
                            }
                            case '?': 
                            case 'h': {
                                unrecognized.add("--help");
                                break;
                            }
                            case 'i': {
                                this.inspectFlag = true;
                                break;
                            }
                            case 'I': {
                                this.noUserSite = true;
                                this.ignoreEnv = true;
                                this.isolateFlag = true;
                                this.safePath = true;
                                break;
                            }
                            case 'P': {
                                this.safePath = true;
                                break;
                            }
                            case 'm': {
                                this.programArgs.add("-m");
                                String module = this.getShortOptionParameter(argumentIterator, remainder, 'm');
                                this.commandString = "import runpy; runpy._run_module_as_main('" + module + "')";
                                break block79;
                            }
                            case 'O': {
                                break;
                            }
                            case 'R': {
                                break;
                            }
                            case 'q': {
                                this.quietFlag = true;
                                break;
                            }
                            case 's': {
                                this.noUserSite = true;
                                break;
                            }
                            case 'S': {
                                this.noSite = true;
                                break;
                            }
                            case 't': {
                                break;
                            }
                            case 'W': {
                                this.warnOptions = this.warnOptions == null ? "" : this.warnOptions + ",";
                                this.warnOptions = this.warnOptions + this.getShortOptionParameter(argumentIterator, remainder, 'W');
                                break block79;
                            }
                            case 'u': {
                                this.unbufferedIO = true;
                                break;
                            }
                            case 'v': {
                                this.verboseFlag = true;
                                break;
                            }
                            case 'V': {
                                this.versionAction = Launcher.VersionAction.PrintAndExit;
                                break;
                            }
                            case 'X': {
                                int eq;
                                String xOption = this.getShortOptionParameter(argumentIterator, remainder, 'X');
                                if ("warn_default_encoding".equals(xOption)) {
                                    this.warnDefaultEncoding = true;
                                } else if (xOption.startsWith("int_max_str_digits") && (eq = xOption.indexOf(61)) > 0) {
                                    this.intMaxStrDigits = this.validateIntMaxStrDigits(xOption.substring(eq), "-X int_max_str_digits");
                                }
                                break block79;
                            }
                            default: {
                                throw this.abort(String.format("Unknown option -%c\n", Character.valueOf(option)) + SHORT_HELP, 2);
                            }
                        }
                    }
                } else {
                    this.inputFile = arg;
                    this.programArgs.add(arg);
                }
            }
            if (this.inputFile == null && this.commandString == null) continue;
            while (argumentIterator.hasNext()) {
                String a = (String)argumentIterator.next();
                this.programArgs.add(a);
                this.origArgs.add(a);
            }
            break block53;
        }
        if (!ImageInfo.inImageCode()) {
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!arg.equals("-ea")) continue;
                this.addRelaunchArg("--vm.ea");
                break;
            }
        }
        if (this.programArgs.isEmpty()) {
            this.programArgs.add("");
        }
        if (!subprocessArgs.isEmpty()) {
            this.subExec(inputArgs, subprocessArgs);
        }
        if (!posixBackendSpecified) {
            polyglotOptions.put("python.PosixModuleBackend", "native");
        }
        if (!sha3BackendSpecified) {
            polyglotOptions.put("python.Sha3ModuleBackend", "native");
        }
        if (!installSignalHandlersSpecified) {
            polyglotOptions.put("python.InstallSignalHandlers", "true");
        }
        if (!isolateNativeModulesSpecified) {
            polyglotOptions.put("python.IsolateNativeModules", "false");
        }
        unrecognized.add("--engine.WarnInterpreterOnly=false");
        return unrecognized;
    }

    private String getShortOptionParameter(Iterator<String> argumentIterator, String remainder, char option) {
        String ret;
        if (remainder.isEmpty()) {
            if (!argumentIterator.hasNext()) {
                throw this.abort(String.format("Argument expected for the -%c option\n", Character.valueOf(option)) + SHORT_HELP, 2);
            }
            ret = argumentIterator.next();
        } else {
            ret = remainder;
        }
        this.origArgs.add(ret);
        return ret;
    }

    protected Launcher.AbortException abortUnrecognizedArgument(String argument) {
        throw this.abort(String.format("Unknown option %s\n", argument) + SHORT_HELP, 2);
    }

    protected void validateArguments(Map<String, String> polyglotOptions) {
        if (this.multiContext) {
            this.enginePolyglotOptions = new HashMap<String, String>(polyglotOptions);
            polyglotOptions.clear();
        }
    }

    private void addRelaunchArg(String arg) {
        if (this.relaunchArgs == null) {
            this.relaunchArgs = new ArrayList<String>();
        }
        this.relaunchArgs.add(arg);
    }

    private String[] execListWithRelaunchArgs(String executableName) {
        if (this.relaunchArgs == null) {
            return new String[]{executableName};
        }
        ArrayList<String> execList = new ArrayList<String>(this.relaunchArgs.size() + 1);
        execList.add(executableName);
        execList.addAll(this.relaunchArgs);
        return execList.toArray(new String[execList.size()]);
    }

    private static void print(String string) {
        System.err.println(string);
    }

    private String getLauncherExecName() {
        if (this.execName != null) {
            return this.execName;
        }
        this.execName = GraalPythonMain.getProgramName();
        this.log("initial executable name: ", this.execName);
        if (this.execName == null) {
            return null;
        }
        this.execName = this.calculateProgramFullPath(this.execName, Files::isExecutable, null);
        this.log("resolved executable name: ", this.execName);
        return this.execName;
    }

    private String calculateProgramFullPath(String program, Predicate<Path> isExecutable, String envPath) {
        Path programPath = Paths.get(program, new String[0]);
        if (programPath.isAbsolute()) {
            String resolvedProgramNameWithExtension;
            if (IS_WINDOWS && (resolvedProgramNameWithExtension = GraalPythonMain.getProgramNameWithExtension(isExecutable, program)) != null) {
                return resolvedProgramNameWithExtension;
            }
            return program;
        }
        if (programPath.getNameCount() < 2) {
            String path;
            String string = path = envPath != null ? envPath : GraalPythonMain.getEnv("PATH");
            if (path != null) {
                int i;
                this.log("resolving the executable name in $PATH = ", path);
                int previous = 0;
                do {
                    String resolvedProgramNameWithExtension;
                    int end;
                    Path resolvedProgramName;
                    if (isExecutable.test(resolvedProgramName = Paths.get(path.substring(previous, end = (i = path.indexOf(File.pathSeparatorChar, previous)) == -1 ? path.length() : i), new String[0]).resolve(programPath))) {
                        return resolvedProgramName.toString();
                    }
                    if (IS_WINDOWS && (resolvedProgramNameWithExtension = GraalPythonMain.getProgramNameWithExtension(isExecutable, resolvedProgramName.toString())) != null) {
                        return resolvedProgramNameWithExtension;
                    }
                    previous = i + 1;
                } while (i != -1);
            } else {
                this.log("executable name looks like it is from $PATH, but $PATH is not available.");
            }
            return null;
        }
        assert (!programPath.isAbsolute());
        if (".".equals(programPath.getName(0).toString())) {
            return programPath.toAbsolutePath().normalize().toString();
        }
        return programPath.toAbsolutePath().toString();
    }

    private static String getProgramNameWithExtension(Predicate<Path> isExecutable, String programStr) {
        if (isExecutable.test(Path.of(programStr, new String[0]))) {
            return programStr;
        }
        if (programStr.length() <= 3 || programStr.charAt(programStr.length() - 4) != '.') {
            Path programNameWithExtension = null;
            String pathExtEnvvar = GraalPythonMain.getEnv("PATHEXT");
            if (pathExtEnvvar != null) {
                String[] pathExts;
                for (String pathExt : pathExts = pathExtEnvvar.toLowerCase().split(";")) {
                    programNameWithExtension = Path.of(programStr + pathExt, new String[0]);
                    if (!isExecutable.test(programNameWithExtension)) continue;
                    return programNameWithExtension.toString();
                }
            }
        }
        return null;
    }

    private String[] getExecutableList() {
        String launcherExecName = this.getLauncherExecName();
        if (launcherExecName != null) {
            return this.execListWithRelaunchArgs(launcherExecName);
        }
        if (!ImageInfo.inImageCode()) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> exec_list = new ArrayList<String>();
            sb.append(System.getProperty("java.home")).append(File.separator).append("bin").append(File.separator).append("java");
            exec_list.add(sb.toString());
            String javaOptions = GraalPythonMain.getEnv("_JAVA_OPTIONS");
            String javaToolOptions = GraalPythonMain.getEnv("JAVA_TOOL_OPTIONS");
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (arg.matches("(-Xrunjdwp:|-agentlib:jdwp=).*suspend=y.*")) {
                    arg = arg.replace("suspend=y", "suspend=n");
                } else if (arg.matches(".*ThreadPriorityPolicy.*") || javaOptions != null && javaOptions.contains(arg) || javaToolOptions != null && javaToolOptions.contains(arg)) continue;
                exec_list.add(arg);
            }
            exec_list.add("-classpath");
            exec_list.add(System.getProperty("java.class.path"));
            exec_list.add(this.getMainClass());
            if (this.relaunchArgs != null) {
                exec_list.addAll(this.relaunchArgs);
            }
            return exec_list.toArray(new String[exec_list.size()]);
        }
        return new String[]{""};
    }

    private String getExecutable() {
        if (ImageInfo.inImageBuildtimeCode()) {
            return "";
        }
        String launcherExecName = this.getLauncherExecName();
        if (launcherExecName != null) {
            return launcherExecName;
        }
        this.log("cannot determine the executable path. Using java command invocation for executable.");
        CharSequence[] executableList = this.getExecutableList();
        for (int i = 0; i < executableList.length; ++i) {
            if (!executableList[i].matches("\\s")) continue;
            executableList[i] = "'" + ((String)executableList[i]).replace("'", "\\'") + "'";
        }
        return String.join((CharSequence)" ", executableList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch(Context.Builder contextBuilder) {
        String executable;
        GraalPythonMain.setStartupTime();
        String cachePrefix = null;
        contextBuilder.out((OutputStream)new FileOutputStream(FileDescriptor.out));
        contextBuilder.err((OutputStream)new FileOutputStream(FileDescriptor.err));
        if (!this.ignoreEnv) {
            String envWarnOptions;
            String hashSeed;
            String pythonpath = GraalPythonMain.getEnv("PYTHONPATH");
            if (pythonpath != null) {
                contextBuilder.option("python.PythonPath", pythonpath);
            }
            this.inspectFlag = this.inspectFlag || GraalPythonMain.getBoolEnv("PYTHONINSPECT");
            this.noUserSite = this.noUserSite || GraalPythonMain.getBoolEnv("PYTHONNOUSERSITE");
            this.safePath = this.safePath || GraalPythonMain.getBoolEnv("PYTHONSAFEPATH");
            this.verboseFlag = this.verboseFlag || GraalPythonMain.getBoolEnv("PYTHONVERBOSE");
            this.unbufferedIO = this.unbufferedIO || GraalPythonMain.getBoolEnv("PYTHONUNBUFFERED");
            this.dontWriteBytecode = this.dontWriteBytecode || GraalPythonMain.getBoolEnv("PYTHONDONTWRITEBYTECODE");
            String maxStrDigitsEnv = GraalPythonMain.getEnv("PYTHONINTMAXSTRDIGITS");
            if (this.intMaxStrDigits < 0 && maxStrDigitsEnv != null) {
                this.intMaxStrDigits = this.validateIntMaxStrDigits(maxStrDigitsEnv, "PYTHONINTMAXSTRDIGITS");
            }
            if ((hashSeed = GraalPythonMain.getEnv("PYTHONHASHSEED")) != null) {
                contextBuilder.option("python.HashSeed", hashSeed);
            }
            if ((envWarnOptions = GraalPythonMain.getEnv("PYTHONWARNINGS")) != null && !envWarnOptions.isEmpty()) {
                this.warnOptions = this.warnOptions == null ? envWarnOptions : envWarnOptions + "," + this.warnOptions;
            }
            cachePrefix = GraalPythonMain.getEnv("PYTHONPYCACHEPREFIX");
            String encoding = GraalPythonMain.getEnv("PYTHONIOENCODING");
            if (encoding != null) {
                contextBuilder.option("python.StandardStreamEncoding", encoding);
            }
        }
        if (this.warnOptions == null || this.warnOptions.isEmpty()) {
            this.warnOptions = "";
        }
        if ((executable = this.getContextOptionIfSetViaCommandLine("Executable")) != null) {
            contextBuilder.option("python.ExecutableList", GraalPythonMain.toAbsolutePath(executable));
        } else {
            boolean tryVenvCfg;
            executable = this.getExecutable();
            contextBuilder.option("python.Executable", GraalPythonMain.toAbsolutePath(executable));
            CharSequence[] executableList = this.getExecutableList();
            executableList[0] = GraalPythonMain.toAbsolutePath(executableList[0]);
            contextBuilder.option("python.ExecutableList", String.join((CharSequence)STRING_LIST_DELIMITER, executableList));
            boolean bl = tryVenvCfg = !this.hasContextOptionSetViaCommandLine("PythonHome") && GraalPythonMain.getEnv("GRAAL_PYTHONHOME") == null;
            if (tryVenvCfg) {
                this.findAndApplyVenvCfg(contextBuilder, executable);
            }
        }
        if (this.isLLVMToolchainLauncher()) {
            if (!this.hasContextOptionSetViaCommandLine("UseSystemToolchain")) {
                contextBuilder.option("python.UseSystemToolchain", "false");
            }
            if (!this.hasContextOptionSetViaCommandLine("NativeModules")) {
                contextBuilder.option("python.NativeModules", "false");
            }
        }
        if (this.relaunchArgs != null) {
            Iterator<String> it = this.origArgs.iterator();
            while (it.hasNext()) {
                if (!this.relaunchArgs.contains(it.next())) continue;
                it.remove();
            }
        }
        this.origArgs.add(0, GraalPythonMain.toAbsolutePath(executable));
        contextBuilder.option("python.OrigArgv", String.join((CharSequence)STRING_LIST_DELIMITER, this.origArgs));
        contextBuilder.option("python.AlwaysRunExcepthook", "true");
        contextBuilder.option("python.InspectFlag", Boolean.toString(this.inspectFlag));
        contextBuilder.option("python.VerboseFlag", Boolean.toString(this.verboseFlag));
        contextBuilder.option("python.IsolateFlag", Boolean.toString(this.isolateFlag));
        contextBuilder.option("python.SafePathFlag", Boolean.toString(this.safePath));
        contextBuilder.option("python.WarnOptions", this.warnOptions);
        contextBuilder.option("python.WarnDefaultEncodingFlag", Boolean.toString(this.warnDefaultEncoding));
        if (this.intMaxStrDigits > 0) {
            contextBuilder.option("python.IntMaxStrDigits", Integer.toString(this.intMaxStrDigits));
        }
        contextBuilder.option("python.DontWriteBytecodeFlag", Boolean.toString(this.dontWriteBytecode));
        if (this.verboseFlag) {
            contextBuilder.option("log.python.level", "INFO");
        }
        contextBuilder.option("python.QuietFlag", Boolean.toString(this.quietFlag));
        contextBuilder.option("python.NoUserSiteFlag", Boolean.toString(this.noUserSite));
        contextBuilder.option("python.NoSiteFlag", Boolean.toString(this.noSite));
        if (!this.noSite) {
            contextBuilder.option("python.ForceImportSite", "true");
        }
        contextBuilder.option("python.IgnoreEnvironmentFlag", Boolean.toString(this.ignoreEnv));
        contextBuilder.option("python.UnbufferedIO", Boolean.toString(this.unbufferedIO));
        ConsoleHandler consoleHandler = GraalPythonMain.createConsoleHandler(System.in, System.out);
        contextBuilder.arguments(this.getLanguageId(), this.programArgs.toArray(new String[this.programArgs.size()]));
        contextBuilder.in(consoleHandler.createInputStream());
        contextBuilder.option("python.TerminalIsInteractive", Boolean.toString(GraalPythonMain.isTTY()));
        contextBuilder.option("python.TerminalWidth", Integer.toString(consoleHandler.getTerminalWidth()));
        contextBuilder.option("python.TerminalHeight", Integer.toString(consoleHandler.getTerminalHeight()));
        contextBuilder.option("python.CheckHashPycsMode", this.checkHashPycsMode);
        contextBuilder.option("python.RunViaLauncher", "true");
        if (this.inputFile != null) {
            contextBuilder.option("python.InputFilePath", this.inputFile);
        }
        contextBuilder.option("python.DontWriteBytecodeFlag", Boolean.toString(this.dontWriteBytecode));
        if (cachePrefix != null) {
            contextBuilder.option("python.PyCachePrefix", cachePrefix);
        }
        if (IS_WINDOWS) {
            contextBuilder.option("python.PosixModuleBackend", "java");
        }
        if (!this.hasContextOptionSetViaCommandLine("WarnExperimentalFeatures")) {
            contextBuilder.option("python.WarnExperimentalFeatures", "false");
        }
        if (this.multiContext) {
            contextBuilder.engine(Engine.newBuilder().allowExperimentalOptions(true).options(this.enginePolyglotOptions).build());
        }
        int rc = 1;
        try (Context context = contextBuilder.build();){
            this.runVersionAction(this.versionAction, context.getEngine());
            if (this.snaptshotStartup) {
                this.evalInternal(context, "__graalpython__.startup_wall_clock_ts = " + startupWallClockTime + "; __graalpython__.startup_nano = " + startupNanoTime);
            }
            if (!this.quietFlag && (this.verboseFlag || this.commandString == null && this.inputFile == null && GraalPythonMain.isTTY())) {
                GraalPythonMain.print("Python " + this.evalInternal(context, "import sys; sys.version + ' on ' + sys.platform").asString());
                if (!this.noSite) {
                    GraalPythonMain.print("Type \"help\", \"copyright\", \"credits\" or \"license\" for more information.");
                }
            }
            consoleHandler.setContext(context);
            if (this.commandString != null || this.inputFile != null || !GraalPythonMain.isTTY()) {
                try {
                    this.evalNonInteractive(context, consoleHandler);
                    rc = 0;
                }
                catch (PolyglotException e) {
                    if (e.isExit()) {
                        rc = e.getExitStatus();
                    }
                    throw e;
                }
                catch (NoSuchFileException e) {
                    GraalPythonMain.printFileNotFoundException(e);
                }
            }
            if (this.commandString == null && this.inputFile == null || this.inspectFlag) {
                this.inspectFlag = false;
                rc = this.readEvalPrint(context, consoleHandler);
            }
        }
        catch (IOException e) {
            rc = 1;
            e.printStackTrace();
        }
        finally {
            consoleHandler.setContext(null);
        }
        System.exit(rc);
    }

    private static boolean getBoolEnv(String var) {
        return GraalPythonMain.getEnv(var) != null;
    }

    private static String getEnv(String var) {
        String value = System.getenv(var);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    private int validateIntMaxStrDigits(String input, String name) {
        try {
            int value = Integer.parseInt(input);
            if (value == 0 || value >= 640) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw this.abort(String.format("%s: invalid limit; must be >= %d  or 0 for unlimited.", name, 640), 1);
    }

    private static String toAbsolutePath(String executable) {
        if (executable.contains(":")) {
            return executable;
        }
        return Paths.get(executable, new String[0]).toAbsolutePath().toString();
    }

    private void findAndApplyVenvCfg(Context.Builder contextBuilder, String executable) {
        Path executablePath;
        try {
            executablePath = Paths.get(executable, new String[0]);
        }
        catch (InvalidPathException e) {
            this.log("cannot determine path of the executable");
            return;
        }
        Path binDir = executablePath.getParent();
        if (binDir == null) {
            this.log("parent directory of the executable does not exist");
            return;
        }
        Path venvCfg = binDir.resolve(J_PYENVCFG);
        this.log("checking: ", venvCfg);
        if (!Files.exists(venvCfg, new LinkOption[0])) {
            Path binParent = binDir.getParent();
            if (binParent == null) {
                return;
            }
            venvCfg = binParent.resolve(J_PYENVCFG);
            this.log("checking: ", venvCfg);
            if (!Files.exists(venvCfg, new LinkOption[0])) {
                return;
            }
        }
        this.log("found: ", venvCfg);
        try (BufferedReader reader = Files.newBufferedReader(venvCfg);){
            String line;
            while ((line = reader.readLine()) != null) {
                String name;
                String[] parts = line.split("=", 2);
                if (parts.length != 2 || !(name = parts[0].trim()).equals("home")) continue;
                try {
                    Path homeProperty;
                    Path graalpyHome = homeProperty = Paths.get(parts[1].trim(), new String[0]);
                    if (graalpyHome.endsWith("bin") || graalpyHome.endsWith("Scripts")) {
                        graalpyHome = graalpyHome.getParent();
                    }
                    contextBuilder.option("python.PythonHome", graalpyHome.toString());
                    Path baseExecutable = null;
                    try {
                        Path realPath = executablePath.toRealPath(new LinkOption[0]);
                        if (!realPath.equals(executablePath.toAbsolutePath())) {
                            baseExecutable = realPath;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (baseExecutable == null) {
                        baseExecutable = homeProperty.resolve(executablePath.getFileName());
                    }
                    if (Files.exists(baseExecutable, new LinkOption[0])) {
                        contextBuilder.option("python.BaseExecutable", baseExecutable.toString());
                        contextBuilder.option("python.PythonHome", baseExecutable.getParent().getParent().toString());
                    }
                }
                catch (NullPointerException | InvalidPathException ex) {
                    this.warn("Could not set PYTHONHOME according to the pyvenv.cfg file.");
                }
                break;
            }
        }
        catch (IOException ex) {
            throw this.abort("Could not read the pyvenv.cfg file.", 66);
        }
    }

    private static boolean matchesPythonOption(String arg, String key) {
        assert (!key.startsWith("python."));
        return arg.startsWith("--python." + key) || arg.startsWith("--" + key);
    }

    private String getContextOptionIfSetViaCommandLine(String key) {
        if (System.getProperty("polyglot.python." + key) != null) {
            return System.getProperty("polyglot.python." + key);
        }
        for (String f : this.givenArguments) {
            if (!GraalPythonMain.matchesPythonOption(f, key)) continue;
            String[] splits = f.split("=", 2);
            if (splits.length > 1) {
                return splits[1];
            }
            return "true";
        }
        return null;
    }

    private boolean hasContextOptionSetViaCommandLine(String key) {
        if (System.getProperty("polyglot.python." + key) != null) {
            return System.getProperty("polyglot.python." + key) != null;
        }
        for (String f : this.givenArguments) {
            if (!GraalPythonMain.matchesPythonOption(f, key)) continue;
            return true;
        }
        return false;
    }

    private static void printFileNotFoundException(NoSuchFileException e) {
        String reason = e.getReason();
        if (reason == null) {
            reason = "No such file or directory";
        }
        System.err.println(GraalPythonMain.class.getCanonicalName() + ": can't open file '" + e.getFile() + "': " + reason);
    }

    private void evalNonInteractive(Context context, ConsoleHandler consoleHandler) throws IOException {
        GraalPythonMain.setupTerminal(consoleHandler);
        Source src = this.commandString != null ? Source.newBuilder((String)this.getLanguageId(), (CharSequence)this.commandString, (String)"<string>").build() : Source.newBuilder((String)this.getLanguageId(), (CharSequence)"__graalpython__.run_path()", (String)"<internal>").internal(true).build();
        context.eval(src);
    }

    protected String getLanguageId() {
        return LANGUAGE_ID;
    }

    protected void printHelp(OptionCategory maxCategory) {
        if (this.isLLVMToolchainLauncher()) {
            System.out.println("GraalPy launcher to use LLVM toolchain and Sulong execution of native extensions.\n");
        }
        System.out.println("usage: python [option] ... (-c cmd | file) [arg] ...\nOptions and arguments (and corresponding environment variables):\n-B     : this disables writing .py[co] files on import\n-c cmd : program passed in as string (terminates option list)\n-E     : ignore PYTHON* environment variables (such as PYTHONPATH)\n-h     : print this help message and exit (also --help)\n-i     : inspect interactively after running script; forces a prompt even\n         if stdin does not appear to be a terminal; also PYTHONINSPECT=x\n-m mod : run library module as a script (terminates option list)\n-O     : on CPython, this optimizes generated bytecode slightly;\n         GraalPython does not use bytecode, and thus this flag has no effect\n-OO    : remove doc-strings in addition to the -O optimizations;\n         GraalPython does not use bytecode, and thus this flag has no effect\n-P     : don't prepend a potentially unsafe path to sys.path; also PYTHONSAFEPATH-R     : on CPython, this enables the use of a pseudo-random salt to make\n         hash()values of various types be unpredictable between separate\n         invocations of the interpreter, as a defense against denial-of-service\n         attacks; GraalPython always enables this and the flag has no effect.\n-q     : don't print version and copyright messages on interactive startup\n-I     : don't add user site and script directory to sys.path; also PYTHONNOUSERSITE\n-s     : don't add user site directory to sys.path; also PYTHONNOUSERSITE\n-S     : don't imply 'import site' on initialization\n-u     : unbuffered binary stdout and stderr; also PYTHONUNBUFFERED=x\n-v     : verbose (trace import statements); also PYTHONVERBOSE=x\n         can be supplied multiple times to increase verbosity\n-V     : print the Python version number and exit (also --version)\n         when given twice, print more information about the build\n-X opt : CPython implementation-specific options. warn_default_encoding and int_max_str_digits are supported on GraalPy\n-W arg : warning control; arg is action:message:category:module:lineno\n         also PYTHONWARNINGS=arg\nfile   : program read from script file\n-      : program read from stdin\narg ...: arguments passed to program in sys.argv[1:]\n\nOther environment variables:\nPYTHONSTARTUP: file executed on interactive startup (no default)\nPYTHONPATH   : ':'-separated list of directories prefixed to the\n               default module search path.  The result is sys.path.\nPYTHONHOME   : alternate <prefix> directory (or <prefix>:<exec_prefix>).\n               The default module search path uses <prefix>/pythonX.X.\nPYTHONCASEOK : ignore case in 'import' statements (Windows).\nPYTHONIOENCODING: Encoding[:errors] used for stdin/stdout/stderr.\nPYTHONHASHSEED: if this variable is set to 'random', the effect is the same\n   as specifying the -R option: a random value is used to seed the hashes of\n   str, bytes and datetime objects.  It can also be set to an integer\n   in the range [0,4294967295] to get hash values with a predictable seed.\nPYTHONPYCACHEPREFIX: if this is set, GraalPython will write .pyc files in a mirror\n   directory tree at this path, instead of in __pycache__ directories within the source tree.\nGRAAL_PYTHON_ARGS: the value is added as arguments as if passed on the\n   commandline. Arguments are split on whitespace - you can use \" and/or ' as required to\n   group them. Alternatively, if the value starts with a vertical tab character, the entire\n   value is split at vertical tabs and the elements are used as arguments without any further\n   escaping. If the value ends with a vertical tab, it is also purged from the environment\n   when the interpreter runs, so that GraalPy subprocess will not pick it up\n   There are two special substitutions for this variable: any `$$' in the value is replaced\n   with the current process id, and any $UUID$ is replaced with random unique string\n   that may contain letters, digits, and '-'. To pass a literal `$$', you must escape the\n   second `$' like so: `$\\$'\n" + (this.wantsExperimental ? "\nArguments specific to the Graal Python launcher:\n--show-version : print the Python version number and continue.\n-CC            : run the C compiler used for generating GraalPython C extensions.\n                 All following arguments are passed to the compiler.\n-LD            : run the linker used for generating GraalPython C extensions.\n                 All following arguments are passed to the linker.\n\nEnvironment variables specific to the Graal Python launcher:\nSULONG_LIBRARY_PATH: Specifies the library path for Sulong.\n   This is required when starting subprocesses of python.\n" : ""));
    }

    private boolean isLLVMToolchainLauncher() {
        String exeName = this.getResolvedExecutableName();
        return exeName != null && exeName.endsWith("-lt");
    }

    protected String[] getDefaultLanguages() {
        return new String[]{this.getLanguageId(), "llvm", "regex"};
    }

    protected void collectArguments(Set<String> options) {
        options.add("-c");
        options.add("-h");
        options.add("-V");
        options.add("--version");
        options.add("--show-version");
    }

    private static ConsoleHandler createConsoleHandler(InputStream inStream, OutputStream outStream) {
        if (!GraalPythonMain.isTTY()) {
            return new DefaultConsoleHandler(inStream);
        }
        return new JLineConsoleHandler(inStream, outStream, false);
    }

    /*
     * Unable to fully structure code
     */
    private int readEvalPrint(Context context, ConsoleHandler consoleHandler) {
        lastStatus = 0;
        try {
            this.setupREPL(context, consoleHandler);
            sys = this.evalInternal(context, "import sys; sys");
            while (true) lbl-1000:
            // 7 sources

            {
                consoleHandler.setPrompt((doEcho = GraalPythonMain.doEcho(context)) != false ? sys.getMember("ps1").asString() : null);
                try {
                    input = consoleHandler.readLine();
                    if (input == null) {
                        throw new EOFException();
                    }
                    if (GraalPythonMain.canSkipFromEval(input)) ** GOTO lbl-1000
                    continuePrompt = null;
                    sb = new StringBuilder(input).append('\n');
                    while (true) {
                        lastStatus = 0;
                        try {
                            context.eval(Source.newBuilder((String)this.getLanguageId(), (CharSequence)sb.toString(), (String)"<stdin>").interactive(true).buildLiteral());
                        }
                        catch (PolyglotException e) {
                            if (continuePrompt == null) {
                                v0 = continuePrompt = doEcho != false ? sys.getMember("ps2").asString() : null;
                            }
                            if (e.isIncompleteSource()) {
                                consoleHandler.setPrompt(continuePrompt);
                                isIncompleteCode = false;
                                do {
                                    additionalInput = consoleHandler.readLine();
                                    sb.append(additionalInput).append('\n');
                                    try {
                                        context.parse(Source.newBuilder((String)this.getLanguageId(), (CharSequence)sb.toString(), (String)"<stdin>").interactive(true).buildLiteral());
                                        e = null;
                                        isIncompleteCode = false;
                                    }
                                    catch (PolyglotException pe) {
                                        if (!pe.isIncompleteSource()) {
                                            e = pe;
                                            break;
                                        }
                                        isIncompleteCode = true;
                                    }
                                } while (additionalInput != null && isIncompleteCode);
                                if (additionalInput != null) continue;
                                throw new EOFException();
                                if (e == null) continue;
                            }
                            if (e.isExit()) {
                                throw new ExitException(e.getExitStatus());
                            }
                            if (e.isInternalError()) {
                                System.err.println("An internal error occurred, continue at your own risk");
                                lastStatus = 1;
                            }
                            lastStatus = 1;
                        }
                        break;
                    }
                }
                catch (EOFException e) {
                    if (!this.noSite) {
                        try {
                            context.eval(Source.newBuilder((String)this.getLanguageId(), (CharSequence)"import site; exit()\n", (String)"<internal>").internal(true).interactive(true).buildLiteral());
                        }
                        catch (PolyglotException e2) {
                            if (e2.isExit()) {
                                return lastStatus;
                            }
                            if (e2.isCancelled()) ** GOTO lbl-1000
                            throw new RuntimeException("error while calling exit", e);
                        }
                    }
                    System.out.println();
                    return lastStatus;
                }
                catch (UserInterruptException var6_9) {
                    continue;
                }
                break;
            }
        }
        catch (ExitException e) {
            return e.code;
        }
        ** GOTO lbl-1000
    }

    private static boolean canSkipFromEval(String input) {
        String[] split;
        for (String s : split = input.split("\n")) {
            if (s.isEmpty() || s.startsWith("#")) continue;
            return false;
        }
        return true;
    }

    private Value evalInternal(Context context, String code) {
        return context.eval(Source.newBuilder((String)this.getLanguageId(), (CharSequence)code, (String)"<internal>").internal(true).buildLiteral());
    }

    private void setupREPL(Context context, ConsoleHandler consoleHandler) {
        this.evalInternal(context, "import sys\ngetattr(sys, '__interactivehook__', lambda: None)()\n");
        Value readline = this.evalInternal(context, "import readline; readline");
        Value getCompleter = readline.getMember("get_completer").execute(new Object[0]);
        Value shouldRecord = readline.getMember("get_auto_history");
        Value addHistory = readline.getMember("add_history");
        Value getHistoryItem = readline.getMember("get_history_item");
        Value setHistoryItem = readline.getMember("replace_history_item");
        Value deleteHistoryItem = readline.getMember("remove_history_item");
        Value clearHistory = readline.getMember("clear_history");
        Value getHistorySize = readline.getMember("get_current_history_length");
        Function<String, List<String>> completer = null;
        if (getCompleter.canExecute()) {
            completer = buffer -> {
                ArrayList<String> candidates = new ArrayList<String>();
                Value candidate = getCompleter.execute(new Object[]{buffer, candidates.size()});
                while (candidate.isString()) {
                    candidates.add(candidate.asString());
                    candidate = getCompleter.execute(new Object[]{buffer, candidates.size()});
                }
                return candidates;
            };
        }
        consoleHandler.setupReader(() -> shouldRecord.execute(new Object[0]).asBoolean(), () -> getHistorySize.execute(new Object[0]).asInt(), item -> addHistory.execute(new Object[]{item}), pos -> getHistoryItem.execute(new Object[]{pos}).asString(), (pos, item) -> setHistoryItem.execute(new Object[]{pos, item}), pos -> deleteHistoryItem.execute(new Object[]{pos}), () -> clearHistory.execute(new Object[0]), completer);
    }

    private static void setupTerminal(ConsoleHandler consoleHandler) {
        consoleHandler.setupReader(() -> false, () -> 0, item -> {}, pos -> null, (pos, item) -> {}, pos -> {}, () -> {}, null);
    }

    private void subExec(List<String> args, List<String> subProcessDefs) {
        List<String> cmd = this.getCmdline(args, subProcessDefs);
        try {
            System.exit(new ProcessBuilder(cmd.toArray(new String[0])).inheritIO().start().waitFor());
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    protected String getResolvedExecutableName() {
        Path realPath;
        String executableName;
        if (ImageInfo.inImageRuntimeCode() && (executableName = ProcessProperties.getExecutableName()) != null) {
            return executableName;
        }
        String launcherExecName = this.getLauncherExecName();
        if (launcherExecName == null) {
            return null;
        }
        Path programPath = Paths.get(launcherExecName, new String[0]);
        try {
            realPath = programPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException ex) {
            throw this.abort(String.format("Cannot determine the executable name from path: '%s'", programPath), 72);
        }
        Path f = realPath.getFileName();
        if (f == null) {
            throw this.abort(String.format("Cannot determine the executable name from path: '%s'", realPath), 73);
        }
        return f.toString();
    }

    private List<String> getCmdline(List<String> args, List<String> subProcessDefs) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (GraalPythonMain.isAOT()) {
            cmd.add(ProcessProperties.getExecutableName());
            for (String subProcArg : subProcessDefs) {
                assert (subProcArg.startsWith("D"));
                cmd.add("--native." + subProcArg);
            }
        } else {
            cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
            switch (System.getProperty("java.vm.name")) {
                case "Java HotSpot(TM) 64-Bit Server VM": {
                    cmd.add("-server");
                    break;
                }
                case "Java HotSpot(TM) 64-Bit Client VM": {
                    cmd.add("-client");
                    break;
                }
            }
            cmd.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
            cmd.add("-cp");
            cmd.add(ManagementFactory.getRuntimeMXBean().getClassPath());
            for (String subProcArg : subProcessDefs) {
                assert (subProcArg.startsWith("D") || subProcArg.startsWith("agent"));
                cmd.add("-" + subProcArg);
            }
            cmd.add(this.getMainClass());
        }
        cmd.addAll(args);
        return cmd;
    }

    private static List<String> getDefaultEnvironmentArgs() {
        String pid = GraalPythonMain.isAOT() ? String.valueOf(ProcessProperties.getProcessID()) : ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        String uuid = UUID.randomUUID().toString();
        String envArgsOpt = GraalPythonMain.getEnv("GRAAL_PYTHON_ARGS");
        ArrayList<String> envArgs = new ArrayList<String>();
        if (envArgsOpt != null) {
            State s = State.NORMAL;
            StringBuilder sb = new StringBuilder();
            char[] charArray = envArgsOpt.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char x = charArray[i];
                if (i == 0 && x == '\u000b') {
                    s = State.VTAB_DELIMITED;
                    continue;
                }
                if (s == State.VTAB_DELIMITED && x == '\u000b') {
                    GraalPythonMain.addArgument(pid, uuid, envArgs, sb);
                    continue;
                }
                if (s == State.VTAB_DELIMITED && x != '\u000b') {
                    sb.append(x);
                    continue;
                }
                if (s == State.NORMAL && Character.isWhitespace(x)) {
                    GraalPythonMain.addArgument(pid, uuid, envArgs, sb);
                    continue;
                }
                if (x == '\"') {
                    if (s == State.NORMAL) {
                        s = State.DOUBLE_QUOTE;
                        continue;
                    }
                    if (s == State.DOUBLE_QUOTE) {
                        s = State.NORMAL;
                        continue;
                    }
                    if (s == State.ESCAPE_DOUBLE_QUOTE) {
                        s = State.DOUBLE_QUOTE;
                        sb.append(x);
                        continue;
                    }
                    sb.append(x);
                    continue;
                }
                if (x == '\'') {
                    if (s == State.NORMAL) {
                        s = State.SINGLE_QUOTE;
                        continue;
                    }
                    if (s == State.SINGLE_QUOTE) {
                        s = State.NORMAL;
                        continue;
                    }
                    if (s == State.ESCAPE_SINGLE_QUOTE) {
                        s = State.SINGLE_QUOTE;
                        sb.append(x);
                        continue;
                    }
                    sb.append(x);
                    continue;
                }
                if (x == '\\') {
                    if (s == State.SINGLE_QUOTE) {
                        s = State.ESCAPE_SINGLE_QUOTE;
                        continue;
                    }
                    if (s != State.DOUBLE_QUOTE) continue;
                    s = State.ESCAPE_DOUBLE_QUOTE;
                    continue;
                }
                sb.append(x);
            }
            GraalPythonMain.addArgument(pid, uuid, envArgs, sb);
        }
        return envArgs;
    }

    private static void addArgument(String pid, String uuid, ArrayList<String> envArgs, StringBuilder sb) {
        if (sb.length() > 0) {
            String arg = sb.toString().replace("$UUID$", uuid).replace("$$", pid).replace("\\$", "$");
            envArgs.add(arg);
            sb.setLength(0);
        }
    }

    private static boolean doEcho(Context context) {
        return true;
    }

    private void log(String message) {
        this.log(message, "");
    }

    private void log(String message1, Object message2) {
        if (this.verboseLauncher) {
            System.err.println("GraalPy launcher: " + message1 + String.valueOf(message2));
        }
    }

    private static final class ExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final int code;

        ExitException(int code) {
            this.code = code;
        }
    }

    private static enum State {
        NORMAL,
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        ESCAPE_SINGLE_QUOTE,
        ESCAPE_DOUBLE_QUOTE,
        VTAB_DELIMITED;

    }
}

