/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupInMROBaseNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.expression.BinaryOp;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.InplaceArithmetic;
import com.oracle.graal.python.nodes.expression.LookupAndCallInplaceNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class LookupAndCallInplaceNode
extends PNodeWithContext
implements BinaryOp {
    @Node.Child
    private CallBinaryMethodNode callBinaryMethodNode;
    @Node.Child
    private BinaryOpNode binaryOpNode;
    @Node.Child
    private LookupAndCallTernaryNode lookupAndCallTernaryNode;
    @Node.Child
    private NotImplementedHandler handler;
    final InplaceArithmetic arithmetic;

    LookupAndCallInplaceNode(InplaceArithmetic arithmetic) {
        this.arithmetic = arithmetic;
    }

    public static LookupAndCallInplaceNode create(InplaceArithmetic arithmetic) {
        return LookupAndCallInplaceNodeGen.create(arithmetic);
    }

    private CallBinaryMethodNode ensureBinaryCallNode() {
        if (this.callBinaryMethodNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callBinaryMethodNode = (CallBinaryMethodNode)this.insert(CallBinaryMethodNode.create());
        }
        return this.callBinaryMethodNode;
    }

    private BinaryOpNode ensureLookupAndCallBinaryNode() {
        if (this.binaryOpNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.binaryOpNode = (BinaryOpNode)this.insert(this.arithmetic.binary.create());
        }
        return this.binaryOpNode;
    }

    private LookupAndCallTernaryNode ensureLookupAndCallTernaryNode() {
        if (this.lookupAndCallTernaryNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupAndCallTernaryNode = (LookupAndCallTernaryNode)this.insert(LookupAndCallTernaryNode.createReversible(this.arithmetic.binaryOpName, null));
        }
        return this.lookupAndCallTernaryNode;
    }

    @Override
    public final Object executeObject(VirtualFrame frame, Object left, Object right) {
        return this.execute(frame, left, right);
    }

    public final Object execute(VirtualFrame frame, Object left, Object right) {
        return this.executeTernary(frame, left, right, PNone.NO_VALUE);
    }

    public abstract Object executeTernary(VirtualFrame var1, Object var2, Object var3, Object var4);

    @NeverDefault
    protected final LookupInMROBaseNode createInplaceLookup() {
        if (this.arithmetic.slot != null) {
            return LookupCallableSlotInMRONode.create(this.arithmetic.slot);
        }
        return LookupAttributeInMRONode.create(this.arithmetic.methodName);
    }

    @Specialization
    Object doBinary(VirtualFrame frame, Object left, Object right, Object z, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(value="createInplaceLookup()") LookupInMROBaseNode lookupInplace) {
        Object result;
        Object inplaceCallable = lookupInplace.execute(getClassNode.execute(inliningTarget, left));
        if (inplaceCallable != PNone.NO_VALUE && (result = this.ensureBinaryCallNode().executeObject((Frame)frame, inplaceCallable, left, right)) != PNotImplemented.NOT_IMPLEMENTED) {
            return result;
        }
        boolean isBinary = PGuards.isPNone(z);
        result = isBinary ? this.ensureLookupAndCallBinaryNode().executeObject(frame, left, right) : this.ensureLookupAndCallTernaryNode().execute(frame, left, right, z);
        if (result != PNotImplemented.NOT_IMPLEMENTED) {
            return result;
        }
        if (this.handler == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.handler = (NotImplementedHandler)this.insert((NotImplementedHandler)((Object)this.arithmetic.notImplementedHandler.get()));
        }
        return this.handler.execute(left, right);
    }

    public static abstract class NotImplementedHandler
    extends PNodeWithContext {
        public abstract Object execute(Object var1, Object var2);
    }
}

