/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.ComparisonOp;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTuple})
public final class TupleBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TupleBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TupleBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetNewargsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PTuple doIt(Object self, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{factory.createTuple(getTupleStorage.execute(inliningTarget, self))});
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        protected static long HASH_UNSET = -1L;

        @Specialization(guards={"self.getHash() != HASH_UNSET"})
        long getHash(PTuple self) {
            return self.getHash();
        }

        @Specialization(guards={"self.getHash() == HASH_UNSET"})
        long computeHash(VirtualFrame frame, PTuple self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="hash") @Cached PyObjectHashNode hashNode) {
            long hash = HashNode.doComputeHash(frame, inliningTarget, getItemNode, hashNode, self.getSequenceStorage());
            self.setHash(hash);
            return hash;
        }

        @Specialization
        long computeHash(VirtualFrame frame, PythonAbstractNativeObject self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="hash") @Cached PyObjectHashNode hashNode, @Cached TupleNodes.GetNativeTupleStorage getStorage) {
            return HashNode.doComputeHash(frame, inliningTarget, getItemNode, hashNode, getStorage.execute(self));
        }

        private static long doComputeHash(VirtualFrame frame, Node inliningTarget, SequenceStorageNodes.GetItemNode getItemNode, PyObjectHashNode hashNode, SequenceStorage tupleStore) {
            int len = tupleStore.length();
            long multiplier = 1000003L;
            long hash = 3430008L;
            for (int i = 0; i < len; ++i) {
                Object item = getItemNode.execute(tupleStore, i);
                long tmp = hashNode.execute((Frame)frame, inliningTarget, item);
                hash = (hash ^ tmp) * multiplier;
                multiplier += (long)(82520 + len + len);
            }
            if ((hash += 97531L) == Long.MAX_VALUE) {
                hash = -2L;
            }
            return hash;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isIntStorage(primary)"})
        static PIntegerSequenceIterator doPTupleInt(PTuple primary, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createIntegerSequenceIterator((IntSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isObjectStorage(primary)"})
        static PObjectSequenceIterator doPTupleObject(PTuple primary, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createObjectSequenceIterator((ObjectSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isLongStorage(primary)"})
        static PLongSequenceIterator doPTupleLong(PTuple primary, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createLongSequenceIterator((LongSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isDoubleStorage(primary)"})
        static PDoubleSequenceIterator doPTupleDouble(PTuple primary, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createDoubleSequenceIterator((DoubleSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"!isIntStorage(primary)", "!isLongStorage(primary)", "!isDoubleStorage(primary)"})
        static PSequenceIterator doPTuple(PTuple primary, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createSequenceIterator(primary);
        }

        @Specialization
        static PSequenceIterator doNativeTuple(PythonAbstractNativeObject primary, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createSequenceIterator(primary);
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        ContainsNode() {
        }

        @Specialization
        boolean contains(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached SequenceStorageNodes.ContainsNode containsNode) {
            return containsNode.execute(frame, inliningTarget, getTupleStorage.execute(inliningTarget, self), other);
        }
    }

    @Slot(value=Slot.SlotKind.sq_repeat, isComplex=true)
    @GenerateNodeFactory
    static abstract class MulNode
    extends TpSlotSizeArgFun.SqRepeatBuiltinNode {
        MulNode() {
        }

        @Specialization
        static Object doTuple(VirtualFrame frame, Object left, int repeats, @Bind(value="this") Node inliningTarget, @Cached PyTupleCheckExactNode checkTuple, @Cached TupleNodes.GetTupleStorage getLeft, @Cached InlinedConditionProfile isSingleRepeat, @Cached PyNumberAsSizeNode asSizeNode, @Cached SequenceStorageNodes.RepeatNode repeatNode, @Cached PythonObjectFactory.Lazy factory) {
            if (isSingleRepeat.profile(inliningTarget, repeats == 1 && checkTuple.execute(inliningTarget, left))) {
                return left;
            }
            return factory.get(inliningTarget).createTuple(repeatNode.execute(frame, getLeft.execute(inliningTarget, left), repeats));
        }
    }

    @Slot(value=Slot.SlotKind.sq_concat, isComplex=true)
    @GenerateNodeFactory
    static abstract class TupleConcatNode
    extends TpSlotBinaryFunc.SqConcatBuiltinNode {
        TupleConcatNode() {
        }

        @Specialization(guards={"checkRight.execute(inliningTarget, right)"}, limit="1")
        static PTuple doTuple(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached PyTupleCheckNode checkRight, @Cached TupleNodes.GetTupleStorage getLeft, @Cached TupleNodes.GetTupleStorage getRight, @Cached(value="createConcat()") SequenceStorageNodes.ConcatNode concatNode, @Cached PythonObjectFactory factory) {
            SequenceStorage concatenated = concatNode.execute(getLeft.execute(inliningTarget, left), getRight.execute(inliningTarget, right));
            return factory.createTuple(concatenated);
        }

        @NeverDefault
        protected static SequenceStorageNodes.ConcatNode createConcat() {
            return SequenceStorageNodes.ConcatNode.create(SequenceStorageNodes.ListGeneralizationNode::create);
        }

        @Fallback
        static Object doGeneric(Object left, Object right, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_CONCAT_S_NOT_P_TO_S, "tuple", right, "tuple");
        }
    }

    @Builtin(name="__truffle_richcompare__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @ImportStatic(value={ComparisonOp.class})
    static abstract class RichCompareNode
    extends PythonTernaryBuiltinNode {
        RichCompareNode() {
        }

        @Specialization(guards={"opCode == cachedOp.opCode"}, limit="6")
        static Object doPTuple(VirtualFrame frame, PTuple left, PTuple right, int opCode, @Cached(value="fromOpCode(opCode)") ComparisonOp cachedOp, @Cached.Exclusive @Cached(value="createCmpNode(cachedOp)") SequenceStorageNodes.CmpNode cmpNode) {
            return cmpNode.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Specialization(guards={"opCode == cachedOp.opCode"}, limit="6", replaces={"doPTuple"})
        static Object doGeneric(VirtualFrame frame, Object left, Object right, int opCode, @Bind(value="this") Node inliningTarget, @Cached(value="fromOpCode(opCode)") ComparisonOp cachedOp, @Cached PyTupleCheckNode checkLeft, @Cached PyTupleCheckNode checkRight, @Cached TupleNodes.GetTupleStorage getLeft, @Cached TupleNodes.GetTupleStorage getRight, @Cached.Exclusive @Cached(value="createCmpNode(cachedOp)") SequenceStorageNodes.CmpNode cmpNode) {
            if (!checkLeft.execute(inliningTarget, left) || !checkRight.execute(inliningTarget, right)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return cmpNode.execute(frame, getLeft.execute(inliningTarget, left), getRight.execute(inliningTarget, right));
        }

        @NeverDefault
        static SequenceStorageNodes.CmpNode createCmpNode(ComparisonOp op) {
            switch (op) {
                case LE: {
                    return SequenceStorageNodes.CmpNode.createLe();
                }
                case LT: {
                    return SequenceStorageNodes.CmpNode.createLt();
                }
                case EQ: {
                    return SequenceStorageNodes.CmpNode.createEq();
                }
                case NE: {
                    return SequenceStorageNodes.CmpNode.createNe();
                }
                case GT: {
                    return SequenceStorageNodes.CmpNode.createGt();
                }
                case GE: {
                    return SequenceStorageNodes.CmpNode.createGe();
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends AbstractCmpNode {
        LtNode() {
        }

        @Override
        @NeverDefault
        protected SequenceStorageNodes.CmpNode createCmp() {
            return SequenceStorageNodes.CmpNode.createLt();
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends AbstractCmpNode {
        GtNode() {
        }

        @Override
        @NeverDefault
        protected SequenceStorageNodes.CmpNode createCmp() {
            return SequenceStorageNodes.CmpNode.createGt();
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends AbstractCmpNode {
        LeNode() {
        }

        @Override
        @NeverDefault
        protected SequenceStorageNodes.CmpNode createCmp() {
            return SequenceStorageNodes.CmpNode.createLe();
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends AbstractCmpNode {
        GeNode() {
        }

        @Override
        @NeverDefault
        protected SequenceStorageNodes.CmpNode createCmp() {
            return SequenceStorageNodes.CmpNode.createGe();
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NeNode
    extends AbstractCmpNode {
        NeNode() {
        }

        @Override
        @NeverDefault
        protected SequenceStorageNodes.CmpNode createCmp() {
            return SequenceStorageNodes.CmpNode.createNe();
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends AbstractCmpNode {
        EqNode() {
        }

        @Override
        @NeverDefault
        protected SequenceStorageNodes.CmpNode createCmp() {
            return SequenceStorageNodes.CmpNode.createEq();
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractCmpNode
    extends PythonBinaryBuiltinNode {
        AbstractCmpNode() {
        }

        @Specialization
        static boolean doPTuple(VirtualFrame frame, PTuple left, PTuple right, @Cached.Shared(value="cmp") @Cached(value="createCmp()") SequenceStorageNodes.CmpNode cmp) {
            return cmp.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Specialization(guards={"checkRight.execute(inliningTarget, right)"}, limit="1", replaces={"doPTuple"})
        static boolean doTuple(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached PyTupleCheckNode checkRight, @Cached TupleNodes.GetTupleStorage getLeft, @Cached TupleNodes.GetTupleStorage getRight, @Cached.Shared(value="cmp") @Cached(value="createCmp()") SequenceStorageNodes.CmpNode cmp) {
            return cmp.execute(frame, getLeft.execute(inliningTarget, left), getRight.execute(inliningTarget, right));
        }

        @Fallback
        static Object doOther(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        protected abstract SequenceStorageNodes.CmpNode createCmp();
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object idx, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile validProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PRaiseNode.Lazy raiseNode, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached SequenceStorageNodes.SequenceStorageMpSubscriptNode subscriptNode) {
            if (!validProfile.profile(inliningTarget, SequenceStorageNodes.SequenceStorageMpSubscriptNode.isValidIndex(inliningTarget, idx, indexCheckNode))) {
                GetItemNode.raiseNonIntIndex(inliningTarget, raiseNode, idx);
            }
            return subscriptNode.execute(frame, inliningTarget, getTupleStorage.execute(inliningTarget, self), idx, ErrorMessages.TUPLE_OUT_OF_BOUNDS, PythonObjectFactory::createTuple);
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseNonIntIndex(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object index) {
            raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "tuple", index);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class TupleSqItem
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        @Specialization
        static Object doIt(Object self, int index, @Bind(value="this") Node inliningTarget, @Cached PyTupleGetItem getItem) {
            return getItem.execute(inliningTarget, self, index);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString NULL = PythonUtils.tsLiteral("(null)");

        public abstract TruffleString execute(VirtualFrame var1, Object var2);

        public static TruffleString toString(VirtualFrame frame, Node inliningTarget, Object item, PyObjectReprAsTruffleStringNode reprNode) {
            if (item != null) {
                return reprNode.execute((Frame)frame, inliningTarget, item);
            }
            return NULL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public static TruffleString repr(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage tupleStore = getTupleStorage.execute(inliningTarget, self);
            int len = tupleStore.length();
            if (len == 0) {
                return StringLiterals.T_EMPTY_PARENS;
            }
            if (!PythonContext.get(reprNode).reprEnter(self)) {
                return StringLiterals.T_ELLIPSIS_IN_PARENS;
            }
            try {
                TruffleStringBuilder buf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_LPAREN);
                for (int i = 0; i < len - 1; ++i) {
                    appendStringNode.execute(buf, (AbstractTruffleString)ReprNode.toString(frame, inliningTarget, getItemNode.execute(tupleStore, i), reprNode));
                    appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                }
                if (len > 0) {
                    appendStringNode.execute(buf, (AbstractTruffleString)ReprNode.toString(frame, inliningTarget, getItemNode.execute(tupleStore, len - 1), reprNode));
                }
                if (len == 1) {
                    appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_COMMA);
                }
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_RPAREN);
                TruffleString truffleString = toStringNode.execute(buf);
                return truffleString;
            }
            finally {
                PythonContext.get(reprNode).reprLeave(self);
            }
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.sq_length), @Slot(value=Slot.SlotKind.mp_length)})
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        public int len(Object self, @Bind(value="this") Node inliningTarget, @Cached PyTupleSizeNode pyTupleSizeNode) {
            return pyTupleSizeNode.execute(inliningTarget, self);
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class CountNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        long count(VirtualFrame frame, Object self, Object value, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            long count = 0L;
            SequenceStorage tupleStore = getTupleStorage.execute(inliningTarget, self);
            for (int i = 0; i < tupleStore.length(); ++i) {
                Object seqItem = getItemNode.execute(tupleStore, i);
                if (!eqNode.compare((Frame)frame, inliningTarget, seqItem, value)) continue;
                ++count;
            }
            return count;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, parameterNames={"$self", "value", "start", "stop"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0"), @ArgumentClinic(name="stop", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE")})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    public static abstract class IndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TupleBuiltinsClinicProviders.IndexNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int index(VirtualFrame frame, Object self, Object value, int startIn, int endIn, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached InlinedBranchProfile startLe0Profile, @Cached InlinedBranchProfile endLe0Profile, @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode, @Cached PRaiseNode.Lazy raiseNode) {
            int idx;
            int end;
            SequenceStorage storage = getTupleStorage.execute(inliningTarget, self);
            int start = startIn;
            if (start < 0) {
                startLe0Profile.enter(inliningTarget);
                if ((start += storage.length()) < 0) {
                    start = 0;
                }
            }
            if ((end = endIn) < 0) {
                endLe0Profile.enter(inliningTarget);
                end += storage.length();
            }
            if ((idx = itemIndexNode.execute(frame, inliningTarget, storage, value, start, end)) != -1) {
                return idx;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.X_NOT_IN_TUPLE);
        }
    }
}

