/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.str;

import com.oracle.graal.python.builtins.objects.str.StringUtilsFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import com.oracle.truffle.regex.chardata.UnicodeCharacterAliases;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public final class StringUtils {
    public static final int LAZY_CODEPOINT_THRESHOLD = 20;
    private static final int[] ASCII_WHITESPACE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static boolean isUnicodeWhitespace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 133: 
            case 160: 
            case 5760: 
            case 8192: 
            case 8193: 
            case 8194: 
            case 8195: 
            case 8196: 
            case 8197: 
            case 8198: 
            case 8199: 
            case 8200: 
            case 8201: 
            case 8202: 
            case 8232: 
            case 8233: 
            case 8239: 
            case 8287: 
            case 12288: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnicodeLineBreak(char ch) {
        switch (ch) {
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpace(int ch) {
        if (ch < 128) {
            return ASCII_WHITESPACE[ch] == 1;
        }
        return StringUtils.isUnicodeWhitespace(ch);
    }

    public static TruffleString strip(TruffleString str, StripKind stripKind, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode, TruffleString.SubstringNode substringNode) {
        int i;
        int len = codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
        if (stripKind != StripKind.RIGHT) {
            int cp;
            for (i = 0; i < len && StringUtils.isSpace(cp = codePointAtIndexNode.execute((AbstractTruffleString)str, i, PythonUtils.TS_ENCODING)); ++i) {
            }
        }
        int j = len;
        if (stripKind != StripKind.LEFT) {
            int cp;
            --j;
            while (j >= i && StringUtils.isSpace(cp = codePointAtIndexNode.execute((AbstractTruffleString)str, j, PythonUtils.TS_ENCODING))) {
                --j;
            }
            ++j;
        }
        return substringNode.execute((AbstractTruffleString)str, i, j - i, PythonUtils.TS_ENCODING, false);
    }

    public static TruffleString strip(TruffleString str, TruffleString chars, StripKind stripKind, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode, TruffleString.IndexOfCodePointNode indexOfCodePointNode, TruffleString.SubstringNode substringNode) {
        int i;
        int len = codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
        int charsLen = codePointLengthNode.execute((AbstractTruffleString)chars, PythonUtils.TS_ENCODING);
        if (stripKind != StripKind.RIGHT) {
            int cp;
            for (i = 0; i < len && indexOfCodePointNode.execute((AbstractTruffleString)chars, cp = codePointAtIndexNode.execute((AbstractTruffleString)str, i, PythonUtils.TS_ENCODING), 0, charsLen, PythonUtils.TS_ENCODING) >= 0; ++i) {
            }
        }
        int j = len;
        if (stripKind != StripKind.LEFT) {
            int cp;
            --j;
            while (j >= i && indexOfCodePointNode.execute((AbstractTruffleString)chars, cp = codePointAtIndexNode.execute((AbstractTruffleString)str, j, PythonUtils.TS_ENCODING), 0, charsLen, PythonUtils.TS_ENCODING) >= 0) {
                --j;
            }
            ++j;
        }
        return substringNode.execute((AbstractTruffleString)str, i, j - i, PythonUtils.TS_ENCODING, false);
    }

    public static Object[] toCharacterArray(TruffleString arg, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, TruffleStringIterator.NextNode nextNode, TruffleString.FromCodePointNode fromCodePointNode) {
        Object[] values = new Object[codePointLengthNode.execute((AbstractTruffleString)arg, PythonUtils.TS_ENCODING)];
        TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)arg, PythonUtils.TS_ENCODING);
        int i = 0;
        while (it.hasNext()) {
            int codePoint = nextNode.execute(it);
            values[i++] = fromCodePointNode.execute(codePoint, PythonUtils.TS_ENCODING, true);
        }
        return values;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isPrintable(int codepoint) {
        if (ImageInfo.inImageBuildtimeCode()) {
            assert (codepoint < 256);
            return codepoint >= 32;
        }
        return StringUtils.isPrintableICU(codepoint);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isPrintableICU(int codepoint) {
        int category = UCharacter.getType((int)codepoint);
        switch (category) {
            case 0: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return false;
            }
            case 12: {
                return codepoint == 32;
            }
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static String toLowerCase(String self) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return self.toLowerCase();
        }
        return UCharacter.toLowerCase((Locale)Locale.ROOT, (String)self);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toUpperCase(String str) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return str.toUpperCase();
        }
        return UCharacter.toUpperCase((Locale)Locale.ROOT, (String)str);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isAlnum(int codePoint) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return Character.isLetterOrDigit(codePoint);
        }
        return StringUtils.isAlnumICU(codePoint);
    }

    private static boolean isAlnumICU(int codePoint) {
        if (UCharacter.isLetter((int)codePoint) || UCharacter.isDigit((int)codePoint) || UCharacter.hasBinaryProperty((int)codePoint, (int)4105)) {
            return true;
        }
        int numericType = UCharacter.getIntPropertyValue((int)codePoint, (int)4105);
        return numericType == 1 || numericType == 2 || numericType == 3;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static String toString(StringBuilder sb) {
        return sb.toString();
    }

    public static int compareStrings(TruffleString a, TruffleString b, TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
        assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32);
        return compareIntsUTF32Node.execute((AbstractTruffleString)a, (AbstractTruffleString)b);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int compareStringsUncached(TruffleString a, TruffleString b) {
        return StringUtils.compareStrings(a, b, TruffleString.CompareIntsUTF32Node.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString joinUncached(TruffleString delimiter, Iterable<TruffleString> values) {
        Iterator<TruffleString> it = values.iterator();
        if (!it.hasNext()) {
            return PythonUtils.TS_ENCODING.getEmpty();
        }
        TruffleString first = it.next();
        if (!it.hasNext()) {
            return first;
        }
        TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        sb.appendStringUncached(first);
        while (it.hasNext()) {
            sb.appendStringUncached(delimiter);
            sb.appendStringUncached(it.next());
        }
        return sb.toStringUncached();
    }

    public static TruffleString[] split(TruffleString s, TruffleString sep, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.IndexOfStringNode indexOfStringNode, TruffleString.SubstringNode substringNode, TruffleString.EqualNode eqNode) {
        int nextIndex;
        int selfLen = codePointLengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING);
        int lastEnd = 0;
        int sepLen = codePointLengthNode.execute((AbstractTruffleString)sep, PythonUtils.TS_ENCODING);
        if (selfLen == sepLen && eqNode.execute((AbstractTruffleString)s, (AbstractTruffleString)sep, PythonUtils.TS_ENCODING)) {
            return PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
        }
        ArrayList<TruffleString> l = new ArrayList<TruffleString>();
        while (lastEnd < selfLen && (nextIndex = indexOfStringNode.execute((AbstractTruffleString)s, (AbstractTruffleString)sep, lastEnd, selfLen, PythonUtils.TS_ENCODING)) >= 0) {
            StringUtils.add(l, substringNode.execute((AbstractTruffleString)s, lastEnd, nextIndex - lastEnd, PythonUtils.TS_ENCODING, false));
            lastEnd = nextIndex + sepLen;
        }
        StringUtils.add(l, substringNode.execute((AbstractTruffleString)s, lastEnd, selfLen - lastEnd, PythonUtils.TS_ENCODING, false));
        return l.toArray(new TruffleString[l.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    private static void add(List<TruffleString> l, TruffleString s) {
        l.add(s);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString cat(TruffleString arg1, TruffleString arg2) {
        return arg1.concatUncached((AbstractTruffleString)arg2, PythonUtils.TS_ENCODING, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString cat(TruffleString ... args) {
        if (args.length == 2) {
            return args[0].concatUncached((AbstractTruffleString)args[1], PythonUtils.TS_ENCODING, false);
        }
        TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        for (TruffleString arg : args) {
            sb.appendStringUncached(arg);
        }
        return sb.toStringUncached();
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString simpleTruffleStringFormatUncached(TruffleString format, Object ... args) {
        return SimpleTruffleStringFormatNode.getUncached().format(format, args);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString simpleTruffleStringFormatUncached(String format, Object ... args) {
        return SimpleTruffleStringFormatNode.getUncached().format(format, args);
    }

    @CompilerDirectives.TruffleBoundary
    public static int getCodePoint(String characterName) {
        String normalizedName = characterName.trim().toUpperCase(Locale.ROOT);
        if (UnicodeCharacterAliases.CHARACTER_ALIASES.containsKey((Object)normalizedName)) {
            return (Integer)UnicodeCharacterAliases.CHARACTER_ALIASES.get((Object)normalizedName);
        }
        return UCharacter.getCharFromName((String)characterName);
    }

    public static enum StripKind {
        LEFT,
        RIGHT,
        BOTH;

    }

    @GenerateUncached
    public static abstract class SimpleTruffleStringFormatNode
    extends Node {
        public final TruffleString format(TruffleString format, Object ... args) {
            return this.executeInternal(format, args);
        }

        public final TruffleString format(String format, Object ... args) {
            return this.executeInternal(format, args);
        }

        abstract TruffleString executeInternal(TruffleString var1, Object[] var2);

        abstract TruffleString executeInternal(String var1, Object[] var2);

        @Specialization
        TruffleString doTruffleString(TruffleString format, Object[] args, @Cached.Shared(value="sbToString") @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached.Shared(value="appendSubstr") @Cached TruffleStringBuilder.AppendSubstringByteIndexNode appendSubstringByteIndexNode, @Cached.Shared(value="appendCP") @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached.Shared(value="appendStr") @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared(value="appendLong") @Cached TruffleStringBuilder.AppendLongNumberNode appendLongNumberNode, @Cached.Shared(value="byteIndexOfCodePoint") @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached.Shared(value="cpAtByteIndex") @Cached TruffleString.CodePointAtByteIndexNode codePointAtByteIndexNode, @Cached.Shared(value="byteLenOfCP") @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            int j;
            int i;
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            int len = format.byteLength(PythonUtils.TS_ENCODING);
            int nextArg = 0;
            block6: for (i = 0; i < len && (j = byteIndexOfCodePointNode.execute((AbstractTruffleString)format, 37, i, len, PythonUtils.TS_ENCODING)) >= 0; i += byteLengthOfCodePointNode.execute((AbstractTruffleString)format, i, PythonUtils.TS_ENCODING)) {
                appendSubstringByteIndexNode.execute(sb, (AbstractTruffleString)format, i, j - i);
                i = j;
                i += byteLengthOfCodePointNode.execute((AbstractTruffleString)format, i, PythonUtils.TS_ENCODING);
                if (i >= len) {
                    throw CompilerDirectives.shouldNotReachHere((String)"Truncated format directive");
                }
                int c = codePointAtByteIndexNode.execute((AbstractTruffleString)format, i, PythonUtils.TS_ENCODING);
                switch (c) {
                    case 37: {
                        appendCodePointNode.execute(sb, 37, 1, true);
                        continue block6;
                    }
                    case 115: {
                        appendStringNode.execute(sb, (AbstractTruffleString)SimpleTruffleStringFormatNode.asString(SimpleTruffleStringFormatNode.fetchArg(args, nextArg++), fromJavaStringNode));
                        continue block6;
                    }
                    case 99: {
                        appendCodePointNode.execute(sb, SimpleTruffleStringFormatNode.asCodePoint(SimpleTruffleStringFormatNode.fetchArg(args, nextArg++)), 1, true);
                        continue block6;
                    }
                    case 100: {
                        appendLongNumberNode.execute(sb, SimpleTruffleStringFormatNode.asLong(SimpleTruffleStringFormatNode.fetchArg(args, nextArg++)));
                        continue block6;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid format directive");
            }
            if (nextArg != args.length) {
                throw CompilerDirectives.shouldNotReachHere((String)"Extra unprocessed arguments");
            }
            if (i < len) {
                appendSubstringByteIndexNode.execute(sb, (AbstractTruffleString)format, i, len - i);
            }
            return toStringNode.execute(sb);
        }

        @Specialization
        TruffleString doJavaString(String format, Object[] args, @Cached.Shared(value="sbToString") @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached.Shared(value="appendSubstr") @Cached TruffleStringBuilder.AppendSubstringByteIndexNode appendSubstringByteIndexNode, @Cached.Shared(value="appendCP") @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached.Shared(value="appendStr") @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared(value="appendLong") @Cached TruffleStringBuilder.AppendLongNumberNode appendLongNumberNode, @Cached.Shared(value="byteIndexOfCodePoint") @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached.Shared(value="cpAtByteIndex") @Cached TruffleString.CodePointAtByteIndexNode codePointAtByteIndexNode, @Cached.Shared(value="byteLenOfCP") @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.doTruffleString(fromJavaStringNode.execute(format, PythonUtils.TS_ENCODING), args, toStringNode, appendSubstringByteIndexNode, appendCodePointNode, appendStringNode, appendLongNumberNode, byteIndexOfCodePointNode, codePointAtByteIndexNode, byteLengthOfCodePointNode, fromJavaStringNode);
        }

        private static Object fetchArg(Object[] args, int nextArg) {
            if (nextArg >= args.length) {
                throw CompilerDirectives.shouldNotReachHere((String)"Not enough arguments for formatting");
            }
            return args[nextArg];
        }

        private static TruffleString asString(Object arg, TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (arg instanceof TruffleString) {
                return (TruffleString)arg;
            }
            if (arg instanceof String) {
                return fromJavaStringNode.execute((String)arg, PythonUtils.TS_ENCODING);
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Expected a string argument");
        }

        private static long asLong(Object arg) {
            if (arg instanceof Long) {
                return (Long)arg;
            }
            if (arg instanceof Integer) {
                return ((Integer)arg).intValue();
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Expected an int or long argument");
        }

        private static int asCodePoint(Object arg) {
            if (arg instanceof Integer) {
                return (Integer)arg;
            }
            if (arg instanceof Character) {
                return ((Character)arg).charValue();
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Expected an int or char argument");
        }

        public static SimpleTruffleStringFormatNode getUncached() {
            return StringUtilsFactory.SimpleTruffleStringFormatNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsIdentifierNode
    extends Node {
        public abstract boolean execute(Node var1, TruffleString var2);

        @Specialization
        static boolean doString(TruffleString str, @Cached(inline=false) TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached(inline=false) TruffleStringIterator.NextNode nextNode) {
            if (str.isEmpty()) {
                return false;
            }
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
            int c = nextNode.execute(it);
            if (c != 95 && !IsIdentifierNode.hasProperty(c, 33)) {
                return false;
            }
            while (it.hasNext()) {
                c = nextNode.execute(it);
                if (IsIdentifierNode.hasProperty(c, 32)) continue;
                return false;
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        static boolean hasProperty(int codePoint, int property) {
            return UCharacter.hasBinaryProperty((int)codePoint, (int)property);
        }
    }
}

