/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BuiltinMethodDescriptor {
    private static final ConcurrentHashMap<BuiltinMethodDescriptor, BuiltinMethodDescriptor> CACHE = new ConcurrentHashMap();
    private final NodeFactory<? extends PythonBuiltinBaseNode> factory;
    private final PythonBuiltinClassType type;
    private final Builtin builtinAnnotation;
    private final String name;
    private final boolean isReverseOperation;
    private final int minNumOfPositionalArgs;

    public static BuiltinMethodDescriptor get(PBuiltinFunction function) {
        CompilerAsserts.neverPartOfCompilation();
        NodeFactory<? extends PythonBuiltinBaseNode> factory = function.getBuiltinNodeFactory();
        if (factory == null) {
            return null;
        }
        Builtin builtinAnnotation = BuiltinMethodDescriptor.findBuiltinAnnotation(function.getName().toJavaStringUncached(), factory);
        if (builtinAnnotation == null || builtinAnnotation.needsFrame()) {
            return null;
        }
        PythonBuiltinClassType type = null;
        Object enclosing = function.getEnclosingType();
        if (enclosing instanceof PythonBuiltinClassType) {
            type = (PythonBuiltinClassType)((Object)enclosing);
        } else if (enclosing instanceof PythonBuiltinClass) {
            type = ((PythonBuiltinClass)enclosing).getType();
        } else assert (enclosing == null);
        return BuiltinMethodDescriptor.get(function.getName().toJavaStringUncached(), factory, type);
    }

    static BuiltinMethodDescriptor get(final String name, NodeFactory<? extends PythonBuiltinBaseNode> factory, PythonBuiltinClassType type) {
        Builtin builtinAnnotation = BuiltinMethodDescriptor.findBuiltinAnnotation(name, factory);
        if (builtinAnnotation == null) {
            return new UnaryBuiltinDescriptor(name, null, PythonBuiltinClassType.PythonObject, new Builtin(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Builtin.class;
                }

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String doc() {
                    return null;
                }

                @Override
                public PythonOS os() {
                    return null;
                }

                @Override
                public PythonBuiltinClassType constructsClass() {
                    return null;
                }

                @Override
                public PythonBuiltinClassType[] base() {
                    return new PythonBuiltinClassType[0];
                }

                @Override
                public int minNumOfPositionalArgs() {
                    return 0;
                }

                @Override
                public int maxNumOfPositionalArgs() {
                    return 0;
                }

                @Override
                public int numOfPositionalOnlyArgs() {
                    return 0;
                }

                @Override
                public boolean isGetter() {
                    return false;
                }

                @Override
                public boolean isSetter() {
                    return false;
                }

                @Override
                public boolean allowsDelete() {
                    return false;
                }

                @Override
                public boolean takesVarArgs() {
                    return false;
                }

                @Override
                public boolean varArgsMarker() {
                    return false;
                }

                @Override
                public boolean takesVarKeywordArgs() {
                    return false;
                }

                @Override
                public String[] parameterNames() {
                    return new String[0];
                }

                @Override
                public String[] keywordOnlyNames() {
                    return new String[0];
                }

                @Override
                public boolean isPublic() {
                    return false;
                }

                @Override
                public boolean isClassmethod() {
                    return false;
                }

                @Override
                public boolean isStaticmethod() {
                    return false;
                }

                @Override
                public boolean needsFrame() {
                    return false;
                }

                @Override
                public boolean alwaysNeedsCallerFrame() {
                    return false;
                }

                @Override
                public boolean declaresExplicitSelf() {
                    return false;
                }

                @Override
                public boolean reverseOperation() {
                    return false;
                }

                @Override
                public String raiseErrorName() {
                    return null;
                }

                @Override
                public boolean forceSplitDirectCalls() {
                    return false;
                }

                @Override
                public boolean autoRegister() {
                    return false;
                }
            });
        }
        assert (builtinAnnotation != null && !builtinAnnotation.needsFrame());
        return BuiltinMethodDescriptor.get(name, factory, type, builtinAnnotation);
    }

    private static BuiltinMethodDescriptor get(String name, NodeFactory<? extends PythonBuiltinBaseNode> factory, PythonBuiltinClassType type, Builtin builtinAnnotation) {
        CompilerAsserts.neverPartOfCompilation();
        if (factory.getClass().getAnnotation(GeneratedBy.class) == null) {
            return null;
        }
        Class nodeClass = factory.getNodeClass();
        BuiltinMethodDescriptor result = null;
        if (PythonUnaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            result = new UnaryBuiltinDescriptor(name, factory, type, builtinAnnotation);
            assert (result.getBuiltinAnnotation().minNumOfPositionalArgs() <= 1) : name;
        } else if (PythonBinaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            result = new BinaryBuiltinDescriptor(name, factory, type, builtinAnnotation);
            assert (result.getBuiltinAnnotation().minNumOfPositionalArgs() <= 2) : name;
        } else if (PythonTernaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            result = new TernaryBuiltinDescriptor(name, factory, type, builtinAnnotation);
            assert (result.getBuiltinAnnotation().minNumOfPositionalArgs() <= 3) : name;
        }
        if (result != null) {
            return CACHE.computeIfAbsent(result, x -> x);
        }
        return null;
    }

    public static boolean isInstance(Object obj) {
        return obj instanceof BuiltinMethodDescriptor;
    }

    private static Builtin findBuiltinAnnotation(String name, NodeFactory<? extends PythonBuiltinBaseNode> factory) {
        if (TpSlot.TpSlotBuiltin.isSlotFactory(factory)) {
            return null;
        }
        for (Builtin builtin : (Builtin[])factory.getNodeClass().getAnnotationsByType(Builtin.class)) {
            if (builtin.name().equals(name)) {
                return builtin;
            }
            if (builtin.constructsClass() == PythonBuiltinClassType.nil || !"__new__".equals(name)) continue;
            return builtin;
        }
        throw new IllegalStateException(String.format("Cannot find corresponding builtin annotation on class %s for builtin '%s'", factory.getNodeClass().getSimpleName(), name));
    }

    private BuiltinMethodDescriptor(String name, NodeFactory<? extends PythonBuiltinBaseNode> factory, PythonBuiltinClassType type, Builtin builtinAnnotation) {
        assert (name.equals(builtinAnnotation.name()));
        this.name = name;
        this.factory = factory;
        this.type = type;
        this.builtinAnnotation = builtinAnnotation;
        this.isReverseOperation = builtinAnnotation.reverseOperation();
        this.minNumOfPositionalArgs = builtinAnnotation.minNumOfPositionalArgs();
    }

    public final NodeFactory<? extends PythonBuiltinBaseNode> getFactory() {
        return this.factory;
    }

    public final boolean isDescriptorOf(PBuiltinFunction fun) {
        return fun.getDescriptor() == this;
    }

    public final PythonBuiltinClassType getEnclosingType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isReverseOperation() {
        return this.isReverseOperation;
    }

    public final int minNumOfPositionalArgs() {
        return this.minNumOfPositionalArgs;
    }

    public final Builtin getBuiltinAnnotation() {
        return this.builtinAnnotation;
    }

    public final boolean equals(Object o) {
        CompilerAsserts.neverPartOfCompilation();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuiltinMethodDescriptor that = (BuiltinMethodDescriptor)o;
        assert (this.factory.getNodeClass() == that.factory.getNodeClass() == (this.factory == that.factory)) : this.name;
        return this.factory == that.factory && this.type == that.type && this.name.equals(that.name);
    }

    public final int hashCode() {
        CompilerAsserts.neverPartOfCompilation();
        return Objects.hash(new Object[]{this.factory, this.type, this.name});
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getClass().getSimpleName() + "{" + String.valueOf((Object)this.type) + "." + this.name + "}";
    }

    public static final class UnaryBuiltinDescriptor
    extends BuiltinMethodDescriptor {
        public UnaryBuiltinDescriptor(String name, NodeFactory<? extends PythonBuiltinBaseNode> factory, PythonBuiltinClassType type, Builtin builtinAnnotation) {
            super(name, factory, type, builtinAnnotation);
        }

        public PythonUnaryBuiltinNode createNode() {
            return (PythonUnaryBuiltinNode)((Object)this.getFactory().createNode(new Object[0]));
        }
    }

    public static final class BinaryBuiltinDescriptor
    extends BuiltinMethodDescriptor {
        public BinaryBuiltinDescriptor(String name, NodeFactory<? extends PythonBuiltinBaseNode> factory, PythonBuiltinClassType type, Builtin builtinAnnotation) {
            super(name, factory, type, builtinAnnotation);
        }

        public PythonBinaryBuiltinNode createNode() {
            return (PythonBinaryBuiltinNode)((Object)this.getFactory().createNode(new Object[0]));
        }
    }

    public static final class TernaryBuiltinDescriptor
    extends BuiltinMethodDescriptor {
        public TernaryBuiltinDescriptor(String name, NodeFactory<? extends PythonBuiltinBaseNode> factory, PythonBuiltinClassType type, Builtin builtinAnnotation) {
            super(name, factory, type, builtinAnnotation);
        }

        public PythonTernaryBuiltinNode createNode() {
            return (PythonTernaryBuiltinNode)((Object)this.getFactory().createNode(new Object[0]));
        }
    }
}

