/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.floats;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public class PFloat
extends PythonBuiltinObject {
    protected final double value;

    public PFloat(Object clazz, Shape instanceShape, double value) {
        super(clazz, instanceShape);
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    @ExportMessage.Ignore
    public boolean equals(Object obj) {
        return obj != null && PFloat.class == obj.getClass() && this.value == ((PFloat)obj).getValue();
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return Double.toString(this.value);
    }

    public boolean isNative() {
        return this.getNativeWrapper() != null && this.getNativeWrapper().isNative();
    }

    public static PFloat create(PythonLanguage lang, double value) {
        return PFloat.create((Object)PythonBuiltinClassType.PFloat, PythonBuiltinClassType.PFloat.getInstanceShape(lang), value);
    }

    public static PFloat create(Object cls, Shape instanceShape, double value) {
        return new PFloat(cls, instanceShape, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString doubleToString(double item) {
        Object d = Double.toString(item);
        int exp = ((String)d).indexOf("E");
        if (exp != -1) {
            int l = ((String)d).length() - 1;
            if (exp == l - 2 && ((String)d).charAt(exp + 1) == '-') {
                d = Integer.valueOf("" + ((String)d).charAt(l)) == 4 ? Double.toString(item * 10.0).replace(".", ".0") : ((String)d).substring(0, l) + "0" + ((String)d).substring(l);
                exp = ((String)d).indexOf("E");
            }
            if (exp != -1 && ((String)d).charAt(exp + 1) != '-') {
                d = ((String)d).substring(0, exp + 1) + "+" + ((String)d).substring(exp + 1, l + 1);
            }
            d = ((String)d).toLowerCase();
        }
        return PythonUtils.toTruffleStringUncached((String)d);
    }

    @ExportMessage
    public boolean isNumber() {
        return true;
    }

    @ExportMessage
    boolean fitsInFloat(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInFloat((Object)this.value);
    }

    @ExportMessage
    float asFloat(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asFloat((Object)this.value);
    }

    @ExportMessage
    public boolean fitsInDouble() {
        return true;
    }

    @ExportMessage
    public double asDouble() {
        return this.getValue();
    }

    @ExportMessage
    boolean fitsInByte(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInByte((Object)this.value);
    }

    @ExportMessage
    byte asByte(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asByte((Object)this.value);
    }

    @ExportMessage
    boolean fitsInShort(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInShort((Object)this.value);
    }

    @ExportMessage
    short asShort(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asShort((Object)this.value);
    }

    @ExportMessage
    boolean fitsInInt(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInInt((Object)this.value);
    }

    @ExportMessage
    int asInt(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asInt((Object)this.value);
    }

    @ExportMessage
    boolean fitsInLong(@CachedLibrary(value="this.value") InteropLibrary interop) {
        return interop.fitsInLong((Object)this.value);
    }

    @ExportMessage
    long asLong(@CachedLibrary(value="this.value") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asLong((Object)this.value);
    }
}

