/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.StopIterationBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.util.SplitArgsNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.StopIteration})
public final class StopIterationBuiltins
extends PythonBuiltins {
    public static final BaseExceptionAttrNode.StorageFactory STOP_ITERATION_ATTR_FACTORY = (args, factory) -> new Object[]{args != null && args.length > 0 ? args[0] : PNone.NONE};

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StopIterationBuiltinsFactory.getFactories();
    }

    @Builtin(name="value", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="generator return value")
    @GenerateNodeFactory
    public static abstract class StopIterationValueNode
    extends PythonBinaryBuiltinNode {
        public final Object execute(PBaseException self) {
            return this.execute(null, self, PNone.NO_VALUE);
        }

        @Specialization
        static Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 0, STOP_ITERATION_ATTR_FACTORY);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class StopIterationInitNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private SplitArgsNode splitArgsNode;

        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            if (arguments.length == 0 || keywords.length != 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
            }
            if (this.splitArgsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.splitArgsNode = (SplitArgsNode)this.insert(SplitArgsNode.create());
            }
            Object[] argsWithoutSelf = this.splitArgsNode.executeCached(arguments);
            return this.execute(frame, arguments[0], argsWithoutSelf, keywords);
        }

        @Specialization
        static Object init(PBaseException self, Object[] args, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseExceptionInitNode) {
            baseExceptionInitNode.execute(self, args);
            self.setExceptionAttributes(STOP_ITERATION_ATTR_FACTORY.create(args, null));
            return PNone.NONE;
        }
    }
}

