/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.MultiprocessingModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.multiprocessing.MultiprocessingModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.multiprocessing.PSemLock;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_multiprocessing")
public class MultiprocessingModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultiprocessingModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="sem_unlink", parameterNames={"name"})
    @GenerateNodeFactory
    static abstract class SemUnlink
    extends PythonUnaryBuiltinNode {
        SemUnlink() {
        }

        @Specialization
        PNone doit(VirtualFrame frame, TruffleString name, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.semUnlink(posixSupport, posixLib.createPathFromString(posixSupport, name));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="SemLock", parameterNames={"$cls", "kind", "value", "maxvalue", "name", "unlink"}, constructsClass=PythonBuiltinClassType.PSemLock)
    @ArgumentsClinic(value={@ArgumentClinic(name="kind", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="value", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="maxvalue", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="unlink", conversion=ArgumentClinic.ClinicConversion.IntToBoolean)})
    @GenerateNodeFactory
    static abstract class SemLockNode
    extends PythonClinicBuiltinNode {
        SemLockNode() {
        }

        @Specialization
        static PSemLock construct(VirtualFrame frame, Object cls, int kind, int value, int maxValue, TruffleString name, boolean unlink, @Bind(value="this") Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Cached PythonObjectFactory factory, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            long handle;
            if (kind != 0 && kind != 1) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNRECOGNIZED_KIND);
            }
            Object posixName = posixLib.createPathFromString(posixSupport, name);
            try {
                handle = posixLib.semOpen(posixSupport, posixName, PosixConstants.O_CREAT.value | PosixConstants.O_EXCL.value, 384, value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            if (unlink) {
                try {
                    posixLib.semUnlink(posixSupport, posixName);
                }
                catch (PosixSupportLibrary.PosixException e) {
                    try {
                        posixLib.semClose(posixSupport, handle);
                    }
                    catch (PosixSupportLibrary.PosixException posixException) {
                        // empty catch block
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            return factory.createSemLock(cls, handle, kind, maxValue, name);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultiprocessingModuleBuiltinsClinicProviders.SemLockNodeClinicProviderGen.INSTANCE;
        }
    }
}

