/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.lib.PyContextCopyCurrent;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextContextBuiltins {

    static abstract class PyContext_Exit
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyContext_Exit() {
        }

        @Specialization
        static Object doGeneric(PContextVarsContext context, @Bind(value="this") Node inliningTarget) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext.PythonThreadState threadState = PyContext_Exit.getContext(inliningTarget).getThreadState(language);
            context.leave(threadState);
            return 0;
        }
    }

    static abstract class PyContext_Enter
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyContext_Enter() {
        }

        @Specialization
        static Object doGeneric(PContextVarsContext context, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext.PythonThreadState threadState = PyContext_Enter.getContext(inliningTarget).getThreadState(language);
            context.enter(inliningTarget, threadState, raiseNode);
            return 0;
        }
    }

    static abstract class PyContext_New
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyContext_New() {
        }

        @Specialization
        static Object doGeneric(@Cached PythonObjectFactory factory) {
            return factory.createContextVarsContext();
        }
    }

    static abstract class PyContext_Copy
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyContext_Copy() {
        }

        @Specialization
        static Object doGeneric(PContextVarsContext context, @Cached PythonObjectFactory factory) {
            return factory.copyContextVarsContext(context);
        }
    }

    static abstract class PyContext_CopyCurrent
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyContext_CopyCurrent() {
        }

        @Specialization
        static Object doGeneric(@Bind(value="this") Node inliningTarget, @Cached PyContextCopyCurrent copyCurrent) {
            return copyCurrent.execute(inliningTarget);
        }
    }

    static abstract class PyContextVar_Set
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyContextVar_Set() {
        }

        @Specialization
        static Object doGeneric(Object var, Object val, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (!(var instanceof PContextVar)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED);
            }
            PythonContext.PythonThreadState threadState = PythonContext.get(inliningTarget).getThreadState(PythonLanguage.get(inliningTarget));
            PContextVar pvar = (PContextVar)var;
            Object oldValue = pvar.getValue(threadState);
            pvar.setValue(threadState, val);
            return factory.createContextVarsToken(pvar, oldValue);
        }
    }

    static abstract class PyTruffleContextVar_Get
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleContextVar_Get() {
        }

        @Specialization
        Object doGeneric(Object var, Object def, Object marker, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.PRaiseNativeNode.Lazy raiseNative) {
            if (!(var instanceof PContextVar)) {
                return raiseNative.get(inliningTarget).raise(null, marker, PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED, new Object[0]);
            }
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            Object result = ((PContextVar)var).getValue(threadState);
            if (result == null) {
                result = def == PNone.NO_VALUE ? (((PContextVar)var).getDefault() == PContextVar.NO_DEFAULT ? PNone.NO_VALUE : ((PContextVar)var).getDefault()) : def;
            }
            return result;
        }
    }

    static abstract class PyContextVar_New
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyContextVar_New() {
        }

        @Specialization
        static Object doGeneric(TruffleString name, Object def, @Cached CallNode callContextvar) {
            return callContextvar.executeWithoutFrame((Object)PythonBuiltinClassType.ContextVar, name, def);
        }

        @Specialization
        static Object doGeneric(PNone name, Object def) {
            assert (name == PNone.NO_VALUE);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyTrufflePrintStacktrace
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTrufflePrintStacktrace() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object stacktrace() {
            ExceptionUtils.printPythonLikeStackTrace();
            return 0;
        }
    }
}

