/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallNonReversibleTernaryNodeGen;
import com.oracle.graal.python.nodes.call.special.LookupAndCallReversibleTernaryNodeGen;
import com.oracle.graal.python.nodes.call.special.LookupSpecialBaseNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={SpecialMethodNames.class, PythonOptions.class})
public abstract class LookupAndCallTernaryNode
extends Node {
    protected final TruffleString name;
    protected final SpecialMethodSlot slot;

    public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

    @NeverDefault
    public static LookupAndCallTernaryNode create(TruffleString name) {
        assert (SpecialMethodSlot.findSpecialSlotUncached(name) == null) : name;
        return LookupAndCallNonReversibleTernaryNodeGen.create(name);
    }

    @NeverDefault
    public static LookupAndCallTernaryNode create(SpecialMethodSlot slot) {
        return LookupAndCallNonReversibleTernaryNodeGen.create(slot);
    }

    @NeverDefault
    public static LookupAndCallTernaryNode createReversible(TruffleString name, Supplier<NotImplementedHandler> handlerFactory) {
        return LookupAndCallReversibleTernaryNodeGen.create(name, handlerFactory);
    }

    @NeverDefault
    public static LookupAndCallTernaryNode createReversible(SpecialMethodSlot slot, Supplier<NotImplementedHandler> handlerFactory) {
        return LookupAndCallReversibleTernaryNodeGen.create(slot, handlerFactory);
    }

    LookupAndCallTernaryNode(TruffleString name) {
        this.name = name;
        this.slot = null;
    }

    LookupAndCallTernaryNode(SpecialMethodSlot slot) {
        this.slot = slot;
        this.name = slot.getName();
    }

    @NeverDefault
    protected final LookupSpecialBaseNode createLookup() {
        if (this.slot != null) {
            return LookupSpecialMethodSlotNode.create(this.slot);
        }
        return LookupSpecialMethodNode.create(this.name);
    }

    public static abstract class NotImplementedHandler
    extends PNodeWithContext {
        public abstract Object execute(Object var1, Object var2, Object var3);
    }
}

