/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.charset;

import com.oracle.graal.python.charset.PythonUnicodeEscapeCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class PythonRawUnicodeEscapeCharsetDecoder
extends CharsetDecoder {
    private boolean seenBackslash = false;

    protected PythonRawUnicodeEscapeCharsetDecoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target) {
        while (source.hasRemaining()) {
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int initialPosition = source.position();
            byte b = source.get();
            if (this.seenBackslash) {
                --initialPosition;
                if (b == 117 || b == 85) {
                    CoderResult result = PythonUnicodeEscapeCharsetDecoder.decodeHexUnicodeEscape(source, target, b, initialPosition);
                    if (result != null) {
                        return result;
                    }
                    this.seenBackslash = false;
                    continue;
                }
                target.put('\\');
                this.seenBackslash = false;
                continue;
            }
            if (b == 92) {
                this.seenBackslash = true;
                continue;
            }
            target.put((char)(b & 0xFF));
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult implFlush(CharBuffer target) {
        if (this.seenBackslash) {
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            target.put('\\');
            this.seenBackslash = false;
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.seenBackslash = false;
    }
}

