/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WeakRefModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WeakRefModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cext.PythonCextTypeBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyObjectBuiltins;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodesFactory;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.IndexedSlotDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.superobject.SuperObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.MROMergeState;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupInheritedSlotNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.CastToListExpressionNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class TypeNodes {
    private static final int SIZEOF_PY_OBJECT_PTR = 8;

    private static long setFlags(long result, long flags) {
        if ((flags & 0x100000L) != 0L) {
            flags &= 0xFFFFFFFFFFEFFFFFL;
        }
        if ((result & 0x60L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFF9FL;
        }
        return (result |= flags & 0xFF400060L) | 0x1000L;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean compareSortedSlots(Object aSlots, Object bSlots) {
        int i;
        Object[] aArray = SequenceNodes.GetObjectArrayNode.executeUncached(aSlots);
        Object[] bArray = SequenceNodes.GetObjectArrayNode.executeUncached(bSlots);
        if (bArray.length != aArray.length) {
            return false;
        }
        aArray = Arrays.copyOf(aArray, aArray.length);
        bArray = Arrays.copyOf(bArray, bArray.length);
        for (i = 0; i < aArray.length; ++i) {
            try {
                aArray[i] = CastToTruffleStringNode.executeUncached(aArray[i]).toJavaStringUncached();
                bArray[i] = CastToTruffleStringNode.executeUncached(bArray[i]).toJavaStringUncached();
                continue;
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"slots are not strings");
            }
        }
        Arrays.sort(bArray);
        Arrays.sort(aArray);
        for (i = 0; i < aArray.length; ++i) {
            if (aArray[i].equals(bArray[i])) continue;
            return false;
        }
        return true;
    }

    @GenerateInline(inlineByDefault=true)
    @ImportStatic(value={SpecialMethodSlot.class})
    public static abstract class HasObjectInitNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2);

        public final boolean executeCached(Object type) {
            return this.execute(this, type);
        }

        @Specialization
        static boolean check(Node inliningTarget, Object type, @Cached(parameters={"Init"}, inline=false) LookupCallableSlotInMRONode lookup, @Cached CheckCallableIsSpecificBuiltinNode check) {
            Object slot = lookup.execute(type);
            return check.execute(inliningTarget, slot, ObjectBuiltinsFactory.InitNodeFactory.getInstance());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CheckCallableIsSpecificBuiltinNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2, NodeFactory<? extends PythonBuiltinBaseNode> var3);

        public static boolean executeUncached(Object methodOrDescriptor, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory) {
            return TypeNodesFactory.CheckCallableIsSpecificBuiltinNodeGen.getUncached().execute(null, methodOrDescriptor, nodeFactory);
        }

        @Specialization
        static boolean check(PBuiltinFunction function, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory) {
            return function.getBuiltinNodeFactory() == nodeFactory;
        }

        @Specialization
        static boolean check(PBuiltinMethod method, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory) {
            return method.getBuiltinFunction().getBuiltinNodeFactory() == nodeFactory;
        }

        @Specialization
        static boolean check(BuiltinMethodDescriptor descriptor, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory) {
            return descriptor.getFactory() == nodeFactory;
        }

        @Fallback
        static boolean check(Object descriptor, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory) {
            return false;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialMethodSlot.class})
    public static abstract class HasSameConstructorNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2, Object var3);

        @Specialization
        static boolean doGeneric(Node inliningTarget, Object left, Object right, @Cached(parameters={"New"}, inline=false) LookupCallableSlotInMRONode lookupLeftNode, @Cached(parameters={"New"}, inline=false) LookupCallableSlotInMRONode lookupRightNode, @Cached InlinedExactClassProfile leftNewProfile, @Cached InlinedExactClassProfile rightNewProfile) {
            assert (IsTypeNode.executeUncached(left));
            assert (IsTypeNode.executeUncached(right));
            Object leftNew = leftNewProfile.profile(inliningTarget, lookupLeftNode.execute(left));
            Object rightNew = rightNewProfile.profile(inliningTarget, lookupRightNode.execute(right));
            return HasSameConstructorNode.isSameFunction(leftNew, rightNew);
        }

        static boolean isSameFunction(Object leftFunc, Object rightFunc) {
            PBuiltinFunction builtinFunction;
            Object baseDecorated;
            PBuiltinFunction builtinFunction2;
            Object typeDecorated;
            Object leftResolved = leftFunc;
            if (leftFunc instanceof PBuiltinFunction && (typeDecorated = GraalHPyObjectBuiltins.HPyObjectNewNode.getDecoratedSuperConstructor(builtinFunction2 = (PBuiltinFunction)leftFunc)) != null) {
                leftResolved = typeDecorated;
            }
            Object rightResolved = rightFunc;
            if (rightFunc instanceof PBuiltinFunction && (baseDecorated = GraalHPyObjectBuiltins.HPyObjectNewNode.getDecoratedSuperConstructor(builtinFunction = (PBuiltinFunction)rightFunc)) != null) {
                rightResolved = baseDecorated;
            }
            return leftResolved == rightResolved;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class NeedsNativeAllocationNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2);

        public static boolean executeUncached(Object cls) {
            return TypeNodesFactory.NeedsNativeAllocationNodeGen.getUncached().execute(null, cls);
        }

        @Specialization
        static boolean doPBCT(PythonBuiltinClassType cls) {
            return false;
        }

        @Specialization
        static boolean doBuiltin(PythonBuiltinClass cls) {
            return false;
        }

        @Specialization
        static boolean doManaged(PythonManagedClass cls) {
            return cls.needsNativeAllocation();
        }

        @Specialization
        static boolean doNative(PythonNativeClass cls) {
            return true;
        }

        @Fallback
        static boolean doOther(Object cls) {
            return false;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetWeakListOffsetNode
    extends Node {
        public abstract void execute(Node var1, PythonManagedClass var2, long var3);

        public static void executeUncached(PythonManagedClass cls, long value) {
            TypeNodesFactory.SetWeakListOffsetNodeGen.getUncached().execute(null, cls, value);
        }

        @Specialization
        static void set(Node inliningTarget, PythonManagedClass cls, long value, @Cached HiddenAttr.WriteNode write) {
            write.execute(inliningTarget, cls, HiddenAttr.WEAKLISTOFFSET, value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetWeakListOffsetNode
    extends Node {
        public abstract long execute(Node var1, Object var2);

        public static long executeUncached(Object cls) {
            return TypeNodesFactory.GetWeakListOffsetNodeGen.getUncached().execute(null, cls);
        }

        @Specialization
        static long lookup(Object cls, @Cached(inline=false) CExtNodes.LookupNativeI64MemberFromBaseNode lookup) {
            return lookup.execute(cls, CFields.PyTypeObject__tp_weaklistoffset, HiddenAttr.WEAKLISTOFFSET, PythonBuiltinClassType::getWeaklistoffset);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetDictOffsetNode
    extends Node {
        public abstract void execute(Node var1, PythonManagedClass var2, long var3);

        public static void executeUncached(PythonManagedClass cls, long value) {
            TypeNodesFactory.SetDictOffsetNodeGen.getUncached().execute(null, cls, value);
        }

        @Specialization
        static void set(Node inliningTarget, PythonManagedClass cls, long value, @Cached HiddenAttr.WriteNode write) {
            write.execute(inliningTarget, cls, HiddenAttr.DICTOFFSET, value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetDictOffsetNode
    extends Node {
        private static final long MANAGED_DICT_OFFSET = -8L;

        public abstract long execute(Node var1, Object var2);

        public static long executeUncached(Object cls) {
            return TypeNodesFactory.GetDictOffsetNodeGen.getUncached().execute(null, cls);
        }

        @Specialization
        static long lookup(Object cls, @Cached(inline=false) GetTypeFlagsNode getTypeFlagsNode, @Cached(inline=false) CExtNodes.LookupNativeI64MemberFromBaseNode lookup) {
            long result = lookup.execute(cls, CFields.PyTypeObject__tp_dictoffset, HiddenAttr.DICTOFFSET, GetDictOffsetNode::getBuiltinDictoffset);
            if (result == 0L && (getTypeFlagsNode.execute(cls) & 0x10L) != 0L) {
                return -8L;
            }
            return result;
        }

        private static int getBuiltinDictoffset(PythonBuiltinClassType cls) {
            if (!cls.isBuiltinWithDict()) {
                return 0;
            }
            return switch (cls) {
                case PythonBuiltinClassType.PythonModule, PythonBuiltinClassType.PBaseException -> 16;
                case PythonBuiltinClassType.PythonClass -> 264;
                default -> cls.getBase() != null ? GetDictOffsetNode.getBuiltinDictoffset(cls.getBase()) : 0;
            };
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetItemSizeNode
    extends Node {
        public abstract void execute(Node var1, PythonManagedClass var2, long var3);

        public static void executeUncached(PythonManagedClass cls, long value) {
            TypeNodesFactory.SetItemSizeNodeGen.getUncached().execute(null, cls, value);
        }

        @Specialization
        static void set(Node inliningTarget, PythonManagedClass cls, long value, @Cached HiddenAttr.WriteNode write) {
            write.execute(inliningTarget, cls, HiddenAttr.ITEMSIZE, value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetItemSizeNode
    extends Node {
        public abstract long execute(Node var1, Object var2);

        public static long executeUncached(Object cls) {
            return TypeNodesFactory.GetItemSizeNodeGen.getUncached().execute(null, cls);
        }

        @Specialization
        static long lookup(Object cls, @Cached(inline=false) CExtNodes.LookupNativeI64MemberFromBaseNode lookup) {
            return lookup.execute(cls, CFields.PyTypeObject__tp_itemsize, HiddenAttr.ITEMSIZE, GetItemSizeNode::getBuiltinTypeItemsize);
        }

        private static int getBuiltinTypeItemsize(PythonBuiltinClassType cls) {
            return switch (cls) {
                case PythonBuiltinClassType.PBytes -> 1;
                case PythonBuiltinClassType.PInt -> 4;
                case PythonBuiltinClassType.DictRemover, PythonBuiltinClassType.StructParam, PythonBuiltinClassType.CArgObject, PythonBuiltinClassType.StgDict, PythonBuiltinClassType.PyCData, PythonBuiltinClassType.PyCArray, PythonBuiltinClassType.PyCPointer, PythonBuiltinClassType.PyCFuncPtr, PythonBuiltinClassType.Structure, PythonBuiltinClassType.Union, PythonBuiltinClassType.SimpleCData, PythonBuiltinClassType.PFrame, PythonBuiltinClassType.CField, PythonBuiltinClassType.CThunkObject, PythonBuiltinClassType.PMemoryView, PythonBuiltinClassType.PTuple, PythonBuiltinClassType.PStatResult, PythonBuiltinClassType.PTerminalSize, PythonBuiltinClassType.PUnameResult, PythonBuiltinClassType.PStructTime, PythonBuiltinClassType.PProfilerEntry, PythonBuiltinClassType.PProfilerSubentry, PythonBuiltinClassType.PStructPasswd, PythonBuiltinClassType.PStructRusage, PythonBuiltinClassType.PVersionInfo, PythonBuiltinClassType.PFlags, PythonBuiltinClassType.PFloatInfo, PythonBuiltinClassType.PIntInfo, PythonBuiltinClassType.PHashInfo, PythonBuiltinClassType.PThreadInfo, PythonBuiltinClassType.PUnraisableHookArgs, PythonBuiltinClassType.PIOBase, PythonBuiltinClassType.PFileIO, PythonBuiltinClassType.PBufferedIOBase, PythonBuiltinClassType.PBufferedReader, PythonBuiltinClassType.PBufferedWriter, PythonBuiltinClassType.PBufferedRWPair, PythonBuiltinClassType.PBufferedRandom, PythonBuiltinClassType.PIncrementalNewlineDecoder, PythonBuiltinClassType.PTextIOWrapper, PythonBuiltinClassType.PWindowsVersion -> 8;
                case PythonBuiltinClassType.PythonClass -> 40;
                default -> 0;
            };
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetBasicSizeNode
    extends Node {
        public abstract void execute(Node var1, PythonManagedClass var2, long var3);

        public static void executeUncached(PythonManagedClass cls, long value) {
            TypeNodesFactory.SetBasicSizeNodeGen.getUncached().execute(null, cls, value);
        }

        @Specialization
        static void set(Node inliningTarget, PythonManagedClass cls, long value, @Cached HiddenAttr.WriteNode write) {
            write.execute(inliningTarget, cls, HiddenAttr.BASICSIZE, value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetBasicSizeNode
    extends Node {
        public abstract long execute(Node var1, Object var2);

        public static long executeUncached(Object cls) {
            return TypeNodesFactory.GetBasicSizeNodeGen.getUncached().execute(null, cls);
        }

        @Specialization
        long lookup(Object cls, @Cached CExtNodes.LookupNativeI64MemberFromBaseNode lookup) {
            return lookup.execute(cls, CFields.PyTypeObject__tp_basicsize, HiddenAttr.BASICSIZE);
        }
    }

    @ImportStatic(value={SpecialMethodNames.class, SpecialAttributeNames.class, SpecialMethodSlot.class})
    @GenerateInline(value=false)
    protected static abstract class AllocateTypeWithMetaclassNode
    extends Node {
        protected AllocateTypeWithMetaclassNode() {
        }

        public abstract PythonClass execute(VirtualFrame var1, TruffleString var2, PTuple var3, PDict var4, Object var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PythonClass typeMetaclass(VirtualFrame frame, TruffleString name, PTuple bases, PDict namespace, Object metaclass, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached HashingStorageNodes.HashingStorageGetItem getHashingStorageItem, @Cached HashingStorageNodes.HashingStorageSetItemWithHash setHashingStorageItem, @Cached GetOrCreateDictNode getOrCreateDictNode, @Cached HashingStorageNodes.HashingStorageGetIterator getHashingStorageIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext hashingStorageItNext, @Cached HashingStorageNodes.HashingStorageIteratorKey hashingStorageItKey, @Cached HashingStorageNodes.HashingStorageIteratorKeyHash hashingStorageItKeyHash, @Cached HashingStorageNodes.HashingStorageIteratorValue hashingStorageItValue, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached InstancesOfTypeHaveDictNode hasDictNode, @Cached InstancesOfTypeHaveWeakrefsNode hasWeakrefsNode, @Cached GetBestBaseClassNode getBestBaseNode, @Cached GetIndexedSlotsCountNode getIndexedSlotsCountNode, @Cached StringBuiltins.IsIdentifierNode isIdentifier, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raise, @Cached SequenceNodes.GetObjectArrayNode getObjectArray, @Cached PythonObjectFactory factory, @Cached CastToListExpressionNode.CastToListNode castToListNode, @Cached PyUnicodeCheckNode stringCheck, @Cached TruffleString.IsValidNode isValidNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.EqualNode equalNode, @Cached CastToTruffleStringNode castToStringNode, @Cached GetItemSizeNode getItemSize) {
            Object eqMethod;
            PythonAbstractClass[] basesArray;
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            Python3Core core = context.getCore();
            TypeNewContext ctx = new TypeNewContext();
            Object[] array = getObjectArray.execute(inliningTarget, bases);
            if (array.length == 0) {
                basesArray = new PythonAbstractClass[]{core.lookupType(PythonBuiltinClassType.PythonObject)};
            } else {
                basesArray = new PythonAbstractClass[array.length];
                for (int i = 0; i < array.length; ++i) {
                    if (PythonAbstractClass.isInstance(array[i])) {
                        basesArray[i] = (PythonAbstractClass)array[i];
                        continue;
                    }
                    if (array[i] instanceof PythonBuiltinClassType) {
                        basesArray[i] = core.lookupType((PythonBuiltinClassType)((Object)array[i]));
                        continue;
                    }
                    throw raise.raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.CREATING_CLASS_NON_CLS_BASES);
                }
            }
            PythonAbstractClass base = getBestBaseNode.execute(inliningTarget, basesArray);
            assert (metaclass != null);
            if (!isValidNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING)) {
                throw constructAndRaiseNode.get(inliningTarget).raiseUnicodeEncodeError((Frame)frame, "utf-8", name, 0, codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING), "can't encode class name");
            }
            if (indexOfCodePointNode.execute((AbstractTruffleString)name, 0, 0, codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0) {
                throw raise.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TYPE_NAME_NO_NULL_CHARS);
            }
            PythonClass pythonClass = factory.createPythonClass(metaclass, name, false, base, basesArray);
            assert (SpecialMethodSlot.replaceInitializedTypeTop(pythonClass));
            AllocateTypeWithMetaclassNode.copyDictSlots(frame, inliningTarget, ctx, pythonClass, namespace, setHashingStorageItem, getHashingStorageIterator, hashingStorageItNext, hashingStorageItKey, hashingStorageItKeyHash, hashingStorageItValue, constructAndRaiseNode, factory, raise, isValidNode, equalNode, codePointLengthNode, getOrCreateDictNode, stringCheck, castToStringNode);
            if (!ctx.qualnameSet) {
                pythonClass.setQualName(name);
            }
            pythonClass.invokeMro();
            HashingStorage namespaceStorage = namespace.getDictStorage();
            Object hashMethod = getHashingStorageItem.execute((Frame)frame, inliningTarget, namespaceStorage, SpecialMethodNames.T___HASH__);
            if (hashMethod == null && (eqMethod = getHashingStorageItem.execute((Frame)frame, inliningTarget, namespaceStorage, SpecialMethodNames.T___EQ__)) != null) {
                pythonClass.setAttribute(SpecialMethodNames.T___HASH__, PNone.NONE);
            }
            ctx.mayAddDict = !hasDictNode.execute(base);
            boolean hasItemSize = getItemSize.execute(inliningTarget, base) != 0L;
            boolean bl = ctx.mayAddWeak = !hasWeakrefsNode.execute(inliningTarget, base) && !hasItemSize;
            if (ctx.slotsObject == null) {
                if (ctx.mayAddDict) {
                    ctx.addDict = true;
                }
                if (ctx.mayAddWeak) {
                    ctx.addWeak = true;
                }
            } else {
                SequenceStorage slotsStorage;
                Object slotsObject = ctx.slotsObject;
                if (stringCheck.execute(inliningTarget, ctx.slotsObject)) {
                    slotsStorage = new ObjectSequenceStorage(new Object[]{castToStringNode.execute(inliningTarget, ctx.slotsObject)});
                } else {
                    Object object = ctx.slotsObject;
                    if (object instanceof PTuple) {
                        PTuple slotsTuple = (PTuple)object;
                        slotsStorage = slotsTuple.getSequenceStorage();
                    } else {
                        object = ctx.slotsObject;
                        if (object instanceof PList) {
                            PList slotsList = (PList)object;
                            slotsStorage = slotsList.getSequenceStorage();
                        } else {
                            PList slotsList = castToListNode.execute(frame, ctx.slotsObject);
                            slotsObject = slotsList;
                            slotsStorage = slotsList.getSequenceStorage();
                        }
                    }
                }
                int slotlen = slotsStorage.length();
                if (slotlen > 0 && hasItemSize) {
                    throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.NONEMPTY_SLOTS_NOT_ALLOWED_FOR_SUBTYPE_OF_S, base);
                }
                for (int i = 0; i < slotlen; ++i) {
                    TruffleString slotName;
                    Object element = getItemNode.execute(inliningTarget, slotsStorage, i);
                    if (stringCheck.execute(inliningTarget, element)) {
                        slotName = castToStringNode.execute(inliningTarget, element);
                        if (!((Boolean)isIdentifier.execute(frame, slotName)).booleanValue()) {
                            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.SLOTS_MUST_BE_IDENTIFIERS);
                        }
                    } else {
                        throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STRINGS_NOT_P, "__slots__ items", element);
                    }
                    if (equalNode.execute((AbstractTruffleString)slotName, (AbstractTruffleString)SpecialAttributeNames.T___DICT__, PythonUtils.TS_ENCODING)) {
                        if (!ctx.mayAddDict || ctx.addDict) {
                            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DICT_SLOT_DISALLOWED_WE_GOT_ONE);
                        }
                        ctx.addDict = true;
                        AllocateTypeWithMetaclassNode.addDictDescrAttribute(basesArray, pythonClass, factory);
                        continue;
                    }
                    if (!equalNode.execute((AbstractTruffleString)slotName, (AbstractTruffleString)SpecialAttributeNames.T___WEAKREF__, PythonUtils.TS_ENCODING)) continue;
                    if (!ctx.mayAddWeak || ctx.addWeak) {
                        throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.WEAKREF_SLOT_DISALLOWED_WE_GOT_ONE);
                    }
                    ctx.addWeak = true;
                }
                Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
                try {
                    pythonClass.setAttribute(SpecialAttributeNames.T___SLOTS__, slotsObject);
                    ctx.copiedSlots = AllocateTypeWithMetaclassNode.copySlots(inliningTarget, ctx, name, slotsStorage, slotlen, namespace);
                }
                finally {
                    ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
                }
                AllocateTypeWithMetaclassNode.typeNewSlotBases(ctx, base, basesArray);
            }
            int indexedSlotCount = getIndexedSlotsCountNode.execute(inliningTarget, base);
            if (ctx.copiedSlots != null) {
                for (TruffleString slotName : ctx.copiedSlots) {
                    IndexedSlotDescriptor slotDesc = factory.createIndexedSlotDescriptor(slotName, indexedSlotCount++, pythonClass);
                    pythonClass.setAttribute(slotName, slotDesc);
                }
            }
            pythonClass.setIndexedSlotCount(indexedSlotCount);
            if (ctx.addDict) {
                AllocateTypeWithMetaclassNode.addDictDescrAttribute(basesArray, pythonClass, factory);
            } else if (ctx.mayAddDict) {
                pythonClass.setHasSlotsButNoDictFlag();
            }
            if (ctx.addWeak) {
                AllocateTypeWithMetaclassNode.addWeakrefDescrAttribute(pythonClass, factory);
            }
            if (pythonClass.needsNativeAllocation()) {
                AllocateTypeWithMetaclassNode.addNativeSlots(ctx, pythonClass, base);
            }
            return pythonClass;
        }

        private static void typeNewSlotBases(TypeNewContext ctx, Object primaryBase, PythonAbstractClass[] basesArray) {
            if (basesArray.length > 1 && (ctx.mayAddDict && !ctx.addDict || ctx.mayAddWeak && !ctx.addWeak)) {
                for (PythonAbstractClass base : basesArray) {
                    if (base == primaryBase) continue;
                    if (ctx.mayAddDict && !ctx.addDict && InstancesOfTypeHaveDictNode.executeUncached(base)) {
                        ctx.addDict = true;
                    }
                    if (ctx.mayAddWeak && !ctx.addWeak && InstancesOfTypeHaveWeakrefsNode.executeUncached(base)) {
                        ctx.addWeak = true;
                    }
                    if (!(ctx.mayAddDict && !ctx.addDict || ctx.mayAddWeak && !ctx.addWeak)) break;
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void addDictDescrAttribute(PythonAbstractClass[] basesArray, PythonClass pythonClass, PythonObjectFactory factory) {
            if (!AllocateTypeWithMetaclassNode.hasPythonClassBases(basesArray) && LookupAttributeInMRONode.lookupSlowPath(pythonClass, SpecialAttributeNames.T___DICT__) == PNone.NO_VALUE || AllocateTypeWithMetaclassNode.basesHaveSlots(basesArray)) {
                Builtin dictBuiltin = ObjectBuiltins.DictNode.class.getAnnotation(Builtin.class);
                RootCallTarget callTarget = PythonLanguage.get(null).createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), dictBuiltin, (NodeFactory<? extends PythonBuiltinBaseNode>)ObjectBuiltinsFactory.DictNodeFactory.getInstance(), true), ObjectBuiltins.DictNode.class);
                AllocateTypeWithMetaclassNode.setAttribute(SpecialAttributeNames.T___DICT__, dictBuiltin, callTarget, pythonClass, factory);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void addWeakrefDescrAttribute(PythonClass pythonClass, PythonObjectFactory factory) {
            if (LookupAttributeInMRONode.lookupSlowPath(pythonClass, SpecialAttributeNames.T___WEAKREF__) == PNone.NO_VALUE) {
                Builtin builtin = WeakRefModuleBuiltins.GetWeakRefsNode.class.getAnnotation(Builtin.class);
                RootCallTarget callTarget = PythonLanguage.get(null).createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)WeakRefModuleBuiltinsFactory.GetWeakRefsNodeFactory.getInstance(), true), WeakRefModuleBuiltins.GetWeakRefsNode.class);
                AllocateTypeWithMetaclassNode.setAttribute(SpecialAttributeNames.T___WEAKREF__, builtin, callTarget, pythonClass, factory);
            }
        }

        private static void setAttribute(TruffleString name, Builtin builtin, RootCallTarget callTarget, PythonClass pythonClass, PythonObjectFactory factory) {
            int flags = PBuiltinFunction.getFlags(builtin, callTarget);
            PBuiltinFunction function = factory.createBuiltinFunction(name, pythonClass, 1, flags, callTarget);
            GetSetDescriptor desc = factory.createGetSetDescriptor(function, function, name, pythonClass, true);
            pythonClass.setAttribute(name, desc);
        }

        private static boolean basesHaveSlots(PythonAbstractClass[] basesArray) {
            for (PythonAbstractClass c : basesArray) {
                if (!(c instanceof PythonClass) || ((PythonClass)c).getAttribute(SpecialAttributeNames.T___SLOTS__) == PNone.NO_VALUE) continue;
                return true;
            }
            return false;
        }

        private static boolean hasPythonClassBases(PythonAbstractClass[] basesArray) {
            for (PythonAbstractClass c : basesArray) {
                if (!(c instanceof PythonClass)) continue;
                return true;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private static void addNativeSlots(TypeNewContext ctx, PythonManagedClass pythonClass, Object base) {
            long slotOffset = GetBasicSizeNode.executeUncached(base);
            if (ctx.copiedSlots != null && ctx.copiedSlots.length != 0) {
                if (slotOffset == 0L) {
                    throw CompilerDirectives.shouldNotReachHere((String)"tp_basicsize not set on a type");
                }
                slotOffset = AllocateTypeWithMetaclassNode.installMemberDescriptors(pythonClass, ctx.copiedSlots, slotOffset);
            }
            long dictOffset = GetDictOffsetNode.executeUncached(base);
            long weakListOffset = GetWeakListOffsetNode.executeUncached(base);
            long itemSize = GetItemSizeNode.executeUncached(base);
            if (ctx.addDict && itemSize != 0L) {
                dictOffset = -8L;
                slotOffset += 8L;
            }
            if (ctx.addWeak) {
                weakListOffset = slotOffset;
                slotOffset += 8L;
            }
            if (ctx.addDict && itemSize == 0L) {
                long flags = GetTypeFlagsNode.executeUncached(pythonClass) | 0x10L;
                SetTypeFlagsNode.executeUncached(pythonClass, flags);
                dictOffset = -slotOffset - 8L;
            }
            SetDictOffsetNode.executeUncached(pythonClass, dictOffset);
            SetBasicSizeNode.executeUncached(pythonClass, slotOffset);
            SetItemSizeNode.executeUncached(pythonClass, itemSize);
            SetWeakListOffsetNode.executeUncached(pythonClass, weakListOffset);
        }

        @CompilerDirectives.TruffleBoundary
        private static long installMemberDescriptors(PythonManagedClass pythonClass, TruffleString[] slotNames, long slotOffset) {
            PDict typeDict = GetOrCreateDictNode.executeUncached(pythonClass);
            for (TruffleString slotName : slotNames) {
                PythonCextTypeBuiltins.PyTruffleType_AddMember.addMember(pythonClass, typeDict, slotName, 16, slotOffset, 1, PNone.NO_VALUE);
                slotOffset += 8L;
            }
            return slotOffset;
        }

        private static void copyDictSlots(VirtualFrame frame, Node inliningTarget, TypeNewContext ctx, PythonClass pythonClass, PDict namespace, HashingStorageNodes.HashingStorageSetItemWithHash setHashingStorageItem, HashingStorageNodes.HashingStorageGetIterator getHashingStorageIterator, HashingStorageNodes.HashingStorageIteratorNext hashingStorageItNext, HashingStorageNodes.HashingStorageIteratorKey hashingStorageItKey, HashingStorageNodes.HashingStorageIteratorKeyHash hashingStorageItKeyHash, HashingStorageNodes.HashingStorageIteratorValue hashingStorageItValue, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PythonObjectFactory factory, PRaiseNode raise, TruffleString.IsValidNode isValidNode, TruffleString.EqualNode equalNode, TruffleString.CodePointLengthNode codePointLengthNode, GetOrCreateDictNode getOrCreateDictNode, PyUnicodeCheckNode stringCheck, CastToTruffleStringNode castToStringNode) {
            PDict typeDict = null;
            HashingStorage namespaceStorage = namespace.getDictStorage();
            HashingStorageNodes.HashingStorageIterator it = getHashingStorageIterator.execute(inliningTarget, namespaceStorage);
            while (hashingStorageItNext.execute(inliningTarget, namespaceStorage, it)) {
                Object keyObj = hashingStorageItKey.execute(inliningTarget, namespaceStorage, it);
                Object value = hashingStorageItValue.execute(inliningTarget, namespaceStorage, it);
                if (stringCheck.execute(inliningTarget, keyObj)) {
                    TruffleString key = castToStringNode.execute(inliningTarget, keyObj);
                    if (equalNode.execute((AbstractTruffleString)SpecialAttributeNames.T___SLOTS__, (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) {
                        ctx.slotsObject = value;
                        continue;
                    }
                    if (equalNode.execute((AbstractTruffleString)SpecialMethodNames.T___NEW__, (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) {
                        if (value instanceof PFunction) {
                            pythonClass.setAttribute(key, factory.createStaticmethodFromCallableObj(value));
                            continue;
                        }
                        pythonClass.setAttribute(key, value);
                        continue;
                    }
                    if (equalNode.execute((AbstractTruffleString)SpecialMethodNames.T___INIT_SUBCLASS__, (AbstractTruffleString)key, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)SpecialMethodNames.T___CLASS_GETITEM__, (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) {
                        if (value instanceof PFunction) {
                            pythonClass.setAttribute(key, factory.createClassmethodFromCallableObj(value));
                            continue;
                        }
                        pythonClass.setAttribute(key, value);
                        continue;
                    }
                    if (equalNode.execute((AbstractTruffleString)SpecialAttributeNames.T___DOC__, (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) {
                        try {
                            TruffleString doc = castToStringNode.execute(inliningTarget, value);
                            if (!isValidNode.execute((AbstractTruffleString)doc, PythonUtils.TS_ENCODING)) {
                                throw constructAndRaiseNode.get(inliningTarget).raiseUnicodeEncodeError((Frame)frame, "utf-8", doc, 0, codePointLengthNode.execute((AbstractTruffleString)doc, PythonUtils.TS_ENCODING), "can't encode docstring");
                            }
                        }
                        catch (CannotCastException doc) {
                            // empty catch block
                        }
                        pythonClass.setAttribute(key, value);
                        continue;
                    }
                    if (equalNode.execute((AbstractTruffleString)SpecialAttributeNames.T___QUALNAME__, (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) {
                        try {
                            pythonClass.setQualName(castToStringNode.execute(inliningTarget, value));
                            ctx.qualnameSet = true;
                            continue;
                        }
                        catch (CannotCastException e) {
                            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_S_NOT_P, "type __qualname__", "str", value);
                        }
                    }
                    if (equalNode.execute((AbstractTruffleString)SpecialAttributeNames.T___CLASSCELL__, (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) continue;
                    if (typeDict == null && keyObj instanceof TruffleString) {
                        pythonClass.setAttribute(key, value);
                        continue;
                    }
                }
                typeDict = getOrCreateDictNode.execute(inliningTarget, pythonClass);
                long keyHash = hashingStorageItKeyHash.execute((Frame)frame, inliningTarget, namespaceStorage, it);
                HashingStorage updatedStore = setHashingStorageItem.execute((Frame)frame, inliningTarget, typeDict.getDictStorage(), keyObj, keyHash, value);
                typeDict.setDictStorage(updatedStore);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString[] copySlots(Node inliningTarget, TypeNewContext ctx, TruffleString className, SequenceStorage slotList, int slotlen, PDict namespace) {
            int nslots = slotlen - PInt.intValue(ctx.addDict) - PInt.intValue(ctx.addWeak);
            TruffleString[] newSlots = new TruffleString[nslots];
            int j = 0;
            for (int i = 0; i < slotlen; ++i) {
                TruffleString slotName = CastToTruffleStringNode.executeUncached(SequenceStorageNodes.GetItemScalarNode.executeUncached(slotList, i));
                if (ctx.addDict && SpecialAttributeNames.T___DICT__.equalsUncached((AbstractTruffleString)slotName, PythonUtils.TS_ENCODING) || ctx.addWeak && SpecialAttributeNames.T___WEAKREF__.equalsUncached((AbstractTruffleString)slotName, PythonUtils.TS_ENCODING)) continue;
                try {
                    slotName = PythonUtils.mangleName(className, slotName);
                }
                catch (OutOfMemoryError e) {
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.PRIVATE_IDENTIFIER_TOO_LARGE_TO_BE_MANGLED);
                }
                if (slotName == null) {
                    return null;
                }
                newSlots[j] = slotName;
                if (!SpecialAttributeNames.T___CLASSCELL__.equalsUncached((AbstractTruffleString)slotName, PythonUtils.TS_ENCODING) && !SpecialAttributeNames.T___QUALNAME__.equalsUncached((AbstractTruffleString)slotName, PythonUtils.TS_ENCODING) && HashingStorageNodes.HashingStorageGetItem.hasKeyUncached(namespace.getDictStorage(), slotName)) {
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_S_CONFLICTS_WITH_CLASS_VARIABLE, slotName, "__slots__");
                }
                ++j;
            }
            assert (j == nslots);
            Arrays.sort(newSlots, StringUtils::compareStringsUncached);
            return newSlots;
        }

        @CompilerDirectives.ValueType
        private static class TypeNewContext {
            boolean addDict;
            boolean addWeak;
            boolean mayAddDict;
            boolean mayAddWeak;
            Object slotsObject;
            TruffleString[] copiedSlots;
            boolean qualnameSet;

            private TypeNewContext() {
            }
        }
    }

    @ImportStatic(value={SpecialMethodNames.class, SpecialAttributeNames.class, SpecialMethodSlot.class})
    public static abstract class CreateTypeNode
    extends Node {
        @Node.Child
        private ReadAttributeFromObjectNode readAttrNode;
        @Node.Child
        private ReadCallerFrameNode readCallerFrameNode;
        @Node.Child
        private CastToTruffleStringNode castToStringNode;

        public abstract PythonClass execute(VirtualFrame var1, PDict var2, TruffleString var3, PTuple var4, Object var5, PKeyword[] var6);

        private ReadAttributeFromObjectNode ensureReadAttrNode() {
            if (this.readAttrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readAttrNode = (ReadAttributeFromObjectNode)this.insert(ReadAttributeFromObjectNode.create());
            }
            return this.readAttrNode;
        }

        private ReadCallerFrameNode getReadCallerFrameNode() {
            if (this.readCallerFrameNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readCallerFrameNode = (ReadCallerFrameNode)this.insert(ReadCallerFrameNode.create());
            }
            return this.readCallerFrameNode;
        }

        private CastToTruffleStringNode ensureCastToStringNode() {
            if (this.castToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.castToStringNode = (CastToTruffleStringNode)this.insert(CastToTruffleStringNode.create());
            }
            return this.castToStringNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected PythonClass makeType(VirtualFrame frame, PDict namespaceOrig, TruffleString name, PTuple bases, Object metaclass, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached HashingStorage.InitNode initNode, @Cached HashingStorageNodes.HashingStorageGetItem getItemGlobals, @Cached HashingStorageNodes.HashingStorageGetItem getItemNamespace, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext itNext, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageIteratorValue itValue, @Cached HashingStorageNodes.HashingStorageDelItem delItemNamespace, @Cached(value="create(SetName)") LookupInheritedSlotNode getSetNameNode, @Cached CallNode callSetNameNode, @Cached CallNode callInitSubclassNode, @Cached(value="create(T___INIT_SUBCLASS__)") GetAttributeNode getInitSubclassNode, @Cached GetMroStorageNode getMroStorageNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode raise, @Cached AllocateTypeWithMetaclassNode typeMetaclass) {
            try {
                Object classcell;
                TruffleString moduleName;
                PFrame callerFrame;
                PythonObject globals;
                assert (SpecialMethodSlot.pushInitializedTypePlaceholder());
                PDict namespace = factory.createDict();
                PythonLanguage language = PythonLanguage.get(this);
                namespace.setDictStorage(initNode.execute(frame, namespaceOrig, PKeyword.EMPTY_KEYWORDS));
                PythonClass newType = typeMetaclass.execute(frame, name, bases, namespace, metaclass);
                Object moduleAttr = this.ensureReadAttrNode().execute(newType, SpecialAttributeNames.T___MODULE__);
                if (moduleAttr == PNone.NO_VALUE && (globals = this.getRootNode() instanceof BuiltinFunctionRootNode ? ((callerFrame = this.getReadCallerFrameNode().executeWith(frame, 0)) != null ? callerFrame.getGlobals() : null) : PArguments.getGlobals((Frame)frame)) != null && (moduleName = this.getModuleNameFromGlobals(inliningTarget, globals, getItemGlobals)) != null) {
                    newType.setAttribute(SpecialAttributeNames.T___MODULE__, moduleName);
                }
                delItemNamespace.execute(inliningTarget, namespace.getDictStorage(), SpecialAttributeNames.T___QUALNAME__, namespace);
                if (newType.getAttribute(SpecialAttributeNames.T___DOC__) == PNone.NO_VALUE) {
                    newType.setAttribute(SpecialAttributeNames.T___DOC__, PNone.NONE);
                }
                if ((classcell = getItemNamespace.execute(inliningTarget, namespace.getDictStorage(), SpecialAttributeNames.T___CLASSCELL__)) != null) {
                    if (!(classcell instanceof PCell)) {
                        throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_A_CELL, "__classcell__");
                    }
                    ((PCell)classcell).setRef(newType);
                    delItemNamespace.execute(inliningTarget, namespace.getDictStorage(), SpecialAttributeNames.T___CLASSCELL__, namespace);
                }
                SpecialMethodSlot.initializeSpecialMethodSlots(newType, getMroStorageNode.execute(inliningTarget, newType), language);
                TpSlots.inherit(newType, getMroStorageNode.execute(inliningTarget, newType), true);
                TpSlots.fixupSlotDispatchers(newType);
                HashingStorage storage = namespace.getDictStorage();
                HashingStorageNodes.HashingStorageIterator it = getIterator.execute(inliningTarget, storage);
                while (itNext.execute(inliningTarget, storage, it)) {
                    Object value = itValue.execute(inliningTarget, storage, it);
                    Object setName = getSetNameNode.execute(value);
                    if (setName == PNone.NO_VALUE) continue;
                    Object key = itKey.execute(inliningTarget, storage, it);
                    try {
                        callSetNameNode.execute((Frame)frame, setName, value, newType, key);
                    }
                    catch (PException e) {
                        throw raise.raiseWithCause(PythonBuiltinClassType.RuntimeError, e.getEscapedException(), ErrorMessages.ERROR_CALLING_SET_NAME, value, key, newType);
                    }
                }
                SuperObject superObject = factory.createSuperObject((Object)PythonBuiltinClassType.Super);
                superObject.init(newType, newType, newType);
                callInitSubclassNode.execute((Frame)frame, getInitSubclassNode.executeObject(frame, superObject), PythonUtils.EMPTY_OBJECT_ARRAY, kwds);
                newType.initializeMroShape(language);
                PythonClass pythonClass = newType;
                return pythonClass;
            }
            finally {
                assert (SpecialMethodSlot.popInitializedType());
            }
        }

        private TruffleString getModuleNameFromGlobals(Node inliningTarget, PythonObject globals, HashingStorageNodes.HashingStorageGetItem getItem) {
            Object nameAttr;
            if (globals instanceof PythonModule) {
                nameAttr = this.ensureReadAttrNode().execute(globals, SpecialAttributeNames.T___NAME__);
            } else if (globals instanceof PDict) {
                nameAttr = getItem.execute(inliningTarget, ((PDict)globals).getDictStorage(), SpecialAttributeNames.T___NAME__);
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("invalid globals object");
            }
            if (nameAttr == null || nameAttr == PNone.NO_VALUE) {
                return null;
            }
            try {
                return this.ensureCastToStringNode().executeCached(nameAttr);
            }
            catch (CannotCastException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @ReportPolymorphism
    public static abstract class GetInstanceShape
    extends PNodeWithContext {
        public abstract Shape execute(Object var1);

        @Specialization(guards={"clazz == cachedClazz"}, limit="1")
        protected Shape doBuiltinClassTypeCached(PythonBuiltinClassType clazz, @Cached(value="clazz") PythonBuiltinClassType cachedClazz) {
            return cachedClazz.getInstanceShape(this.getLanguage());
        }

        @Specialization(replaces={"doBuiltinClassTypeCached"})
        protected Shape doBuiltinClassType(PythonBuiltinClassType clazz) {
            return clazz.getInstanceShape(this.getLanguage());
        }

        @Specialization(guards={"isSingleContext()", "clazz == cachedClazz"}, limit="3")
        protected static Shape doBuiltinClassCached(PythonBuiltinClass clazz, @Cached(value="clazz") PythonBuiltinClass cachedClazz) {
            return cachedClazz.getInstanceShape();
        }

        @Specialization(guards={"isSingleContext()", "clazz == cachedClazz"}, limit="3")
        protected static Shape doClassCached(PythonClass clazz, @Cached(value="clazz") PythonClass cachedClazz) {
            return cachedClazz.getInstanceShape();
        }

        @Specialization(replaces={"doClassCached", "doBuiltinClassCached"})
        protected static Shape doManagedClass(PythonManagedClass clazz) {
            return clazz.getInstanceShape();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        protected static Shape doNativeClass(PythonAbstractNativeObject clazz, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadObjectNode getTpDictNode, @Cached HiddenAttr.ReadNode readAttrNode) {
            Object tpDictObj = getTpDictNode.readFromObj(clazz, CFields.PyTypeObject__tp_dict);
            if (tpDictObj instanceof PythonManagedClass) {
                return ((PythonManagedClass)tpDictObj).getInstanceShape();
            }
            if (tpDictObj instanceof PDict) {
                PDict dict = (PDict)tpDictObj;
                Object instanceShapeObj = readAttrNode.execute(inliningTarget, dict, HiddenAttr.INSTANCESHAPE, PNone.NO_VALUE);
                if (instanceShapeObj != PNone.NO_VALUE) {
                    return (Shape)instanceShapeObj;
                }
                throw CompilerDirectives.shouldNotReachHere((String)"instanceshape object is not a shape");
            }
            throw CompilerDirectives.shouldNotReachHere((String)"custom dicts for native classes are unsupported");
        }

        @Specialization(guards={"!isManagedClass(clazz)", "!isPythonBuiltinClassType(clazz)"})
        @HostCompilerDirectives.InliningCutoff
        protected static Shape doError(Object clazz, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.SystemError, ErrorMessages.CANNOT_GET_SHAPE_OF_NATIVE_CLS);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class IsAcceptableBaseNode
    extends Node {
        public abstract boolean execute(Object var1);

        @Specialization
        static boolean doUserClass(PythonClass obj) {
            if (obj.isHPyType()) {
                return (obj.getFlags() & 0x400L) != 0L;
            }
            return true;
        }

        @Specialization
        static boolean doBuiltinClass(PythonBuiltinClass obj) {
            return obj.getType().isAcceptableBase();
        }

        @Specialization
        static boolean doBuiltinType(PythonBuiltinClassType obj) {
            return obj.isAcceptableBase();
        }

        @Specialization
        static boolean doNativeClass(PythonAbstractNativeObject obj, @Bind(value="this") Node inliningTarget, @Cached IsTypeNode isType, @Cached GetTypeFlagsNode getFlags) {
            if (isType.execute(inliningTarget, obj)) {
                return (getFlags.execute(obj) & 0x400L) != 0L;
            }
            return false;
        }

        @Fallback
        static boolean doOther(Object obj) {
            return false;
        }

        public static IsAcceptableBaseNode create() {
            return TypeNodesFactory.IsAcceptableBaseNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @ImportStatic(value={PGuards.class})
    public static abstract class IsTypeNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2);

        public final boolean executeCached(Object obj) {
            return this.execute(this, obj);
        }

        public static boolean executeUncached(Object obj) {
            return TypeNodesFactory.IsTypeNodeGen.getUncached().execute(null, obj);
        }

        @Specialization
        static boolean doManagedClass(PythonClass obj) {
            return true;
        }

        @Specialization
        static boolean doManagedClass(PythonBuiltinClass obj) {
            return true;
        }

        @Specialization
        static boolean doBuiltinType(PythonBuiltinClassType obj) {
            return true;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static boolean doNativeClass(Node inliningTarget, PythonAbstractNativeObject obj, @Cached BuiltinClassProfiles.IsBuiltinClassProfile profile, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached(inline=false) CExtNodes.PCallCapiFunction nativeTypeCheck) {
            Object type = getClassNode.execute(inliningTarget, obj);
            if (profile.profileClass(inliningTarget, type, PythonBuiltinClassType.PythonClass)) {
                return true;
            }
            if (PythonNativeClass.isInstance(type)) {
                return (Integer)nativeTypeCheck.call(NativeCAPISymbol.FUN_SUBCLASS_CHECK, obj.getPtr()) == 1;
            }
            return false;
        }

        @Fallback
        static boolean doOther(Object obj) {
            return false;
        }

        @NeverDefault
        public static IsTypeNode create() {
            return TypeNodesFactory.IsTypeNodeGen.create();
        }
    }

    public static abstract class ComputeMroNode
    extends Node {
        @CompilerDirectives.TruffleBoundary
        public static PythonAbstractClass[] doSlowPath(PythonAbstractClass cls) {
            return ComputeMroNode.doSlowPath(cls, true);
        }

        @CompilerDirectives.TruffleBoundary
        public static PythonAbstractClass[] doSlowPath(PythonAbstractClass cls, boolean invokeMro) {
            return ComputeMroNode.computeMethodResolutionOrder(cls, invokeMro);
        }

        @CompilerDirectives.TruffleBoundary
        static PythonAbstractClass[] invokeMro(PythonAbstractClass cls) {
            Object mroMeth;
            Object type = GetClassNode.executeUncached(cls);
            if (IsTypeNode.executeUncached(type) && type instanceof PythonClass && (mroMeth = LookupAttributeInMRONode.Dynamic.getUncached().execute(type, SpecialMethodNames.T_MRO)) instanceof PFunction) {
                Object mroObj = CallUnaryMethodNode.getUncached().executeObject(mroMeth, cls);
                if (mroObj instanceof PSequence) {
                    PSequence mroSequence = (PSequence)mroObj;
                    SequenceStorage mroStorage = mroSequence.getSequenceStorage();
                    return ComputeMroNode.mroCheck(cls, SequenceStorageNodes.GetInternalObjectArrayNode.executeUncached(mroStorage), mroStorage);
                }
                throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, cls);
            }
            return null;
        }

        private static PythonAbstractClass[] computeMethodResolutionOrder(PythonAbstractClass cls, boolean invokeMro) {
            PythonAbstractClass[] currentMRO;
            PythonAbstractClass[] mro;
            CompilerAsserts.neverPartOfCompilation();
            if (invokeMro && (mro = ComputeMroNode.invokeMro(cls)) != null) {
                return mro;
            }
            PythonAbstractClass[] baseClasses = GetBaseClassesNode.executeUncached(cls);
            if (baseClasses.length == 0) {
                currentMRO = new PythonAbstractClass[]{cls};
            } else if (baseClasses.length == 1) {
                PythonAbstractClass[] baseMRO = GetMroNode.executeUncached(baseClasses[0]);
                if (baseMRO == null) {
                    currentMRO = new PythonAbstractClass[]{cls};
                } else {
                    currentMRO = new PythonAbstractClass[baseMRO.length + 1];
                    PythonUtils.arraycopy(baseMRO, 0, currentMRO, 1, baseMRO.length);
                    currentMRO[0] = cls;
                }
            } else {
                MROMergeState[] toMerge = new MROMergeState[baseClasses.length + 1];
                for (int i = 0; i < baseClasses.length; ++i) {
                    toMerge[i] = new MROMergeState(GetMroNode.executeUncached(baseClasses[i]));
                }
                toMerge[baseClasses.length] = new MROMergeState(baseClasses);
                ArrayList<PythonAbstractClass> mro2 = new ArrayList<PythonAbstractClass>();
                mro2.add(cls);
                currentMRO = ComputeMroNode.mergeMROs(toMerge, mro2);
            }
            return currentMRO;
        }

        private static PythonAbstractClass[] mroCheck(Object cls, Object[] mro, SequenceStorage storage) {
            ArrayList<PythonAbstractClass> resultMro = new ArrayList<PythonAbstractClass>(storage.length());
            Object solid = GetSolidBaseNode.executeUncached(cls);
            for (int i = 0; i < storage.length(); ++i) {
                Object object = mro[i];
                if (object == null) continue;
                if (!IsTypeNode.executeUncached(object)) {
                    throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_RETURNED_NON_CLASS, "mro()", object);
                }
                if (!IsSubtypeNode.getUncached().execute(solid, GetSolidBaseNode.executeUncached(object))) {
                    throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_RETURNED_BASE_WITH_UNSUITABLE_LAYOUT, "mro()", object);
                }
                resultMro.add((PythonAbstractClass)object);
            }
            return resultMro.toArray(new PythonAbstractClass[resultMro.size()]);
        }

        private static PythonAbstractClass[] mergeMROs(MROMergeState[] toMerge, List<PythonAbstractClass> mro) {
            block0: for (int idx = 0; idx < toMerge.length; ++idx) {
                if (toMerge[idx].isMerged()) continue;
                PythonAbstractClass candidate = toMerge[idx].getCandidate();
                for (MROMergeState mergee : toMerge) {
                    if (mergee.pastnextContains(candidate)) continue block0;
                }
                mro.add(candidate);
                for (MROMergeState element : toMerge) {
                    element.noteMerged(candidate);
                }
                idx = -1;
            }
            ArrayList<PythonAbstractClass> notMerged = new ArrayList<PythonAbstractClass>();
            for (MROMergeState mergee : toMerge) {
                PythonAbstractClass candidate;
                if (mergee.isMerged() || notMerged.contains(candidate = mergee.getCandidate())) continue;
                notMerged.add(candidate);
            }
            if (!notMerged.isEmpty()) {
                Iterator it = notMerged.iterator();
                StringBuilder bases = new StringBuilder(GetNameNode.doSlowPath(it.next()).toJavaStringUncached());
                while (it.hasNext()) {
                    bases.append(", ").append(GetNameNode.doSlowPath(it.next()));
                }
                throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_GET_CONSISTEMT_METHOD_RESOLUTION, bases.toString());
            }
            return mro.toArray(new PythonAbstractClass[mro.size()]);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class ProfileClassNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, Object var2);

        public final Object profile(Node inliningTarget, Object object) {
            return this.execute(inliningTarget, object);
        }

        public final PythonBuiltinClassType profile(Node inliningTarget, PythonBuiltinClassType object) {
            return (PythonBuiltinClassType)((Object)this.execute(inliningTarget, (Object)object));
        }

        @Specialization(guards={"classType == cachedClassType"}, limit="1")
        static PythonBuiltinClassType doPythonBuiltinClassType(PythonBuiltinClassType classType, @Cached(value="classType") PythonBuiltinClassType cachedClassType) {
            return cachedClassType;
        }

        @Specialization(guards={"classType == cachedClassType"}, limit="1")
        static PythonBuiltinClassType doPythonBuiltinClassType(PythonBuiltinClass builtinClass, @Bind(value="builtinClass.getType()") PythonBuiltinClassType classType, @Cached(value="classType") PythonBuiltinClassType cachedClassType) {
            return cachedClassType;
        }

        @Specialization(guards={"isSingleContext()", "isPythonAbstractClass(object)"}, rewriteOn={NotSameTypeException.class})
        static Object doPythonAbstractClass(Object object, @Cached(value="object", weak=true) Object cachedObject, @CachedLibrary(limit="2") InteropLibrary lib) throws NotSameTypeException {
            if (lib.isIdentical(object, cachedObject, lib)) {
                return cachedObject;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw NotSameTypeException.INSTANCE;
        }

        @Specialization(replaces={"doPythonBuiltinClassType", "doPythonAbstractClass"})
        static Object doDisabled(Object object) {
            return object;
        }

        protected static boolean isPythonAbstractClass(Object obj) {
            return PythonAbstractClass.isInstance(obj);
        }

        static final class NotSameTypeException
        extends ControlFlowException {
            private static final long serialVersionUID = 1L;
            static final NotSameTypeException INSTANCE = new NotSameTypeException();

            NotSameTypeException() {
            }
        }
    }

    @GenerateUncached
    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class IsSameTypeNode
    extends PNodeWithContext {
        public abstract boolean execute(Node var1, Object var2, Object var3);

        public final boolean executeCached(Object left, Object right) {
            return this.execute(this, left, right);
        }

        public static boolean executeUncached(Object left, Object right) {
            return TypeNodesFactory.IsSameTypeNodeGen.getUncached().execute(null, left, right);
        }

        public static IsSameTypeNode create() {
            return TypeNodesFactory.IsSameTypeNodeGen.create();
        }

        @Specialization
        static boolean doManaged(PythonManagedClass left, PythonManagedClass right) {
            return left == right;
        }

        @Specialization
        static boolean doManaged(PythonBuiltinClassType left, PythonBuiltinClassType right) {
            return left == right;
        }

        @Specialization
        static boolean doManaged(PythonBuiltinClassType left, PythonBuiltinClass right) {
            return left == right.getType();
        }

        @Specialization
        static boolean doManaged(PythonBuiltinClass left, PythonBuiltinClassType right) {
            return left.getType() == right;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static boolean doNativeSingleContext(PythonAbstractNativeObject left, PythonAbstractNativeObject right, @CachedLibrary(limit="1") InteropLibrary lib) {
            if (left == right) {
                return true;
            }
            if (left.getPtr() instanceof Long && right.getPtr() instanceof Long) {
                return ((Long)left.getPtr()).longValue() == ((Long)right.getPtr()).longValue();
            }
            return lib.isIdentical(left.getPtr(), right.getPtr(), lib);
        }

        @Fallback
        static boolean doOther(Object left, Object right) {
            return false;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialMethodNames.class})
    static abstract class GetSolidBaseNode
    extends Node {
        GetSolidBaseNode() {
        }

        abstract Object execute(Node var1, Object var2);

        static Object executeUncached(Object type) {
            return TypeNodesFactory.GetSolidBaseNodeGen.getUncached().execute(null, type);
        }

        @Specialization
        protected static Object getSolid(Node inliningTarget, Object type, @Cached GetBaseClassNode getBaseClassNode, @Cached(value="createForceType()", inline=false) ReadAttributeFromObjectNode readAttr, @Cached InlinedBranchProfile typeIsNotBase, @Cached InlinedBranchProfile hasBase, @Cached InlinedBranchProfile hasNoBase) {
            return GetSolidBaseNode.solidBase(type, inliningTarget, getBaseClassNode, PythonContext.get(inliningTarget), readAttr, typeIsNotBase, hasBase, hasNoBase, 0);
        }

        @CompilerDirectives.TruffleBoundary
        protected static Object solidBaseTB(Object type, Node inliningTarget, GetBaseClassNode getBaseClassNode, PythonContext context, int depth) {
            return GetSolidBaseNode.solidBase(type, inliningTarget, getBaseClassNode, context, ReadAttributeFromObjectNode.getUncachedForceType(), InlinedBranchProfile.getUncached(), InlinedBranchProfile.getUncached(), InlinedBranchProfile.getUncached(), depth);
        }

        protected static Object solidBase(Object type, Node inliningTarget, GetBaseClassNode getBaseClassNode, PythonContext context, ReadAttributeFromObjectNode readAttr, InlinedBranchProfile typeIsNotBase, InlinedBranchProfile hasBase, InlinedBranchProfile hasNoBase, int depth) {
            CompilerAsserts.partialEvaluationConstant((int)depth);
            Object base = getBaseClassNode.execute(inliningTarget, type);
            if (base != null) {
                hasBase.enter(inliningTarget);
                base = depth > 3 ? GetSolidBaseNode.solidBaseTB(base, inliningTarget, getBaseClassNode, context, depth) : GetSolidBaseNode.solidBase(base, inliningTarget, getBaseClassNode, context, readAttr, typeIsNotBase, hasBase, hasNoBase, depth + 1);
            } else {
                hasNoBase.enter(inliningTarget);
                base = context.lookupType(PythonBuiltinClassType.PythonObject);
            }
            if (type == base) {
                return type;
            }
            typeIsNotBase.enter(inliningTarget);
            Object typeSlots = GetSolidBaseNode.getSlotsFromType(type, readAttr);
            if (GetSolidBaseNode.extraivars(type, base, typeSlots)) {
                return type;
            }
            return base;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean extraivars(Object type, Object base, Object typeSlots) {
            Object baseNewMethod;
            if (NeedsNativeAllocationNode.executeUncached(type) || NeedsNativeAllocationNode.executeUncached(base)) {
                long tSize = GetBasicSizeNode.executeUncached(type);
                long bSize = GetBasicSizeNode.executeUncached(base);
                long tItemSize = GetItemSizeNode.executeUncached(type);
                long bItemSize = GetItemSizeNode.executeUncached(base);
                if (tItemSize != 0L || bItemSize != 0L) {
                    return tSize != bSize || tItemSize != bItemSize;
                }
                long flags = GetTypeFlagsNode.executeUncached(type);
                long tDictOffset = GetDictOffsetNode.executeUncached(type);
                long bDictOffset = GetDictOffsetNode.executeUncached(base);
                long tWeakListOffset = GetWeakListOffsetNode.executeUncached(type);
                long bWeakListOffset = GetWeakListOffsetNode.executeUncached(base);
                if (tWeakListOffset != 0L && bWeakListOffset == 0L && tWeakListOffset + 8L == tSize) {
                    tSize -= 8L;
                }
                if ((flags & 0x10L) == 0L && tDictOffset != 0L && bDictOffset == 0L && tDictOffset + 8L == tSize) {
                    tSize -= 8L;
                }
                if (tWeakListOffset != 0L && bWeakListOffset == 0L && tWeakListOffset + 8L == tSize) {
                    tSize -= 8L;
                }
                return tSize != bSize;
            }
            if (typeSlots != null && GetSolidBaseNode.length(typeSlots) != 0) {
                return true;
            }
            Object typeNewMethod = LookupAttributeInMRONode.lookup(SpecialMethodNames.T___NEW__, GetMroStorageNode.executeUncached(type), ReadAttributeFromObjectNode.getUncached(), true, DynamicObjectLibrary.getUncached());
            return !HasSameConstructorNode.isSameFunction(typeNewMethod, baseNewMethod = LookupAttributeInMRONode.lookup(SpecialMethodNames.T___NEW__, GetMroStorageNode.executeUncached(base), ReadAttributeFromObjectNode.getUncached(), true, DynamicObjectLibrary.getUncached()));
        }

        @CompilerDirectives.TruffleBoundary
        private static int length(Object slotsObject) {
            assert (PGuards.isString(slotsObject) || PGuards.isPSequence(slotsObject)) : "slotsObject must be either a String or a PSequence";
            if (PGuards.isString(slotsObject)) {
                TruffleString slotName = (TruffleString)slotsObject;
                return SpecialAttributeNames.T___DICT__.equalsUncached((AbstractTruffleString)slotName, PythonUtils.TS_ENCODING) || SpecialAttributeNames.T___WEAKREF__.equalsUncached((AbstractTruffleString)slotName, PythonUtils.TS_ENCODING) ? 0 : 1;
            }
            SequenceStorage storage = ((PSequence)slotsObject).getSequenceStorage();
            int count = 0;
            int length = storage.length();
            Object[] slots = SequenceStorageNodes.GetInternalObjectArrayNode.executeUncached(storage);
            for (int i = 0; i < length; ++i) {
                Object s = slots[i];
                if (s instanceof TruffleString && (SpecialAttributeNames.T___DICT__.equalsUncached((AbstractTruffleString)((TruffleString)s), PythonUtils.TS_ENCODING) || SpecialAttributeNames.T___WEAKREF__.equalsUncached((AbstractTruffleString)((TruffleString)s), PythonUtils.TS_ENCODING))) continue;
                ++count;
            }
            return count;
        }

        private static Object getSlotsFromType(Object type, ReadAttributeFromObjectNode readAttr) {
            Object slots = readAttr.execute(type, SpecialAttributeNames.T___SLOTS__);
            return slots != PNone.NO_VALUE ? slots : null;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class InstancesOfTypeHaveWeakrefsNode
    extends PNodeWithContext {
        InstancesOfTypeHaveWeakrefsNode() {
        }

        public abstract boolean execute(Node var1, Object var2);

        public static boolean executeUncached(Object type) {
            return TypeNodesFactory.InstancesOfTypeHaveWeakrefsNodeGen.getUncached().execute(null, type);
        }

        @Specialization
        static boolean check(Node inliningTarget, Object type, @Cached NeedsNativeAllocationNode needsNativeAllocationNode, @Cached(inline=false) ReadAttributeFromObjectNode read, @Cached GetWeakListOffsetNode getWeakListOffsetNode) {
            if (needsNativeAllocationNode.execute(inliningTarget, type)) {
                return getWeakListOffsetNode.execute(inliningTarget, type) != 0L;
            }
            return read.execute(type, SpecialAttributeNames.T___WEAKREF__) != PNone.NO_VALUE;
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class InstancesOfTypeHaveDictNode
    extends PNodeWithContext {
        InstancesOfTypeHaveDictNode() {
        }

        public abstract boolean execute(Object var1);

        public static boolean executeUncached(Object type) {
            return TypeNodesFactory.InstancesOfTypeHaveDictNodeGen.getUncached().execute(type);
        }

        @Specialization
        static boolean doPBCT(PythonBuiltinClassType type) {
            return type.isBuiltinWithDict();
        }

        @Specialization
        static boolean doPythonClass(PythonManagedClass type) {
            return (type.getInstanceShape().getFlags() & 2) == 0;
        }

        @Specialization
        static boolean doNativeObject(PythonAbstractNativeObject type, @Cached CStructAccess.ReadI64Node getMember) {
            return getMember.readFromObj(type, CFields.PyTypeObject__tp_dictoffset) != 0L;
        }

        @Fallback
        static boolean doOther(Object type) {
            return true;
        }

        @NeverDefault
        public static InstancesOfTypeHaveDictNode create() {
            return TypeNodesFactory.InstancesOfTypeHaveDictNodeGen.create();
        }
    }

    public static abstract class CheckCompatibleForAssigmentNode
    extends PNodeWithContext {
        @Node.Child
        private LookupAttributeInMRONode lookupSlotsNode;
        @Node.Child
        private LookupAttributeInMRONode lookupNewNode;
        @Node.Child
        private PyObjectSizeNode sizeNode;
        @Node.Child
        private PRaiseNode raiseNode;
        @Node.Child
        private GetNameNode getTypeNameNode;
        @Node.Child
        private ReadAttributeFromObjectNode readAttr;
        @Node.Child
        private InstancesOfTypeHaveDictNode instancesHaveDictNode;

        public abstract boolean execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        boolean isCompatible(VirtualFrame frame, Object oldBase, Object newBase, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile errorSlotsBranch, @Cached IsSameTypeNode isSameTypeNode, @Cached GetBaseClassNode getBaseClassNode) {
            if (!this.compatibleForAssignment(frame, inliningTarget, oldBase, newBase, isSameTypeNode, getBaseClassNode)) {
                errorSlotsBranch.enter(inliningTarget);
                throw this.getRaiseNode().raise(PythonBuiltinClassType.TypeError, ErrorMessages.CLASS_ASSIGNMENT_S_LAYOUT_DIFFERS_FROM_S, this.getTypeName(newBase), this.getTypeName(oldBase));
            }
            return true;
        }

        private boolean compatibleForAssignment(VirtualFrame frame, Node inliningTarget, Object oldB, Object newB, IsSameTypeNode isSameTypeNode, GetBaseClassNode getBaseClassNode) {
            Object newBase = newB;
            Object oldBase = oldB;
            Object newParent = getBaseClassNode.execute(inliningTarget, newBase);
            while (newParent != null && this.compatibleWithBase(frame, newBase, newParent)) {
                newBase = newParent;
                newParent = getBaseClassNode.execute(inliningTarget, newBase);
            }
            Object oldParent = getBaseClassNode.execute(inliningTarget, oldBase);
            while (oldParent != null && this.compatibleWithBase(frame, oldBase, oldParent)) {
                oldBase = oldParent;
                oldParent = getBaseClassNode.execute(inliningTarget, oldBase);
            }
            return isSameTypeNode.execute(inliningTarget, newBase, oldBase) || isSameTypeNode.execute(inliningTarget, newParent, oldParent) && this.sameSlotsAdded(frame, newBase, oldBase);
        }

        private boolean compatibleWithBase(VirtualFrame frame, Object child, Object parent) {
            Object parentNewMethod;
            if (PGuards.isNativeClass(child) && PGuards.isNativeClass(parent)) {
                return false;
            }
            if (PGuards.isNativeClass(child) != PGuards.isNativeClass(parent)) {
                return false;
            }
            if (this.instancesHaveDict(child) != this.instancesHaveDict(parent)) {
                return false;
            }
            Object childNewMethod = this.getLookupNewNode().execute(child);
            if (childNewMethod != (parentNewMethod = this.getLookupNewNode().execute(parent))) {
                return false;
            }
            Object childSlots = this.getSlotsFromType(child);
            Object parentSlots = this.getSlotsFromType(parent);
            if (childSlots == null && parentSlots == null) {
                return true;
            }
            if (childSlots == null || parentSlots == null) {
                return false;
            }
            return this.compareSlots(frame, parent, child, parentSlots, childSlots);
        }

        private boolean sameSlotsAdded(VirtualFrame frame, Object a, Object b) {
            if (PGuards.isKindOfBuiltinClass(a) || PGuards.isKindOfBuiltinClass(b)) {
                return false;
            }
            Object aSlots = this.getSlotsFromType(a);
            Object bSlots = this.getSlotsFromType(b);
            return this.compareSlots(frame, a, b, aSlots, bSlots);
        }

        private boolean compareSlots(VirtualFrame frame, Object aType, Object bType, Object aSlotsArg, Object bSlotsArg) {
            Object aSlots = aSlotsArg;
            Object bSlots = bSlotsArg;
            if (aSlots == null && bSlots == null) {
                return true;
            }
            if (aSlots != null && bSlots != null) {
                return TypeNodes.compareSortedSlots(aSlots, bSlots);
            }
            aSlots = this.getLookupSlots().execute(aType);
            bSlots = this.getLookupSlots().execute(bType);
            int aSize = aSlots != PNone.NO_VALUE ? this.getSizeNode().executeCached((Frame)frame, aSlots) : 0;
            int bSize = bSlots != PNone.NO_VALUE ? this.getSizeNode().executeCached((Frame)frame, bSlots) : 0;
            return aSize == bSize;
        }

        private TruffleString getTypeName(Object clazz) {
            if (this.getTypeNameNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getTypeNameNode = (GetNameNode)this.insert(GetNameNode.create());
            }
            return this.getTypeNameNode.executeCached(clazz);
        }

        private Object getSlotsFromType(Object type) {
            Object slots = this.getReadAttr().execute(type, SpecialAttributeNames.T___SLOTS__);
            return slots != PNone.NO_VALUE ? slots : null;
        }

        private boolean instancesHaveDict(Object type) {
            if (this.instancesHaveDictNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.instancesHaveDictNode = (InstancesOfTypeHaveDictNode)this.insert(InstancesOfTypeHaveDictNode.create());
            }
            return this.instancesHaveDictNode.execute(type);
        }

        private ReadAttributeFromObjectNode getReadAttr() {
            if (this.readAttr == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readAttr = (ReadAttributeFromObjectNode)this.insert(ReadAttributeFromObjectNode.createForceType());
            }
            return this.readAttr;
        }

        private PyObjectSizeNode getSizeNode() {
            if (this.sizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.sizeNode = (PyObjectSizeNode)this.insert(PyObjectSizeNode.create());
            }
            return this.sizeNode;
        }

        private LookupAttributeInMRONode getLookupSlots() {
            if (this.lookupSlotsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupSlotsNode = (LookupAttributeInMRONode)this.insert(LookupAttributeInMRONode.create(SpecialAttributeNames.T___SLOTS__));
            }
            return this.lookupSlotsNode;
        }

        private LookupAttributeInMRONode getLookupNewNode() {
            if (this.lookupNewNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupNewNode = (LookupAttributeInMRONode)this.insert(LookupAttributeInMRONode.createForLookupOfUnmanagedClasses(SpecialMethodNames.T___NEW__));
            }
            return this.lookupNewNode;
        }

        private PRaiseNode getRaiseNode() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode;
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class GetIndexedSlotsCountNode
    extends Node {
        public abstract int execute(Node var1, Object var2);

        public static int executeUncached(Object cls) {
            return TypeNodesFactory.GetIndexedSlotsCountNodeGen.getUncached().execute(null, cls);
        }

        @Specialization
        static int doManaged(PythonManagedClass cls) {
            return cls.getIndexedSlotCount();
        }

        @Specialization
        static int getNative(Node inliningTarget, PythonNativeClass cls, @Cached GetBaseClassNode getBaseClassNode, @Cached(inline=false) GetIndexedSlotsCountNode recursiveNode) {
            return recursiveNode.execute(inliningTarget, getBaseClassNode.execute(inliningTarget, cls));
        }

        @Fallback
        static int fallback(Object cls) {
            return 0;
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetBestBaseClassNode
    extends PNodeWithContext {
        public abstract PythonAbstractClass execute(Node var1, PythonAbstractClass[] var2);

        @Specialization(guards={"bases.length == 0"})
        static PythonAbstractClass getEmpty(PythonAbstractClass[] bases) {
            return null;
        }

        @Specialization(guards={"bases.length == 1"})
        static PythonAbstractClass getOne(PythonAbstractClass[] bases) {
            return bases[0];
        }

        @Specialization(guards={"bases.length > 1"})
        static PythonAbstractClass getBestBase(Node inliningTarget, PythonAbstractClass[] bases, @Cached(inline=false) IsSubtypeNode isSubTypeNode, @Cached GetSolidBaseNode getSolidBaseNode, @Cached PRaiseNode.Lazy raiseNode) {
            return GetBestBaseClassNode.bestBase(inliningTarget, bases, getSolidBaseNode, isSubTypeNode, raiseNode);
        }

        @Fallback
        static PythonAbstractClass fallback(PythonAbstractClass[] bases) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        private static PythonAbstractClass bestBase(Node inliningTarget, PythonAbstractClass[] bases, GetSolidBaseNode getSolidBaseNode, IsSubtypeNode isSubTypeNode, PRaiseNode.Lazy raiseNode) throws PException {
            PythonAbstractClass base = null;
            Object winner = null;
            for (int i = 0; i < bases.length; ++i) {
                PythonAbstractClass basei = bases[i];
                Object candidate = getSolidBaseNode.execute(inliningTarget, basei);
                if (winner == null) {
                    winner = candidate;
                    base = basei;
                    continue;
                }
                if (isSubTypeNode.execute(winner, candidate)) continue;
                if (isSubTypeNode.execute(candidate, winner)) {
                    winner = candidate;
                    base = basei;
                    continue;
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MULTIPLE_BASES_LAYOUT_CONFLICT);
            }
            return base;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetBaseClassNode
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        public static Object executeUncached(Object obj) {
            return TypeNodesFactory.GetBaseClassNodeGen.getUncached().execute(null, obj);
        }

        @Specialization
        static Object doPythonClass(PythonManagedClass obj) {
            return obj.getBase();
        }

        @Specialization
        static Object doBuiltinType(PythonBuiltinClassType obj) {
            return obj.getBase();
        }

        @Specialization
        static Object doNative(Node inliningTarget, PythonNativeClass obj, @Cached(inline=false) CStructAccess.ReadObjectNode getTpBaseNode, @Cached InlinedExactClassProfile resultTypeProfile) {
            Object result = resultTypeProfile.profile(inliningTarget, getTpBaseNode.readFromObj(obj, CFields.PyTypeObject__tp_base));
            if (PGuards.isPNone(result)) {
                return null;
            }
            if (PGuards.isPythonClass(result)) {
                return result;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_BASE_TYPE_OBJ_FOR_CLASS, GetNameNode.doSlowPath(obj), result);
        }

        public static GetBaseClassNode getUncached() {
            return TypeNodesFactory.GetBaseClassNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetBaseClassesNode
    extends PNodeWithContext {
        public abstract PythonAbstractClass[] execute(Node var1, Object var2);

        public static PythonAbstractClass[] executeUncached(Object obj) {
            return TypeNodesFactory.GetBaseClassesNodeGen.getUncached().execute(null, obj);
        }

        @Specialization
        static PythonAbstractClass[] doPythonClass(PythonManagedClass obj) {
            return obj.getBaseClasses();
        }

        @Specialization
        PythonAbstractClass[] doPythonClass(PythonBuiltinClassType obj) {
            return PythonContext.get(this).lookupType(obj).getBaseClasses();
        }

        @Specialization
        static PythonAbstractClass[] doNative(Node inliningTarget, PythonNativeClass obj, @Cached PRaiseNode.Lazy raise, @Cached(inline=false) CStructAccess.ReadObjectNode getTpBasesNode, @Cached InlinedExactClassProfile resultTypeProfile, @Cached SequenceStorageNodes.GetInternalObjectArrayNode toArrayNode) {
            Object result = resultTypeProfile.profile(inliningTarget, getTpBasesNode.readFromObj(obj, CFields.PyTypeObject__tp_bases));
            if (result instanceof PTuple) {
                PTuple tuple = (PTuple)result;
                SequenceStorage storage = tuple.getSequenceStorage();
                Object[] values = toArrayNode.execute(inliningTarget, storage);
                try {
                    return GetBaseClassesNode.cast(values, storage);
                }
                catch (ClassCastException e) {
                    throw raise.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.UNSUPPORTED_OBJ_IN, "tp_bases");
                }
            }
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.TYPE_DOES_NOT_PROVIDE_BASES);
        }

        private static PythonAbstractClass[] cast(Object[] arr, SequenceStorage storage) {
            PythonAbstractClass[] bases = new PythonAbstractClass[storage.length()];
            for (int i = 0; i < storage.length(); ++i) {
                bases[i] = (PythonAbstractClass)arr[i];
            }
            return bases;
        }
    }

    @GenerateUncached
    @GenerateInline(value=true)
    @GenerateCached(value=true)
    public static abstract class GetSubclassesAsArrayNode
    extends Node {
        private static final PythonAbstractClass[] EMPTY = new PythonAbstractClass[0];

        abstract PythonAbstractClass[] execute(Node var1, Object var2);

        public static PythonAbstractClass[] executeUncached(Object clazz) {
            return TypeNodesFactory.GetSubclassesAsArrayNodeGen.getUncached().execute(null, clazz);
        }

        @Specialization
        static PythonAbstractClass[] doTpSubclasses(Node inliningTarget, Object object, @Cached GetSubclassesNode getSubclassesNode, @Cached EachSubclassAdd eachNode, @Cached HashingStorageNodes.HashingStorageLen dictLen, @Cached HashingStorageNodes.HashingStorageForEach forEachNode) {
            PDict subclasses = getSubclassesNode.execute(inliningTarget, object);
            if (subclasses == null) {
                return EMPTY;
            }
            HashingStorage storage = subclasses.getDictStorage();
            if (storage == EmptyStorage.INSTANCE) {
                return EMPTY;
            }
            int size = dictLen.execute(inliningTarget, storage);
            PythonAbstractClassList list = new PythonAbstractClassList(new PythonAbstractClass[size]);
            forEachNode.execute(null, inliningTarget, storage, eachNode, list);
            return list.subclasses;
        }

        static final class PythonAbstractClassList {
            final PythonAbstractClass[] subclasses;
            int i;

            PythonAbstractClassList(PythonAbstractClass[] subclasses) {
                this.subclasses = subclasses;
                this.i = 0;
            }

            void add(PythonAbstractClass clazz) {
                this.subclasses[this.i++] = clazz;
            }
        }

        @GenerateUncached
        @GenerateInline(value=true)
        static abstract class EachSubclassAdd
        extends HashingStorageNodes.HashingStorageForEachCallback<PythonAbstractClassList> {
            EachSubclassAdd() {
            }

            @Override
            public abstract PythonAbstractClassList execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, PythonAbstractClassList var5);

            @Specialization
            static PythonAbstractClassList doIt(Node inliningTarget, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, PythonAbstractClassList subclasses, @Cached HashingStorageNodes.HashingStorageIteratorValue itValue) {
                Object value = itValue.execute(inliningTarget, storage, it);
                subclasses.add(PythonAbstractClass.cast(value));
                return subclasses;
            }
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetSubclassesNode
    extends PNodeWithContext {
        public abstract PDict execute(Node var1, Object var2);

        public static PDict executeUncached(Object clazz) {
            return TypeNodesFactory.GetSubclassesNodeGen.getUncached().execute(null, clazz);
        }

        protected static void unsafeAddSubclass(Object base, Object subclass) {
            long hash = ObjectBuiltins.HashNode.hash(subclass);
            PDict dict = GetSubclassesNode.executeUncached(base);
            HashingStorage storage = dict.getDictStorage();
            if (HashingStorageNodes.HashingStorageLen.executeUncached(storage) == 0) {
                HashingStorageNodes.HashingStorageSetItemWithHash setItem = HashingStorageNodesFactory.HashingStorageSetItemWithHashNodeGen.getUncached();
                storage = setItem.execute(null, null, storage, subclass, hash, subclass);
                dict.setDictStorage(storage);
            } else {
                EconomicMapStorage mapStorage = (EconomicMapStorage)storage;
                mapStorage.putUncachedWithJavaEq(subclass, hash, subclass);
            }
        }

        protected static void unsafeRemoveSubclass(Object base, Object subclass) {
            long hash = ObjectBuiltins.HashNode.hash(subclass);
            PDict dict = GetSubclassesNode.executeUncached(base);
            HashingStorage storage = dict.getDictStorage();
            if (storage instanceof EconomicMapStorage) {
                EconomicMapStorage ems = (EconomicMapStorage)storage;
                HashingStorageNodes.HashingStorageDelItem.executeUncachedWithHash(ems, subclass, hash);
            } else assert (storage == EmptyStorage.INSTANCE) : "Unexpected storage type!";
        }

        @Specialization
        static PDict doPythonClass(PythonManagedClass obj) {
            return obj.getSubClasses();
        }

        @Specialization
        static PDict doPythonClass(Node inliningTarget, PythonBuiltinClassType obj) {
            return PythonContext.get(inliningTarget).lookupType(obj).getSubClasses();
        }

        @Specialization
        static PDict doNativeClass(Node inliningTarget, PythonNativeClass obj, @Cached(inline=false) CStructAccess.ReadObjectNode getTpSubclassesNode, @Cached InlinedExactClassProfile profile) {
            Object tpSubclasses = getTpSubclassesNode.readFromObj(obj, CFields.PyTypeObject__tp_subclasses);
            Object profiled = profile.profile(inliningTarget, tpSubclasses);
            if (profiled instanceof PDict) {
                PDict dict = (PDict)profiled;
                return dict;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("invalid subclasses dict " + profiled.getClass().getName());
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class GetQualNameNode
    extends Node {
        public abstract TruffleString execute(Node var1, Object var2);

        @Specialization
        static TruffleString getQualName(PythonManagedClass clazz) {
            return clazz.getQualName();
        }

        @Specialization
        static TruffleString getQualName(Node inliningTarget, PythonAbstractNativeObject clazz, @Cached(inline=false) GetTypeFlagsNode getTypeFlagsNode, @Cached(inline=false) CStructAccess.ReadObjectNode readObjectNode, @Cached(inline=false) CStructAccess.ReadCharPtrNode readCharPtrNode, @Cached CastToTruffleStringNode cast) {
            assert (IsTypeNode.executeUncached(clazz));
            long flags = getTypeFlagsNode.execute(clazz);
            if ((flags & 0x200L) != 0L) {
                Object qualname = readObjectNode.readFromObj(clazz, CFields.PyHeapTypeObject__ht_qualname);
                try {
                    return cast.execute(inliningTarget, qualname);
                }
                catch (CannotCastException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)"Cannot cast ht_qualname to string");
                }
            }
            return readCharPtrNode.readFromObj(clazz, CFields.PyTypeObject__tp_name);
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class GetNameNode
    extends Node {
        public abstract TruffleString execute(Node var1, Object var2);

        public final TruffleString executeCached(Object obj) {
            return this.execute(this, obj);
        }

        public static TruffleString executeUncached(Object obj) {
            return TypeNodesFactory.GetNameNodeGen.getUncached().execute(null, obj);
        }

        @Specialization
        static TruffleString doManagedClass(PythonManagedClass obj) {
            return obj.getName();
        }

        @Specialization
        static TruffleString doBuiltinClassType(PythonBuiltinClassType obj) {
            return obj.getName();
        }

        @Specialization
        TruffleString doNativeClass(PythonNativeClass obj, @Cached(inline=false) CStructAccess.ReadCharPtrNode getTpNameNode) {
            return getTpNameNode.readFromObj(obj, CFields.PyTypeObject__tp_name);
        }

        @Specialization(replaces={"doManagedClass", "doBuiltinClassType", "doNativeClass"})
        @CompilerDirectives.TruffleBoundary
        public static TruffleString doSlowPath(Object obj) {
            if (obj instanceof PythonManagedClass) {
                return ((PythonManagedClass)obj).getName();
            }
            if (obj instanceof PythonBuiltinClassType) {
                return ((PythonBuiltinClassType)((Object)obj)).getName();
            }
            if (PGuards.isNativeClass(obj)) {
                return CStructAccess.ReadCharPtrNode.getUncached().readFromObj((PythonNativeClass)obj, CFields.PyTypeObject__tp_name);
            }
            throw new IllegalStateException("unknown type " + obj.getClass().getName());
        }

        @NeverDefault
        public static GetNameNode create() {
            return TypeNodesFactory.GetNameNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class GetMroStorageNode
    extends PNodeWithContext {
        public abstract MroSequenceStorage execute(Node var1, Object var2);

        public final MroSequenceStorage executeCached(Object obj) {
            return this.execute(this, obj);
        }

        public static MroSequenceStorage executeUncached(Object obj) {
            return TypeNodesFactory.GetMroStorageNodeGen.getUncached().execute(null, obj);
        }

        private static MroSequenceStorage doPythonClass(PythonManagedClass obj, Node inliningTarget, InlinedConditionProfile notInitialized, InlinedConditionProfile isPythonClass, PythonLanguage language) {
            if (!notInitialized.profile(inliningTarget, obj.isMROInitialized())) {
                GetMroStorageNode.initializeMRO(obj, inliningTarget, isPythonClass, language);
            }
            return obj.getMethodResolutionOrder();
        }

        @HostCompilerDirectives.InliningCutoff
        private static void initializeMRO(PythonManagedClass obj, Node inliningTarget, InlinedConditionProfile isPythonClass, PythonLanguage language) {
            PythonAbstractClass[] mro = ComputeMroNode.doSlowPath(obj, false);
            if (isPythonClass.profile(inliningTarget, obj instanceof PythonClass)) {
                ((PythonClass)obj).setMRO(mro, language);
            } else {
                assert (obj instanceof PythonBuiltinClass);
                ((PythonBuiltinClass)obj).setMRO(mro);
            }
        }

        @Specialization
        static MroSequenceStorage doPythonClass(Node inliningTarget, PythonManagedClass obj, @Cached.Exclusive @Cached InlinedConditionProfile notInitialized, @Cached.Exclusive @Cached InlinedConditionProfile isPythonClass) {
            return GetMroStorageNode.doPythonClass(obj, inliningTarget, notInitialized, isPythonClass, PythonLanguage.get(inliningTarget));
        }

        @Specialization
        static MroSequenceStorage doBuiltinClass(Node inliningTarget, PythonBuiltinClassType obj) {
            return PythonContext.get(inliningTarget).lookupType(obj).getMethodResolutionOrder();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static MroSequenceStorage doNativeClass(Node inliningTarget, PythonNativeClass obj, @Cached(inline=false) CStructAccess.ReadObjectNode getTpMroNode, @Cached.Exclusive @Cached InlinedConditionProfile lazyTypeInitProfile, @Cached.Exclusive @Cached InlinedExactClassProfile tpMroProfile, @Cached.Exclusive @Cached InlinedExactClassProfile storageProfile, @Cached.Exclusive @Cached InlinedBranchProfile raiseSystemErrorBranch) {
            SequenceStorage sequenceStorage;
            Object profiled;
            Object tupleObj = getTpMroNode.readFromObj(obj, CFields.PyTypeObject__tp_mro);
            if (lazyTypeInitProfile.profile(inliningTarget, tupleObj == PNone.NO_VALUE)) {
                tupleObj = GetMroStorageNode.initializeType(inliningTarget, obj, getTpMroNode);
            }
            if ((profiled = tpMroProfile.profile(inliningTarget, tupleObj)) instanceof PTuple && (sequenceStorage = (SequenceStorage)storageProfile.profile(inliningTarget, (Object)((PTuple)profiled).getSequenceStorage())) instanceof MroSequenceStorage) {
                return (MroSequenceStorage)sequenceStorage;
            }
            raiseSystemErrorBranch.enter(inliningTarget);
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_MRO_OBJ);
        }

        private static Object initializeType(Node inliningTarget, PythonNativeClass obj, CStructAccess.ReadObjectNode getTpMroNode) {
            CompilerDirectives.transferToInterpreter();
            int res = (Integer)CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TYPE_READY, CApiTransitionsFactory.PythonToNativeNodeGen.getUncached().execute(obj));
            if (res < 0) {
                PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.LAZY_INITIALIZATION_FAILED, GetNameNode.executeUncached(obj));
            }
            Object tupleObj = getTpMroNode.readFromObj(obj, CFields.PyTypeObject__tp_mro);
            assert (tupleObj != PNone.NO_VALUE) : "MRO object is still NULL even after lazy type initialization";
            return tupleObj;
        }

        @Specialization(replaces={"doPythonClass", "doBuiltinClass", "doNativeClass"})
        @CompilerDirectives.TruffleBoundary
        static MroSequenceStorage doSlowPath(Node inliningTarget, Object obj) {
            if (obj instanceof PythonManagedClass) {
                return GetMroStorageNode.doPythonClass((PythonManagedClass)obj, inliningTarget, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), PythonLanguage.get(null));
            }
            if (obj instanceof PythonBuiltinClassType) {
                return PythonContext.get(null).lookupType((PythonBuiltinClassType)((Object)obj)).getMethodResolutionOrder();
            }
            if (PGuards.isNativeClass(obj)) {
                SequenceStorage sequenceStorage;
                CStructAccess.ReadObjectNode getTypeMemeberNode = CStructAccess.ReadObjectNode.getUncached();
                Object tupleObj = getTypeMemeberNode.readFromObj((PythonNativeClass)obj, CFields.PyTypeObject__tp_mro);
                if (tupleObj == PNone.NO_VALUE) {
                    tupleObj = GetMroStorageNode.initializeType(inliningTarget, (PythonNativeClass)obj, CStructAccess.ReadObjectNode.getUncached());
                }
                if (tupleObj instanceof PTuple && (sequenceStorage = ((PTuple)tupleObj).getSequenceStorage()) instanceof MroSequenceStorage) {
                    return (MroSequenceStorage)sequenceStorage;
                }
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_MRO_OBJ);
            }
            throw new IllegalStateException("unknown type " + obj.getClass().getName());
        }

        @NeverDefault
        public static GetMroStorageNode create() {
            return TypeNodesFactory.GetMroStorageNodeGen.create();
        }

        public static GetMroStorageNode getUncached() {
            return TypeNodesFactory.GetMroStorageNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class GetMroNode
    extends Node {
        public abstract PythonAbstractClass[] execute(Node var1, Object var2);

        public final PythonAbstractClass[] executeCached(Object obj) {
            return this.execute(this, obj);
        }

        public static PythonAbstractClass[] executeUncached(Object obj) {
            return TypeNodesFactory.GetMroNodeGen.getUncached().execute(null, obj);
        }

        @Specialization
        static PythonAbstractClass[] doIt(Node inliningTarget, Object obj, @Cached GetMroStorageNode getMroStorageNode) {
            return getMroStorageNode.execute(inliningTarget, obj).getInternalClassArray();
        }

        @NeverDefault
        public static GetMroNode create() {
            return TypeNodesFactory.GetMroNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetTypeFlagsNode
    extends Node {
        public abstract void execute(Node var1, Object var2, long var3);

        public static void executeUncached(Object clazz, long flags) {
            TypeNodesFactory.SetTypeFlagsNodeGen.getUncached().execute(null, clazz, flags);
        }

        @Specialization
        static void doPBCT(Node inliningTarget, PythonBuiltinClassType clazz, long flags, @Cached.Shared(value="write") @Cached HiddenAttr.WriteNode writeHiddenFlagsNode) {
            SetTypeFlagsNode.doManaged(inliningTarget, PythonContext.get(inliningTarget).getCore().lookupType(clazz), flags, writeHiddenFlagsNode);
        }

        @Specialization
        static void doManaged(Node inliningTarget, PythonManagedClass clazz, long flags, @Cached.Shared(value="write") @Cached HiddenAttr.WriteNode writeHiddenFlagsNode) {
            writeHiddenFlagsNode.execute(inliningTarget, clazz, HiddenAttr.FLAGS, flags);
        }

        @Specialization
        static void doNative(PythonNativeClass clazz, long flags, @Cached(inline=false) CStructAccess.WriteLongNode write) {
            write.writeToObject(clazz, CFields.PyTypeObject__tp_flags, flags);
        }
    }

    @GenerateUncached
    public static abstract class GetTypeFlagsNode
    extends Node {
        public abstract long execute(Object var1);

        public static long executeUncached(Object clazz) {
            return TypeNodesFactory.GetTypeFlagsNodeGen.getUncached().execute(clazz);
        }

        @Specialization
        static long doBuiltinClassType(PythonBuiltinClassType clazz, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="read") @Cached HiddenAttr.ReadNode readHiddenFlagsNode, @Cached.Shared(value="write") @Cached HiddenAttr.WriteNode writeHiddenFlagsNode, @Cached.Shared(value="profile") @Cached InlinedCountingConditionProfile profile) {
            return GetTypeFlagsNode.doManaged(PythonContext.get(inliningTarget).getCore().lookupType(clazz), inliningTarget, readHiddenFlagsNode, writeHiddenFlagsNode, profile);
        }

        @Specialization
        static long doManaged(PythonManagedClass clazz, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="read") @Cached HiddenAttr.ReadNode readHiddenFlagsNode, @Cached.Shared(value="write") @Cached HiddenAttr.WriteNode writeHiddenFlagsNode, @Cached.Shared(value="profile") @Cached InlinedCountingConditionProfile profile) {
            Object flagsObject = readHiddenFlagsNode.execute(inliningTarget, clazz, HiddenAttr.FLAGS, null);
            if (profile.profile(inliningTarget, flagsObject != null)) {
                return (Long)flagsObject;
            }
            long flags = GetTypeFlagsNode.computeFlags(clazz);
            writeHiddenFlagsNode.execute(inliningTarget, clazz, HiddenAttr.FLAGS, flags);
            return flags;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static long doNative(PythonNativeClass clazz, @Cached CStructAccess.ReadI64Node getTpFlagsNode) {
            return getTpFlagsNode.readFromObj(clazz, CFields.PyTypeObject__tp_flags);
        }

        @CompilerDirectives.TruffleBoundary
        private static long computeFlags(PythonManagedClass clazz) {
            if (clazz instanceof PythonBuiltinClass) {
                return GetTypeFlagsNode.defaultBuiltinFlags(((PythonBuiltinClass)clazz).getType());
            }
            long result = 17920L;
            if (clazz.isAbstractClass()) {
                result |= 0x100000L;
            }
            if ((clazz.getInstanceShape().getFlags() & 2) == 0) {
                result |= 0x10L;
            }
            PythonContext context = PythonContext.get(null);
            MroSequenceStorage mroStorage = GetMroStorageNode.executeUncached(clazz);
            int n = mroStorage.length();
            for (int i = 0; i < n; ++i) {
                Object mroEntry = SequenceStorageNodes.GetItemDynamicNode.executeUncached(mroStorage, i);
                if (mroEntry instanceof PythonBuiltinClassType) {
                    mroEntry = context.getCore().lookupType((PythonBuiltinClassType)((Object)mroEntry));
                }
                if (mroEntry instanceof PythonAbstractNativeObject) {
                    result = TypeNodes.setFlags(result, GetTypeFlagsNode.doNative((PythonAbstractNativeObject)mroEntry, CStructAccess.ReadI64Node.getUncached()));
                    continue;
                }
                if (mroEntry == clazz || !(mroEntry instanceof PythonManagedClass)) continue;
                long flags = GetTypeFlagsNode.doManaged((PythonManagedClass)mroEntry, null, HiddenAttr.ReadNode.getUncached(), HiddenAttr.WriteNode.getUncached(), InlinedCountingConditionProfile.getUncached());
                result = TypeNodes.setFlags(result, flags);
            }
            return result;
        }

        private static long defaultBuiltinFlags(PythonBuiltinClassType clazz) {
            long result = switch (clazz) {
                case PythonBuiltinClassType.DictRemover, PythonBuiltinClassType.StructParam, PythonBuiltinClassType.CArgObject, PythonBuiltinClassType.MultibyteCodec, PythonBuiltinClassType.PEllipsis, PythonBuiltinClassType.PNotImplemented, PythonBuiltinClassType.PNone -> 0L;
                case PythonBuiltinClassType.PythonObject, PythonBuiltinClassType.StgDict, PythonBuiltinClassType.PyCData, PythonBuiltinClassType.PyCArray, PythonBuiltinClassType.PyCPointer, PythonBuiltinClassType.PyCFuncPtr, PythonBuiltinClassType.Structure, PythonBuiltinClassType.Union, PythonBuiltinClassType.SimpleCData, PythonBuiltinClassType.MultibyteIncrementalEncoder, PythonBuiltinClassType.MultibyteIncrementalDecoder, PythonBuiltinClassType.MultibyteStreamReader, PythonBuiltinClassType.MultibyteStreamWriter, PythonBuiltinClassType.PyCSimpleType, PythonBuiltinClassType.PyCFuncPtrType -> 1024L;
                case PythonBuiltinClassType.PArray -> 1056L;
                case PythonBuiltinClassType.PythonClass, PythonBuiltinClassType.Super, PythonBuiltinClassType.PythonModule, PythonBuiltinClassType.PReferenceType, PythonBuiltinClassType.PProperty, PythonBuiltinClassType.PDeque, PythonBuiltinClassType.POrderedDict, PythonBuiltinClassType.PSimpleQueue, PythonBuiltinClassType.PSimpleNamespace, PythonBuiltinClassType.PMap, PythonBuiltinClassType.PStaticmethod, PythonBuiltinClassType.PZip, PythonBuiltinClassType.PReverseIterator, PythonBuiltinClassType.PCycle, PythonBuiltinClassType.PEnumerate, PythonBuiltinClassType.PyCStructType, PythonBuiltinClassType.PyCPointerType, PythonBuiltinClassType.PyCArrayType, PythonBuiltinClassType.UnionType, PythonBuiltinClassType.PBaseException -> 17408L;
                case PythonBuiltinClassType.PFrozenSet, PythonBuiltinClassType.PSet -> 0x404400L;
                case PythonBuiltinClassType.Boolean -> 0x400000L;
                case PythonBuiltinClassType.PFunction, PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.WrapperDescriptor, PythonBuiltinClassType.PLruCacheWrapper -> 147456L;
                case PythonBuiltinClassType.PLruListElem -> 16512L;
                case PythonBuiltinClassType.PBytesIOBuf, PythonBuiltinClassType.PMethod, PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.PBuiltinMethod, PythonBuiltinClassType.MethodWrapper, PythonBuiltinClassType.PInstancemethod, PythonBuiltinClassType.GetSetDescriptor, PythonBuiltinClassType.MemberDescriptor, PythonBuiltinClassType.PFrame, PythonBuiltinClassType.PGenerator, PythonBuiltinClassType.PSlice, PythonBuiltinClassType.PTraceback, PythonBuiltinClassType.PDequeIter, PythonBuiltinClassType.PDequeRevIter, PythonBuiltinClassType.CField, PythonBuiltinClassType.CThunkObject, PythonBuiltinClassType.PArrayIterator, PythonBuiltinClassType.PAsyncGenerator, PythonBuiltinClassType.PCell, PythonBuiltinClassType.PIterator -> 16384L;
                case PythonBuiltinClassType.PMappingproxy -> 16448L;
                case PythonBuiltinClassType.PMemoryView -> 16416L;
                case PythonBuiltinClassType.PDict -> 0x404440L;
                case PythonBuiltinClassType.PDefaultDict -> 17472L;
                case PythonBuiltinClassType.PList, PythonBuiltinClassType.PTuple -> 0x404420L;
                case PythonBuiltinClassType.PRange -> 32L;
                case PythonBuiltinClassType.PythonModuleDef, PythonBuiltinClassType.Capsule -> 0L;
                case PythonBuiltinClassType.PByteArray, PythonBuiltinClassType.PFloat, PythonBuiltinClassType.PInt, PythonBuiltinClassType.PString, PythonBuiltinClassType.PBytes -> 0x400400L;
                default -> 0L;
            };
            result |= clazz.isAcceptableBase() ? 1024L : 0L;
            for (PythonBuiltinClassType iter = clazz; iter != null; iter = iter.getBase()) {
                if (iter == PythonBuiltinClassType.PBaseException) {
                    result |= 0x40004000L;
                    continue;
                }
                if (iter == PythonBuiltinClassType.PythonClass) {
                    result |= 0x80000000L;
                    continue;
                }
                if (iter == PythonBuiltinClassType.PInt) {
                    result |= 0x1000000L;
                    continue;
                }
                if (iter == PythonBuiltinClassType.PBytes) {
                    result |= 0x8000000L;
                    continue;
                }
                if (iter == PythonBuiltinClassType.PString) {
                    result |= 0x10000000L;
                    continue;
                }
                if (iter == PythonBuiltinClassType.PTuple) {
                    result |= 0x4000000L;
                    continue;
                }
                if (iter == PythonBuiltinClassType.PList) {
                    result |= 0x2000000L;
                    continue;
                }
                if (iter != PythonBuiltinClassType.PDict) continue;
                result |= 0x20000000L;
            }
            return result | 0x1000L | 0x100L;
        }

        public static GetTypeFlagsNode getUncached() {
            return TypeNodesFactory.GetTypeFlagsNodeGen.getUncached();
        }
    }
}

