/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.io.IOAccess;
import org.graalvm.python.embedding.VirtualFileSystem;
import org.graalvm.python.embedding.VirtualFileSystemImpl;

public final class GraalPyResources {
    private GraalPyResources() {
    }

    public static Context createContext() {
        return GraalPyResources.contextBuilder().build();
    }

    public static Context.Builder contextBuilder() {
        VirtualFileSystem vfs = VirtualFileSystem.create();
        return GraalPyResources.contextBuilder(vfs);
    }

    public static Context.Builder contextBuilder(VirtualFileSystem vfs) {
        return GraalPyResources.createContextBuilder().allowIO(IOAccess.newBuilder().allowHostSocketAccess(true).fileSystem(vfs.delegatingFileSystem).build()).option("python.Executable", vfs.impl.vfsVenvPath() + (VirtualFileSystemImpl.isWindows() ? "\\Scripts\\python.exe" : "/bin/python")).option("python.PythonPath", vfs.impl.vfsSrcPath()).option("python.InputFilePath", vfs.impl.vfsSrcPath());
    }

    public static Context.Builder contextBuilder(Path externalResourcesDirectory) {
        String execPath = VirtualFileSystemImpl.isWindows() ? externalResourcesDirectory.resolve("venv").resolve("Scripts").resolve("python.exe").toAbsolutePath().toString() : externalResourcesDirectory.resolve("venv").resolve("bin").resolve("python").toAbsolutePath().toString();
        String srcPath = externalResourcesDirectory.resolve("src").toAbsolutePath().toString();
        return GraalPyResources.createContextBuilder().allowIO(IOAccess.ALL).option("python.Executable", execPath).option("python.PythonPath", srcPath).option("python.InputFilePath", srcPath);
    }

    private static Context.Builder createContextBuilder() {
        return Context.newBuilder((String[])new String[0]).allowExperimentalOptions(false).allowAllAccess(false).allowHostAccess(HostAccess.ALL).allowCreateThread(true).allowNativeAccess(true).allowPolyglotAccess(PolyglotAccess.ALL).option("python.PosixModuleBackend", "java").option("python.DontWriteBytecodeFlag", "true").option("python.ForceImportSite", "true").option("python.CheckHashPycsMode", "never");
    }

    public static Path getNativeExecutablePath() {
        if (ImageInfo.inImageRuntimeCode()) {
            String pn = null;
            pn = ProcessProperties.getArgumentVectorBlockSize() > 0 ? ProcessProperties.getArgumentVectorProgramName() : ProcessProperties.getExecutableName();
            if (pn != null) {
                return Paths.get(pn, new String[0]).toAbsolutePath();
            }
        }
        return null;
    }

    public static void extractVirtualFileSystemResources(VirtualFileSystem vfs, Path externalResourcesDirectory) throws IOException {
        if (Files.exists(externalResourcesDirectory, new LinkOption[0]) && !Files.isDirectory(externalResourcesDirectory, new LinkOption[0])) {
            throw new IOException(String.format("%s has to be a directory", externalResourcesDirectory.toString()));
        }
        vfs.impl.extractResources(externalResourcesDirectory);
    }
}

