/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;

final class DefaultSpecialInvokeTypeFlow
extends AbstractSpecialInvokeTypeFlow {
    MethodFlowsGraph calleeFlows = null;

    DefaultSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        assert (!this.isSaturated());
        this.initCallee();
        if (this.calleeFlows == null) {
            this.calleeFlows = this.callee.getOrCreateMethodFlowsGraph(bb, this);
            this.linkCallee(bb, false, this.calleeFlows);
        }
        TypeState invokeState = this.filterReceiverState(bb, this.getReceiver().getState());
        this.updateReceiver(bb, this.calleeFlows, invokeState);
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
        if (this.callee == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.callee.getMethodFlowsGraph());
    }
}

