/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Function;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class UninitializedStaticFieldValueReader {
    public static JavaConstant readUninitializedStaticValue(AnalysisField field, Function<Object, JavaConstant> function) {
        boolean canHaveConstantValueAttribute;
        JavaKind kind = field.getJavaKind();
        boolean bl = canHaveConstantValueAttribute = kind.isPrimitive() || field.getType().getName().equals("Ljava/lang/String;");
        if (!canHaveConstantValueAttribute || !field.isFinal()) {
            return JavaConstant.defaultForKind((JavaKind)kind);
        }
        assert (Modifier.isStatic(field.getModifiers()));
        Class<?> base = field.getDeclaringClass().getJavaClass();
        long offset = field.wrapped.getOffset();
        Field reflectionField = field.getJavaField();
        if (reflectionField != null) {
            assert (kind == JavaKind.fromJavaClass(reflectionField.getType()));
            Object reflectionFieldBase = Unsafe.getUnsafe().staticFieldBase(reflectionField);
            long reflectionFieldOffset = Unsafe.getUnsafe().staticFieldOffset(reflectionField);
            AnalysisError.guarantee(reflectionFieldBase == base && reflectionFieldOffset == offset);
        }
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((boolean)Unsafe.getUnsafe().getBoolean(base, offset));
            }
            case Byte: {
                return JavaConstant.forByte((byte)Unsafe.getUnsafe().getByte(base, offset));
            }
            case Char: {
                return JavaConstant.forChar((char)Unsafe.getUnsafe().getChar(base, offset));
            }
            case Short: {
                return JavaConstant.forShort((short)Unsafe.getUnsafe().getShort(base, offset));
            }
            case Int: {
                return JavaConstant.forInt((int)Unsafe.getUnsafe().getInt(base, offset));
            }
            case Long: {
                return JavaConstant.forLong((long)Unsafe.getUnsafe().getLong(base, offset));
            }
            case Float: {
                return JavaConstant.forFloat((float)Unsafe.getUnsafe().getFloat(base, offset));
            }
            case Double: {
                return JavaConstant.forDouble((double)Unsafe.getUnsafe().getDouble(base, offset));
            }
            case Object: {
                Object value = Unsafe.getUnsafe().getObject(base, offset);
                assert (value == null || value instanceof String) : "String is currently the only specified object type for the ConstantValue class file attribute";
                return function.apply(value);
            }
        }
        throw AnalysisError.shouldNotReachHere();
    }
}

