/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaField;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.AnnotationWrapper;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;

public abstract class AnalysisField
extends AnalysisElement
implements WrappedJavaField,
OriginalFieldProvider,
AnnotationWrapper {
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> OBSERVERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "observers");
    private static final AtomicIntegerFieldUpdater<AnalysisField> isAccessedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "isAccessed");
    private static final AtomicIntegerFieldUpdater<AnalysisField> isReadUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "isRead");
    private static final AtomicIntegerFieldUpdater<AnalysisField> isWrittenUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "isWritten");
    private static final AtomicIntegerFieldUpdater<AnalysisField> isFoldedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "isFolded");
    private static final AtomicIntegerFieldUpdater<AnalysisField> isUnsafeAccessedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "isUnsafeAccessed");
    private static final AtomicIntegerFieldUpdater<AnalysisField> unsafeFrozenTypeStateUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "unsafeFrozenTypeState");
    private final int id;
    public final ResolvedJavaField wrapped;
    private FieldTypeFlow staticFieldFlow;
    private FieldTypeFlow initialInstanceFieldFlow;
    private ContextInsensitiveFieldTypeFlow instanceFieldFlow;
    private volatile int isAccessed;
    private volatile int isRead;
    private volatile int isWritten;
    private volatile int isFolded;
    private boolean isJNIAccessed;
    private boolean isUsedInComparison;
    private volatile int isUnsafeAccessed;
    private volatile int unsafeFrozenTypeState;
    private volatile Object observers;
    private boolean canBeNull;
    private ConcurrentMap<AnalysisMethod, Boolean> readBy;
    private ConcurrentMap<AnalysisMethod, Boolean> writtenBy;
    protected TypeState instanceFieldTypeState;
    protected int position;
    protected final AnalysisType declaringClass;
    protected final AnalysisType fieldType;

    public AnalysisField(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        assert (!wrappedField.isInternal());
        this.position = -1;
        this.wrapped = wrappedField;
        this.id = universe.nextFieldId.getAndIncrement();
        boolean trackAccessChain = (Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options());
        this.readBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.writtenBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.declaringClass = universe.lookup((JavaType)wrappedField.getDeclaringClass());
        this.fieldType = AnalysisField.getDeclaredType(universe, wrappedField);
        this.isUsedInComparison = false;
        if (this.isStatic()) {
            this.canBeNull = false;
            this.staticFieldFlow = new FieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = null;
        } else {
            this.canBeNull = true;
            this.instanceFieldFlow = new ContextInsensitiveFieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = new FieldTypeFlow(this, this.getType());
        }
    }

    private AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    private static AnalysisType getDeclaredType(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        ResolvedJavaType resolvedType;
        try {
            resolvedType = wrappedField.getType().resolve(universe.substitutions.resolve(wrappedField.getDeclaringClass()));
        }
        catch (LinkageError e) {
            return universe.objectType();
        }
        return universe.lookup((JavaType)resolvedType);
    }

    @Override
    public ResolvedJavaField getWrapped() {
        return this.wrapped;
    }

    public void copyAccessInfos(AnalysisField other) {
        isAccessedUpdater.set(this, other.isAccessed);
        isUnsafeAccessedUpdater.set(this, other.isUnsafeAccessed);
        this.canBeNull = other.canBeNull;
        isWrittenUpdater.set(this, other.isWritten);
        isFoldedUpdater.set(this, other.isFolded);
        isReadUpdater.set(this, other.isRead);
        this.notifyUpdateAccessInfo();
    }

    public void intersectAccessInfos(AnalysisField other) {
        isAccessedUpdater.set(this, this.isAccessed & other.isAccessed);
        this.canBeNull = this.canBeNull && other.canBeNull;
        isWrittenUpdater.set(this, this.isWritten & other.isWritten);
        isFoldedUpdater.set(this, this.isFolded & other.isFolded);
        isReadUpdater.set(this, this.isRead & other.isRead);
        this.notifyUpdateAccessInfo();
    }

    public void clearAccessInfos() {
        isAccessedUpdater.set(this, 0);
        this.canBeNull = true;
        isWrittenUpdater.set(this, 0);
        isFoldedUpdater.set(this, 0);
        isReadUpdater.set(this, 0);
        this.notifyUpdateAccessInfo();
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public JavaKind getStorageKind() {
        return this.fieldType.getStorageKind();
    }

    public TypeState getTypeState() {
        if (this.getType().getStorageKind() != JavaKind.Object) {
            return null;
        }
        if (this.isStatic()) {
            return this.interceptTypeState(this.staticFieldFlow.getState());
        }
        return this.getInstanceFieldTypeState();
    }

    public TypeState getInstanceFieldTypeState() {
        return this.interceptTypeState(this.instanceFieldFlow.getState());
    }

    public FieldTypeFlow getInitialInstanceFieldFlow() {
        return this.initialInstanceFieldFlow;
    }

    public FieldTypeFlow getStaticFieldFlow() {
        assert (Modifier.isStatic(this.getModifiers()));
        return this.staticFieldFlow;
    }

    public ContextInsensitiveFieldTypeFlow getInstanceFieldFlow() {
        assert (!Modifier.isStatic(this.getModifiers()));
        return this.instanceFieldFlow;
    }

    public void cleanupAfterAnalysis() {
        this.staticFieldFlow = null;
        this.instanceFieldFlow = null;
        this.initialInstanceFieldFlow = null;
        this.readBy = null;
        this.writtenBy = null;
        this.instanceFieldTypeState = null;
    }

    public boolean registerAsAccessed() {
        boolean firstAttempt = AtomicUtils.atomicMark(this, isAccessedUpdater);
        this.notifyUpdateAccessInfo();
        if (firstAttempt) {
            this.onReachable();
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsRead(AnalysisMethod method) {
        boolean firstAttempt = AtomicUtils.atomicMark(this, isReadUpdater);
        this.notifyUpdateAccessInfo();
        if (this.readBy != null && method != null) {
            this.readBy.put(method, Boolean.TRUE);
        }
        if (firstAttempt) {
            this.onReachable();
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsWritten(AnalysisMethod method) {
        boolean firstAttempt = AtomicUtils.atomicMark(this, isWrittenUpdater);
        this.notifyUpdateAccessInfo();
        if (this.writtenBy != null && method != null) {
            this.writtenBy.put(method, Boolean.TRUE);
        }
        if (firstAttempt) {
            this.onReachable();
            if (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object) {
                this.getUniverse().onFieldAccessed(this);
            }
        }
        return firstAttempt;
    }

    public void markFolded() {
        if (AtomicUtils.atomicMark(this, isFoldedUpdater)) {
            this.getDeclaringClass().registerAsReachable();
            this.onReachable();
        }
    }

    public void registerAsUnsafeAccessed() {
        this.registerAsUnsafeAccessed(DefaultUnsafePartition.get());
    }

    public boolean registerAsUnsafeAccessed(UnsafePartitionKind partitionKind) {
        this.registerAsAccessed();
        if (AtomicUtils.atomicMark(this, isUnsafeAccessedUpdater)) {
            this.registerAsWritten(null);
            if (this.isStatic()) {
                this.getUniverse().registerUnsafeAccessedStaticField(this);
            } else {
                AnalysisType declaringType = this.getDeclaringClass();
                declaringType.registerUnsafeAccessedField(this, partitionKind);
            }
            return true;
        }
        this.notifyUpdateAccessInfo();
        return false;
    }

    public boolean isUnsafeAccessed() {
        return AtomicUtils.isSet(this, isUnsafeAccessedUpdater);
    }

    public void registerAsJNIAccessed() {
        this.isJNIAccessed = true;
    }

    public boolean isJNIAccessed() {
        return this.isJNIAccessed;
    }

    public void setUnsafeFrozenTypeState(boolean value) {
        unsafeFrozenTypeStateUpdater.set(this, value ? 1 : 0);
    }

    public boolean hasUnsafeFrozenTypeState() {
        return AtomicUtils.isSet(this, unsafeFrozenTypeStateUpdater);
    }

    public Set<AnalysisMethod> getReadBy() {
        return this.readBy.keySet();
    }

    public Set<AnalysisMethod> getWrittenBy() {
        return this.writtenBy.keySet();
    }

    public boolean isAccessed() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) && (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object);
    }

    public boolean isRead() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater);
    }

    public boolean isWritten() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isWrittenUpdater);
    }

    public boolean isFolded() {
        return AtomicUtils.isSet(this, isFoldedUpdater);
    }

    @Override
    public boolean isReachable() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) || AtomicUtils.isSet(this, isFoldedUpdater);
    }

    @Override
    public void onReachable() {
        this.notifyReachabilityCallbacks(this.declaringClass.getUniverse(), new ArrayList<AnalysisFuture<Void>>());
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
        this.notifyUpdateAccessInfo();
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public int getPosition() {
        assert (this.position != -1) : this;
        return this.position;
    }

    public AnalysisType getType() {
        return this.fieldType;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        throw GraalError.shouldNotReachHere();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.wrapped;
    }

    public String toString() {
        return "AnalysisField<" + this.format("%h.%n") + " accessed: " + this.isAccessed + " reads: " + this.isRead + " written: " + this.isWritten + " folded: " + this.isFolded + ">";
    }

    public void markAsUsedInComparison() {
        this.isUsedInComparison = true;
    }

    public boolean isUsedInComparison() {
        return this.isUsedInComparison;
    }

    @Override
    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField(this.getUniverse().getOriginalSnippetReflection(), this.wrapped);
    }

    public void addAnalysisFieldObserver(AnalysisFieldObserver observer) {
        ConcurrentLightHashSet.addElement(this, OBSERVERS_UPDATER, observer);
    }

    public void removeAnalysisFieldObserver(AnalysisFieldObserver observer) {
        ConcurrentLightHashSet.removeElement(this, OBSERVERS_UPDATER, observer);
    }

    private void notifyUpdateAccessInfo() {
        for (Object observer : ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER)) {
            ((AnalysisFieldObserver)observer).notifyUpdateAccessInfo(this);
        }
    }

    private TypeState interceptTypeState(TypeState typestate) {
        TypeState result = typestate;
        for (Object observer : ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER)) {
            result = ((AnalysisFieldObserver)observer).interceptTypeState(this, typestate);
        }
        return result;
    }

    public static interface AnalysisFieldObserver {
        public void notifyUpdateAccessInfo(AnalysisField var1);

        public TypeState interceptTypeState(AnalysisField var1, TypeState var2);
    }
}

