/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap.value;

import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public final class LazyValueSupplier<V>
implements ValueSupplier<V> {
    private final Supplier<V> valueSupplier;
    private final BooleanSupplier isAvailable;

    LazyValueSupplier(Supplier<V> valueSupplier, BooleanSupplier isAvailable) {
        this.valueSupplier = valueSupplier;
        this.isAvailable = isAvailable;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable.getAsBoolean();
    }

    @Override
    public V get() {
        AnalysisError.guarantee(this.isAvailable(), "Value is not yet available.", new Object[0]);
        return this.valueSupplier.get();
    }
}

