/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public final class DynamicNewInstanceTypeFlow
extends TypeFlow<BytecodePosition> {
    private TypeFlow<?> newTypeFlow;
    private final AnalysisContext allocationContext;

    public DynamicNewInstanceTypeFlow(BytecodePosition location, TypeFlow<?> newTypeFlow, AnalysisType type) {
        super(location, type);
        this.allocationContext = null;
        this.newTypeFlow = newTypeFlow;
    }

    private DynamicNewInstanceTypeFlow(PointsToAnalysis bb, DynamicNewInstanceTypeFlow original, MethodFlowsGraph methodFlows, AnalysisContext allocationContext) {
        super(original, methodFlows);
        this.allocationContext = allocationContext;
        this.newTypeFlow = methodFlows.lookupCloneOf(bb, original.newTypeFlow);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        AnalysisContext allocContext = bb.analysisPolicy().allocationContext(bb, methodFlows);
        return new DynamicNewInstanceTypeFlow(bb, this, methodFlows, allocContext);
    }

    @Override
    public void initFlow(PointsToAnalysis bb) {
        this.newTypeFlow.addObserver(bb, this);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        TypeState newTypeState = this.newTypeFlow.getState();
        TypeState updateState = bb.analysisPolicy().dynamicNewInstanceState(bb, this.state, newTypeState, (BytecodePosition)this.source, this.allocationContext);
        this.addState(bb, updateState);
    }

    public AnalysisContext allocationContext() {
        return this.allocationContext;
    }

    @Override
    public void setObserved(TypeFlow<?> declaredTypeFlow) {
        this.newTypeFlow = declaredTypeFlow;
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        this.replaceObservedWith(bb, this.declaredType);
    }

    @Override
    public boolean canSaturate() {
        return false;
    }

    @Override
    public String toString() {
        return "DynamicNewInstanceFlow<" + this.getState() + ">";
    }
}

