/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.SubstrateIntrinsicGraphBuilder;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.util.ClassUtil;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.runtime.RuntimeProvider;

public final class AnalysisParsedGraph {
    public static final Architecture HOST_ARCHITECTURE;
    private static final AnalysisParsedGraph EMPTY;
    private final EncodedGraph encodedGraph;
    private final boolean isIntrinsic;

    private AnalysisParsedGraph(EncodedGraph encodedGraph, boolean isIntrinsic) {
        this.isIntrinsic = isIntrinsic;
        this.encodedGraph = encodedGraph;
    }

    public EncodedGraph getEncodedGraph() {
        return this.encodedGraph;
    }

    public boolean isIntrinsic() {
        return this.isIntrinsic;
    }

    /*
     * Loose catch block
     */
    public static AnalysisParsedGraph parseBytecode(BigBang bb, AnalysisMethod method) {
        if (bb == null) {
            throw AnalysisError.shouldNotReachHere("BigBang object required for parsing method " + method.format("%H.%p(%n)"));
        }
        OptionValues options = bb.getOptions();
        DebugContext.Description description = new DebugContext.Description((Object)method, ClassUtil.getUnqualifiedName(method.getClass()) + ":" + method.getId());
        DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(bb.getProviders().getSnippetReflection())).description(description).build();
        try (Indent indent = debug.logAndIndent("parse graph %s", (Object)method);){
            StructuredGraph graph;
            block35: {
                AnalysisParsedGraph code;
                graph = method.buildGraph(debug, method, bb.getProviders(), GraphProvider.Purpose.ANALYSIS);
                if (graph != null) {
                    AnalysisParsedGraph analysisParsedGraph = AnalysisParsedGraph.optimizeAndEncode(bb, method, graph, false);
                    return analysisParsedGraph;
                }
                InvocationPlugin plugin = bb.getProviders().getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)method, options);
                if (plugin != null && !plugin.inlineOnly()) {
                    code = new ResolvedJavaMethodBytecode((ResolvedJavaMethod)method);
                    graph = new SubstrateIntrinsicGraphBuilder(options, debug, (CoreProviders)bb.getProviders(), (Bytecode)code).buildGraph(plugin);
                    if (graph != null) {
                        AnalysisParsedGraph analysisParsedGraph = AnalysisParsedGraph.optimizeAndEncode(bb, method, graph, true);
                        return analysisParsedGraph;
                    }
                }
                if (method.getCode() == null) {
                    code = EMPTY;
                    return code;
                }
                graph = new StructuredGraph.Builder(options, debug).method((ResolvedJavaMethod)method).recordInlinedMethods(false).build();
                DebugContext.Scope s = debug.scope((Object)"ClosedWorldAnalysis", (Object)graph, (Object)method);
                try (Indent indent2 = debug.logAndIndent("parse graph phases");){
                    GraphBuilderConfiguration config = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)bb.getProviders().getGraphBuilderPlugins()).withEagerResolving(true).withUnresolvedIsError(((Boolean)PointstoOptions.UnresolvedIsError.getValue(bb.getOptions())).booleanValue()).withNodeSourcePosition(true).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.CheckAll).withRetainLocalVariables(true);
                    config = bb.getHostVM().updateGraphBuilderConfiguration(config, method);
                    bb.getHostVM().createGraphBuilderPhase(bb.getProviders(), config, OptimisticOptimizations.NONE, null).apply(graph);
                }
                catch (PermanentBailoutException ex) {
                    bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, ex.getLocalizedMessage(), null, ex);
                    AnalysisParsedGraph analysisParsedGraph = EMPTY;
                    if (s != null) {
                        s.close();
                    }
                    if (indent != null) {
                        indent.close();
                    }
                    return analysisParsedGraph;
                }
                try {
                    if (s != null) {
                        s.close();
                    }
                    break block35;
                    {
                        catch (Throwable throwable) {
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
            }
            AnalysisParsedGraph analysisParsedGraph = AnalysisParsedGraph.optimizeAndEncode(bb, method, graph, false);
            return analysisParsedGraph;
        }
    }

    private static AnalysisParsedGraph optimizeAndEncode(BigBang bb, AnalysisMethod method, StructuredGraph graph, boolean isIntrinsic) {
        AnalysisParsedGraph analysisParsedGraph;
        block8: {
            DebugContext.Scope s = graph.getDebug().scope((Object)"ClosedWorldAnalysis", (Object)graph, (Object)method);
            try {
                bb.getHostVM().methodAfterParsingHook(bb, method, graph);
                EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph((StructuredGraph)graph, (Architecture)HOST_ARCHITECTURE);
                analysisParsedGraph = new AnalysisParsedGraph(encodedGraph, isIntrinsic);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw graph.getDebug().handle(e);
                }
            }
            s.close();
        }
        return analysisParsedGraph;
    }

    static {
        GraalJVMCICompiler compiler = (GraalJVMCICompiler)JVMCI.getRuntime().getCompiler();
        HOST_ARCHITECTURE = ((RuntimeProvider)compiler.getGraalRuntime().getCapability(RuntimeProvider.class)).getHostBackend().getTarget().arch;
        EMPTY = new AnalysisParsedGraph(null, false);
    }
}

