/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.sbom;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.xml.Xpp3Dom;
import org.graalvm.buildtools.maven.sbom.ArtifactAdapter;
import org.graalvm.buildtools.maven.sbom.FileWalkerUtility;

final class ArtifactAdapterResolver {
    private final MavenProject mavenProject;
    private final Plugin shadePlugin;
    private final Set<Path> pathToClassFilesDirectories;
    private final Set<Path> visitedPathToClassFileDirectories;
    private final String mainClass;
    private static final String mavenShadePluginName = "maven-shade-plugin";

    ArtifactAdapterResolver(MavenProject mavenProject, String mainClass) {
        this.mavenProject = mavenProject;
        this.shadePlugin = ArtifactAdapterResolver.getShadePluginIfUsed(mavenProject);
        this.pathToClassFilesDirectories = new HashSet<Path>();
        this.visitedPathToClassFileDirectories = new HashSet<Path>();
        this.mainClass = mainClass;
    }

    Optional<ArtifactAdapter> populateWithAdditionalFields(Path jarPath, ArtifactAdapter artifact) throws IOException {
        if (!Files.exists(jarPath, new LinkOption[0]) || !jarPath.toString().endsWith(".jar")) {
            return Optional.empty();
        }
        if (this.shadePlugin == null) {
            return this.handleNonShadedCase(artifact, jarPath);
        }
        Optional<Path> optionalShadedJarPath = this.getShadedJarPath();
        if (optionalShadedJarPath.isEmpty()) {
            return this.handleNonShadedCase(artifact, jarPath);
        }
        Path shadedJarPath = optionalShadedJarPath.get();
        FileSystem jarFileSystem = ArtifactAdapterResolver.getOrCreateFileSystem(shadedJarPath);
        if (!this.isPartOfJar(jarFileSystem, artifact)) {
            return this.handleNonShadedCase(artifact, jarPath);
        }
        Optional<Set<Path>> optionalClassFileDirectories = this.resolveArtifactClassFileDirectories(jarFileSystem, jarPath, artifact);
        if (optionalClassFileDirectories.isPresent()) {
            Set<Path> classFileDirectories = optionalClassFileDirectories.get();
            HashSet<String> packageNames = new HashSet<String>();
            for (Path directory : classFileDirectories) {
                Set newPackageNames = FileWalkerUtility.collectPackageNamesFromFileSystem(jarFileSystem, directory).orElse(Set.of());
                packageNames.addAll(newPackageNames);
            }
            artifact.setPackageNames(packageNames);
            artifact.setJarPath(shadedJarPath.toUri());
            return Optional.of(artifact);
        }
        return Optional.empty();
    }

    static void markShadedArtifactsAsNonPrunable(Set<ArtifactAdapter> artifacts) throws IOException {
        for (ArtifactAdapter artifact : artifacts) {
            if (!ArtifactAdapterResolver.isShaded(artifact)) continue;
            artifact.prunable = false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isShaded(ArtifactAdapter artifact) throws IOException {
        if (artifact.jarPath == null) {
            return false;
        }
        FileSystem jarFileSystem = ArtifactAdapterResolver.getOrCreateFileSystem(Paths.get(artifact.jarPath));
        Optional<Path> optionalMetaInfPath = ArtifactAdapterResolver.getMetaInfArtifactPath(jarFileSystem, artifact);
        if (optionalMetaInfPath.isEmpty()) {
            return false;
        }
        Path metaInfPath = optionalMetaInfPath.get();
        Path pomPath = jarFileSystem.getPath(metaInfPath.toString(), "pom.xml");
        try (InputStream pomInputStream = Files.newInputStream(pomPath, new OpenOption[0]);){
            boolean bl;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(pomInputStream));){
                bl = reader.lines().anyMatch(line -> line.contains(String.format("<artifactId>%s</artifactId>", mavenShadePluginName)));
            }
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private Optional<ArtifactAdapter> handleNonShadedCase(ArtifactAdapter artifactAdapter, Path jarPath) throws IOException {
        FileSystem fileSystem = ArtifactAdapterResolver.getOrCreateFileSystem(jarPath);
        Set<String> packageNames = FileWalkerUtility.collectPackageNamesFromFileSystem(fileSystem, fileSystem.getPath("/", new String[0])).orElse(Set.of());
        artifactAdapter.setPackageNames(packageNames);
        artifactAdapter.setJarPath(jarPath.toUri());
        return Optional.of(artifactAdapter);
    }

    private Optional<Path> getShadedJarPath() {
        Path finalJarPath;
        Path outputPath;
        Path targetDirectory = Paths.get(this.mavenProject.getBuild().getDirectory(), new String[0]);
        Optional<String> outputFile = ArtifactAdapterResolver.getParameterFromPlugin(this.shadePlugin, "outputFile");
        if (outputFile.isPresent() && Files.exists(outputPath = Paths.get(outputFile.get(), new String[0]), new LinkOption[0])) {
            return Optional.of(outputPath);
        }
        Optional<String> finalName = ArtifactAdapterResolver.getParameterFromPlugin(this.shadePlugin, "finalName");
        if (finalName.isPresent() && Files.exists(finalJarPath = targetDirectory.resolve(finalName.get() + ".jar"), new LinkOption[0])) {
            return Optional.of(finalJarPath);
        }
        Path defaultJarPath = targetDirectory.resolve(this.mavenProject.getArtifactId() + "-" + this.mavenProject.getVersion() + ".jar");
        if (Files.exists(defaultJarPath, new LinkOption[0])) {
            return Optional.of(defaultJarPath);
        }
        return Optional.empty();
    }

    private boolean isPartOfJar(FileSystem jarFileSystem, ArtifactAdapter artifact) throws IOException {
        Optional<Path> optionalMetaInfPath = ArtifactAdapterResolver.getMetaInfArtifactPath(jarFileSystem, artifact);
        if (optionalMetaInfPath.isEmpty()) {
            return false;
        }
        Path metaInfPath = optionalMetaInfPath.get();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(metaInfPath);){
            int versionCount = 0;
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                ++versionCount;
            }
            if (versionCount > 1) {
                Path versionedPath = metaInfPath.resolve(artifact.version);
                boolean bl = Files.isDirectory(versionedPath, new LinkOption[0]);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private static Optional<Path> getMetaInfArtifactPath(FileSystem jarFileSystem, ArtifactAdapter artifact) {
        Path path = jarFileSystem.getPath("META-INF", "maven", artifact.groupId, artifact.artifactId);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(path);
    }

    private Optional<Set<Path>> resolveArtifactClassFileDirectories(FileSystem jarFileSystem, Path jarPath, ArtifactAdapter artifact) throws IOException {
        if (this.pathToClassFilesDirectories.isEmpty()) {
            Set<Path> potentialDirectories = this.resolveDirectoriesContainingClassFiles(jarFileSystem.getPath("/", new String[0]));
            if (potentialDirectories.isEmpty()) {
                return Optional.empty();
            }
            this.pathToClassFilesDirectories.addAll(potentialDirectories);
        }
        if (this.pathToClassFilesDirectories.size() == 1) {
            Path onlyPossiblePath = (Path)this.pathToClassFilesDirectories.stream().findFirst().get();
            this.visitedPathToClassFileDirectories.add(onlyPossiblePath);
            return Optional.of(Set.of(onlyPossiblePath));
        }
        Set<Path> difference = this.notVisitedPaths();
        if (difference.size() == 1) {
            Path onlyPossiblePath = (Path)difference.stream().findFirst().get();
            this.visitedPathToClassFileDirectories.add(onlyPossiblePath);
            return Optional.of(Set.of(onlyPossiblePath));
        }
        Optional<Path> resolvedPath = this.tryResolveUsingGAVCoordinates(jarFileSystem.getPath("/", new String[0]), artifact);
        if (resolvedPath.isPresent()) {
            return Optional.of(Set.of(resolvedPath.get()));
        }
        boolean isMainArtifact = artifact.equals(this.mavenProject.getArtifact());
        if (isMainArtifact) {
            resolvedPath = this.findTopClassDirectory(jarFileSystem.getPath("/", new String[0]), this.mainClass);
            if (resolvedPath.isPresent()) {
                return Optional.of(Set.of(resolvedPath.get()));
            }
            resolvedPath = this.tryResolveUsingGAVCoordinates(jarFileSystem.getPath("/", new String[0]), artifact);
            return resolvedPath.map(Set::of);
        }
        FileSystem fileSystemOriginalJar = ArtifactAdapterResolver.getOrCreateFileSystem(jarPath);
        HashSet<String> originalClassFiles = new HashSet<String>();
        FileWalkerUtility.walkFileTreeWithExtensions(fileSystemOriginalJar.getPath("/", new String[0]), Set.of(".class", ".java"), file -> {
            Path fileName = file.getFileName();
            if (fileName != null) {
                originalClassFiles.add(fileName.toString());
            }
        });
        Optional<Set<Path>> optionalPaths = this.resolveDirectoriesFromClassNameMatching(artifact, originalClassFiles);
        if (optionalPaths.isPresent()) {
            Set<Path> paths = optionalPaths.get();
            this.visitedPathToClassFileDirectories.addAll(paths);
            return Optional.of(paths);
        }
        return Optional.empty();
    }

    private Optional<Path> findTopClassDirectory(Path rootPath, String qualifiedName) throws IOException {
        String mainClassPath = qualifiedName.replace('.', File.separatorChar) + ".class";
        Path classFilePath = rootPath.resolve(mainClassPath);
        for (Path currentPath = classFilePath.getParent(); currentPath != null && !Files.isSameFile(currentPath, rootPath); currentPath = currentPath.getParent()) {
            if (!FileWalkerUtility.containsClassFiles(currentPath)) continue;
            return Optional.of(currentPath);
        }
        return Optional.empty();
    }

    private Optional<Path> tryResolveUsingGAVCoordinates(Path rootPath, ArtifactAdapter artifact) throws IOException {
        Optional<Path> resolvedPath = this.resolveGAVCoordinates(rootPath, artifact, true);
        if (resolvedPath.isPresent()) {
            return resolvedPath;
        }
        return this.resolveGAVCoordinates(rootPath, artifact, false);
    }

    private Optional<Path> resolveGAVCoordinates(Path rootPath, ArtifactAdapter artifact, boolean useArtifactId) throws IOException {
        Path gavPath = this.pathFromGAVCoordinates(rootPath, artifact, useArtifactId);
        Set pathsAsStrings = this.pathToClassFilesDirectories.stream().map(Path::toString).collect(Collectors.toSet());
        if (pathsAsStrings.contains(gavPath.toString())) {
            this.visitedPathToClassFileDirectories.add(gavPath);
            return Optional.of(gavPath);
        }
        return Optional.empty();
    }

    private Set<Path> notVisitedPaths() {
        HashSet<Path> difference = new HashSet<Path>(this.pathToClassFilesDirectories);
        difference.removeAll(this.visitedPathToClassFileDirectories);
        return difference;
    }

    private Optional<Set<Path>> resolveDirectoriesFromClassNameMatching(ArtifactAdapter artifact, Set<String> originalClassFiles) throws IOException {
        HashSet<Path> matchingDirectories = new HashSet<Path>();
        for (Path potentialDirectory : this.pathToClassFilesDirectories) {
            AtomicBoolean successfulMatching = new AtomicBoolean(true);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(potentialDirectory);){
                for (Path file : stream) {
                    String fileName;
                    if (!Files.isRegularFile(file, new LinkOption[0]) || !file.toString().endsWith(".class") || originalClassFiles.contains(fileName = file.getFileName().toString())) continue;
                    successfulMatching.set(false);
                    break;
                }
            }
            if (!successfulMatching.get()) continue;
            matchingDirectories.add(potentialDirectory);
        }
        if (matchingDirectories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(matchingDirectories);
    }

    private Set<Path> resolveDirectoriesContainingClassFiles(Path rootPath) throws IOException {
        final HashSet<Path> directories = new HashSet<Path>();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toString().endsWith(".class")) {
                    Path classDirectory = file.getParent();
                    directories.add(classDirectory);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path fileName = dir.getFileName();
                if (fileName != null && fileName.toString().equals("META-INF")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return directories;
    }

    private Path pathFromGAVCoordinates(Path basePath, ArtifactAdapter artifact, boolean useArtifactId) throws IOException {
        FileSystem fileSystem = basePath.getFileSystem();
        Path expectedPath = basePath.resolve(fileSystem.getPath(artifact.groupId.replace('.', '/'), new String[0]));
        if (useArtifactId) {
            expectedPath = expectedPath.resolve(artifact.artifactId.replace('.', '/'));
        }
        if (Files.isDirectory(expectedPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(expectedPath);){
                boolean hasMultipleDirectories;
                boolean bl = hasMultipleDirectories = StreamSupport.stream(stream.spliterator(), false).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).count() > 1L;
                if (hasMultipleDirectories) {
                    expectedPath = expectedPath.resolve(artifact.version);
                }
            }
        }
        return expectedPath;
    }

    private static Optional<String> getParameterFromPlugin(Plugin plugin, String parameter) {
        Xpp3Dom parameterNode;
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration != null && parameter != null && !parameter.isEmpty() && (parameterNode = configuration.getChild(parameter)) != null) {
            return Optional.of(parameterNode.getValue());
        }
        return Optional.empty();
    }

    private static Plugin getShadePluginIfUsed(MavenProject mavenProject) {
        return mavenProject.getBuildPlugins().stream().filter(v -> mavenShadePluginName.equals(v.getArtifactId())).findFirst().orElse(null);
    }

    private static FileSystem getOrCreateFileSystem(Path jarPath) throws IOException {
        try {
            return FileSystems.newFileSystem(jarPath, (ClassLoader)null);
        }
        catch (FileSystemAlreadyExistsException e) {
            return FileSystems.getFileSystem(jarPath.toUri());
        }
    }
}

