/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.config;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Parameter;

public class MetadataRepositoryConfiguration {
    @Parameter(defaultValue="true")
    private boolean enabled = true;
    @Parameter
    private String version;
    @Parameter
    private File localPath;
    @Parameter
    private URL url;
    @Parameter
    private List<DependencyConfiguration> dependencies;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(File localPath) {
        this.localPath = localPath;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public List<DependencyConfiguration> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<DependencyConfiguration> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean isArtifactExcluded(Artifact artifact) {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            return false;
        }
        return this.dependencies.stream().filter(DependencyConfiguration::isExcluded).anyMatch(d -> d.getGroupId().equals(artifact.getGroupId()) && d.getArtifactId().equals(artifact.getArtifactId()));
    }

    public Optional<String> getMetadataVersion(Artifact artifact) {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            return Optional.empty();
        }
        return this.dependencies.stream().filter(d -> d.getGroupId().equals(artifact.getGroupId()) && d.getArtifactId().equals(artifact.getArtifactId())).map(DependencyConfiguration::getMetadataVersion).filter(Objects::nonNull).findFirst();
    }

    public static class DependencyConfiguration
    extends Dependency {
        @Parameter(defaultValue="false")
        private boolean excluded;
        @Parameter
        private String metadataVersion;

        public DependencyConfiguration() {
        }

        public DependencyConfiguration(String groupId, String artifactId, boolean excluded) {
            this.setGroupId(groupId);
            this.setArtifactId(artifactId);
            this.excluded = excluded;
        }

        public DependencyConfiguration(String groupId, String artifactId, String metadataVersion) {
            this.setGroupId(groupId);
            this.setArtifactId(artifactId);
            this.metadataVersion = metadataVersion;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        public String getMetadataVersion() {
            return this.metadataVersion;
        }

        public void setMetadataVersion(String metadataVersion) {
            this.metadataVersion = metadataVersion;
        }
    }
}

