/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.StandardAgentMode;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.gradle.internal.agent.AgentConfigurationFactory;
import org.graalvm.buildtools.gradle.tasks.actions.MergeAgentFilesAction;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecOperations;

public abstract class MetadataCopyTask
extends DefaultTask {
    private final GraalVMLogger logger = GraalVMLogger.of(this.getLogger());
    private final ProjectLayout layout;
    private final ProviderFactory providerFactory;
    private final ObjectFactory objectFactory;
    private final ExecOperations execOperations;

    @Inject
    public MetadataCopyTask(ProjectLayout layout, ProviderFactory providerFactory, ObjectFactory objectFactory, ExecOperations execOperations) {
        this.layout = layout;
        this.providerFactory = providerFactory;
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
    }

    @Internal
    public abstract ListProperty<String> getInputTaskNames();

    @Internal
    public abstract ListProperty<String> getOutputDirectories();

    @Internal
    public abstract Property<Boolean> getMergeWithExisting();

    @Internal
    public abstract Property<Boolean> getToolchainDetection();

    @Option(option="task", description="Executed task previously instrumented with the agent whose metadata should be copied.")
    public void overrideInputTaskNames(List<String> inputTaskNames) {
        this.getInputTaskNames().set(inputTaskNames);
    }

    @Option(option="dir", description="Directory to which the metadata will be copied.")
    public void overrideOutputDirectories(List<String> outputDirectories) {
        this.getOutputDirectories().set(outputDirectories);
    }

    @TaskAction
    public void exec() {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> inputDirectories = new ArrayList<String>();
        for (String taskName : (List)this.getInputTaskNames().get()) {
            File dir = ((Directory)AgentConfigurationFactory.getAgentOutputDirectoryForTask(this.layout, taskName).get()).getAsFile();
            if (!dir.exists()) {
                builder.append("Could not find configuration for task: ").append(taskName).append(". Please run the task with the agent.");
            } else if (!dir.isDirectory()) {
                builder.append("Expected a directory with configuration for task: ").append(taskName).append(" but found a regular file at ").append(dir.getAbsolutePath()).append(". Was the output directory manually modified?");
            }
            inputDirectories.add(dir.getAbsolutePath());
        }
        String errorString = builder.toString();
        if (!errorString.isEmpty()) {
            throw new GradleException(errorString);
        }
        ArrayList<String> outputDirectories = new ArrayList<String>();
        for (String dirName : (List)this.getOutputDirectories().get()) {
            File dir = ((Directory)this.layout.dir(this.providerFactory.provider(() -> new File(dirName))).get()).getAsFile();
            outputDirectories.add(dir.getAbsolutePath());
            if (dir.exists()) {
                if (dir.isDirectory()) continue;
                builder.append("Specified output path must either not exist or be a directory: ").append(dirName);
                continue;
            }
            try {
                this.logger.log("Creating output directory: " + dirName);
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new GradleException("Could not create output directory: " + dirName, (Throwable)e);
            }
        }
        Provider isMergeEnabled = this.providerFactory.provider(() -> true);
        Provider agentModeProvider = this.providerFactory.provider(StandardAgentMode::new);
        new MergeAgentFilesAction((Provider<Boolean>)isMergeEnabled, (Provider<AgentMode>)agentModeProvider, (Provider<Boolean>)this.getMergeWithExisting(), this.objectFactory, NativeImageExecutableLocator.graalvmHomeProvider(this.providerFactory), () -> inputDirectories, () -> outputDirectories, (Provider<Boolean>)this.getToolchainDetection(), this.execOperations).execute((Task)this);
    }
}

