/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import jakarta.inject.Singleton;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageUtils;

@Singleton
@Produces(value={"multipart/*"})
public class MultiPartWriter
implements MessageBodyWriter<MultiPart> {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final Providers providers;

    public MultiPartWriter(@Context Providers providers) {
        this.providers = providers;
    }

    public long getSize(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    public void writeTo(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream stream) throws IOException, WebApplicationException {
        Object value;
        if (entity.getBodyParts() == null || entity.getBodyParts().size() < 1) {
            throw new IllegalArgumentException(LocalizationMessages.MUST_SPECIFY_BODY_PART());
        }
        if (entity.getParent() == null && (value = headers.getFirst((Object)"MIME-Version")) == null) {
            headers.putSingle((Object)"MIME-Version", (Object)"1.0");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, MessageUtils.getCharset((MediaType)mediaType)));
        MediaType boundaryMediaType = Boundary.addBoundary(mediaType);
        if (boundaryMediaType != mediaType) {
            headers.putSingle((Object)"Content-Type", (Object)boundaryMediaType.toString());
        }
        String boundaryString = (String)boundaryMediaType.getParameters().get("boundary");
        boolean isFirst = true;
        for (BodyPart bodyPart : entity.getBodyParts()) {
            MessageBodyWriter bodyWriter;
            if (isFirst) {
                isFirst = false;
                writer.write("--");
            } else {
                writer.write("\r\n--");
            }
            writer.write(boundaryString);
            writer.write("\r\n");
            MediaType bodyMediaType = bodyPart.getMediaType();
            if (bodyMediaType == null) {
                throw new IllegalArgumentException(LocalizationMessages.MISSING_MEDIA_TYPE_OF_BODY_PART());
            }
            MultivaluedMap<String, String> bodyHeaders = bodyPart.getHeaders();
            bodyHeaders.putSingle((Object)"Content-Type", (Object)bodyMediaType.toString());
            if (bodyHeaders.getFirst((Object)"Content-Disposition") == null && bodyPart.getContentDisposition() != null) {
                bodyHeaders.putSingle((Object)"Content-Disposition", (Object)bodyPart.getContentDisposition().toString());
            }
            for (Map.Entry entry : bodyHeaders.entrySet()) {
                writer.write((String)entry.getKey());
                ((Writer)writer).write(58);
                boolean first = true;
                for (String value2 : (List)entry.getValue()) {
                    if (first) {
                        ((Writer)writer).write(32);
                        first = false;
                    } else {
                        ((Writer)writer).write(44);
                    }
                    writer.write(value2);
                }
                writer.write("\r\n");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            Object bodyEntity = bodyPart.getEntity();
            if (bodyEntity == null) {
                throw new IllegalArgumentException(LocalizationMessages.MISSING_ENTITY_OF_BODY_PART(bodyMediaType));
            }
            Class bodyClass = bodyEntity.getClass();
            if (bodyEntity instanceof BodyPartEntity) {
                bodyClass = InputStream.class;
                bodyEntity = ((BodyPartEntity)bodyEntity).getInputStream();
            }
            Type bodyType = bodyClass;
            if (GenericEntity.class.isInstance(bodyEntity)) {
                bodyClass = ((GenericEntity)bodyEntity).getRawType();
                bodyType = ((GenericEntity)bodyEntity).getType();
                bodyEntity = ((GenericEntity)bodyEntity).getEntity();
            }
            if ((bodyWriter = this.providers.getMessageBodyWriter(bodyClass, bodyType, EMPTY_ANNOTATIONS, bodyMediaType)) == null) {
                throw new IllegalArgumentException(LocalizationMessages.NO_AVAILABLE_MBW(bodyClass, bodyMediaType));
            }
            bodyWriter.writeTo(bodyEntity, bodyClass, (Type)bodyClass, EMPTY_ANNOTATIONS, bodyMediaType, bodyHeaders, stream);
        }
        writer.write("\r\n--");
        writer.write(boundaryString);
        writer.write("--\r\n");
        ((Writer)writer).flush();
    }
}

