/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.Sse;
import org.glassfish.jersey.ext.cdi1x.inject.internal.JerseyContext;
import org.glassfish.jersey.ext.cdi1x.inject.internal.ServletReferenceProducer;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

class InjectExtension
implements Extension {
    private static final Class<?> WEB_CONFIG_CLASS = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)"org.glassfish.jersey.servlet.WebConfig"));
    private AnnotatedType<ServletReferenceProducer> interceptorAnnotatedType;
    private static final LazyValue<Set<Class<?>>> JERSEY_BOUND_INJECTABLES = Values.lazy(() -> InjectExtension.sumNonJerseyBoundInjectables());

    InjectExtension() {
    }

    private void processAnnotatedType(@Observes ProcessAnnotatedType<?> processAnnotatedType, BeanManager beanManager) {
        Class baseClass = (Class)processAnnotatedType.getAnnotatedType().getBaseType();
        if (Application.class.isAssignableFrom(baseClass) && Configuration.class.isAssignableFrom(baseClass) && !baseClass.isAnnotationPresent(Alternative.class)) {
            processAnnotatedType.veto();
        }
    }

    private void beforeDiscoveryObserver(@Observes BeforeBeanDiscovery bbf, BeanManager beanManager) {
        if (WEB_CONFIG_CLASS != null) {
            this.interceptorAnnotatedType = beanManager.createAnnotatedType(ServletReferenceProducer.class);
            bbf.addAnnotatedType(this.interceptorAnnotatedType, ServletReferenceProducer.class.getName());
        }
        CdiComponentProvider.addHK2DepenendencyCheck(InjectExtension::isHK2Dependency);
    }

    private void afterDiscoveryObserver(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        if (WEB_CONFIG_CLASS != null) {
            abd.addBean((Bean)new ServletReferenceProducerBean(beanManager));
        }
    }

    private static final boolean isHK2Dependency(Class<?> clazz) {
        return ((Set)JERSEY_BOUND_INJECTABLES.get()).contains(clazz);
    }

    private static Set<Class<?>> sumNonJerseyBoundInjectables() {
        HashSet injectables = new HashSet();
        injectables.add(Application.class);
        injectables.add(Configuration.class);
        injectables.add(ContainerRequestContext.class);
        injectables.add(HttpHeaders.class);
        injectables.add(ParamConverterProvider.class);
        injectables.add(Providers.class);
        injectables.add(Request.class);
        injectables.add(ResourceContext.class);
        injectables.add(ResourceInfo.class);
        injectables.add(SecurityContext.class);
        injectables.add(Sse.class);
        injectables.add(UriInfo.class);
        return injectables;
    }

    private static class CdiAnyAnnotation
    extends AnnotationLiteral<Any>
    implements Any {
        private static final long serialVersionUID = 1L;

        private CdiAnyAnnotation() {
        }
    }

    private static class CdiJerseyContextAnnotation
    extends AnnotationLiteral<JerseyContext>
    implements JerseyContext {
        private static final long serialVersionUID = 1L;

        private CdiJerseyContextAnnotation() {
        }
    }

    @Singleton
    private final class ServletReferenceProducerBean
    implements Bean<ServletReferenceProducer>,
    PassivationCapable {
        private final Set<Annotation> qualifiers = new HashSet<Annotation>();
        private final Set<Type> types = new HashSet<Type>(2);
        private final InjectionTarget<ServletReferenceProducer> interceptorTarget;
        private final String id = UUID.randomUUID().toString();

        private ServletReferenceProducerBean(BeanManager beanManager) {
            this.qualifiers.add(new CdiJerseyContextAnnotation());
            this.qualifiers.add((Annotation)((Object)new CdiAnyAnnotation()));
            this.types.add((Type)((Object)ServletReferenceProducer.class));
            this.types.add((Type)((Object)Object.class));
            AnnotatedType interceptorType = InjectExtension.this.interceptorAnnotatedType;
            InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(interceptorType);
            this.interceptorTarget = injectionTargetFactory.createInjectionTarget(null);
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return RequestScoped.class;
        }

        public String getName() {
            return ServletReferenceProducer.class.getName();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public ServletReferenceProducer create(CreationalContext<ServletReferenceProducer> creationalContext) {
            ServletReferenceProducer result = (ServletReferenceProducer)this.interceptorTarget.produce(creationalContext);
            this.interceptorTarget.inject((Object)result, creationalContext);
            this.interceptorTarget.postConstruct((Object)result);
            return result;
        }

        public void destroy(ServletReferenceProducer servletProducer, CreationalContext<ServletReferenceProducer> creationalContext) {
            this.interceptorTarget.preDestroy((Object)servletProducer);
            this.interceptorTarget.dispose((Object)servletProducer);
            creationalContext.release();
        }

        public Class<?> getBeanClass() {
            return ServletReferenceProducer.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.interceptorTarget.getInjectionPoints();
        }

        public boolean isNullable() {
            return false;
        }

        public String getId() {
            return this.id;
        }
    }
}

