/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import jakarta.ws.rs.core.Application;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.spi.ExecutorServiceProvider;
import org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;

class NettyHttpContainer
implements Container {
    private volatile ApplicationHandler appHandler;

    public NettyHttpContainer(Application application) {
        this.appHandler = new ApplicationHandler(application);
        this.appHandler.onStartup((Container)this);
    }

    NettyHttpContainer(Class<? extends Application> applicationClass) {
        this.appHandler = new ApplicationHandler(applicationClass);
        this.appHandler.onStartup((Container)this);
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    public void reload() {
        this.reload(new ResourceConfig(this.appHandler.getConfiguration()));
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration);
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
    }

    ExecutorService getExecutorService() {
        return ((ExecutorServiceProvider)this.appHandler.getInjectionManager().getInstance(ExecutorServiceProvider.class)).getExecutorService();
    }

    ScheduledExecutorService getScheduledExecutorService() {
        return ((ScheduledExecutorServiceProvider)this.appHandler.getInjectionManager().getInstance(ScheduledExecutorServiceProvider.class)).getExecutorService();
    }
}

