/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.faces.facelets.tag.jsf.core;

import javax.faces.view.facelets.*;

/**
 * Register a named Validator instance on the UIComponent associated with the
 * closest parent UIComponent custom action.<p/> See <a target="_new"
 * href="http://java.sun.com/j2ee/javaserverfaces/1.1_01/docs/tlddocs/f/validator.html">tag
 * documentation</a>.
 * 
 * @author Jacob Hookom
 * @version $Id$
 */
public final class ValidateDelegateHandler extends ValidatorHandler {

    private final TagAttribute validatorId;

    public ValidateDelegateHandler(ValidatorConfig config) {
        super(config);
        this.validatorId = this.getAttribute("validatorId");
    }

    /**
     * Resolve the validator id from the attribute "validatorId", which is then used to create a new
     * Validator instance from the Application.
     * 
     * @see javax.faces.application.Application#createValidator(java.lang.String)
     */
    protected String getValidator(FaceletContext ctx) {
        return ((validatorId != null) ? this.validatorId.getValue(ctx) : null);
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type) {
        return super.createMetaRuleset(type).ignoreAll();
    }

}
