/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.util.List;
import org.fusesource.hawtjni.generator.JNIGenerator;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIMethod;

public class StatsGenerator
extends JNIGenerator {
    boolean header;

    public StatsGenerator(boolean header) {
        this.header = header;
    }

    @Override
    public void generateCopyright() {
        this.outputln(StatsGenerator.fixDelimiter(this.getCopyright()));
    }

    @Override
    public void generateIncludes() {
        if (!this.header) {
            this.outputln("#include \"hawtjni.h\"");
            this.outputln("#include \"" + this.getOutputName() + "_stats.h\"");
            this.outputln();
        }
    }

    @Override
    public void generate(JNIClass clazz) {
        if (this.header) {
            this.generateHeaderFile(clazz);
        } else {
            this.generateSourceFile(clazz);
        }
    }

    void generateHeaderFile(JNIClass clazz) {
        this.generateNATIVEMacros(clazz);
        List<JNIMethod> methods = clazz.getDeclaredMethods();
        StatsGenerator.sortMethods(methods);
        this.generateFunctionEnum(methods);
    }

    void generateNATIVEMacros(JNIClass clazz) {
        String className = clazz.getSimpleName();
        this.outputln("#ifdef NATIVE_STATS");
        this.output("extern int ");
        this.output(className);
        this.outputln("_nativeFunctionCount;");
        this.output("extern int ");
        this.output(className);
        this.outputln("_nativeFunctionCallCount[];");
        this.output("extern char* ");
        this.output(className);
        this.outputln("_nativeFunctionNames[];");
        this.output("#define ");
        this.output(className);
        this.output("_NATIVE_ENTER(env, that, func) ");
        this.output(className);
        this.outputln("_nativeFunctionCallCount[func]++;");
        this.output("#define ");
        this.output(className);
        this.outputln("_NATIVE_EXIT(env, that, func) ");
        this.outputln("#else");
        this.output("#ifndef ");
        this.output(className);
        this.outputln("_NATIVE_ENTER");
        this.output("#define ");
        this.output(className);
        this.outputln("_NATIVE_ENTER(env, that, func) ");
        this.outputln("#endif");
        this.output("#ifndef ");
        this.output(className);
        this.outputln("_NATIVE_EXIT");
        this.output("#define ");
        this.output(className);
        this.outputln("_NATIVE_EXIT(env, that, func) ");
        this.outputln("#endif");
        this.outputln("#endif");
        this.outputln();
    }

    void generateSourceFile(JNIClass clazz) {
        this.outputln("#ifdef NATIVE_STATS");
        this.outputln();
        List<JNIMethod> methods = clazz.getDeclaredMethods();
        int methodCount = 0;
        for (JNIMethod method : methods) {
            if ((method.getModifiers() & 0x100) == 0) continue;
            ++methodCount;
        }
        String className = clazz.getSimpleName();
        this.output("int ");
        this.output(className);
        this.output("_nativeFunctionCount = ");
        this.output(String.valueOf(methodCount));
        this.outputln(";");
        this.output("int ");
        this.output(className);
        this.output("_nativeFunctionCallCount[");
        this.output(String.valueOf(methodCount));
        this.outputln("];");
        this.output("char * ");
        this.output(className);
        this.outputln("_nativeFunctionNames[] = {");
        StatsGenerator.sortMethods(methods);
        for (JNIMethod method : methods) {
            String function64;
            if ((method.getModifiers() & 0x100) == 0) continue;
            String function = StatsGenerator.getFunctionName(method);
            if (!function.equals(function64 = StatsGenerator.getFunctionName(method, method.getParameterTypes64()))) {
                this.output("#ifndef ");
                this.output("JNI64");
                this.outputln();
            }
            this.output("\t\"");
            this.output(function);
            this.outputln("\",");
            if (!function.equals(function64)) {
                this.outputln("#else");
                this.output("\t\"");
                this.output(function64);
                this.outputln("\",");
                this.outputln("#endif");
            }
            if (this.progress == null) continue;
            this.progress.step();
        }
        this.outputln("};");
        this.outputln();
        this.generateStatsNatives(className);
        this.outputln();
        this.outputln("#endif");
    }

    void generateStatsNatives(String className) {
        this.outputln("#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func");
        this.outputln();
        this.output("JNIEXPORT jint JNICALL STATS_NATIVE(");
        this.output(StatsGenerator.toC(className + "_GetFunctionCount"));
        this.outputln(")");
        this.outputln("\t(JNIEnv *env, jclass that)");
        this.outputln("{");
        this.output("\treturn ");
        this.output(className);
        this.outputln("_nativeFunctionCount;");
        this.outputln("}");
        this.outputln();
        this.output("JNIEXPORT jstring JNICALL STATS_NATIVE(");
        this.output(StatsGenerator.toC(className + "_GetFunctionName"));
        this.outputln(")");
        this.outputln("\t(JNIEnv *env, jclass that, jint index)");
        this.outputln("{");
        this.output("\treturn ");
        if (this.isCPP) {
            this.output("env->NewStringUTF(");
        } else {
            this.output("(*env)->NewStringUTF(env, ");
        }
        this.output(className);
        this.outputln("_nativeFunctionNames[index]);");
        this.outputln("}");
        this.outputln();
        this.output("JNIEXPORT jint JNICALL STATS_NATIVE(");
        this.output(StatsGenerator.toC(className + "_GetFunctionCallCount"));
        this.outputln(")");
        this.outputln("\t(JNIEnv *env, jclass that, jint index)");
        this.outputln("{");
        this.output("\treturn ");
        this.output(className);
        this.outputln("_nativeFunctionCallCount[index];");
        this.outputln("}");
    }

    void generateFunctionEnum(List<JNIMethod> methods) {
        if (methods.isEmpty()) {
            return;
        }
        this.outputln("typedef enum {");
        for (JNIMethod method : methods) {
            String function64;
            if ((method.getModifiers() & 0x100) == 0) continue;
            String function = StatsGenerator.getFunctionName(method);
            if (!function.equals(function64 = StatsGenerator.getFunctionName(method, method.getParameterTypes64()))) {
                this.output("#ifndef ");
                this.output("JNI64");
                this.outputln();
            }
            this.output("\t");
            this.output(method.getDeclaringClass().getSimpleName() + "_" + function);
            this.outputln("_FUNC,");
            if (!function.equals(function64)) {
                this.outputln("#else");
                this.output("\t");
                this.output(method.getDeclaringClass().getSimpleName() + "_" + function64);
                this.outputln("_FUNC,");
                this.outputln("#endif");
            }
            if (this.progress == null) continue;
            this.progress.step();
        }
        JNIClass clazz = methods.get(0).getDeclaringClass();
        this.output("} ");
        this.output(clazz.getSimpleName());
        this.outputln("_FUNCS;");
    }
}

