/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtjni.generator.JNIGenerator;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIField;
import org.fusesource.hawtjni.generator.model.JNIFieldAccessor;
import org.fusesource.hawtjni.generator.model.JNIMethod;
import org.fusesource.hawtjni.generator.model.JNIParameter;
import org.fusesource.hawtjni.generator.model.JNIType;
import org.fusesource.hawtjni.runtime.ArgFlag;
import org.fusesource.hawtjni.runtime.ClassFlag;
import org.fusesource.hawtjni.runtime.FieldFlag;
import org.fusesource.hawtjni.runtime.MethodFlag;

public class NativesGenerator
extends JNIGenerator {
    boolean enterExitMacro = true;

    @Override
    public void generateCopyright() {
        this.outputln(NativesGenerator.fixDelimiter(this.getCopyright()));
    }

    @Override
    public void generateIncludes() {
        String outputName = this.getOutputName();
        this.outputln("#include \"" + outputName + ".h\"");
        this.outputln("#include \"hawtjni.h\"");
        this.outputln("#include \"" + outputName + "_structs.h\"");
        this.outputln("#include \"" + outputName + "_stats.h\"");
        this.outputln();
    }

    @Override
    public void generate(JNIClass clazz) {
        List<JNIMethod> methods = clazz.getNativeMethods();
        if (methods.isEmpty()) {
            return;
        }
        NativesGenerator.sortMethods(methods);
        this.generateNativeMacro(clazz);
        this.generate(methods);
    }

    public void generate(List<JNIMethod> methods) {
        NativesGenerator.sortMethods(methods);
        for (JNIMethod method : methods) {
            if ((method.getModifiers() & 0x100) == 0) continue;
            this.generate(method);
            if (this.progress == null) continue;
            this.progress.step();
        }
    }

    boolean isStruct(ArgFlag[] flags) {
        for (ArgFlag flag : flags) {
            if (!flag.equals((Object)ArgFlag.BY_VALUE)) continue;
            return true;
        }
        return false;
    }

    void generateCallback(JNIMethod method, String function, List<JNIParameter> params, JNIType returnType) {
        int i;
        this.output("static jintLong ");
        this.output(function);
        this.outputln(";");
        this.output("static ");
        String[] types = method.getCallbackTypes();
        ArgFlag[][] flags = method.getCallbackFlags();
        this.output(types[0]);
        this.output(" ");
        this.output("proc_");
        this.output(function);
        this.output("(");
        boolean first = true;
        for (i = 1; i < types.length; ++i) {
            if (!first) {
                this.output(", ");
            }
            this.output(types[i]);
            this.output(" ");
            this.output("arg");
            this.output(String.valueOf(i - 1));
            first = false;
        }
        this.outputln(") {");
        this.output("\t");
        if (this.isStruct(flags[0])) {
            this.output(types[0]);
            this.output("* lprc = ");
        } else if (!types[0].equals("void")) {
            this.output("return ");
        }
        this.output("((");
        this.output(types[0]);
        if (this.isStruct(flags[0])) {
            this.output("*");
        }
        this.output(" (*)(");
        first = true;
        for (i = 1; i < types.length; ++i) {
            if (!first) {
                this.output(", ");
            }
            first = false;
            this.output(types[i]);
            if (!this.isStruct(flags[i])) continue;
            this.output("*");
        }
        this.output("))");
        this.output(function);
        this.output(")(");
        first = true;
        for (i = 1; i < types.length; ++i) {
            if (!first) {
                this.output(", ");
            }
            first = false;
            if (this.isStruct(flags[i])) {
                this.output("&");
            }
            this.output("arg");
            this.output(String.valueOf(i - 1));
        }
        this.outputln(");");
        if (this.isStruct(flags[0])) {
            this.output("\t");
            this.output(types[0]);
            this.outputln(" rc;");
            this.outputln("\tif (lprc) {");
            this.outputln("\t\trc = *lprc;");
            this.outputln("\t\tfree(lprc);");
            this.outputln("\t} else {");
            this.output("\t\tmemset(&rc, 0, sizeof(");
            this.output(types[0]);
            this.outputln("));");
            this.outputln("\t}");
            this.outputln("\treturn rc;");
        }
        this.outputln("}");
        this.output("static jintLong ");
        this.output(method.getName());
        this.outputln("(jintLong func) {");
        this.output("\t");
        this.output(function);
        this.outputln(" = func;");
        this.output("\treturn (jintLong)proc_");
        this.output(function);
        this.outputln(";");
        this.outputln("}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateConstantsInitializer(JNIMethod method) {
        JNIClass clazz = method.getDeclaringClass();
        ArrayList<JNIField> constants = this.getConstantFields(clazz);
        if (constants.isEmpty()) {
            return;
        }
        if (this.isCPP) {
            this.output("extern \"C\" ");
        }
        this.outputln("JNIEXPORT void JNICALL " + clazz.getSimpleName() + "_NATIVE(" + NativesGenerator.toC(method.getName()) + ")(JNIEnv *env, jclass that)");
        this.outputln("{");
        for (JNIField field : constants) {
            JNIType type64;
            JNIType type;
            String conditional = field.getConditional();
            if (conditional != null) {
                this.outputln("#if " + conditional);
            }
            boolean allowConversion = !(type = field.getType()).equals(type64 = field.getType64());
            String simpleName = type.getSimpleName();
            JNIFieldAccessor accessor = field.getAccessor();
            String fieldId = "(*env)->GetStaticFieldID(env, that, \"" + field.getName() + "\", \"" + type.getTypeSignature(allowConversion) + "\")";
            if (this.isCPP) {
                fieldId = "env->GetStaticFieldID(that, \"" + field.getName() + "\", \"" + type.getTypeSignature(allowConversion) + "\")";
            }
            if (type.isPrimitive()) {
                if (this.isCPP) {
                    this.output("\tenv->SetStatic" + type.getTypeSignature1(allowConversion) + "Field(that, " + fieldId + ", ");
                } else {
                    this.output("\t(*env)->SetStatic" + type.getTypeSignature1(allowConversion) + "Field(env, that, " + fieldId + ", ");
                }
                this.output("(" + type.getTypeSignature2(allowConversion) + ")");
                if (field.isPointer()) {
                    this.output("(intptr_t)");
                }
                this.output(accessor.getter());
                this.output(");");
            } else if (type.isArray()) {
                JNIType componentType = type.getComponentType();
                JNIType componentType64 = type64.getComponentType();
                if (!componentType.isPrimitive()) throw new Error("not done");
                this.outputln("\t{");
                this.output("\t");
                this.output(type.getTypeSignature2(allowConversion));
                this.output(" lpObject1 = (");
                this.output(type.getTypeSignature2(allowConversion));
                if (this.isCPP) {
                    this.output(")env->GetStaticObjectField(that, ");
                } else {
                    this.output(")(*env)->GetStaticObjectField(env, that, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output(fieldId);
                this.outputln(");");
                if (this.isCPP) {
                    this.output("\tenv->Set");
                } else {
                    this.output("\t(*env)->Set");
                }
                this.output(componentType.getTypeSignature1(!componentType.equals(componentType64)));
                if (this.isCPP) {
                    this.output("ArrayRegion(lpObject1, 0, sizeof(");
                } else {
                    this.output("ArrayRegion(env, lpObject1, 0, sizeof(");
                }
                this.output(accessor.getter());
                this.output(")");
                if (!componentType.isType("byte")) {
                    this.output(" / sizeof(");
                    this.output(componentType.getTypeSignature2(!componentType.equals(componentType64)));
                    this.output(")");
                }
                this.output(", (");
                this.output(type.getTypeSignature4(allowConversion, false));
                this.output(")");
                this.output(accessor.getter());
                this.outputln(");");
                this.output("\t}");
            } else {
                this.outputln("\t{");
                if (this.isCPP) {
                    this.output("\tjobject lpObject1 = env->GetStaticObjectField(that, ");
                } else {
                    this.output("\tjobject lpObject1 = (*env)->GetStaticObjectField(env, that, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output("Fc.");
                this.output(field.getName());
                this.outputln(");");
                this.output("\tif (lpObject1 != NULL) set");
                this.output(simpleName);
                this.output("Fields(env, lpObject1, &lpStruct->");
                this.output(accessor.getter());
                this.outputln(");");
                this.output("\t}");
            }
            this.outputln();
            if (conditional == null) continue;
            this.outputln("#endif");
        }
        this.outputln("   return;");
        this.outputln("}");
    }

    private ArrayList<JNIField> getConstantFields(JNIClass clazz) {
        ArrayList<JNIField> rc = new ArrayList<JNIField>();
        List<JNIField> fields = clazz.getDeclaredFields();
        for (JNIField field : fields) {
            int mods = field.getModifiers();
            if ((mods & 8) == 0 || !field.getFlag(FieldFlag.CONSTANT)) continue;
            rc.add(field);
        }
        return rc;
    }

    public void generate(JNIMethod method) {
        String function64;
        if (method.getFlag(MethodFlag.METHOD_SKIP)) {
            return;
        }
        JNIType returnType = method.getReturnType32();
        JNIType returnType64 = method.getReturnType64();
        if (method.getFlag(MethodFlag.CONSTANT_INITIALIZER)) {
            if (returnType.isType("void") && method.getParameters().isEmpty()) {
                this.generateConstantsInitializer(method);
            } else {
                this.output("#error Warning: invalid CONSTANT_INITIALIZER tagged method. It must be void and take no arguments: ");
                this.outputln(method.toString());
            }
            return;
        }
        if (!(returnType.isType("void") || returnType.isPrimitive() || this.isSystemClass(returnType) || returnType.isType("java.lang.String"))) {
            this.output("#error Warning: bad return type. :");
            this.outputln(method.toString());
            return;
        }
        String conditional = method.getConditional();
        if (conditional != null) {
            this.outputln("#if " + conditional);
        }
        List<JNIParameter> params = method.getParameters();
        String function = NativesGenerator.getFunctionName(method);
        boolean sameFunction = function.equals(function64 = NativesGenerator.getFunctionName(method, method.getParameterTypes64()));
        if (!sameFunction) {
            this.output("#ifndef ");
            this.output("JNI64");
            this.outputln();
        }
        if (this.isCPP) {
            this.output("extern \"C\" ");
            this.generateFunctionPrototype(method, function, params, returnType, returnType64, true);
            this.outputln(";");
        }
        if (function.startsWith("CALLBACK_")) {
            this.generateCallback(method, function, params, returnType);
        }
        this.generateFunctionPrototype(method, function, params, returnType, returnType64, !sameFunction);
        if (!function.equals(function64)) {
            this.outputln();
            this.outputln("#else");
            if (this.isCPP) {
                this.output("extern \"C\" ");
                this.generateFunctionPrototype(method, function64, params, returnType, returnType64, true);
                this.outputln(";");
            }
            this.generateFunctionPrototype(method, function64, params, returnType, returnType64, !sameFunction);
            this.outputln();
            this.outputln("#endif");
        }
        this.generateFunctionBody(method, function, function64, params, returnType, returnType64);
        if (conditional != null) {
            this.outputln("#endif");
        }
        this.outputln();
    }

    public void setEnterExitMacro(boolean enterExitMacro) {
        this.enterExitMacro = enterExitMacro;
    }

    void generateNativeMacro(JNIClass clazz) {
        this.output("#define ");
        this.output(clazz.getSimpleName());
        this.output("_NATIVE(func) Java_");
        this.output(NativesGenerator.toC(clazz.getName()));
        this.outputln("_##func");
        this.outputln();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateGetParameter(JNIMethod method, JNIParameter param, boolean critical, int indent) {
        JNIType paramType = param.getType32();
        JNIType paramType64 = param.getType64();
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return false;
        }
        String iStr = String.valueOf(param.getParameter());
        for (int j = 0; j < indent; ++j) {
            this.output("\t");
        }
        this.output("if (arg");
        this.output(iStr);
        this.output(") if ((lparg");
        this.output(iStr);
        this.output(" = ");
        if (paramType.isArray()) {
            JNIType componentType = paramType.getComponentType();
            if (!componentType.isPrimitive()) throw new Error("not done");
            if ("long".equals(componentType.getName()) && param.isPointer()) {
                this.output("hawtjni_malloc_pointer_array(env, arg");
                this.output(iStr);
                this.output(")");
            } else if (critical) {
                if (this.isCPP) {
                    this.output("(");
                    this.output(componentType.getTypeSignature2(!paramType.equals(paramType64)));
                    this.output("*)");
                    this.output("env->GetPrimitiveArrayCritical(arg");
                } else {
                    this.output("(*env)->GetPrimitiveArrayCritical(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            } else {
                if (this.isCPP) {
                    this.output("env->Get");
                } else {
                    this.output("(*env)->Get");
                }
                this.output(componentType.getTypeSignature1(!paramType.equals(paramType64)));
                if (this.isCPP) {
                    this.output("ArrayElements(arg");
                } else {
                    this.output("ArrayElements(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            }
        } else if (paramType.isType("java.lang.String")) {
            if (param.getFlag(ArgFlag.UNICODE)) {
                if (this.isCPP) {
                    this.output("env->GetStringChars(arg");
                } else {
                    this.output("(*env)->GetStringChars(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            } else {
                if (this.isCPP) {
                    this.output("env->GetStringUTFChars(arg");
                } else {
                    this.output("(*env)->GetStringUTFChars(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            }
        } else if (param.getFlag(ArgFlag.NO_IN)) {
            this.output("&_arg");
            this.output(iStr);
        } else {
            this.output("get");
            this.output(paramType.getSimpleName());
            this.output("Fields(env, arg");
            this.output(iStr);
            this.output(", &_arg");
            this.output(iStr);
            this.output(")");
        }
        this.outputln(") == NULL) goto fail;");
        return true;
    }

    void generateSetParameter(JNIParameter param, boolean critical) {
        JNIType paramType = param.getType32();
        JNIType paramType64 = param.getType64();
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return;
        }
        String iStr = String.valueOf(param.getParameter());
        if (paramType.isArray()) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            JNIType componentType = paramType.getComponentType();
            if (componentType.isPrimitive()) {
                if ("long".equals(componentType.getName()) && param.isPointer()) {
                    this.output("hawtjni_free_pointer_array(env, arg");
                    this.output(iStr);
                } else if (critical) {
                    if (this.isCPP) {
                        this.output("env->ReleasePrimitiveArrayCritical(arg");
                    } else {
                        this.output("(*env)->ReleasePrimitiveArrayCritical(env, arg");
                    }
                    this.output(iStr);
                } else {
                    if (this.isCPP) {
                        this.output("env->Release");
                    } else {
                        this.output("(*env)->Release");
                    }
                    this.output(componentType.getTypeSignature1(!paramType.equals(paramType64)));
                    if (this.isCPP) {
                        this.output("ArrayElements(arg");
                    } else {
                        this.output("ArrayElements(env, arg");
                    }
                    this.output(iStr);
                }
                this.output(", lparg");
                this.output(iStr);
                this.output(", ");
                if (param.getFlag(ArgFlag.NO_OUT)) {
                    this.output("JNI_ABORT");
                } else {
                    this.output("0");
                }
            } else {
                throw new Error("not done");
            }
            this.output(");");
            this.outputln();
        } else if (paramType.isType("java.lang.String")) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            if (param.getFlag(ArgFlag.UNICODE)) {
                if (this.isCPP) {
                    this.output("env->ReleaseStringChars(arg");
                } else {
                    this.output("(*env)->ReleaseStringChars(env, arg");
                }
            } else if (this.isCPP) {
                this.output("env->ReleaseStringUTFChars(arg");
            } else {
                this.output("(*env)->ReleaseStringUTFChars(env, arg");
            }
            this.output(iStr);
            this.output(", lparg");
            this.output(iStr);
            this.outputln(");");
        } else if (!param.getFlag(ArgFlag.NO_OUT)) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            this.output("set");
            this.output(paramType.getSimpleName());
            this.output("Fields(env, arg");
            this.output(iStr);
            this.output(", lparg");
            this.output(iStr);
            this.outputln(");");
        }
    }

    void generateEnterExitMacro(JNIMethod method, String function, String function64, boolean enter) {
        if (!this.enterExitMacro) {
            return;
        }
        if (!function.equals(function64)) {
            this.output("#ifndef ");
            this.output("JNI64");
            this.outputln();
        }
        this.output("\t");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_NATIVE_");
        this.output(enter ? "ENTER" : "EXIT");
        this.output("(env, that, ");
        this.output(method.getDeclaringClass().getSimpleName() + "_" + function);
        this.outputln("_FUNC);");
        if (!function.equals(function64)) {
            this.outputln("#else");
            this.output("\t");
            this.output(method.getDeclaringClass().getSimpleName());
            this.output("_NATIVE_");
            this.output(enter ? "ENTER" : "EXIT");
            this.output("(env, that, ");
            this.output(method.getDeclaringClass().getSimpleName() + "_" + function64);
            this.outputln("_FUNC);");
            this.outputln("#endif");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateLocalVars(JNIMethod method, List<JNIParameter> params, JNIType returnType, JNIType returnType64) {
        boolean needsReturn = this.enterExitMacro;
        for (int i = 0; i < params.size(); ++i) {
            JNIParameter param = params.get(i);
            JNIType paramType = param.getType32();
            JNIType paramType64 = param.getType64();
            if (paramType.isPrimitive() || this.isSystemClass(paramType)) continue;
            this.output("\t");
            if (paramType.isArray()) {
                JNIType componentType = paramType.getComponentType();
                if ("long".equals(componentType.getName()) && param.isPointer()) {
                    this.output("void **lparg" + i + "=NULL;");
                } else {
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.output(componentType.getTypeSignature2(!paramType.equals(paramType64)));
                    this.output(" *lparg" + i);
                    this.output("=NULL;");
                }
            } else if (!paramType.isType("org.fusesource.hawtjni.runtime.JNIEnv")) {
                if (paramType.isType("java.lang.String")) {
                    if (param.getFlag(ArgFlag.UNICODE)) {
                        this.output("const jchar *lparg" + i);
                    } else {
                        this.output("const char *lparg" + i);
                    }
                    this.output("= NULL;");
                } else {
                    if (param.getTypeClass().getFlag(ClassFlag.STRUCT) && !param.getTypeClass().getFlag(ClassFlag.TYPEDEF)) {
                        this.output("struct ");
                    }
                    this.output(paramType.getNativeName());
                    this.output(" _arg" + i);
                    if (param.getFlag(ArgFlag.INIT)) {
                        this.output("={0}");
                    }
                    this.output(", *lparg" + i);
                    this.output("=NULL;");
                }
            }
            this.outputln();
            needsReturn = true;
        }
        if (!needsReturn || returnType.isType("void")) return needsReturn;
        this.output("\t");
        this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
        this.outputln(" rc = 0;");
        return needsReturn;
    }

    boolean generateGetters(JNIMethod method, List<JNIParameter> params) {
        boolean genFailTag = false;
        int criticalCount = 0;
        for (JNIParameter param : params) {
            if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName())) continue;
            if (!this.isCritical(param)) {
                genFailTag |= this.generateGetParameter(method, param, false, 1);
                continue;
            }
            ++criticalCount;
        }
        if (criticalCount != 0) {
            this.outputln("#ifdef JNI_VERSION_1_2");
            this.outputln("\tif (IS_JNI_1_2) {");
            for (JNIParameter param : params) {
                if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName()) || !this.isCritical(param)) continue;
                genFailTag |= this.generateGetParameter(method, param, true, 2);
            }
            this.outputln("\t} else");
            this.outputln("#endif");
            this.outputln("\t{");
            for (JNIParameter param : params) {
                if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName()) || !this.isCritical(param)) continue;
                genFailTag |= this.generateGetParameter(method, param, false, 2);
            }
            this.outputln("\t}");
        }
        return genFailTag;
    }

    void generateSetters(JNIMethod method, List<JNIParameter> params) {
        JNIParameter param;
        int i;
        int criticalCount = 0;
        for (i = params.size() - 1; i >= 0; --i) {
            param = params.get(i);
            if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName()) || !this.isCritical(param)) continue;
            ++criticalCount;
        }
        if (criticalCount != 0) {
            this.outputln("#ifdef JNI_VERSION_1_2");
            this.outputln("\tif (IS_JNI_1_2) {");
            for (i = params.size() - 1; i >= 0; --i) {
                param = params.get(i);
                if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName()) || !this.isCritical(param)) continue;
                this.output("\t");
                this.generateSetParameter(param, true);
            }
            this.outputln("\t} else");
            this.outputln("#endif");
            this.outputln("\t{");
            for (i = params.size() - 1; i >= 0; --i) {
                param = params.get(i);
                if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName()) || !this.isCritical(param)) continue;
                this.output("\t");
                this.generateSetParameter(param, false);
            }
            this.outputln("\t}");
        }
        for (i = params.size() - 1; i >= 0; --i) {
            param = params.get(i);
            if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName()) || this.isCritical(param)) continue;
            this.generateSetParameter(param, false);
        }
    }

    void generateDynamicFunctionCall(JNIMethod method, List<JNIParameter> params, JNIType returnType, JNIType returnType64, boolean needsReturn) {
        this.outputln("/*");
        this.generateFunctionCall(method, params, returnType, returnType64, needsReturn);
        this.outputln("*/");
        this.outputln("\t{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        this.output("\t\tLOAD_FUNCTION(fp, ");
        this.output(name);
        this.outputln(")");
        this.outputln("\t\tif (fp) {");
        this.output("\t\t");
        this.generateFunctionCallLeftSide(method, returnType, returnType64, needsReturn);
        this.output("((");
        this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
        this.output(" (CALLING_CONVENTION*)(");
        for (int i = 0; i < params.size(); ++i) {
            JNIType paramType64;
            JNIType paramType;
            if (i != 0) {
                this.output(", ");
            }
            JNIParameter param = params.get(i);
            String cast = param.getCast();
            if (param.isPointer()) {
                this.output("(intptr_t)");
            }
            boolean isStruct = param.getFlag(ArgFlag.BY_VALUE);
            if (cast.length() > 2) {
                int index;
                cast = cast.substring(1, cast.length() - 1);
                if (isStruct && (index = cast.lastIndexOf(42)) != -1) {
                    cast = cast.substring(0, index).trim();
                }
                this.output(cast);
                continue;
            }
            this.output(paramType.getTypeSignature4(!(paramType = param.getType32()).equals(paramType64 = param.getType64()), isStruct));
        }
        this.output("))");
        this.output("fp");
        this.output(")");
        this.generateFunctionCallRightSide(method, params, 0);
        this.output(";");
        this.outputln();
        this.outputln("\t\t}");
        this.outputln("\t}");
    }

    void generateFunctionCallLeftSide(JNIMethod method, JNIType returnType, JNIType returnType64, boolean needsReturn) {
        this.output("\t");
        if (!returnType.isType("void")) {
            if (needsReturn) {
                this.output("rc = ");
            } else {
                this.output("return ");
            }
            String cast = method.getCast();
            if (cast.length() != 0 && !cast.equals("()")) {
                if (method.isPointer()) {
                    this.output("(intptr_t)");
                }
                this.output(cast);
            } else if (method.getFlag(MethodFlag.CPP_NEW)) {
                String[] parts = NativesGenerator.getNativeNameParts(method);
                String className = parts[0];
                this.output("(intptr_t)(" + className + " *)");
            } else {
                this.output("(");
                this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
                this.output(")");
            }
        }
        if (method.getFlag(MethodFlag.ADDRESS)) {
            this.output("&");
        }
        if (method.getFlag(MethodFlag.JNI)) {
            this.output(this.isCPP ? "env->" : "(*env)->");
        }
    }

    void generateFunctionCallRightSide(JNIMethod method, List<JNIParameter> params, int paramStart) {
        if (!method.getFlag(MethodFlag.CONSTANT_GETTER)) {
            this.output("(");
            if (method.getFlag(MethodFlag.JNI) && !this.isCPP) {
                this.output("env, ");
            }
            for (int i = paramStart; i < params.size(); ++i) {
                JNIParameter param = params.get(i);
                if (i != paramStart) {
                    this.output(", ");
                }
                if (param.getFlag(ArgFlag.BY_VALUE)) {
                    this.output("*");
                }
                this.output(param.getCast());
                if (param.isPointer()) {
                    this.output("(intptr_t)");
                }
                if (param.getFlag(ArgFlag.CS_OBJECT)) {
                    this.output("TO_OBJECT(");
                }
                if (i == params.size() - 1 && param.getFlag(ArgFlag.SENTINEL)) {
                    this.output("NULL");
                } else if ("org.fusesource.hawtjni.runtime.JNIEnv".equals(param.getTypeClass().getName())) {
                    this.output("env");
                } else {
                    JNIType paramType = param.getType32();
                    if (!paramType.isPrimitive() && !this.isSystemClass(paramType)) {
                        this.output("lp");
                    }
                    this.output("arg" + i);
                }
                if (!param.getFlag(ArgFlag.CS_OBJECT)) continue;
                this.output(")");
            }
            this.output(")");
        }
    }

    static String[] getNativeNameParts(JNIMethod method) {
        String className = null;
        String methodName = null;
        JNIClass dc = method.getDeclaringClass();
        if (dc.getFlag(ClassFlag.CPP) || dc.getFlag(ClassFlag.STRUCT)) {
            className = method.getDeclaringClass().getNativeName();
        }
        if (method.getAccessor().length() != 0) {
            methodName = method.getAccessor();
            int pos = methodName.lastIndexOf("::");
            if (pos >= 0) {
                className = methodName.substring(0, pos);
                methodName = methodName.substring(pos + 2);
            }
        } else {
            int pos;
            methodName = method.getName();
            if (className == null && (pos = methodName.indexOf("_")) > 0) {
                className = methodName.substring(0, pos);
                methodName = methodName.substring(pos + 1);
            }
        }
        if (className == null) {
            throw new Error(String.format("Could not determine object type name of method '%s'", method.getDeclaringClass().getSimpleName() + "." + method.getName()));
        }
        return new String[]{className, methodName};
    }

    void generateFunctionCall(JNIMethod method, List<JNIParameter> params, JNIType returnType, JNIType returnType64, boolean needsReturn) {
        boolean makeCopy;
        String name = method.getName();
        String copy = method.getCopy();
        boolean bl = makeCopy = copy.length() != 0 && this.isCPP && !returnType.isType("void");
        if (makeCopy) {
            this.output("\t{");
            this.output("\t\t");
            this.output(copy);
            this.output(" temp = ");
        } else {
            this.generateFunctionCallLeftSide(method, returnType, returnType64, needsReturn);
        }
        int paramStart = 0;
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        boolean objc_struct = false;
        if (name.equals("objc_msgSend_stret") || name.equals("objc_msgSendSuper_stret")) {
            objc_struct = true;
        }
        if (objc_struct) {
            this.outputln("if (sizeof(_arg0) > STRUCT_SIZE_LIMIT) {");
            this.generate_objc_msgSend_stret(method, params, name);
            paramStart = 1;
        } else if (name.equalsIgnoreCase("call")) {
            this.output("(");
            JNIParameter param = params.get(0);
            String cast = param.getCast();
            if (cast.length() != 0 && !cast.equals("()")) {
                this.output(cast);
                if (param.isPointer()) {
                    this.output("(intptr_t)");
                }
            } else {
                this.output("(");
                this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
                this.output(" (*)())");
            }
            this.output("arg0)");
            paramStart = 1;
        } else if (name.startsWith("VtblCall") || name.startsWith("_VtblCall")) {
            this.output("((");
            this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
            this.output(" (STDMETHODCALLTYPE *)(");
            for (int i = 1; i < params.size(); ++i) {
                JNIType paramType64;
                JNIParameter param;
                JNIType paramType;
                if (i != 1) {
                    this.output(", ");
                }
                this.output(paramType.getTypeSignature4(!(paramType = (param = params.get(i)).getType32()).equals(paramType64 = param.getType64()), false));
            }
            this.output("))(*(");
            JNIType paramType = params.get(1).getType32();
            JNIType paramType64 = params.get(1).getType64();
            this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), false));
            this.output(" **)arg1)[arg0])");
            paramStart = 1;
        } else if (method.getFlag(MethodFlag.CPP_METHOD) || method.getFlag(MethodFlag.SETTER) || method.getFlag(MethodFlag.GETTER) || method.getFlag(MethodFlag.ADDER)) {
            String cast;
            String[] parts = NativesGenerator.getNativeNameParts(method);
            String className = parts[0];
            String methodName = parts[1];
            if (method.getFlag(MethodFlag.CS_OBJECT)) {
                this.output("TO_HANDLE(");
            }
            this.output("(");
            if (params.isEmpty()) {
                throw new Error(String.format("C++ bound method '%s' missing the 'this' parameter", method.getDeclaringClass().getSimpleName() + "." + method.getName()));
            }
            JNIParameter param = params.get(0);
            if (param.getFlag(ArgFlag.BY_VALUE)) {
                this.output("*");
            }
            if ((cast = param.getCast()).length() != 0 && !cast.equals("()")) {
                this.output(cast);
                if (param.isPointer()) {
                    this.output("(intptr_t)");
                }
            } else {
                this.output("(" + className + " *)(intptr_t)");
            }
            if (param.getFlag(ArgFlag.CS_OBJECT)) {
                this.output("TO_OBJECT(");
            }
            this.output("arg0");
            if (param.getFlag(ArgFlag.CS_OBJECT)) {
                this.output(")");
            }
            this.output(")->");
            this.output(methodName);
            paramStart = 1;
        } else if (method.getFlag(MethodFlag.CS_NEW)) {
            this.output("TO_HANDLE(gcnew ");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                JNIClass dc = method.getDeclaringClass();
                if (dc.getFlag(ClassFlag.CPP) || dc.getFlag(ClassFlag.STRUCT)) {
                    this.output(dc.getNativeName());
                } else {
                    int index = -1;
                    index = name.indexOf(95);
                    if (index != -1) {
                        this.output(name.substring(index + 1));
                    } else {
                        this.output(name);
                    }
                }
            }
        } else if (method.getFlag(MethodFlag.CPP_NEW)) {
            if (method.getFlag(MethodFlag.CS_OBJECT)) {
                this.output("TO_HANDLE(");
            }
            this.output("new ");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                JNIClass dc = method.getDeclaringClass();
                if (dc.getFlag(ClassFlag.CPP)) {
                    this.output(method.getDeclaringClass().getNativeName());
                } else {
                    int index = -1;
                    index = name.indexOf(95);
                    if (index != -1) {
                        this.output(name.substring(index + 1));
                    } else {
                        this.output(name);
                    }
                }
            }
        } else {
            String accessor;
            if (method.getFlag(MethodFlag.CPP_DELETE)) {
                String[] parts = NativesGenerator.getNativeNameParts(method);
                String className = parts[0];
                this.output("delete ");
                JNIParameter param = params.get(0);
                String cast = param.getCast();
                if (cast.length() != 0 && !cast.equals("()")) {
                    this.output(cast);
                    if (param.isPointer()) {
                        this.output("(intptr_t)");
                    }
                } else {
                    this.output("(" + className + " *)(intptr_t)");
                }
                this.outputln("arg0;");
                return;
            }
            if (method.getFlag(MethodFlag.CS_OBJECT)) {
                this.output("TO_HANDLE(");
            }
            if (method.getFlag(MethodFlag.CAST)) {
                this.output("((");
                String returnCast = returnType.getTypeSignature2(!returnType.equals(returnType64));
                if (name.equals("objc_msgSend_bool") && returnCast.equals("jboolean")) {
                    returnCast = "BOOL";
                }
                this.output(returnCast);
                this.output(" (*)(");
                for (int i = 0; i < params.size(); ++i) {
                    JNIParameter param;
                    String cast;
                    if (i != 0) {
                        this.output(", ");
                    }
                    if ((cast = (param = params.get(i)).getCast()).length() != 0 && !cast.equals("()")) {
                        if (cast.startsWith("(")) {
                            cast = cast.substring(1);
                        }
                        if (cast.endsWith(")")) {
                            cast = cast.substring(0, cast.length() - 1);
                        }
                        this.output(cast);
                        continue;
                    }
                    JNIType paramType = param.getType32();
                    JNIType paramType64 = param.getType64();
                    if (!paramType.isPrimitive() && !paramType.isArray() && param.getTypeClass().getFlag(ClassFlag.STRUCT) && !param.getTypeClass().getFlag(ClassFlag.TYPEDEF)) {
                        this.output("struct ");
                    }
                    this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), param.getFlag(ArgFlag.BY_VALUE)));
                }
                this.output("))");
            }
            if ((accessor = method.getAccessor()).length() != 0) {
                this.output(accessor);
            } else {
                this.output(name);
            }
            if (method.getFlag(MethodFlag.CAST)) {
                this.output(")");
            }
        }
        if (method.getFlag(MethodFlag.SETTER) && params.size() == 3 || method.getFlag(MethodFlag.GETTER) && params.size() == 2) {
            this.output("[arg1]");
            ++paramStart;
        }
        if (method.getFlag(MethodFlag.SETTER)) {
            this.output(" = ");
        }
        if (method.getFlag(MethodFlag.ADDER)) {
            this.output(" += ");
        }
        if (!method.getFlag(MethodFlag.GETTER)) {
            this.generateFunctionCallRightSide(method, params, paramStart);
        }
        if (method.getFlag(MethodFlag.CS_NEW) || method.getFlag(MethodFlag.CS_OBJECT)) {
            this.output(")");
        }
        this.output(";");
        this.outputln();
        if (makeCopy) {
            this.outputln("\t\t{");
            this.output("\t\t\t");
            this.output(copy);
            this.output("* copy = new ");
            this.output(copy);
            this.outputln("();");
            this.outputln("\t\t\t*copy = temp;");
            this.output("\t\t\trc = ");
            this.output("(");
            this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
            this.output(")");
            this.outputln("copy;");
            this.outputln("\t\t}");
            this.outputln("\t}");
        }
        if (objc_struct) {
            this.outputln("\t} else {");
            this.generate_objc_msgSend_stret(method, params, name.substring(0, name.length() - "_stret".length()));
            this.generateFunctionCallRightSide(method, params, 1);
            this.outputln(";");
            this.outputln("\t}");
        }
    }

    void generate_objc_msgSend_stret(JNIMethod method, List<JNIParameter> params, String func) {
        this.output("\t\t*lparg0 = (*(");
        JNIType paramType = params.get(0).getType32();
        JNIType paramType64 = params.get(0).getType64();
        this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), true));
        this.output(" (*)(");
        for (int i = 1; i < params.size(); ++i) {
            if (i != 1) {
                this.output(", ");
            }
            JNIParameter param = params.get(i);
            String cast = param.getCast();
            if (param.isPointer()) {
                this.output("(intptr_t)");
            }
            if (cast.length() != 0 && !cast.equals("()")) {
                if (cast.startsWith("(")) {
                    cast = cast.substring(1);
                }
                if (cast.endsWith(")")) {
                    cast = cast.substring(0, cast.length() - 1);
                }
                this.output(cast);
                continue;
            }
            paramType = param.getType32();
            paramType64 = param.getType64();
            if (!paramType.isPrimitive() && !paramType.isArray() && param.getTypeClass().getFlag(ClassFlag.STRUCT) && !param.getTypeClass().getFlag(ClassFlag.TYPEDEF)) {
                this.output("struct ");
            }
            this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), param.getFlag(ArgFlag.BY_VALUE)));
        }
        this.output("))");
        this.output(func);
        this.output(")");
    }

    void generateReturn(JNIMethod method, JNIType returnType, boolean needsReturn) {
        if (needsReturn && !returnType.isType("void")) {
            this.outputln("\treturn rc;");
        }
    }

    void generateMemmove(JNIMethod method, String function, String function64, List<JNIParameter> params) {
        this.generateEnterExitMacro(method, function, function64, true);
        this.output("\t");
        boolean get = params.get(0).getType32().isPrimitive();
        String className = params.get(get ? 1 : 0).getType32().getSimpleName();
        this.output(get ? "if (arg1) get" : "if (arg0) set");
        this.output(className);
        this.output(get ? "Fields(env, arg1, (" : "Fields(env, arg0, (");
        this.output(className);
        this.output(get ? " *)arg0)" : " *)arg1)");
        this.outputln(";");
        this.generateEnterExitMacro(method, function, function64, false);
    }

    void generateFunctionBody(JNIMethod method, String function, String function64, List<JNIParameter> params, JNIType returnType, JNIType returnType64) {
        boolean isMemove;
        this.outputln("{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        boolean bl = isMemove = (name.equals("memmove") || name.equals("MoveMemory")) && params.size() == 2 && returnType.isType("void");
        if (isMemove) {
            this.generateMemmove(method, function, function64, params);
        } else {
            boolean needsReturn = this.generateLocalVars(method, params, returnType, returnType64);
            this.generateEnterExitMacro(method, function, function64, true);
            boolean genFailTag = this.generateGetters(method, params);
            if (method.getFlag(MethodFlag.DYNAMIC)) {
                this.generateDynamicFunctionCall(method, params, returnType, returnType64, needsReturn);
            } else {
                this.generateFunctionCall(method, params, returnType, returnType64, needsReturn);
            }
            if (genFailTag) {
                this.outputln("fail:");
            }
            this.generateSetters(method, params);
            this.generateEnterExitMacro(method, function, function64, false);
            this.generateReturn(method, returnType, needsReturn);
        }
        this.outputln("}");
    }

    void generateFunctionPrototype(JNIMethod method, String function, List<JNIParameter> params, JNIType returnType, JNIType returnType64, boolean singleLine) {
        this.output("JNIEXPORT ");
        this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
        this.output(" JNICALL ");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_NATIVE(");
        this.output(function);
        if (singleLine) {
            this.output(")");
            this.output("(JNIEnv *env, ");
        } else {
            this.outputln(")");
            this.output("\t(JNIEnv *env, ");
        }
        if ((method.getModifiers() & 8) != 0) {
            this.output("jclass");
        } else {
            this.output("jobject");
        }
        this.output(" that");
        for (int i = 0; i < params.size(); ++i) {
            this.output(", ");
            JNIType paramType = params.get(i).getType32();
            JNIType paramType64 = params.get(i).getType64();
            this.output(paramType.getTypeSignature2(!paramType.equals(paramType64)));
            this.output(" arg" + i);
        }
        this.output(")");
        if (!singleLine) {
            this.outputln();
        }
    }

    boolean isCritical(JNIParameter param) {
        JNIType paramType = param.getType32();
        return paramType.isArray() && paramType.getComponentType().isPrimitive() && param.getFlag(ArgFlag.CRITICAL);
    }

    boolean isSystemClass(JNIType type) {
        return type.isType("java.lang.Object") || type.isType("java.lang.Class");
    }
}

