/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

public class MozillaGenerator {
    static boolean DEBUG = false;
    FileReader r = null;
    FileWriter w = null;
    int maxLines = 1000;
    int cntLines = 0;
    int n = 0;
    String[] b = null;
    String body = null;
    int nMethods = 0;
    String uuidName;
    String uuidValue;
    String className;
    String parentName;
    String[] constantNames;
    String[] constantValues;
    String[] methodNames;
    String[][] argTypes;
    String[][] argNames;
    String bodyOrder;
    TreeMap<Integer, TreeSet<String>> vtbls = new TreeMap();
    static String[] BEFORE_METHOD_NAME = new String[]{"  NS_IMETHOD ", "  NS_IMETHOD_(nsrefcnt) ", "  NS_IMETHOD_(void *) ", "  NS_IMETHOD_(void) ", "  NS_IMETHOD_(nsresult) ", "  NS_SCRIPTABLE NS_IMETHOD ", "  NS_SCRIPTABLE NS_IMETHOD_(nsrefcnt) ", "  NS_SCRIPTABLE NS_IMETHOD_(void *) ", "  NS_SCRIPTABLE NS_IMETHOD_(void) ", "  NS_SCRIPTABLE NS_IMETHOD_(nsresult) "};
    static String NO_SUPER_CLASS = "SWT_NO_SUPER_CLASS";
    static String[][] TYPES_C2JAVA = new String[][]{{"PRBool *", "int[]"}, {"nsIID &", "nsID"}, {"nsCID &", "nsID"}, {"nsCID * *", "int /*long*/"}, {"* *", "int /*long*/[]"}, {"**", "int /*long*/[]"}, {"* &", "int /*long*/[]"}, {"PRUint32 *", "int[]"}, {"PRInt32 *", "int[]"}, {"PRInt64 *", "long[]"}, {"PRUnichar *", "char[]"}, {"char *", "byte[]"}, {"float *", "float[]"}, {"PRUint16 *", "short[]"}, {"nativeWindow *", "int /*long*/[]"}, {"nsWriteSegmentFun", "int /*long*/"}, {"nativeWindow", "int /*long*/"}, {"*", "int /*long*/"}, {"&", "int /*long*/"}, {"PRUint32", "int"}, {"PRInt32", "int"}, {"PRInt64", "long"}, {"nsresult", "int"}, {"PRBool", "int"}, {"float", "float"}, {"PRUint16", "short"}, {"size_t", "int"}};
    static String GECKO = "/bluebird/teamhawtjni/hawtjni-builddir/mozilla/1.4/linux_gtk2/mozilla/dist/include/";
    static String TARGET_FOLDER = "/bluebird/teamhawtjni/chrisx/amd64/workspace/org.eclipse.hawtjni/Eclipse SWT Mozilla/common/org/eclipse/hawtjni/internal/mozilla/";
    static String[] XPCOM_HEADERS = new String[]{"profile/nsIProfile.h", "widget/nsIAppShell.h", "widget/nsIBaseWindow.h", "xpcom/nsIComponentManager.h", "xpcom/nsIComponentRegistrar.h", "webbrwsr/nsIContextMenuListener.h", "docshell/nsIDocShell.h", "dom/nsIDOMEvent.h", "dom/nsIDOMMouseEvent.h", "dom/nsIDOMUIEvent.h", "dom/nsIDOMWindow.h", "uriloader/nsIDownload.h", "webbrwsr/nsIEmbeddingSiteWindow.h", "xpcom/nsIFactory.h", "xpcom/nsIFile.h", "helperAppDlg/nsIHelperAppLauncherDialog.h", "exthandler/nsIExternalHelperAppService.h", "xpcom/nsIInputStream.h", "xpcom/nsIInterfaceRequestor.h", "necko/nsIIOService.h", "xpcom/nsILocalFile.h", "xpcom/nsIMemory.h", "progressDlg/nsIProgressDialog.h", "windowwatcher/nsIPromptService.h", "xpcom/nsIServiceManager.h", "xpcom/nsISupports.h", "webbrwsr/nsITooltipListener.h", "necko/nsIURI.h", "uriloader/nsIURIContentListener.h", "xpcom/nsIWeakReference.h", "webbrwsr/nsIWebBrowser.h", "webbrwsr/nsIWebBrowserChrome.h", "webbrwsr/nsIWebBrowserChromeFocus.h", "webbrwsr/nsIWebBrowserFocus.h", "docshell/nsIWebNavigation.h", "uriloader/nsIWebProgress.h", "uriloader/nsIWebProgressListener.h", "embed_base/nsIWindowCreator.h", "windowwatcher/nsIWindowWatcher.h"};
    static int CONSTANT = 0;
    static int METHOD = 1;
    static int END_BODY = 2;
    static String COPYRIGHTS = "/* ***** BEGIN LICENSE BLOCK *****\r\n * Version: MPL 1.1\r\n *\r\n * The contents of this file are subject to the Mozilla Public License Version\r\n * 1.1 (the \"License\"); you may not use this file except in compliance with\r\n * the License. You may obtain a copy of the License at\r\n * http://www.mozilla.org/MPL/\r\n *\r\n * Software distributed under the License is distributed on an \"AS IS\" basis,\r\n * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License\r\n * for the specific language governing rights and limitations under the\r\n * License.\r\n *\r\n * The Original Code is Mozilla Communicator client code, released March 31, 1998.\r\n *\r\n * The Initial Developer of the Original Code is\r\n * Netscape Communications Corporation.\r\n * Portions created by Netscape are Copyright (C) 1998-1999\r\n * Netscape Communications Corporation.  All Rights Reserved.\r\n *\r\n * Contributor(s):\r\n *\r\n * IBM\r\n * -  Binding to permit interfacing between Mozilla and SWT\r\n * -  Copyright (C) 2003, 2009 IBM Corp.  All Rights Reserved.\r\n *\r\n * ***** END LICENSE BLOCK ***** */";
    static String PACKAGE_DECLARATION = "package org.eclipse.hawtjni.internal.mozilla;";

    public static void main(String[] args) {
        MozillaGenerator x = new MozillaGenerator();
        for (int i = 0; i < XPCOM_HEADERS.length; ++i) {
            x.parse(GECKO + XPCOM_HEADERS[i], TARGET_FOLDER);
        }
        x.outputVtblCall();
        System.out.println("done");
    }

    public void write(String data) {
        if (DEBUG) {
            System.out.print(data);
            return;
        }
        try {
            this.w.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeLine() {
        if (DEBUG) {
            System.out.println();
            return;
        }
        this.write("\r\n");
    }

    public void writeLine(String data) {
        if (DEBUG) {
            System.out.println(data);
            return;
        }
        this.write(data + "\r\n");
    }

    public void writeCopyrights() {
        this.writeLine(COPYRIGHTS);
    }

    public void writePackageDeclaration() {
        this.writeLine(PACKAGE_DECLARATION);
    }

    public void writeClassDeclaration(String className, String parentName) {
        String line = "public class " + className;
        if (!parentName.equals(NO_SUPER_CLASS)) {
            line = line + " extends " + parentName;
        }
        line = line + " {";
        this.writeLine(line);
    }

    public void writeLastMethodId(String parentName, int nMethods) {
        String line = "\tstatic final int LAST_METHOD_ID = ";
        line = !parentName.equals(NO_SUPER_CLASS) ? line + parentName + ".LAST_METHOD_ID + " + nMethods + ";" : line + "" + (nMethods - 1) + ";";
        this.writeLine(line);
    }

    public void writeIID(String uuidName, String uuidValue) {
        this.writeLine("\tpublic static final String " + uuidName + " =");
        this.writeLine("\t\t\"" + uuidValue + "\";");
        this.writeLine();
        String iid = uuidName.substring(0, uuidName.indexOf("_STR"));
        this.writeLine("\tpublic static final nsID " + iid + " =");
        this.writeLine("\t\tnew nsID(" + uuidName + ");");
    }

    public void writeAddressField() {
        this.writeLine("\tint /*long*/ address;");
    }

    public void writeConstructor(String className, String parentName) {
        this.writeLine("\tpublic " + className + "(int /*long*/ address) {");
        if (!parentName.equals(NO_SUPER_CLASS)) {
            this.writeLine("\t\tsuper(address);");
        } else {
            this.writeLine("\t\tthis.address = address;");
        }
        this.writeLine("\t}");
    }

    public void writeAddressGetter() {
        this.writeLine("\tpublic int /*long*/ getAddress() {");
        this.writeLine("\t\treturn this.address;");
        this.writeLine("\t}");
    }

    public void writeConstant(String name, String value) {
        this.writeLine("\tpublic static final int " + name + " = " + value + ";");
    }

    public void writeMethod(String name, String parentName, int methodIndex, String[] argTypes, String[] argNames) {
        this.write("\tpublic int " + name + "(");
        for (int i = 0; i < argTypes.length; ++i) {
            this.write(argTypes[i] + " " + argNames[i]);
            if (i >= argTypes.length - 1) continue;
            this.write(", ");
        }
        this.write(") {");
        this.writeLine();
        String line = "\t\treturn XPCOM.VtblCall(";
        line = !parentName.equals(NO_SUPER_CLASS) ? line + parentName + ".LAST_METHOD_ID + " + (methodIndex + 1) + ", getAddress()" : line + methodIndex + ", getAddress()";
        this.write(line);
        if (argTypes.length > 0) {
            this.write(", ");
        }
        for (int i = 0; i < argTypes.length; ++i) {
            this.write(argNames[i]);
            if (i >= argTypes.length - 1) continue;
            this.write(", ");
        }
        this.writeLine(");");
        this.writeLine("\t}");
    }

    public void writeClassEnd() {
        this.write("}");
    }

    public void logVtblCall(String[] argTypes) {
        String vtbl = "static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl";
        if (argTypes.length > 0) {
            vtbl = vtbl + ", ";
        }
        for (int i = 0; i < argTypes.length; ++i) {
            vtbl = vtbl + argTypes[i] + " arg" + i;
            if (i >= argTypes.length - 1) continue;
            vtbl = vtbl + ", ";
        }
        vtbl = vtbl + ");";
        Integer key = new Integer(argTypes.length);
        TreeSet<String> list = this.vtbls.get(key);
        if (list == null) {
            list = new TreeSet();
            this.vtbls.put(key, list);
        }
        boolean duplicate = false;
        for (String s : list) {
            if (!vtbl.equals(s)) continue;
            duplicate = true;
            break;
        }
        if (!duplicate) {
            list.add(vtbl);
        }
    }

    public void outputVtblCall() {
        Collection<TreeSet<String>> values = this.vtbls.values();
        for (TreeSet<String> elts : values) {
            for (String elt : elts) {
                System.out.println(elt);
            }
        }
    }

    public void parse(String src, String destPath) {
        if (DEBUG) {
            this.writeLine("*** PARSING <" + src + "> to folder " + destPath);
        }
        this.b = new String[this.maxLines];
        this.cntLines = 0;
        try {
            this.r = new FileReader(src);
            BufferedReader br = new BufferedReader(this.r);
            while ((this.b[this.cntLines] = br.readLine()) != null) {
                ++this.cntLines;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.n = 0;
        boolean lookForClasses = true;
        while (lookForClasses) {
            lookForClasses = this.parse();
            String destFile = destPath + this.className + ".java";
            try {
                this.w = new FileWriter(destFile);
                if (DEBUG) {
                    this.writeLine("** CREATED JAVA FILE <" + destFile + ">");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.writeCopyrights();
            this.writePackageDeclaration();
            this.writeLine();
            this.writeClassDeclaration(this.className, this.parentName);
            this.writeLine();
            this.writeLastMethodId(this.parentName, this.nMethods);
            this.writeLine();
            this.writeIID(this.uuidName, this.uuidValue);
            this.writeLine();
            if (this.parentName.equals(NO_SUPER_CLASS)) {
                this.writeAddressField();
                this.writeLine();
            }
            this.writeConstructor(this.className, this.parentName);
            this.writeLine();
            if (this.parentName.equals(NO_SUPER_CLASS)) {
                this.writeAddressGetter();
                this.writeLine();
            }
            int constantIndex = 0;
            int methodIndex = 0;
            for (int i = 0; i < this.bodyOrder.length(); ++i) {
                if (this.bodyOrder.charAt(i) == 'C') {
                    this.writeConstant(this.constantNames[constantIndex], this.constantValues[constantIndex]);
                    if (i < this.bodyOrder.length() - 1) {
                        this.writeLine();
                    }
                    ++constantIndex;
                    continue;
                }
                if (this.bodyOrder.charAt(i) != 'M') continue;
                this.writeMethod(this.methodNames[methodIndex], this.parentName, methodIndex, this.argTypes[methodIndex], this.argNames[methodIndex]);
                if (i < this.bodyOrder.length() - 1) {
                    this.writeLine();
                }
                ++methodIndex;
            }
            this.writeClassEnd();
            try {
                this.w.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getPackages() {
        return "package org.eclipse.hawtjni.internal.mozilla;";
    }

    public boolean parse() {
        if (!this.jumpToUuidDeclaration()) {
            return false;
        }
        this.uuidName = this.getUuidName(this.b[this.n]);
        if (DEBUG) {
            System.out.println("UUID name: <" + this.uuidName + ">");
        }
        this.uuidValue = this.getUuidValue(this.b[this.n]);
        if (DEBUG) {
            System.out.println("UUID value: <" + this.uuidValue + ">");
        }
        this.jumpToInterfaceDeclaration();
        this.className = this.getClassName(this.b[this.n]);
        if (DEBUG) {
            System.out.println("Interface name: <" + this.className + ">");
        }
        this.parentName = this.getParentName(this.b[this.n]);
        if (DEBUG) {
            System.out.println("parentName: <" + this.parentName + ">");
        }
        this.parseBody();
        return true;
    }

    boolean jumpToUuidDeclaration() {
        while (!this.b[this.n].startsWith("#define ") || this.b[this.n].indexOf("_IID_STR \"") == -1) {
            ++this.n;
            if (this.n < this.cntLines) continue;
            return false;
        }
        return true;
    }

    String getUuidName(String declaration) {
        return declaration.substring(declaration.indexOf("#define ") + "#define ".length(), declaration.indexOf(" \""));
    }

    String getUuidValue(String declaration) {
        return declaration.substring(declaration.indexOf("_IID_STR \"") + "_IID_STR \"".length(), declaration.lastIndexOf(34));
    }

    void jumpToInterfaceDeclaration() {
        while (!this.b[this.n].startsWith("class NS_NO_VTABLE ")) {
            ++this.n;
        }
    }

    String getClassName(String declaration) {
        String searchString;
        int startIndex;
        int endIndex = declaration.indexOf(" :");
        if (endIndex == -1) {
            endIndex = declaration.indexOf(" {");
        }
        if ((startIndex = declaration.indexOf(searchString = "class NS_NO_VTABLE NS_SCRIPTABLE")) == -1) {
            searchString = "class NS_NO_VTABLE ";
            startIndex = declaration.indexOf(searchString);
        }
        return declaration.substring(startIndex + searchString.length(), endIndex);
    }

    String getParentName(String declaration) {
        if (declaration.indexOf(" :") == -1) {
            return NO_SUPER_CLASS;
        }
        return declaration.substring(declaration.indexOf(": public ") + ": public ".length(), declaration.indexOf(" {"));
    }

    void parseBody() {
        this.body = "";
        this.bodyOrder = "";
        int nConstants = 0;
        this.nMethods = 0;
        int tmp_n = this.n;
        while (true) {
            int type;
            if ((type = this.jumpToNextConstantOrMethod()) == CONSTANT) {
                ++nConstants;
            }
            if (type == METHOD) {
                ++this.nMethods;
            }
            if (type == END_BODY) break;
            ++this.n;
        }
        this.n = tmp_n;
        this.constantNames = new String[nConstants];
        this.constantValues = new String[nConstants];
        this.methodNames = new String[this.nMethods];
        this.argTypes = new String[this.nMethods][];
        this.argNames = new String[this.nMethods][];
        int constantIndex = 0;
        int methodIndex = 0;
        while (true) {
            int type;
            if ((type = this.jumpToNextConstantOrMethod()) == CONSTANT) {
                this.parseConstant(this.b[this.n], constantIndex);
                this.bodyOrder = this.bodyOrder + "C";
                ++constantIndex;
            }
            if (type == METHOD) {
                this.parseMethod(this.b[this.n], methodIndex);
                this.logVtblCall(this.argTypes[methodIndex]);
                this.bodyOrder = this.bodyOrder + "M";
                ++methodIndex;
            }
            if (type == END_BODY) {
                return;
            }
            ++this.n;
        }
    }

    boolean isEndOfInterfaceBody() {
        return this.b[this.n].startsWith("};");
    }

    int jumpToNextConstantOrMethod() {
        while (!this.isEndOfInterfaceBody()) {
            if (this.b[this.n].startsWith("  enum { ")) {
                return CONSTANT;
            }
            if (this.methodNameStartIndexOf(this.b[this.n]) != -1) {
                return METHOD;
            }
            ++this.n;
        }
        return END_BODY;
    }

    void parseConstant(String constant, int constantIndex) {
        String constantName = constant.substring(constant.indexOf(" enum { ") + " enum { ".length(), constant.indexOf(" ="));
        if (DEBUG) {
            this.writeLine("constantName <" + constantName + ">");
        }
        this.constantNames[constantIndex] = constantName;
        int endIndex = constant.indexOf("U };");
        if (endIndex == -1) {
            endIndex = constant.indexOf(" };");
        }
        String constantValue = constant.substring(constant.indexOf(" = ") + " = ".length(), endIndex);
        if (DEBUG) {
            this.writeLine("constantValue <" + constantValue + ">");
        }
        this.constantValues[constantIndex] = constantValue;
    }

    void parseMethod(String line, int methodIndex) {
        int start = this.methodNameStartIndexOf(line);
        int end = this.methodNameEndIndexOf(line);
        String methodName = line.substring(start, end);
        if (DEBUG) {
            this.writeLine("method name: <" + methodName + ">");
        }
        this.methodNames[methodIndex] = methodName;
        int argStart = end + "(".length();
        int argEnd = line.indexOf(")", argStart);
        this.parseArgs(line.substring(argStart, argEnd), methodIndex);
    }

    int methodNameStartIndexOf(String line) {
        for (int i = 0; i < BEFORE_METHOD_NAME.length; ++i) {
            int index = line.indexOf(BEFORE_METHOD_NAME[i]);
            if (index == -1) continue;
            return index + BEFORE_METHOD_NAME[i].length();
        }
        return -1;
    }

    int methodNameEndIndexOf(String line) {
        int startIndex = this.methodNameStartIndexOf(line);
        return line.indexOf("(", startIndex);
    }

    void parseArgs(String args, int methodIndex) {
        int nArgs = -1;
        String[] noArgs = new String[]{"", "void"};
        for (int i = 0; i < noArgs.length; ++i) {
            if (!args.equals(noArgs[i])) continue;
            nArgs = 0;
            break;
        }
        if (nArgs == -1) {
            nArgs = MozillaGenerator.count(args, ", ") + 1;
        }
        String[] argTypes = new String[nArgs];
        this.argTypes[methodIndex] = argTypes;
        String[] argNames = new String[nArgs];
        this.argNames[methodIndex] = argNames;
        int typeStart = 0;
        String[] typeNameSep = new String[]{" * *", " **", " * & ", " * ", " *", " & ", " "};
        for (int i = 0; i < nArgs; ++i) {
            int typeNameSepIndex;
            int nextTypeStart = i < nArgs - 1 ? args.indexOf(", ", typeStart) + ", ".length() : args.length();
            int separatorIndex = 0;
            for (typeNameSepIndex = 0; typeNameSepIndex < typeNameSep.length && ((separatorIndex = args.indexOf(typeNameSep[typeNameSepIndex], typeStart)) == -1 || separatorIndex >= nextTypeStart); ++typeNameSepIndex) {
            }
            String separator = typeNameSep[typeNameSepIndex];
            argTypes[i] = this.getC2JavaType(args.substring(typeStart, separatorIndex + separator.length()));
            if (DEBUG) {
                this.writeLine("arg type" + i + ": <" + argTypes[i] + ">");
            }
            int nameStart = separatorIndex + separator.length();
            int nameEnd = i < nArgs - 1 ? args.indexOf(", ", nameStart) : args.length();
            argNames[i] = args.substring(nameStart, nameEnd);
            if (DEBUG) {
                this.writeLine("arg name" + i + ": <" + argNames[i] + ">");
            }
            typeStart = nextTypeStart;
        }
    }

    String getC2JavaType(String cType) {
        for (int i = 0; i < TYPES_C2JAVA.length; ++i) {
            if (cType.indexOf(TYPES_C2JAVA[i][0]) == -1) continue;
            return TYPES_C2JAVA[i][1];
        }
        return "!ERROR UNKNOWN C TYPE <" + cType + ">!";
    }

    static int count(String s, String part) {
        int index = -1;
        int cnt = 0;
        while ((index = s.indexOf(part, index + 1)) != -1) {
            ++cnt;
        }
        return cnt;
    }
}

