/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.fusesource.hawtjni.generator.CleanupClass;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIMethod;
import org.fusesource.hawtjni.generator.model.ReflectClass;

public class CleanupNatives
extends CleanupClass {
    @Override
    public void generate(JNIClass clazz) {
        this.usedCount = 0;
        this.unusedCount = 0;
        super.generate(clazz);
        List<JNIMethod> methods = clazz.getDeclaredMethods();
        this.generate(methods);
        this.output("used=" + this.usedCount + " unused=" + this.unusedCount + " total=" + (this.unusedCount + this.usedCount));
    }

    public void generate(List<JNIMethod> methods) {
        CleanupNatives.sortMethods(methods);
        for (JNIMethod method : methods) {
            if ((method.getModifiers() & 0x100) == 0) continue;
            this.generate(method);
        }
    }

    public void generate(JNIMethod method) {
        String name = method.getName();
        Set keys = this.files.keySet();
        for (File key : keys) {
            String str = (String)this.files.get(key);
            if (str.indexOf(name) == -1) continue;
            ++this.usedCount;
            return;
        }
        ++this.unusedCount;
        this.output("NOT USED=" + method.toString() + "\n");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java CleanupNatives <OS className> <OS class source> <src path0> <src path1>");
            return;
        }
        try {
            CleanupNatives gen = new CleanupNatives();
            String clazzName = args[0];
            String classSource = args[1];
            String[] sourcePath = new String[args.length - 2];
            System.arraycopy(args, 2, sourcePath, 0, sourcePath.length);
            Class<?> clazz = Class.forName(clazzName);
            gen.setSourcePath(sourcePath);
            gen.setClassSourcePath(classSource);
            gen.generate(new ReflectClass(clazz));
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

