/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.fusesource.hawtjni.generator.JNIGenerator;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIMethod;

public abstract class CleanupClass
extends JNIGenerator {
    String classSourcePath;
    String[] sourcePath;
    String classSource;
    HashMap<File, String> files;
    int usedCount;
    int unusedCount;

    String[] getArgNames(JNIMethod method) {
        int parantesesStart;
        int n_args = method.getParameters().size();
        if (n_args == 0) {
            return new String[0];
        }
        String name = method.getName();
        String params = "";
        int index = 0;
        while (true) {
            if (!Character.isWhitespace(this.classSource.charAt((index = this.classSource.indexOf(name, index + 1)) - 1))) {
                continue;
            }
            if (index == -1) {
                return null;
            }
            parantesesStart = this.classSource.indexOf("(", index);
            if (this.classSource.substring(index + name.length(), parantesesStart).trim().length() == 0) break;
        }
        int parantesesEnd = this.classSource.indexOf(")", parantesesStart);
        params = this.classSource.substring(parantesesStart + 1, parantesesEnd);
        String[] names = new String[n_args];
        StringTokenizer tk = new StringTokenizer(params, ",");
        for (int i = 0; i < names.length; ++i) {
            String s = tk.nextToken().trim();
            StringTokenizer tk1 = new StringTokenizer(s, " ");
            String s1 = null;
            while (tk1.hasMoreTokens()) {
                s1 = tk1.nextToken();
            }
            names[i] = s1.trim();
        }
        return names;
    }

    void loadClassSource() {
        if (this.classSourcePath == null) {
            return;
        }
        File f = new File(this.classSourcePath);
        this.classSource = this.loadFile(f);
    }

    void loadFiles() {
        if (this.sourcePath == null) {
            return;
        }
        this.files = new HashMap();
        for (int i = 0; i < this.sourcePath.length; ++i) {
            File file = new File(this.sourcePath[i]);
            if (!file.exists()) continue;
            if (!file.isDirectory()) {
                if (!file.getAbsolutePath().endsWith(".java")) continue;
                this.files.put(file, this.loadFile(file));
                continue;
            }
            this.loadDirectory(file);
        }
    }

    String loadFile(File file) {
        try {
            int read;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            StringBuffer str = new StringBuffer();
            char[] buffer = new char[1024];
            while ((read = br.read(buffer)) != -1) {
                str.append(buffer, 0, read);
            }
            fr.close();
            return str.toString();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    void loadDirectory(File file) {
        String[] entries = file.list();
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            File f = new File(file, entry);
            if (!f.isDirectory()) {
                if (!f.getAbsolutePath().endsWith(".java")) continue;
                this.files.put(f, this.loadFile(f));
                continue;
            }
            this.loadDirectory(f);
        }
    }

    @Override
    public void generate(JNIClass clazz) {
        this.loadFiles();
        this.loadClassSource();
    }

    public void setSourcePath(String[] sourcePath) {
        this.sourcePath = sourcePath;
        this.files = null;
    }

    public void setClassSourcePath(String classSourcePath) {
        this.classSourcePath = classSourcePath;
    }
}

