/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class Versionstamp
implements Comparable<Versionstamp> {
    public static final int LENGTH = 12;
    private static final byte[] UNSET_TRANSACTION_VERSION = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final boolean complete;
    private final byte[] versionBytes;

    public static int unpackUserVersion(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static Versionstamp fromBytes(byte[] byArray) {
        if (byArray.length != 12) {
            throw new IllegalArgumentException("Versionstamp bytes must have length 12");
        }
        boolean bl = false;
        for (int i = 0; i < UNSET_TRANSACTION_VERSION.length; ++i) {
            if (byArray[i] == UNSET_TRANSACTION_VERSION[i]) continue;
            bl = true;
        }
        return new Versionstamp(bl, byArray);
    }

    public static Versionstamp incomplete(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Local version must fit in unsigned short");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(UNSET_TRANSACTION_VERSION);
        byteBuffer.putShort((short)n);
        return new Versionstamp(false, byteBuffer.array());
    }

    public static Versionstamp incomplete() {
        return Versionstamp.incomplete(0);
    }

    public static Versionstamp complete(byte[] byArray, int n) {
        if (byArray.length != UNSET_TRANSACTION_VERSION.length) {
            throw new IllegalArgumentException("Global version has invalid length " + byArray.length);
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Local version must fit in unsigned short");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(byArray);
        byteBuffer.putShort((short)n);
        return new Versionstamp(true, byteBuffer.array());
    }

    public static Versionstamp complete(byte[] byArray) {
        return Versionstamp.complete(byArray, 0);
    }

    private Versionstamp(boolean bl, byte[] byArray) {
        if (byArray.length != 12) {
            throw new IllegalArgumentException("Versionstamp bytes must have length 12");
        }
        this.complete = bl;
        this.versionBytes = byArray;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public byte[] getBytes() {
        return this.versionBytes;
    }

    public byte[] getTransactionVersion() {
        byte[] byArray = new byte[10];
        System.arraycopy(this.versionBytes, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getUserVersion() {
        return Versionstamp.unpackUserVersion(this.versionBytes, 10);
    }

    public String toString() {
        if (this.complete) {
            return "Versionstamp(" + ByteArrayUtil.printable(this.getTransactionVersion()) + " " + this.getUserVersion() + ")";
        }
        return "Versionstamp(<incomplete> " + this.getUserVersion() + ")";
    }

    @Override
    public int compareTo(Versionstamp versionstamp) {
        if (this.complete && versionstamp.complete) {
            return ByteArrayUtil.compareUnsigned(this.versionBytes, versionstamp.versionBytes);
        }
        if (this.complete) {
            return -1;
        }
        if (versionstamp.complete) {
            return 1;
        }
        return Integer.compare(this.getUserVersion(), versionstamp.getUserVersion());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Versionstamp)) {
            return false;
        }
        Versionstamp versionstamp = (Versionstamp)object;
        return this.isComplete() == versionstamp.isComplete() && Arrays.equals(this.getBytes(), versionstamp.getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }
}

