/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.Arrays;

public class Range {
    public final byte[] begin;
    public final byte[] end;

    public Range(byte[] byArray, byte[] byArray2) {
        this.begin = byArray;
        this.end = byArray2;
    }

    public static Range startsWith(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("prefix cannot be null");
        }
        return new Range(byArray, ByteArrayUtil.strinc(byArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        return Arrays.equals(this.begin, range.begin) && Arrays.equals(this.end, range.end);
    }

    public int hashCode() {
        return Arrays.hashCode(this.begin) ^ 37 * Arrays.hashCode(this.end);
    }

    public String toString() {
        return "Range(" + (this.begin == null ? "null" : "\"" + ByteArrayUtil.printable(this.begin) + "\"") + ", " + (this.end == null ? "null" : "\"" + ByteArrayUtil.printable(this.end) + "\"") + ")";
    }
}

