/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.database.oracle.OracleDatabase;
import org.flywaydb.database.oracle.OracleSchema;

public class OracleConnection
extends org.flywaydb.core.internal.database.base.Connection<OracleDatabase> {
    OracleConnection(OracleDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL", new String[0]);
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("ALTER SESSION SET CURRENT_SCHEMA=" + ((OracleDatabase)this.database).quote(new String[]{schema}), new Object[0]);
    }

    public Schema getSchema(String name) {
        return new OracleSchema(this.jdbcTemplate, (OracleDatabase)this.database, name);
    }
}

