/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.extensibility.FlywayExtension;
import org.flywaydb.core.internal.database.DatabaseType;

public class PluginRegister {
    private static final Log LOG = LogFactory.getLog(PluginRegister.class);
    private static final ClassLoader CLASS_LOADER = new PluginRegister().getClass().getClassLoader();
    private static final List<FlywayExtension> registeredFlywayExtensions = new ArrayList<FlywayExtension>();
    private static final List<DatabaseType> registeredDatabaseTypes = new ArrayList<DatabaseType>();
    private static final List<ConfigurationProvider> registeredConfigurationProviders = new ArrayList<ConfigurationProvider>();
    private static final List<ConfigurationExtension> registeredConfigurationExtensions = new ArrayList<ConfigurationExtension>();
    private static boolean hasRegisteredPlugins = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPlugins() {
        List<DatabaseType> list = registeredDatabaseTypes;
        synchronized (list) {
            if (hasRegisteredPlugins) {
                return;
            }
            for (FlywayExtension flywayExtensionPlugin : ServiceLoader.load(FlywayExtension.class, CLASS_LOADER)) {
                registeredFlywayExtensions.add(flywayExtensionPlugin);
                LOG.debug("Adding FlywayExtensions:" + flywayExtensionPlugin.getClass().getName());
            }
            for (DatabaseType databaseTypePlugin : ServiceLoader.load(DatabaseType.class, CLASS_LOADER)) {
                registeredDatabaseTypes.add(databaseTypePlugin);
                LOG.debug("Adding DB:" + databaseTypePlugin.getClass().getName());
            }
            Collections.sort(registeredDatabaseTypes);
            for (ConfigurationProvider configurationProviderPlugin : ServiceLoader.load(ConfigurationProvider.class, CLASS_LOADER)) {
                registeredConfigurationProviders.add(configurationProviderPlugin);
                LOG.debug("Adding ConfigurationProvider:" + configurationProviderPlugin.getClass().getName());
            }
            for (ConfigurationExtension configurationExtensionPlugin : ServiceLoader.load(ConfigurationExtension.class, CLASS_LOADER)) {
                registeredConfigurationExtensions.add(configurationExtensionPlugin);
                LOG.debug("Adding ConfigurationExtension:" + configurationExtensionPlugin.getClass().getName());
            }
            hasRegisteredPlugins = true;
        }
    }

    public static List<FlywayExtension> getFlywayExtensions() {
        if (!hasRegisteredPlugins) {
            PluginRegister.registerPlugins();
        }
        return registeredFlywayExtensions;
    }

    public static List<DatabaseType> getDatabaseTypes() {
        if (!hasRegisteredPlugins) {
            PluginRegister.registerPlugins();
        }
        return registeredDatabaseTypes;
    }

    public static List<ConfigurationProvider> getConfigurationProviders() {
        if (!hasRegisteredPlugins) {
            PluginRegister.registerPlugins();
        }
        return registeredConfigurationProviders;
    }

    public static List<ConfigurationExtension> getConfigurationExtensions() {
        if (!hasRegisteredPlugins) {
            PluginRegister.registerPlugins();
        }
        return registeredConfigurationExtensions;
    }

    public static <T extends ConfigurationExtension> T getConfigurationExtension(Class<T> clazz) {
        for (ConfigurationExtension configurationExtension : registeredConfigurationExtensions) {
            if (!clazz.isInstance(configurationExtension)) continue;
            return (T)configurationExtension;
        }
        throw new FlywayException("Requested configuration extension of type " + clazz.getName() + " but none found.");
    }

    private PluginRegister() {
    }
}

