/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import java.util.Date;
import java.util.Objects;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;

public class AppliedMigration
implements Comparable<AppliedMigration> {
    private final int installedRank;
    private final MigrationVersion version;
    private final String description;
    private final MigrationType type;
    private final String script;
    private final Integer checksum;
    private final Date installedOn;
    private final String installedBy;
    private final int executionTime;
    private final boolean success;

    public AppliedMigration(int installedRank, MigrationVersion version, String description, MigrationType type, String script, Integer checksum, Date installedOn, String installedBy, int executionTime, boolean success) {
        this.installedRank = installedRank;
        this.version = version;
        this.description = description;
        this.type = type;
        this.script = script;
        this.checksum = checksum;
        this.installedOn = installedOn;
        this.installedBy = installedBy;
        this.executionTime = executionTime;
        this.success = success;
    }

    public int getInstalledRank() {
        return this.installedRank;
    }

    public MigrationVersion getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public MigrationType getType() {
        return this.type;
    }

    public String getScript() {
        return this.script;
    }

    public Integer getChecksum() {
        return this.checksum;
    }

    public Date getInstalledOn() {
        return this.installedOn;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public int getExecutionTime() {
        return this.executionTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppliedMigration that = (AppliedMigration)o;
        if (this.executionTime != that.executionTime) {
            return false;
        }
        if (this.installedRank != that.installedRank) {
            return false;
        }
        if (this.success != that.success) {
            return false;
        }
        if (this.checksum != null ? !this.checksum.equals(that.checksum) : that.checksum != null) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (this.installedBy != null ? !this.installedBy.equals(that.installedBy) : that.installedBy != null) {
            return false;
        }
        if (this.installedOn != null ? !this.installedOn.equals(that.installedOn) : that.installedOn != null) {
            return false;
        }
        if (!this.script.equals(that.script)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.installedRank;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.script.hashCode();
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        result = 31 * result + (this.installedOn != null ? this.installedOn.hashCode() : 0);
        result = 31 * result + (this.installedBy != null ? this.installedBy.hashCode() : 0);
        result = 31 * result + this.executionTime;
        result = 31 * result + (this.success ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(AppliedMigration o) {
        return this.installedRank - o.installedRank;
    }
}

