/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.classpath;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.util.UrlUtils;

public class ClassPathResource
extends LoadableResource {
    private final String fileNameWithAbsolutePath;
    private final String fileNameWithRelativePath;
    private final ClassLoader classLoader;
    private final Charset encoding;

    public ClassPathResource(Location location, String fileNameWithAbsolutePath, ClassLoader classLoader, Charset encoding) {
        this.fileNameWithAbsolutePath = fileNameWithAbsolutePath;
        this.fileNameWithRelativePath = location == null ? fileNameWithAbsolutePath : location.getPathRelativeToThis(fileNameWithAbsolutePath);
        this.classLoader = classLoader;
        this.encoding = encoding;
    }

    @Override
    public String getRelativePath() {
        return this.fileNameWithRelativePath;
    }

    @Override
    public String getAbsolutePath() {
        return this.fileNameWithAbsolutePath;
    }

    @Override
    public String getAbsolutePathOnDisk() {
        URL url = this.getUrl();
        if (url == null) {
            throw new FlywayException("Unable to find resource on disk: " + this.fileNameWithAbsolutePath);
        }
        return new File(UrlUtils.decodeURL(url.getPath())).getAbsolutePath();
    }

    private URL getUrl() {
        return this.classLoader.getResource(this.fileNameWithAbsolutePath);
    }

    @Override
    public Reader read() {
        InputStream inputStream = this.classLoader.getResourceAsStream(this.fileNameWithAbsolutePath);
        if (inputStream == null) {
            throw new FlywayException("Unable to obtain inputstream for resource: " + this.fileNameWithAbsolutePath);
        }
        return new InputStreamReader(inputStream, this.encoding.newDecoder());
    }

    @Override
    public String getFilename() {
        return this.fileNameWithAbsolutePath.substring(this.fileNameWithAbsolutePath.lastIndexOf("/") + 1);
    }

    public boolean exists() {
        return this.getUrl() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return this.fileNameWithAbsolutePath.equals(that.fileNameWithAbsolutePath);
    }

    public int hashCode() {
        return this.fileNameWithAbsolutePath.hashCode();
    }
}

