/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.migration.MigrationChecksumProvider;
import org.flywaydb.core.api.migration.MigrationInfoProvider;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.clazz.ClassProvider;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public abstract class AbstractJavaMigrationResolver<M, E extends MigrationExecutor>
implements MigrationResolver {
    private static final Log LOG = LogFactory.getLog(AbstractJavaMigrationResolver.class);
    private ClassProvider classProvider;
    private Configuration configuration;

    public AbstractJavaMigrationResolver(ClassProvider classProvider, Configuration configuration) {
        this.classProvider = classProvider;
        this.configuration = configuration;
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        for (Class<M> clazz : this.classProvider.getClasses(this.getImplementedInterface())) {
            Object migration = ClassUtils.instantiate(clazz.getName(), this.configuration.getClassLoader());
            ConfigUtils.injectFlywayConfiguration(migration, this.configuration);
            ResolvedMigrationImpl migrationInfo = this.extractMigrationInfo(migration);
            migrationInfo.setPhysicalLocation(ClassUtils.getLocationOnDisk(clazz));
            migrationInfo.setExecutor((MigrationExecutor)this.createExecutor(migration));
            migrations.add(migrationInfo);
        }
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    protected abstract String getMigrationTypeStr();

    protected abstract Class<M> getImplementedInterface();

    protected abstract E createExecutor(M var1);

    public ResolvedMigrationImpl extractMigrationInfo(M migration) {
        String description;
        MigrationVersion version;
        Integer checksum = null;
        if (migration instanceof MigrationChecksumProvider) {
            MigrationChecksumProvider checksumProvider = (MigrationChecksumProvider)migration;
            checksum = checksumProvider.getChecksum();
        }
        if (migration instanceof MigrationInfoProvider) {
            MigrationInfoProvider infoProvider = (MigrationInfoProvider)migration;
            version = infoProvider.getVersion();
            description = infoProvider.getDescription();
            if (!StringUtils.hasText(description)) {
                throw new FlywayException("Missing description for migration " + version);
            }
        } else {
            String shortName = ClassUtils.getShortName(migration.getClass());
            boolean repeatable = shortName.startsWith("R");
            if (!shortName.startsWith("V") && !repeatable) {
                throw new FlywayException("Invalid " + this.getMigrationTypeStr() + " migration class name: " + migration.getClass().getName() + " => ensure it starts with V or R, or implement org.flywaydb.core.api.migration.MigrationInfoProvider for non-default naming");
            }
            String prefix = shortName.substring(0, 1);
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(shortName, prefix, "__", new String[]{""}, repeatable);
            version = info.getLeft();
            description = info.getRight();
        }
        ResolvedMigrationImpl resolvedMigration = new ResolvedMigrationImpl();
        resolvedMigration.setVersion(version);
        resolvedMigration.setDescription(description);
        resolvedMigration.setScript(migration.getClass().getName());
        resolvedMigration.setChecksum(checksum);
        resolvedMigration.setType(this.getMigrationType());
        return resolvedMigration;
    }

    protected abstract MigrationType getMigrationType();
}

