/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.proxy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fluentlenium.core.domain.ElementUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class LastElementLocator
implements ElementLocator {
    private final ElementLocator listLocator;

    public LastElementLocator(ElementLocator listLocator) {
        this.listLocator = listLocator;
    }

    private WebElement findElementImpl() {
        List elements = this.listLocator.findElements();
        if (elements.isEmpty()) {
            return null;
        }
        return (WebElement)elements.get(elements.size() - 1);
    }

    public WebElement findElement() {
        WebElement element = this.findElementImpl();
        if (element == null) {
            throw ElementUtils.noSuchElementException(String.valueOf("Element " + this));
        }
        return element;
    }

    public List<WebElement> findElements() {
        WebElement element = this.findElementImpl();
        if (element == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(element);
    }

    public String toString() {
        return this.listLocator.toString() + " (last)";
    }
}

