/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.label;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.fluentlenium.core.label.FluentLabel;
import org.fluentlenium.core.label.FluentLabelProvider;

public class FluentLabelImpl<T>
implements FluentLabel<T>,
FluentLabelProvider {
    private final T reference;
    private final Supplier<String> defaultLabelSupplier;
    private String label;
    private final List<String> labelHints = new ArrayList<String>();

    public FluentLabelImpl(T reference, Supplier<String> defaultLabelSupplier) {
        this.reference = reference;
        this.defaultLabelSupplier = defaultLabelSupplier;
    }

    @Override
    public T withLabel(String label) {
        this.label = label;
        return this.reference;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public T withLabelHint(String ... labelHint) {
        if (labelHint != null) {
            this.labelHints.addAll(Arrays.asList(labelHint));
        }
        return this.reference;
    }

    @Override
    public String[] getLabelHints() {
        return this.labelHints.toArray(new String[this.labelHints.size()]);
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        if (this.label == null) {
            toStringBuilder.append(this.defaultLabelSupplier.get());
        } else {
            toStringBuilder.append(this.label);
        }
        if (!this.labelHints.isEmpty()) {
            toStringBuilder.append(" [");
            boolean notFirst = false;
            for (String labelHint : this.labelHints) {
                if (notFirst) {
                    toStringBuilder.append(", ");
                }
                toStringBuilder.append(labelHint);
                notFirst = true;
            }
            toStringBuilder.append(']');
        }
        return toStringBuilder.toString();
    }
}

