/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.fluentlenium.configuration.AnnotationConfiguration;
import org.fluentlenium.configuration.ComposedConfiguration;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.configuration.ConfigurationDefaults;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationFactory;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.DefaultPropertiesBackend;
import org.fluentlenium.configuration.EnvironmentVariablesBackend;
import org.fluentlenium.configuration.ProgrammaticConfiguration;
import org.fluentlenium.configuration.PropertiesBackendConfiguration;
import org.fluentlenium.configuration.SystemPropertiesBackend;

public class DefaultConfigurationFactory
implements ConfigurationFactory {
    protected InputStream getPropertiesInputStream() {
        return this.getClass().getResourceAsStream("/fluentlenium.properties");
    }

    @Override
    public Configuration newConfiguration(Class<?> containerClass, ConfigurationProperties configurationDefaults) {
        InputStream configurationFile;
        Properties properties = new Properties();
        if (configurationDefaults == null) {
            configurationDefaults = new ConfigurationDefaults();
        }
        if ((configurationFile = this.getPropertiesInputStream()) != null) {
            try {
                properties.load(configurationFile);
            }
            catch (IOException e) {
                throw new ConfigurationException("Can't read fluentlenium.properties. " + e);
            }
        }
        ProgrammaticConfiguration programmaticConfiguration = new ProgrammaticConfiguration();
        ComposedConfiguration configuration = new ComposedConfiguration(programmaticConfiguration, programmaticConfiguration, new PropertiesBackendConfiguration(new SystemPropertiesBackend()), new PropertiesBackendConfiguration(new EnvironmentVariablesBackend()), new AnnotationConfiguration(containerClass), new PropertiesBackendConfiguration(new DefaultPropertiesBackend(properties), "", "fluentlenium."), configurationDefaults);
        return configuration;
    }
}

