/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.net.URL;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigurationHelper.class);

    private static ProcessEngine buildProcessEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND PROCESS ENGINE =========================================");
        GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});
        Map beansOfType = applicationContext.getBeansOfType(ProcessEngine.class);
        if (beansOfType == null || beansOfType.isEmpty()) {
            throw new ActivitiException("no " + ProcessEngine.class.getName() + " defined in the application context " + resource.toString());
        }
        ProcessEngine processEngine = (ProcessEngine)beansOfType.values().iterator().next();
        LOGGER.debug("==== SPRING PROCESS ENGINE CREATED ==================================================================");
        return processEngine;
    }
}

